/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AdditionalJournalingDataBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.AdditionalJournalingData;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.BookYear;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class TransactionBatchBookBP
extends GenericTransactionBP {
    private static final long serialVersionUID = -5978252768941883259L;
    private TransactionBatch transactionBatch;
    private HashMap bookYears = new HashMap();
    private HashMap voucherIds = new HashMap();
    private String maId1;
    private String maId2;
    private String maId3;
    private String maId4;
    private String maId5;
    private String maId6;
    private String maId7;
    private String maId8;
    private String maId9;
    private String maId10;
    private String maId11;
    private HashMap ajdForAP1;
    private HashMap ajdForAP2;
    private boolean AP1HasAJD = false;
    private boolean AP2HasAJD = false;
    private int currentDocumentNr = 0;
    private int currentAccountingPrinciple = 0;
    private int currentYear = 0;
    private String lastVoucherId = "";
    private int currentVoucherId = 0;
    private boolean singleVoucherId;
    private String[][] dbIds = new String[5][8];
    private String[] currentDaybook = new String[5];
    private String[][] dirlas = new String[5][6];
    private String[][] dirpas = new String[5][6];
    private boolean successfullyInitialized;
    private int voucherDateMainSwitch;
    private int voucherDateSubSwitch;
    private int startMonth;
    private Date processingDate;
    private IncomingFinancialTransaction ift;
    private Date iftDate;
    private String processDescriptionShort = "";
    private String belgianVoucherId;
    private Date belgianVoucherDate;

    public TransactionBatchBookBP(Company company, TransactionBatch transactionBatch) throws Exception {
        super(company, 0);
        this.transactionBatch = transactionBatch;
    }

    public TransactionBatch getTransactionBatch() {
        return this.transactionBatch;
    }

    public static Object[] createSelections(TransactionBatch transactionBatch, LoginHelper loginHelper, String operationArea, String dataLib, String programLib, String bookYear) throws Exception {
        Object[] result = new Object[2];
        String description = "FAC-" + transactionBatch.getBatchId() + "-" + transactionBatch.getEndYear() + "/" + transactionBatch.getEndPeriod() + "-" + transactionBatch.getCompanyId();
        DecimalFormat formatter = new DecimalFormat("000000000");
        String batchId = formatter.format(transactionBatch.getBatchId());
        if (operationArea.length() == 0) {
            String[][] selections;
            Company company = (Company)CompanyBO.get(transactionBatch.getDBData(), transactionBatch.getCompanyId())[0];
            String prefix = company.getFamMemberPrefix();
            if (prefix.length() == 0) {
                prefix = "FA";
            }
            result[0] = selections = new String[][]{{"facLib", transactionBatch.getDBData().getSchema()}, {"User", loginHelper.getUser()}, {"operationArea", operationArea}, {"dataLib", dataLib}, {"programLib", programLib}, {"Company", transactionBatch.getCompanyId()}, {"FISMBRPRFX", prefix}, {"FISMBRDSCR", description}, {"batchId", batchId}};
            result[1] = "FACF100CL";
        } else {
            String[][] selections;
            result[0] = selections = new String[][]{{"facLib", transactionBatch.getDBData().getSchema()}, {"User", loginHelper.getUser()}, {"operationArea", operationArea}, {"dataLib", dataLib}, {"programLib", programLib}, {"Company", transactionBatch.getCompanyId()}, {"BATCHDSCR", description}, {"batchId", batchId}};
            result[1] = "FACM100CL";
        }
        return result;
    }

    public Object[] prepareForPost(Collection transactions, LoginHelper loginHelper, boolean refreshMainAccounts) throws Exception {
        Object[] result = new Object[2];
        boolean newBatchCreated = false;
        boolean batchHasTransactionsToBook = false;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            if (this.transactionBatch.getState() == 2) {
                result = TransactionBatchBO.create(this.transactionBatch.getDBData(), this.transactionBatch.getCompanyId(), loginHelper.getUser(), this.transactionBatch.getBatchCode());
                if ((String)result[1] != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return result;
                }
                TransactionBatch newBatch = (TransactionBatch)result[0];
                newBatch.setOriginatingFACBatchId(this.transactionBatch.getBatchId());
                newBatch.setEndPeriod(this.transactionBatch.getEndPeriod());
                newBatch.setEndYear(this.transactionBatch.getEndYear());
                newBatch.setState(1);
                this.transactionBatch = newBatch;
                newBatchCreated = true;
            }
            Log.debug((String)"*** handleTransactions");
            batchHasTransactionsToBook = this.handleTransactions(transactions, refreshMainAccounts, newBatchCreated);
            Log.debug((String)("*** prepareForPost: batchHasTransactionsToBook=" + batchHasTransactionsToBook));
            if (!batchHasTransactionsToBook) {
                this.transactionBatch.setState(2);
            }
            this.transactionBatch.setProcessedBy(loginHelper.getUser());
            if (!newBatchCreated && batchHasTransactionsToBook) {
                this.updateLastUsedVoucherIds();
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = BOAdapter.investigate(e, dbTransaction);
            return result;
        }
        result[0] = new Boolean(batchHasTransactionsToBook);
        return result;
    }

    private boolean handleTransactions(Collection transactions, boolean refreshMainAccounts, boolean newBatchCreated) throws Exception {
        this.initializeVoucherDateSwitches();
        this.initializeDaybookArray();
        this.initializeDisinvestmentReasonMainAccounts();
        this.initializeAdditionalJournalingData();
        Iterator iterator = transactions.iterator();
        boolean batchHasTransactionsToBook = false;
        while (iterator.hasNext()) {
            IncomingFinancialTransaction invoice;
            boolean financialDimensionsAreEqual;
            Transaction transaction = (Transaction)iterator.next();
            Log.debug((String)("*** 0-handleTransactions: transaction.getTransactionType() =" + transaction.getTransactionType()));
            Log.debug((String)("*** 0-handleTransactions: transaction.getJournalingState() =" + transaction.getJournalingState()));
            if (transaction.getDocumentNr() != this.currentDocumentNr || transaction.getAccountingPrinciple() != this.currentAccountingPrinciple) {
                this.currentDocumentNr = transaction.getDocumentNr();
                this.currentAccountingPrinciple = transaction.getAccountingPrinciple();
                if (!this.singleVoucherId && this.voucherDateMainSwitch != 5) {
                    this.initializeCurrentVoucherId(transaction);
                }
                this.successfullyInitialized = false;
                if (transaction.getAsset() != null || "C".equals(transaction.getCora()) && transaction.getCreditId() != null) {
                    this.initializeCurrentMainAccounts(transaction);
                    this.initializeCurrentDaybook(transaction.getTransactionType());
                    this.successfullyInitialized = true;
                }
                if (this.voucherDateMainSwitch == 3) {
                    this.iftDate = null;
                    this.ift = transaction.getIncomingFinancialTransaction();
                    if (this.ift != null) {
                        this.iftDate = this.ift.getBookDate();
                    }
                }
            }
            if (!this.successfullyInitialized && (transaction.getAsset() != null || "C".equals(transaction.getCora()) && transaction.getCreditId() != null)) {
                this.initializeCurrentMainAccounts(transaction);
                this.initializeCurrentDaybook(transaction.getTransactionType());
                this.successfullyInitialized = true;
            }
            Log.debug((String)"*** handleTransactions: Handle 'to be journalized' for investments");
            Log.debug((String)("*** handleTransactions: Transactiontype = " + transaction.getTransactionType()));
            if (transaction.getTransactionType() == 10) {
                Log.debug((String)("*** 1-handleTransactions: transaction.getJournalingState() =" + transaction.getJournalingState()));
                Log.debug((String)"*** handleTransactions: INVESTMENT!");
                financialDimensionsAreEqual = false;
                invoice = transaction.getIncomingFinancialTransaction();
                if (invoice != null) {
                    Log.debug((String)"*** handleTransactions: invoice != null");
                    financialDimensionsAreEqual = true;
                    Log.debug((String)("*** handleTransactions: invoice.getMainAccount().trim()=" + invoice.getMainAccount().trim()));
                    Log.debug((String)("*** handleTransactions: maId1.trim()=" + this.maId1.trim()));
                    if (!invoice.getMainAccount().trim().equals(this.maId1.trim())) {
                        financialDimensionsAreEqual = false;
                    } else {
                        Log.debug((String)("*** handleTransactions: invoice.getFinDimId1()=" + invoice.getFinDimId1()));
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId1(), transaction.getFinDimId1());
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId2(), transaction.getFinDimId2());
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId3(), transaction.getFinDimId3());
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId4(), transaction.getFinDimId4());
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId5(), transaction.getFinDimId5());
                    }
                }
                Log.debug((String)("*** 2-handleTransactions: transaction.getJournalingState() =" + transaction.getJournalingState()));
                if (financialDimensionsAreEqual) {
                    Log.debug((String)"*** 3-handleTransactions: TransactionJournalingStateEnum.NO_JOURNALIZATION");
                    transaction.setJournalingState(0);
                }
            } else if (transaction.getTransactionType() == 190 || transaction.getTransactionType() == 110) {
                Log.debug((String)("*** 1-handleTransactions: transaction.getJournalingState() =" + transaction.getJournalingState()));
                Log.debug((String)"*** handleTransactions: PAYOFF!");
                financialDimensionsAreEqual = false;
                invoice = transaction.getIncomingFinancialTransaction();
                if (invoice != null) {
                    Log.debug((String)"*** handleTransactions: invoice != null");
                    financialDimensionsAreEqual = true;
                    Log.debug((String)("*** handleTransactions: invoice.getMainAccount().trim()=" + invoice.getMainAccount().trim()));
                    Log.debug((String)("*** handleTransactions: maId1.trim()=" + this.maId1.trim()));
                    if (!invoice.getMainAccount().trim().equals(this.maId1.trim())) {
                        financialDimensionsAreEqual = false;
                    } else {
                        Log.debug((String)("*** handleTransactions: invoice.getFinDimId1()=" + invoice.getFinDimId1()));
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId1(), transaction.getFinDimId1());
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId2(), transaction.getFinDimId2());
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId3(), transaction.getFinDimId3());
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId4(), transaction.getFinDimId4());
                        financialDimensionsAreEqual = this.evaluateFinancialDimension(financialDimensionsAreEqual, invoice.getFinDimId5(), transaction.getFinDimId5());
                    }
                }
                Log.debug((String)("*** 2-handleTransactions: transaction.getJournalingState() =" + transaction.getJournalingState()));
                if (financialDimensionsAreEqual) {
                    Log.debug((String)"*** 3-handleTransactions: TransactionJournalingStateEnum.NO_JOURNALIZATION");
                    transaction.setJournalingState(0);
                }
            }
            Log.debug((String)("*** 4-handleTransactions: transaction.getJournalingState() =" + transaction.getJournalingState()));
            if (transaction.getJournalingState() == 0) continue;
            batchHasTransactionsToBook = true;
            if (!newBatchCreated) {
                if (transaction.getAsset() != null || "C".equals(transaction.getCora()) && transaction.getCreditId() != null) {
                    this.setMainaccounts(transaction);
                    transaction.setDaybookId(this.currentDaybook[transaction.getAccountingPrinciple()]);
                }
                this.setVoucherDate(transaction);
                if (this.voucherDateMainSwitch != 5) {
                    transaction.setVoucherId("" + this.currentVoucherId);
                } else {
                    transaction.setVoucherId(this.belgianVoucherId);
                }
                transaction.setGLDescription(this.retrieveGLDescription(transaction));
                transaction.setState(1);
                continue;
            }
            if (!refreshMainAccounts) break;
            if (transaction.getAsset() == null && (!"C".equals(transaction.getCora()) || transaction.getCreditId() == null)) continue;
            this.setMainaccounts(transaction);
            transaction.setDaybookId(this.currentDaybook[transaction.getAccountingPrinciple()]);
        }
        return batchHasTransactionsToBook;
    }

    private boolean evaluateFinancialDimension(boolean dimensionsAreEqual, String invoiceDimension, String transactionDimension) throws Exception {
        if (!dimensionsAreEqual) {
            return false;
        }
        if (invoiceDimension == null || invoiceDimension.trim().length() == 0) {
            return true;
        }
        return invoiceDimension.trim().equals(transactionDimension.trim());
    }

    private String retrieveGLDescription(Transaction transaction) throws Exception {
        Asset asset;
        String glDescription = "";
        if (this.processParameters.getAssetDescriptionInDescription() && (asset = transaction.getAsset()) != null) {
            glDescription = asset.getDescription();
            return this.substringGLDescription(glDescription);
        }
        if (transaction.getIncomingFinancialTransaction() != null && transaction.getGLDescription().trim().length() == 0) {
            glDescription = this.processParameters.getAssetIdInDescription() ? String.valueOf(transaction.getAssetId()) + " " + transaction.getIncomingFinancialTransaction().getDescription() : transaction.getIncomingFinancialTransaction().getDescription();
            return this.substringGLDescription(glDescription);
        }
        glDescription = this.singleVoucherId ? transaction.getDescription() : ("A".equals(transaction.getCora()) ? String.valueOf(this.processDescriptionShort) + transaction.getAssetId() : String.valueOf(this.processDescriptionShort) + transaction.getCreditId());
        return this.substringGLDescription(glDescription);
    }

    private String substringGLDescription(String glDescription) throws Exception {
        int descriptionLength = glDescription.length();
        if (descriptionLength == 0) {
            return "";
        }
        if (descriptionLength < 20) {
            return glDescription;
        }
        return glDescription.substring(0, 20);
    }

    private void initializeVoucherDateSwitches() throws Exception {
        if (this.processParameters.getStandardVoucherDate() == 5) {
            this.belgianVoucherId = this.transactionBatch.getVoucherId();
            this.belgianVoucherDate = this.transactionBatch.getVoucherDate();
            this.voucherDateMainSwitch = 5;
            return;
        }
        if (this.transactionBatch.getBatchCode() != 0 && this.transactionBatch.getBatchCode() != 3) {
            if (this.processParameters.getVoucherDateDIR() == 4) {
                this.voucherDateMainSwitch = 4;
                this.startMonth = this.processParameters.getStartMonth();
            }
            if (this.processParameters.getSummarizeOnKey()) {
                this.initializeCurrentVoucherId(this.transactionBatch);
                this.singleVoucherId = true;
            }
        } else if (this.processParameters.getVoucherDateIFTT() == 3) {
            this.voucherDateMainSwitch = 3;
        }
        if (this.processParameters.getStandardVoucherDate() == 2) {
            this.voucherDateSubSwitch = 2;
            this.processingDate = new Date();
        } else {
            this.voucherDateSubSwitch = 1;
        }
    }

    private void initializeAdditionalJournalingData() throws Exception {
        HashMap hm;
        Collection typeIds = AdditionalJournalingDataBO.retrieveAdditionalJournalingDataTypes(this.company, 1);
        if (typeIds != null && !typeIds.isEmpty()) {
            this.AP1HasAJD = true;
            this.ajdForAP1 = hm = this.retrieveJournalingTerms(typeIds, 1);
        }
        if ((typeIds = AdditionalJournalingDataBO.retrieveAdditionalJournalingDataTypes(this.company, 2)) != null && !typeIds.isEmpty()) {
            this.AP2HasAJD = true;
            this.ajdForAP2 = hm = this.retrieveJournalingTerms(typeIds, 2);
        }
    }

    private HashMap retrieveJournalingTerms(Collection typeIds, int accountingPrinciple) throws Exception {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (String typeId : typeIds) {
            Collection ajds = AdditionalJournalingDataBO.retrieveJournalingTerms(this.company, typeId, accountingPrinciple);
            Iterator ajdsIter = ajds.iterator();
            String jts = "-";
            while (ajdsIter.hasNext()) {
                AdditionalJournalingData ajd = (AdditionalJournalingData)ajdsIter.next();
                jts = String.valueOf(jts) + ajd.getJournalingTerm() + "-";
            }
            hm.put(typeId, jts);
        }
        return hm;
    }

    private void initializeDisinvestmentReasonMainAccounts() throws Exception {
        int i = 1;
        while (i < 5) {
            if (this.capDefaults[i] != null) {
                this.dirlas[i][1] = this.capDefaults[i].getMainAccountDIRC150();
                this.dirlas[i][2] = this.capDefaults[i].getMainAccountDIRC250();
                this.dirlas[i][3] = this.capDefaults[i].getMainAccountDIRC350();
                this.dirlas[i][4] = this.capDefaults[i].getMainAccountDIRC450();
                this.dirlas[i][5] = this.capDefaults[i].getMainAccountDIRC550();
                this.dirpas[i][1] = this.capDefaults[i].getMainAccountDIRC160();
                this.dirpas[i][2] = this.capDefaults[i].getMainAccountDIRC260();
                this.dirpas[i][3] = this.capDefaults[i].getMainAccountDIRC360();
                this.dirpas[i][4] = this.capDefaults[i].getMainAccountDIRC460();
                this.dirpas[i][5] = this.capDefaults[i].getMainAccountDIRC560();
            }
            ++i;
        }
    }

    private void initializeDaybookArray() throws Exception {
        int i = 1;
        while (i < 5) {
            if (this.capDefaults[i] != null) {
                this.dbIds[i][1] = this.capDefaults[i].getDaybookId1();
                this.dbIds[i][2] = this.capDefaults[i].getDaybookId2();
                this.dbIds[i][3] = this.capDefaults[i].getDaybookId3();
                this.dbIds[i][4] = this.capDefaults[i].getDaybookId4();
                this.dbIds[i][5] = this.capDefaults[i].getDaybookId5();
                this.dbIds[i][6] = this.capDefaults[i].getDaybookId6();
                this.dbIds[i][7] = this.capDefaults[i].getDaybookId7();
                if (this.dbIds[i][2].length() == 0) {
                    this.dbIds[i][2] = this.dbIds[i][1];
                }
                if (this.dbIds[i][3].length() == 0) {
                    this.dbIds[i][3] = this.dbIds[i][1];
                }
                if (this.dbIds[i][4].length() == 0) {
                    this.dbIds[i][4] = this.dbIds[i][1];
                }
                if (this.dbIds[i][5].length() == 0) {
                    this.dbIds[i][5] = this.dbIds[i][1];
                }
                if (this.dbIds[i][6].length() == 0) {
                    this.dbIds[i][6] = this.dbIds[i][1];
                }
                if (this.dbIds[i][7].length() == 0) {
                    this.dbIds[i][7] = this.dbIds[i][1];
                }
            }
            ++i;
        }
    }

    private void initializeCurrentDaybook(int transactionType) throws Exception {
        this.processDescriptionShort = this.currentDocumentNr + "-" + transactionType + "-";
        int i = 1;
        while (i < 5) {
            if (this.capDefaults[i] != null) {
                switch (transactionType) {
                    case 10: {
                        this.currentDaybook[i] = this.dbIds[i][2];
                        break;
                    }
                    case 15: {
                        this.currentDaybook[i] = this.dbIds[i][2];
                        break;
                    }
                    case 20: {
                        this.currentDaybook[i] = this.dbIds[i][2];
                        break;
                    }
                    case 30: {
                        this.currentDaybook[i] = this.dbIds[i][3];
                        break;
                    }
                    case 40: {
                        this.currentDaybook[i] = this.dbIds[i][4];
                        break;
                    }
                    case 50: {
                        this.currentDaybook[i] = this.dbIds[i][5];
                        break;
                    }
                    case 60: {
                        this.currentDaybook[i] = this.dbIds[i][1];
                        break;
                    }
                    case 70: {
                        this.currentDaybook[i] = this.dbIds[i][6];
                        break;
                    }
                    case 71: {
                        this.currentDaybook[i] = this.dbIds[i][6];
                        break;
                    }
                    case 72: {
                        this.currentDaybook[i] = this.dbIds[i][6];
                        break;
                    }
                    case 80: {
                        this.currentDaybook[i] = this.dbIds[i][6];
                        break;
                    }
                    case 90: {
                        this.currentDaybook[i] = this.dbIds[i][6];
                        break;
                    }
                    case 85: {
                        this.currentDaybook[i] = this.dbIds[i][6];
                        break;
                    }
                    case 130: {
                        this.currentDaybook[i] = this.dbIds[i][3];
                        break;
                    }
                    default: {
                        this.currentDaybook[i] = this.dbIds[i][1];
                    }
                }
            }
            ++i;
        }
    }

    private void initializeCurrentVoucherId(Transaction transaction) throws Exception {
        this.currentYear = transaction.getBookYearForJournalization();
        this.initializeCurrentVoucherId();
    }

    private void initializeCurrentVoucherId(TransactionBatch transactionBatch) throws Exception {
        this.currentYear = transactionBatch.getEndYear();
        this.initializeCurrentVoucherId();
    }

    private void initializeCurrentVoucherId() throws Exception {
        this.lastVoucherId = (String)this.voucherIds.get("" + this.currentYear);
        if (this.lastVoucherId == null) {
            BookYear bookYear = (BookYear)BookYearBO.get(this.company, this.currentYear)[0];
            if (bookYear == null) {
                TokenList tl = new TokenList();
                tl.addNonTranslatable("" + this.currentYear);
                throw new Exception(LanguageHelper.getString("nl.ibs.fac.language", "bookYear_not_found", tl));
            }
            this.bookYears.put("" + this.currentYear, bookYear);
            this.lastVoucherId = "" + bookYear.getLastVoucherId();
        }
        this.currentVoucherId = Integer.parseInt(this.lastVoucherId) + 1;
        this.voucherIds.put("" + this.currentYear, "" + this.currentVoucherId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeCurrentMainAccounts(Transaction transaction) throws Exception {
        this.maId1 = "";
        this.maId2 = "";
        this.maId3 = "";
        this.maId4 = "";
        this.maId5 = "";
        this.maId6 = "";
        this.maId7 = "";
        this.maId8 = "";
        this.maId9 = "";
        this.maId10 = "";
        this.maId11 = "";
        if (transaction.getAsset() != null) {
            if (!this.company.getUseValuationMainAccount()) {
                MainAccountScheme mainAccountSchemeToUse = MainAccountSchemeBO.getMainAccountSchemeToUse(transaction.getAsset().getAssetType(), transaction);
                if (mainAccountSchemeToUse == null) return;
                this.maId1 = mainAccountSchemeToUse.getMainAccountId1();
                this.maId2 = mainAccountSchemeToUse.getMainAccountId2();
                this.maId3 = mainAccountSchemeToUse.getMainAccountId3();
                this.maId4 = mainAccountSchemeToUse.getMainAccountId4();
                this.maId5 = mainAccountSchemeToUse.getMainAccountId5();
                this.maId6 = mainAccountSchemeToUse.getMainAccountId6();
                this.maId7 = mainAccountSchemeToUse.getMainAccountId7();
                this.maId8 = mainAccountSchemeToUse.getMainAccountId8();
                this.maId9 = mainAccountSchemeToUse.getMainAccountId9();
                this.maId10 = mainAccountSchemeToUse.getMainAccountId10();
                this.maId11 = mainAccountSchemeToUse.getMainAccountId11();
                return;
            }
            this.handleValuationMainAccountValues(transaction);
            return;
        }
        if (transaction.getCreditId() == null) return;
        this.handleValuationMainAccountValues(transaction);
    }

    private void handleValuationMainAccountValues(Transaction transaction) throws Exception {
        ValuationMainAccount vmaToUse = ValuationMainAccountBO.getValuationMainAccountToUse(transaction);
        if (vmaToUse != null) {
            this.maId1 = vmaToUse.getMainAccountId1();
            this.maId2 = vmaToUse.getMainAccountId2();
            this.maId3 = vmaToUse.getMainAccountId3();
            this.maId4 = vmaToUse.getMainAccountId4();
            this.maId5 = vmaToUse.getMainAccountId5();
            this.maId6 = vmaToUse.getMainAccountId6();
            this.maId7 = vmaToUse.getMainAccountId7();
            this.maId8 = vmaToUse.getMainAccountId8();
            this.maId9 = vmaToUse.getMainAccountId9();
            return;
        }
    }

    private void setMainaccounts(Transaction transaction) throws Exception {
        if (transaction.getMainAccountsSet()) {
            return;
        }
        Log.debug((String)("*** setMainaccounts transaction.getMainTransactionType()=" + transaction.getMainTransactionType()));
        switch (transaction.getMainTransactionType()) {
            case 1: {
                Log.debug((String)("*** setMainaccounts transaction.getAccountingPrinciple()=" + transaction.getAccountingPrinciple()));
                Log.debug((String)("*** INVESTMENT maId1 = " + this.maId1));
                Log.debug((String)("***            maId2 = " + this.maId2));
                Log.debug((String)("***            maId3 = " + this.maId3));
                Log.debug((String)("***            maId4 = " + this.maId4));
                Log.debug((String)("***            maId5 = " + this.maId5));
                Log.debug((String)("***            maId6 = " + this.maId6));
                Log.debug((String)("***            maId7 = " + this.maId7));
                Log.debug((String)("***            maId8 = " + this.maId8));
                if (transaction.getAccountingPrinciple() == 3) {
                    transaction.setMainAccount2(this.maId2);
                    transaction.setMainAccount4(this.maId4);
                    this.updateJournalingTerms(transaction, 10, 20, 0, 40);
                    return;
                }
                transaction.setMainAccount1(this.maId1);
                transaction.setMainAccount2(this.maId2);
                if (transaction.getTransactionType() == 50) {
                    transaction.setMainAccount4(this.maId9);
                    this.updateJournalingTerms(transaction, 10, 20, 0, 90);
                } else {
                    transaction.setMainAccount4(this.maId4);
                    this.updateJournalingTerms(transaction, 10, 20, 0, 40);
                }
                return;
            }
            case 2: {
                transaction.setMainAccount1(this.maId1);
                transaction.setMainAccount2(this.maId2);
                if (transaction.getTransactionType() == 50) {
                    if ("".equals(transaction.getAlternativeCompanyId())) {
                        transaction.setMainAccount3(this.maId9);
                        this.updateJournalingTerms(transaction, 10, 20, 0, 90);
                    } else {
                        String[] maId34 = this.retrieveICMovementMainAccounts(transaction);
                        transaction.setMainAccount3(maId34[0]);
                        transaction.setMainAccount4(maId34[1]);
                        this.updateJournalingTerms(transaction, 10, 20, 0, 0);
                    }
                    return;
                }
                transaction.setMainAccount4(this.maId4);
                this.setBookResultAccount(transaction);
                return;
            }
            case 3: {
                Log.debug((String)"*** setMainaccounts DEPRECIATION_INTEREST_ECONOMICLIFE");
                Log.debug((String)("*** DEPRECIATION_INTEREST_ECONOMICLIFE maId1 = " + this.maId1));
                Log.debug((String)("***                                    maId2 = " + this.maId2));
                Log.debug((String)("***                                    maId3 = " + this.maId3));
                Log.debug((String)("***                                    maId4 = " + this.maId4));
                Log.debug((String)("***                                    maId5 = " + this.maId5));
                Log.debug((String)("***                                    maId6 = " + this.maId6));
                Log.debug((String)("***                                    maId7 = " + this.maId7));
                Log.debug((String)("***                                    maId8 = " + this.maId8));
                transaction.setMainAccount1(this.maId3);
                transaction.setMainAccount2(this.maId2);
                transaction.setMainAccount3(this.maId8);
                transaction.setMainAccount4(this.maId7);
                this.updateJournalingTerms(transaction, 30, 20, 80, 70);
                return;
            }
            case 5: {
                transaction.setMainAccount1(this.maId11);
                transaction.setMainAccount2(this.maId10);
                transaction.setMainAccount3(this.maId8);
                transaction.setMainAccount4(this.maId7);
                this.updateJournalingTerms(transaction, 100, 110, 80, 70);
                return;
            }
        }
    }

    private void updateJournalingTerms(Transaction transaction, int jt1, int jt2, int jt3, int jt4) throws Exception {
        Log.debug((String)"*** updateJournalingTerms");
        Log.debug((String)("***                       jt1 = " + jt1));
        Log.debug((String)("***                       jt2 = " + jt2));
        Log.debug((String)("***                       jt3 = " + jt3));
        Log.debug((String)("***                       jt4 = " + jt4));
        if (transaction.getAccountingPrinciple() == 1) {
            if (!this.AP1HasAJD) {
                return;
            }
            if (!this.ajdForAP1.containsKey(transaction.getProFormaTypeId())) {
                return;
            }
            this.updateJournalingTerms(transaction, jt1, jt2, jt3, jt4, (String)this.ajdForAP1.get(transaction.getProFormaTypeId()));
            return;
        }
        if (transaction.getAccountingPrinciple() == 2) {
            if (!this.AP2HasAJD) {
                return;
            }
            if (!this.ajdForAP2.containsKey(transaction.getProFormaTypeId())) {
                return;
            }
            this.updateJournalingTerms(transaction, jt1, jt2, jt3, jt4, (String)this.ajdForAP2.get(transaction.getProFormaTypeId()));
            return;
        }
        if (transaction.getAccountingPrinciple() == 3) {
            if (!this.AP1HasAJD) {
                return;
            }
            Credit credit = (Credit)CreditBO.get(this.company, transaction.getCreditId())[0];
            if (credit == null) {
                return;
            }
            String proFormaTypeId = credit.getProFormaTypeId();
            if (proFormaTypeId == null || proFormaTypeId.trim().length() == 0) {
                return;
            }
            if (!this.ajdForAP1.containsKey(proFormaTypeId)) {
                return;
            }
            this.updateJournalingTerms(transaction, jt1, jt2, jt3, jt4, (String)this.ajdForAP1.get(proFormaTypeId));
            return;
        }
    }

    private void updateJournalingTerms(Transaction transaction, int jt1, int jt2, int jt3, int jt4, String jts) throws Exception {
        int[] jtIn = new int[]{jt1, jt2, jt3, jt4};
        int[] jtOut = new int[4];
        int i = 0;
        while (i < 4) {
            if (jtIn[i] > 0 && jts.indexOf("-" + jtIn[i] + "-") > -1) {
                jtOut[i] = jtIn[i];
            }
            ++i;
        }
        if (jtOut[0] > 0) {
            transaction.setJournalingTerm1(jtOut[0]);
        }
        if (jtOut[1] > 0) {
            transaction.setJournalingTerm2(jtOut[1]);
        }
        if (jtOut[2] > 0) {
            transaction.setJournalingTerm3(jtOut[2]);
        }
        if (jtOut[3] > 0) {
            transaction.setJournalingTerm4(jtOut[3]);
        }
    }

    private void setBookResultAccount(Transaction transaction) throws Exception {
        boolean isProfit = false;
        String resultAccount = "";
        BigDecimal value = transaction.getAmount1().subtract(transaction.getAmount2()).add(transaction.getAmount3());
        if (value.doubleValue() == 0.0) {
            transaction.setMainAccount3("");
            return;
        }
        if (transaction.getAsset().getNegativeInvestment()) {
            if (value.doubleValue() < 0.0) {
                transaction.setMainAccount3(this.maId6);
                isProfit = true;
            } else {
                transaction.setMainAccount3(this.maId5);
            }
        } else if (value.doubleValue() > 0.0) {
            transaction.setMainAccount3(this.maId6);
            isProfit = true;
        } else {
            transaction.setMainAccount3(this.maId5);
        }
        if (isProfit) {
            this.updateJournalingTerms(transaction, 10, 20, 60, 40);
        } else {
            this.updateJournalingTerms(transaction, 10, 20, 50, 40);
        }
        if (transaction.getDisinvestmentReasonCode() > 0 && !"".equals((resultAccount = isProfit ? this.dirpas[transaction.getAccountingPrinciple()][transaction.getDisinvestmentReasonCode()] : this.dirlas[transaction.getAccountingPrinciple()][transaction.getDisinvestmentReasonCode()]).trim())) {
            transaction.setMainAccount3(resultAccount);
        }
    }

    private String[] retrieveICMovementMainAccounts(Transaction transaction) throws Exception {
        String[] maId34 = new String[]{"", ""};
        Company companyTo = (Company)CompanyBO.get(transaction.getDBData(), transaction.getAlternativeCompanyId())[0];
        if (companyTo == null) {
            return maId34;
        }
        Transaction transactionTo = (Transaction)TransactionBO.get(transaction.getDBData(), companyTo.getId(), transaction.getRevDocumentNr(), transaction.getRevSeqNr())[0];
        if (transactionTo == null) {
            return maId34;
        }
        Asset assetTo = transactionTo.getAsset();
        if (assetTo == null) {
            return maId34;
        }
        AssetType assetTypeTo = assetTo.getAssetType();
        if (assetTypeTo == null) {
            return maId34;
        }
        MainAccountScheme masTo = MainAccountSchemeBO.getMainAccountSchemeToUse(assetTypeTo, transactionTo.getAccountingPrinciple(), transactionTo.getBookYearForJournalization(), transactionTo.getPeriodForJournalization());
        if (masTo != null) {
            maId34[0] = masTo.getMainAccountId1();
            maId34[1] = masTo.getMainAccountId2();
        }
        return maId34;
    }

    private void setVoucherDate(Transaction transaction) throws Exception {
        switch (this.voucherDateMainSwitch) {
            case 5: {
                transaction.setVoucherDate(this.belgianVoucherDate);
                return;
            }
            case 4: {
                transaction.setVoucherDate(PeriodHelper.getLastDayOfMonth(this.startMonth, transaction.getBookYear(), transaction.getPeriod(), this.processParameters.getCalendarYearCorrection()));
                return;
            }
            case 3: {
                if (this.iftDate == null) break;
                transaction.setVoucherDate(this.iftDate);
                return;
            }
        }
        switch (this.voucherDateSubSwitch) {
            case 1: {
                transaction.setVoucherDate(transaction.getCreationDate());
                return;
            }
            case 2: {
                transaction.setVoucherDate(this.processingDate);
                return;
            }
        }
    }

    private void updateLastUsedVoucherIds() throws Exception {
        if (this.voucherDateMainSwitch == 5) {
            return;
        }
        for (String year : this.bookYears.keySet()) {
            BookYear bookYear = (BookYear)this.bookYears.get(year);
            int lastVoucherId = Integer.parseInt((String)this.voucherIds.get(year));
            if (lastVoucherId == bookYear.getLastVoucherId()) continue;
            bookYear.setLastVoucherId(lastVoucherId);
        }
    }
}

