/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class WriteOffBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 3067787731772046677L;
    private Valuation valuation;
    private String reasonDescription;

    public WriteOffBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public String[] retrieveYearsAndPeriodsForWriteOff(Asset asset) throws Exception {
        String[] yps = new String[4];
        int[] yearPeriod = this.getLastTransactionYearPeriod(asset, 0, 0);
        int[] nextYearPeriod = PeriodHelper.isAfter(yearPeriod[0], yearPeriod[1], this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod()) ? PeriodHelper.getNextPeriod(this.numberOfPeriods, yearPeriod[0], yearPeriod[1]) : PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
        yps[0] = "" + nextYearPeriod[0];
        yps[1] = "" + nextYearPeriod[1];
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    private int[] getLastTransactionYearPeriod(Asset asset, int year, int period) throws Exception {
        int[] correctionYearPeriod = new int[2];
        for (Valuation valuation : asset.getValuationsCollection(null)) {
            Collection transactions = TransactionBO.getAfterOrEquals(asset, year, period, valuation.getAccountingPrinciple());
            for (Transaction transaction : transactions) {
                if (!PeriodHelper.isAfter(transaction.getBookYear(), transaction.getPeriod(), year, period)) continue;
                correctionYearPeriod[0] = transaction.getBookYear();
                correctionYearPeriod[1] = transaction.getPeriod();
            }
        }
        return correctionYearPeriod;
    }

    public String[] retrieveYearsAndPeriodsForUndoWriteOff(Asset asset) throws Exception {
        String[] yps = new String[4];
        int[] nextYearPeriod = null;
        if (this.company.getLastDepreciationRunYear() > 0) {
            nextYearPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
        }
        if (nextYearPeriod == null) {
            yps[0] = "" + asset.getDisinvestmentYear();
            yps[1] = "" + asset.getDisinvestmentPeriod();
        } else if (PeriodHelper.isAfter((int)nextYearPeriod[0], (int)nextYearPeriod[1], asset.getDisinvestmentYear(), asset.getDisinvestmentPeriod())) {
            yps[0] = "" + nextYearPeriod[0];
            yps[1] = "" + nextYearPeriod[1];
        } else {
            yps[0] = "" + asset.getDisinvestmentYear();
            yps[1] = "" + asset.getDisinvestmentPeriod();
        }
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    public String[] validateFACYearAndPeriodForWriteOff(Asset asset, int facYear, int facPeriod) throws Exception {
        int status;
        String[] messages = new String[2];
        int index = 0;
        int[] yearPeriod = this.getLastTransactionYearPeriod(asset, 0, 0);
        if (!PeriodHelper.isAfter(facYear, facPeriod, yearPeriod[0], yearPeriod[1])) {
            messages[index] = "FACPeriodShouldBeAfterLastTransactionPeriod";
            ++index;
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateFACYearAndPeriodForUndoWriteOff(Asset asset, int facYear, int facPeriod) throws Exception {
        int status;
        int thePeriod;
        String[] messages = new String[2];
        int index = 0;
        int theYear = asset.getDisinvestmentYear();
        if (PeriodHelper.isBefore(facYear, facPeriod, theYear, thePeriod = asset.getDisinvestmentPeriod())) {
            messages[index] = "FACPeriodBeforeWriteOffPeriod";
            ++index;
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String createWriteOff(Asset asset, Transaction anonymous, String user, int batchId, int transactionNumber) throws Exception {
        this.asset = asset;
        this.facYear = anonymous.getBookYear();
        this.facPeriod = anonymous.getPeriod();
        this.finBookYear = anonymous.getBookYearForJournalization();
        this.finBookPeriod = anonymous.getPeriodForJournalization();
        if (this.finBookYear == 0) {
            this.finBookYear = this.facYear;
            this.finBookPeriod = this.facPeriod;
        }
        this.reasonDescription = anonymous.getDescription();
        this.user = user;
        this.documentNr = transactionNumber;
        this.seqNr = 0;
        this.post = true;
        String message = null;
        this.writeOff(batchId, transactionNumber);
        return message;
    }

    public String createWriteOff(Asset asset, int facYear, int facPeriod, int finYear, int finPeriod, String description, String user) throws Exception {
        this.asset = asset;
        this.facYear = facYear;
        this.facPeriod = facPeriod;
        if (finYear == 0) {
            this.finBookYear = facYear;
            this.finBookPeriod = facPeriod;
        } else {
            this.finBookYear = finYear;
            this.finBookPeriod = finPeriod;
        }
        this.reasonDescription = description.trim().length() == 0 ? String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "ManualWriteOff")) + " " + facYear + "-" + facPeriod : description;
        this.user = user;
        this.documentNr = 0;
        this.seqNr = 0;
        this.post = true;
        String message = null;
        this.writeOff(-1, 0);
        return message;
    }

    private String writeOff(int batchId, int transactionNumber) throws Exception {
        String message = null;
        this.retrieveFinancialDimensions(this.facYear, this.facPeriod);
        Iterator vi = this.asset.getValuationsCollection(null).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (vi.hasNext()) {
                this.valuation = (Valuation)vi.next();
                Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.reasonDescription, this.asset.getCora(), this.asset.getId(), this.valuation.getAccountingPrinciple(), 1, 140, this.facYear, this.facPeriod, this.finBookYear, this.finBookPeriod, this.valuation.getPostedAcquisitionBalance().negate(), this.valuation.getPostedDepreciationBalance().negate(), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(this.valuation.getAccountingPrinciple(), 1), 0, batchId, this.user, this.asset.getTypeId());
                if (objects[0] == null) {
                    return (String)objects[1];
                }
                Transaction transaction = (Transaction)objects[0];
                transaction.setState(1);
                if (this.documentNr == 0) {
                    this.documentNr = transaction.getDocumentNr();
                }
                GenericTransactionBP.updatePostedAcquisitionBalance(this.asset, this.valuation, transaction, false);
            }
            this.asset.setState(7);
            this.asset.setDisinvestmentYear(this.facYear);
            this.asset.setDisinvestmentPeriod(this.facPeriod);
            this.asset.setFinDisinvestmentYear(this.finBookYear);
            this.asset.setFinDisinvestmentPeriod(this.finBookPeriod);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    public String createUndoWriteOff(Asset asset, int facYear, int facPeriod, int finYear, int finPeriod, String description, String user) throws Exception {
        this.asset = asset;
        this.facYear = facYear;
        this.facPeriod = facPeriod;
        if (finYear == 0) {
            this.finBookYear = facYear;
            this.finBookPeriod = facPeriod;
        } else {
            this.finBookYear = finYear;
            this.finBookPeriod = finPeriod;
        }
        this.documentNr = 0;
        this.seqNr = 0;
        if (description.trim().length() == 0) {
            description = LanguageHelper.getString("nl.ibs.fac.language", "UndoWriteOff");
        }
        String message = null;
        this.retrieveFinancialDimensions(facYear, facPeriod);
        Iterator vi = asset.getValuationsCollection(null).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (vi.hasNext()) {
                this.valuation = (Valuation)vi.next();
                BigDecimal[] undoForWriteOffValues = this.retrieveUndoWriteOffValues(asset, asset.getDisinvestmentYear(), asset.getDisinvestmentPeriod(), this.valuation.getAccountingPrinciple());
                Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, description, asset.getCora(), asset.getId(), this.valuation.getAccountingPrinciple(), 1, 142, facYear, facPeriod, this.finBookYear, this.finBookPeriod, undoForWriteOffValues[0].negate(), undoForWriteOffValues[1].negate(), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(this.valuation.getAccountingPrinciple(), 1), 0, -1, user, asset.getTypeId());
                if (objects[0] == null) {
                    return (String)objects[1];
                }
                Transaction transaction = (Transaction)objects[0];
                transaction.setState(1);
                if (this.documentNr == 0) {
                    this.documentNr = transaction.getDocumentNr();
                }
                GenericTransactionBP.updatePostedAcquisitionBalance(asset, this.valuation, transaction, false);
            }
            asset.setState(2);
            asset.setDisinvestmentYear(0);
            asset.setDisinvestmentPeriod(0);
            asset.setFinDisinvestmentYear(0);
            asset.setFinDisinvestmentPeriod(0);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    public BigDecimal[] retrieveUndoWriteOffValues(Asset asset, int year, int period, int accountingPrinciple) throws Exception {
        BigDecimal[] values = new BigDecimal[]{new BigDecimal(0), new BigDecimal(0)};
        for (Transaction writeOffTransaction : TransactionBO.getAfterOrEquals(asset, year, period, accountingPrinciple)) {
            if (writeOffTransaction.getTransactionType() != 140) continue;
            values[0] = writeOffTransaction.getAmount1();
            values[1] = writeOffTransaction.getAmount2();
        }
        return values;
    }
}

