/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.commands;

import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public abstract class DepreciationNewProposalCommand {
    public static final String CLASSNAME = DepreciationNewProposalCommand.class.getName();

    public static String execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        String message = null;
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        Log.info((String)map.toString());
        DBData dbData = BOAdapter.getDBData(map);
        String companyId = (String)map.get("Company");
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        TransactionBatch transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(dbData, companyId);
        if (transactionBatch != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "batch_already_exists");
            Log.error((String)message);
            return message;
        }
        String user = BatchJobHelper.getUser(args);
        Object[] result = TransactionBatchBO.create(company.getDBData(), company.getId(), user, 1);
        message = (String)result[1];
        if (message != null) {
            Log.error((String)LanguageHelper.getString("nl.ibs.fac.language", message));
            return message;
        }
        transactionBatch = (TransactionBatch)result[0];
        transactionBatch.setEndYear(Integer.parseInt((String)map.get("BookYearTo")));
        transactionBatch.setEndPeriod(Integer.parseInt((String)map.get("PeriodTo")));
        transactionBatch.setFinYear(Integer.parseInt((String)map.get("finYear")));
        transactionBatch.setFinPeriod(Integer.parseInt((String)map.get("finPeriod")));
        String value = (String)map.get("AP1");
        if (value != null) {
            transactionBatch.setCodeFiscal(Boolean.valueOf(value));
        }
        if ((value = (String)map.get("AP2")) != null) {
            transactionBatch.setCodeAccountingPrinciple2(Boolean.valueOf(value));
        }
        return message;
    }
}

