/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.commands;

import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public abstract class MassTransactionCreateCommand {
    public static final String CLASSNAME = MassTransactionCreateCommand.class.getName();

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            String message = MassTransactionCreateCommand.execute(args);
            if (message != null) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static String execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        Log.info((String)map.toString());
        DBData dbData = BOAdapter.getDBData(map);
        String companyId = (String)map.get("Company");
        String user = (String)map.get("User");
        int mtProcType = Integer.parseInt((String)map.get("PROCTYPE"));
        String message = null;
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(dbData, companyId);
        if (transactionBatch != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "batch_already_exists");
            Log.error((String)message);
            return message;
        }
        Object[] result = TransactionBatchBO.create(dbData, companyId, user, 3);
        if (result[1] != null) {
            message = (String)result[1];
            Log.error((String)message);
            return message;
        }
        transactionBatch = (TransactionBatch)result[0];
        transactionBatch.setMassTransactionProcessType(mtProcType);
        String[] args2 = new String[args.length + 2];
        System.arraycopy(args, 0, args2, 0, args.length);
        args2[args.length] = "batchId";
        args2[args.length + 1] = "" + transactionBatch.getBatchId();
        args = args2;
        selections = BatchJobHelper.getSelections(args);
        MassTransactionBP massTransactionBP = MassTransactionBP.getInstanceFor(transactionBatch);
        massTransactionBP.addParameters(transactionBatch, selections);
        message = massTransactionBP.createProposal(transactionBatch, user);
        if (message != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return message;
        }
        return message;
    }
}

