/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.commands;

import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.commands.TransactionBatchBookCommand;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public abstract class MassTransactionPostCommand {
    public static final String CLASSNAME = MassTransactionPostCommand.class.getName();

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            String message = MassTransactionPostCommand.execute(args);
            if (message != null) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static String execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        String message = null;
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        Log.info((String)map.toString());
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(dbData, companyId);
        if (transactionBatch == null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            Log.error((String)message);
            return message;
        }
        String user = (String)map.get("User");
        MassTransactionBP massTransactionBP = MassTransactionBP.getInstanceFor(transactionBatch);
        message = massTransactionBP.postProposal(transactionBatch, user);
        if (message != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return message;
        }
        if (transactionBatch.getMassTransactionProcessType() == 3) {
            return message;
        }
        if (!map.containsKey("batchId")) {
            String[] args2 = new String[args.length + 2];
            System.arraycopy(args, 0, args2, 0, args.length);
            args2[args.length] = "batchId";
            args2[args.length + 1] = "" + transactionBatch.getBatchId();
            args = args2;
        }
        return TransactionBatchBookCommand.execute(args);
    }
}

