/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.conversion;

import java.util.Collection;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public abstract class FacDB0120 {
    public static void execute(DBData dbData) throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setFilter("state = 4 OR state = 5");
        Collection assets = AssetManagerFactory.getInstance(dbData).getCollection(query);
        Log.debug((String)("number of assets: " + assets.size()));
        if (assets.size() == 0) {
            return;
        }
        Collection transactions = null;
        for (Asset asset : assets) {
            Valuation valuation = (Valuation)ValuationBO.getValuation(dbData, asset.getCompanyId(), "A", asset.getId(), 1)[0];
            if (valuation == null || (transactions = TransactionBO.getTransactions(valuation, true)).size() == 0) continue;
            for (Transaction transaction : transactions) {
                if (transaction.getTransactionType() != 30 && transaction.getTransactionType() != 50) continue;
                asset.setDisinvestmentYear(transaction.getBookYear());
                asset.setDisinvestmentPeriod(transaction.getPeriod());
                asset.setFinDisinvestmentYear(transaction.getBookYearForJournalization());
                asset.setFinDisinvestmentPeriod(transaction.getPeriodForJournalization());
            }
        }
    }
}

