/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.db.AnalysisCode;
import nl.ibs.fac.db.AnalysisCodeDataBean;
import nl.ibs.fac.db.AnalysisCodePK;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AnalysisGroupPK;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.impl.AnalysisCodeManager_Impl;
import nl.ibs.fac.db.impl.AnalysisGroupManager_Impl;
import nl.ibs.fac.db.impl.AssetAnalysisCodeManager_Impl;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataAnalysisCode;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class AnalysisCode_Impl
implements AnalysisCode,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataAnalysisCode.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected int seqNr;
    protected String code;
    protected String description;

    protected AnalysisCode_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected AnalysisCode_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected AnalysisCode_Impl(DBData _dbd, String _companyId, int _seqNr, String _code) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setSeqNr(_seqNr);
            this.setCode(_code);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected AnalysisCode_Impl(DBData _dbd, AnalysisCodeDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.AnalysisCodeDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate AnalysisCode with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.AnalysisCodeDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setSeqNr(bean.getSeqNr());
            this.setCode(bean.getCode());
            this.setDescription(bean.getDescription());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public AnalysisCode_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.seqNr = rs.getInt(pmd.getFieldName("SeqNr", provider));
        this.code = rs.getString(pmd.getFieldName("Code", provider));
        this.description = rs.getString(pmd.getFieldName("Description", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        AnalysisCodePK key = new AnalysisCodePK();
        key.setCompanyId(this.getCompanyId());
        key.setSeqNr(this.getSeqNr());
        key.setCode(this.getCode());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public int getSeqNr() throws Exception {
        this.assureStorage();
        return this.seqNr;
    }

    @Override
    public String getCode() throws Exception {
        this.assureStorage();
        return this.code;
    }

    @Override
    public String getDescription() throws Exception {
        return this.description;
    }

    @Override
    public Company getOwnedByCompanyAsAnalysisCodes() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsAnalysisCodes")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsAnalysisCodes");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsAnalysisCodes", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public AnalysisGroup getOwnedByAnalysisGroupAsCodes() throws Exception {
        if (this.isCachedRelation("ownedByAnalysisGroupAsCodes")) {
            return (AnalysisGroup)this.getCachedRelationObject("ownedByAnalysisGroupAsCodes");
        }
        AnalysisGroupPK primaryKey = new AnalysisGroupPK();
        primaryKey.setCompanyId(this.getCompanyId());
        primaryKey.setSeqNr(this.getSeqNr());
        try {
            return (AnalysisGroup)this.addCachedRelationObject("ownedByAnalysisGroupAsCodes", ((AnalysisGroupManager_Impl)AnalysisGroupManager_Impl.getInstance(this.dbd)).findByPrimaryKey(primaryKey));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        BusinessObject owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsAnalysisCodes();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        owningBusinessObject = this.getOwnedByAnalysisGroupAsCodes();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    @Override
    public AssetAnalysisCode getAssetAnalysisCodesReferencingAnalysisCodeAsAnalysisCodeObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("analysisGroupCompanyId", this.getCompanyId());
        queryImpl.setParameter("seqNr", this.getSeqNr());
        queryImpl.setParameter("code", this.getCode());
        queryImpl.setRelationFilter("analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code");
        return AssetAnalysisCodeManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getAssetAnalysisCodesReferencingAnalysisCodeAsAnalysisCodeCollection(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("analysisGroupCompanyId", this.getCompanyId());
        queryImpl.setParameter("seqNr", this.getSeqNr());
        queryImpl.setParameter("code", this.getCode());
        queryImpl.setRelationFilter("analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code");
        return AssetAnalysisCodeManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getAssetAnalysisCodesReferencingAnalysisCodeAsAnalysisCodeDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("analysisGroupCompanyId", this.getCompanyId());
        queryImpl.setParameter("seqNr", this.getSeqNr());
        queryImpl.setParameter("code", this.getCode());
        queryImpl.setRelationFilter("analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code");
        return AssetAnalysisCodeManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getAssetAnalysisCodesReferencingAnalysisCodeAsAnalysisCodeDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("analysisGroupCompanyId", this.getCompanyId());
        queryImpl.setParameter("seqNr", this.getSeqNr());
        queryImpl.setParameter("code", this.getCode());
        queryImpl.setRelationFilter("analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code");
        return AssetAnalysisCodeManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getAssetAnalysisCodesReferencingAnalysisCodeAsAnalysisCodeDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("analysisGroupCompanyId", this.getCompanyId());
        queryImpl.setParameter("seqNr", this.getSeqNr());
        queryImpl.setParameter("code", this.getCode());
        queryImpl.setRelationFilter("analysisGroupCompanyId = ?analysisGroupCompanyId AND seqNr = ?seqNr AND code = ?code");
        return AssetAnalysisCodeManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public Collection referencedByBusinessObjects() throws Exception {
        ArrayList list = new ArrayList();
        list.addAll(this.getAssetAnalysisCodesReferencingAnalysisCodeAsAnalysisCodeCollection(null));
        return list;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setSeqNr(int _seqNr) throws Exception {
        if (_seqNr == this.getSeqNr()) {
            return;
        }
        this.preSet();
        this.seqNr = _seqNr;
        this.autoUpdate();
    }

    public void setCode(String _code) throws Exception {
        if (_code == null) {
            _code = "";
        }
        if (_code.equals(this.getCode())) {
            return;
        }
        this.preSet();
        this.code = _code;
        this.autoUpdate();
    }

    @Override
    public void setDescription(String _description) throws Exception {
        if (_description == null) {
            _description = "";
        }
        if (_description.equals(this.getDescription())) {
            return;
        }
        this.preSet();
        this.description = _description;
        this.autoUpdate();
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.seqNr = 0;
        this.code = "";
        this.description = "";
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.seqNr = this.seqNr;
        this.currentDBImage.code = this.code;
        this.currentDBImage.description = this.description;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("AnalysisCode is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            AnalysisCodePK key = new AnalysisCodePK();
            key.setCompanyId(this.getCompanyId());
            key.setSeqNr(this.getSeqNr());
            key.setCode(this.getCode());
            ((AnalysisCodeManager_Impl)AnalysisCodeManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((AnalysisCodeManager_Impl)AnalysisCodeManager_Impl.getInstance(this.dbd)).getResultSet((AnalysisCodePK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("1109723631_" + this.dbd.getDBId() + this.companyId + this.seqNr + this.code).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public AnalysisCodeDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public AnalysisCodeDataBean getAnalysisCodeDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private AnalysisCodeDataBean getDataBean(AnalysisCodeDataBean bean) throws Exception {
        if (bean == null) {
            bean = new AnalysisCodeDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setSeqNr(this.getSeqNr());
        bean.setCode(this.getCode());
        bean.setDescription(this.getDescription());
        return bean;
    }

    public boolean equals(Object object) {
        AnalysisCode_Impl bo;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    try {
                                        if (object != null && object instanceof AnalysisCode_Impl) break block11;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e.getMessage());
                                    }
                                }
                                bo = (AnalysisCode_Impl)object;
                                if (bo.getCompanyId() != null) break block12;
                                if (this.getCompanyId() != null) {
                                    return false;
                                }
                                break block13;
                            }
                            if (bo.getCompanyId().equals(this.getCompanyId())) break block13;
                            return false;
                        }
                        if (bo.getSeqNr() == this.getSeqNr()) break block14;
                        return false;
                    }
                    if (bo.getCode() != null) break block15;
                    if (this.getCode() != null) {
                        return false;
                    }
                    break block16;
                }
                if (bo.getCode().equals(this.getCode())) break block16;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block17;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(AnalysisCodeDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(AnalysisCodeDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setSeqNr(bean.getSeqNr());
            this.setCode(bean.getCode());
            this.setDescription(bean.getDescription());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "AnalysisCode is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.AnalysisCode.save");
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("SeqNr", provider) + " = ? " + ", " + pmd.getFieldName("Code", provider) + " = ? " + ", " + pmd.getFieldName("Description", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("SeqNr", provider) + " = ? " + " AND  " + pmd.getFieldName("Code", provider) + " = ? " + " AND  " + pmd.getFieldName("Description", provider) + " = ? ");
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.seqNr), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.code, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.seqNr), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.code, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.description, mapping.getJDBCTypeFor("String"));
                int n = prep.executeUpdate();
                if (n == 0) {
                    this.rollback(true);
                    throw new UpdateException("AnalysisCode modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.AnalysisCode.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.AnalysisCode.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("SeqNr", provider) + ", " + pmd.getFieldName("Code", provider) + ", " + pmd.getFieldName("Description", provider) + ") VALUES (?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)new Integer(this.seqNr), mapping.getJDBCTypeFor("int"));
                prep.setObject(3, (Object)this.code, mapping.getJDBCTypeFor("String"));
                prep.setObject(4, (Object)this.description, mapping.getJDBCTypeFor("String"));
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.seqNr = this.currentDBImage.seqNr;
            this.transactionImage.dbImage.code = this.currentDBImage.code;
            this.transactionImage.dbImage.description = this.currentDBImage.description;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.seqNr = this.transactionImage.dbImage.seqNr;
        this.currentDBImage.code = this.transactionImage.dbImage.code;
        this.currentDBImage.description = this.transactionImage.dbImage.description;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.seqNr = this.transactionImage.dbImage.seqNr;
            this.code = this.transactionImage.dbImage.code;
            this.description = this.transactionImage.dbImage.description;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private int seqNr;
        private String code;
        private String description;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

