/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.ListIterator;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCodeManagerFactory;
import nl.ibs.fac.db.AssetDataBean;
import nl.ibs.fac.db.AssetManager;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.AssetPK;
import nl.ibs.fac.db.AssetTypeManagerFactory;
import nl.ibs.fac.db.AssetValueManagerFactory;
import nl.ibs.fac.db.FinancialDimensionHistoryManagerFactory;
import nl.ibs.fac.db.IncomingFinancialTransactionManagerFactory;
import nl.ibs.fac.db.ValuationManagerFactory;
import nl.ibs.fac.db.WozValueManagerFactory;
import nl.ibs.fac.db.impl.Asset_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataAsset;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.Cache;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.RemoveException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.ListIteratorImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.QueryTranslator;
import nl.ibs.vegas.ExecutableQuery;
import nl.ibs.vegas.meta.AttributeMeta;
import nl.ibs.vegas.meta.impl.CollectionRelationMetaImpl;
import nl.ibs.vegas.meta.impl.FieldMetaImpl;
import nl.ibs.vegas.meta.impl.ObjectRelationMetaImpl;
import nl.ibs.vegas.persistence.Manager;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AssetManager_Impl
extends BusinessObjectManager
implements AssetManager {
    private static final String APPLICATION = "fac";
    private static DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    private static AttributeAccessor generalAccessor = new AttributeAccessor();
    private static boolean verbose = Log.debug();
    private static PersistenceMetaData pmd = PersistenceMetaDataAsset.getInstance();
    private static Hashtable instances = new Hashtable();
    private DBData dbd;
    static final String[] keys = new String[]{"companyId", "cora", "id"};
    static final AttributeMeta[] attributes = new AttributeMeta[]{new FieldMetaImpl("companyId", "txt-company-id", "txt-company-id-short", "txt-company-id-description", "text", String.class, 7, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("cora", "txt-cora", "txt-cora-short", "txt-cora-description", "text", String.class, 1, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("id", "txt-id", "txt-id-short", "txt-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("typeCompanyId", "txt-type-company-id", "txt-type-company-id-short", "txt-type-company-id-description", "text", String.class, 7, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("typeId", "txt-type-id", "txt-type-id-short", "txt-type-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("description", "txt-description", "txt-description-short", "txt-description-description", "text", String.class, 50, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("state", "txt-state", "txt-state-short", "txt-state-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("parentCora", "txt-parent-cora", "txt-parent-cora-short", "txt-parent-cora-description", "text", String.class, 1, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("parentId", "txt-parent-id", "txt-parent-id-short", "txt-parent-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("currentCapitalization", "txt-current-capitalization", "txt-current-capitalization-short", "txt-current-capitalization-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("startUseYear", "txt-start-use-year", "txt-start-use-year-short", "txt-start-use-year-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("startUsePeriod", "txt-start-use-period", "txt-start-use-period-short", "txt-start-use-period-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("historicalYear", "txt-historical-year", "txt-historical-year-short", "txt-historical-year-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("historicalPeriod", "txt-historical-period", "txt-historical-period-short", "txt-historical-period-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("acquisitionDate", "txt-acquisition-date", "txt-acquisition-date-short", "txt-acquisition-date-description", "date", Date.class, 0, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("incomingFinancialTransactionId", "txt-incoming-financial-transaction-id", "txt-incoming-financial-transaction-id-short", "txt-incoming-financial-transaction-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId1", "txt-fin-dim-id1", "txt-fin-dim-id1-short", "txt-fin-dim-id1-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId2", "txt-fin-dim-id2", "txt-fin-dim-id2-short", "txt-fin-dim-id2-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId3", "txt-fin-dim-id3", "txt-fin-dim-id3-short", "txt-fin-dim-id3-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId4", "txt-fin-dim-id4", "txt-fin-dim-id4-short", "txt-fin-dim-id4-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId5", "txt-fin-dim-id5", "txt-fin-dim-id5-short", "txt-fin-dim-id5-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimYearFrom", "txt-fin-dim-year-from", "txt-fin-dim-year-from-short", "txt-fin-dim-year-from-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimPeriodFrom", "txt-fin-dim-period-from", "txt-fin-dim-period-from-short", "txt-fin-dim-period-from-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("credit", "txt-credit", "txt-credit-short", "txt-credit-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("negativeInvestment", "txt-negative-investment", "txt-negative-investment-short", "txt-negative-investment-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("creditState", "txt-credit-state", "txt-credit-state-short", "txt-credit-state-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("councilDecision", "txt-council-decision", "txt-council-decision-short", "txt-council-decision-description", "text", String.class, 50, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("councilDecisionDate", "txt-council-decision-date", "txt-council-decision-date-short", "txt-council-decision-date-description", "date", Date.class, 0, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("originCora", "txt-origin-cora", "txt-origin-cora-short", "txt-origin-cora-description", "text", String.class, 1, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("originId", "txt-origin-id", "txt-origin-id-short", "txt-origin-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("parentAsset", "txt-parent-asset", "txt-parent-asset-short", "txt-parent-asset-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("subAsset", "txt-sub-asset", "txt-sub-asset-short", "txt-sub-asset-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("loan", "txt-loan", "txt-loan-short", "txt-loan-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("hasMemo", "txt-has-memo", "txt-has-memo-short", "txt-has-memo-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("disinvestmentYear", "txt-disinvestment-year", "txt-disinvestment-year-short", "txt-disinvestment-year-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("disinvestmentPeriod", "txt-disinvestment-period", "txt-disinvestment-period-short", "txt-disinvestment-period-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDisinvestmentYear", "txt-fin-disinvestment-year", "txt-fin-disinvestment-year-short", "txt-fin-disinvestment-year-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDisinvestmentPeriod", "txt-fin-disinvestment-period", "txt-fin-disinvestment-period-short", "txt-fin-disinvestment-period-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("creditId", "txt-credit-id", "txt-credit-id-short", "txt-credit-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("payOffYearAmount", "txt-pay-off-year-amount", "txt-pay-off-year-amount-short", "txt-pay-off-year-amount-description", "decimal", BigDecimal.class, 15, 2, "0.00", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("bookValue", "txt-book-value", "txt-book-value-short", "txt-book-value-description", "decimal", BigDecimal.class, 11, 2, "0.00", "false", "false", "", "", false, false, null, null), new ObjectRelationMetaImpl("assetType", "txt-asset-type", "txt-asset-type-short", "txt-asset-type-description", (Manager)AssetTypeManagerFactory.getInstance(), false, null), new ObjectRelationMetaImpl("parent", "txt-parent", "txt-parent-short", "txt-parent-description", (Manager)AssetManagerFactory.getInstance(), false, "companyId = ?companyId"), new ObjectRelationMetaImpl("originating", "txt-originating", "txt-originating-short", "txt-originating-description", (Manager)AssetManagerFactory.getInstance(), false, "companyId = ?companyId"), new ObjectRelationMetaImpl("incomingFinancialTransaction", "txt-incoming-financial-transaction", "txt-incoming-financial-transaction-short", "txt-incoming-financial-transaction-description", (Manager)IncomingFinancialTransactionManagerFactory.getInstance(), false, "companyId = ?companyId"), new CollectionRelationMetaImpl("assetAnalysisCode", "txt-asset-analysis-code", "txt-asset-analysis-code-short", "txt-asset-analysis-code-description", (Manager)AssetAnalysisCodeManagerFactory.getInstance(), true), new CollectionRelationMetaImpl("assetValue", "txt-asset-value", "txt-asset-value-short", "txt-asset-value-description", (Manager)AssetValueManagerFactory.getInstance(), true), new CollectionRelationMetaImpl("woz", "txt-woz", "txt-woz-short", "txt-woz-description", (Manager)WozValueManagerFactory.getInstance(), true), new CollectionRelationMetaImpl("financialDimensionHistory", "txt-financial-dimension-history", "txt-financial-dimension-history-short", "txt-financial-dimension-history-description", (Manager)FinancialDimensionHistoryManagerFactory.getInstance(), true), new CollectionRelationMetaImpl("valuations", "txt-valuations", "txt-valuations-short", "txt-valuations-description", (Manager)ValuationManagerFactory.getInstance(), true)};

    private AssetManager_Impl(DBData dbData) {
        this.dbd = dbData;
    }

    public static AssetManager getInstance() {
        return AssetManager_Impl.getInstance(DBData.getDefaultDBData(APPLICATION));
    }

    public static AssetManager getInstance(DBData dbd) {
        if (dbd == null) {
            throw new IllegalArgumentException("Tried to instantiate a Manager it DBData = null!");
        }
        AssetManager_Impl inst = (AssetManager_Impl)instances.get(dbd);
        if (inst == null) {
            inst = new AssetManager_Impl(dbd);
            instances.put(dbd, inst);
        }
        return inst;
    }

    public DBData getDBData() {
        return this.dbd;
    }

    @Override
    public Asset create(AssetDataBean bean) throws Exception {
        Asset_Impl impl = new Asset_Impl(this.dbd, bean);
        impl.assureStorage();
        return impl;
    }

    @Override
    public Asset create(String _companyId, String _cora, String _id) throws Exception {
        Asset_Impl obj = new Asset_Impl(this.dbd, _companyId, _cora, _id);
        obj.assureStorage();
        return obj;
    }

    private AssetPK getPK(ResultSet rs) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        AssetPK inst = new AssetPK();
        inst.setCompanyId(rs.getString(pmd.getFieldName("CompanyId", provider)));
        inst.setCora(rs.getString(pmd.getFieldName("Cora", provider)));
        inst.setId(rs.getString(pmd.getFieldName("Id", provider)));
        return inst;
    }

    @Override
    public Asset findOrCreate(AssetPK key) throws Exception {
        Asset obj;
        try {
            obj = this.findByPrimaryKey(key);
        }
        catch (FinderException e) {
            obj = this.create(key.getCompanyId(), key.getCora(), key.getId());
        }
        return obj;
    }

    @Override
    public void add(AssetDataBean inst) throws Exception {
        Asset_Impl impl = new Asset_Impl(this.dbd, inst);
        impl.assureStorage();
    }

    @Override
    public void removeByPrimaryKey(AssetPK key) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        Asset cachedObject = this.getCachedObjectByPrimaryKey(key);
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate((BusinessObject_Impl)((Object)cachedObject)) : provider.getConnection();
        String pskey = "nl.ibs.fac.db.Asset.removeByPrimaryKey";
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(pskey);
                if (prep == null) {
                    prep = dbc.getPreparedStatement(pskey, " DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=?" + " AND " + pmd.getFieldName("Cora", provider) + "=?" + " AND " + pmd.getFieldName("Id", provider) + "=?");
                }
                prep.setString(1, key.getCompanyId());
                prep.setString(2, key.getCora());
                prep.setString(3, key.getId());
                int x = prep.executeUpdate();
                if (x == 0) {
                    throw new RemoveException("Key not found");
                }
                if (cachedObject != null) {
                    DBPersistenceManager.removeFromCache(cachedObject);
                }
            }
            catch (SQLException e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public Asset findByPrimaryKey(AssetPK key) throws Exception {
        Asset asset = this.getCachedObjectByPrimaryKey(key);
        if (asset != null) {
            return asset;
        }
        ResultSet rs = null;
        try {
            rs = this.getResultSet(key);
            Asset asset2 = (Asset)this.getBusinessObject(rs);
            return asset2;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public ResultSet getResultSet(AssetPK key) throws Exception {
        ResultSet rs = null;
        String pskey = "nl.ibs.fac.db.Asset.findByPrimaryKey1";
        Object inst = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(pskey);
                if (prep == null) {
                    prep = dbc.getPreparedStatement(pskey, " SELECT *  FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=?" + " AND " + pmd.getFieldName("Cora", provider) + "=?" + " AND " + pmd.getFieldName("Id", provider) + "=?");
                }
                prep.setString(1, key.getCompanyId());
                prep.setString(2, key.getCora());
                prep.setString(3, key.getId());
                prep.executeQuery();
                rs = prep.getResultSet();
                if (!rs.next()) {
                    throw new FinderException("Key not found");
                }
            }
            catch (SQLException e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
        return rs;
    }

    public Asset getCachedObjectByPrimaryKey(AssetPK key) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache == null) {
            return null;
        }
        Object o = cache.get(new String("-959831382_" + this.dbd.getDBId() + key.getCompanyId() + key.getCora() + key.getId()));
        return (Asset)o;
    }

    @Override
    public ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public String getAssetIdMax(String _companyId) throws Exception {
        ResultSet rs = null;
        String result = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            try {
                String pskey = "nl.ibs.fac.db.Asset.getAssetIdMax_-1417777467";
                PreparedStatement prep = dbc.getPreparedStatement(pskey);
                if (prep == null) {
                    prep = dbc.getPreparedStatement(pskey, " SELECT   MAX(" + pmd.getFieldName("Id", provider) + ")" + " FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? " + " AND " + pmd.getFieldName("Credit", provider) + "=? ", 0);
                }
                prep.setObject(1, (Object)_companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)new Boolean("false"), mapping.getJDBCTypeFor("boolean"));
                rs = prep.executeQuery();
                if (rs.next()) {
                    result = rs.getString(1);
                }
            }
            catch (SQLException e) {
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
        return result;
    }

    @Override
    public String getCreditIdMax(String _companyId) throws Exception {
        ResultSet rs = null;
        String result = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            try {
                String pskey = "nl.ibs.fac.db.Asset.getCreditIdMax_-1417777467";
                PreparedStatement prep = dbc.getPreparedStatement(pskey);
                if (prep == null) {
                    prep = dbc.getPreparedStatement(pskey, " SELECT   MAX(" + pmd.getFieldName("Id", provider) + ")" + " FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? " + " AND " + pmd.getFieldName("Credit", provider) + "=? ", 0);
                }
                prep.setObject(1, (Object)_companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)new Boolean("true"), mapping.getJDBCTypeFor("boolean"));
                rs = prep.executeQuery();
                if (rs.next()) {
                    result = rs.getString(1);
                }
            }
            catch (SQLException e) {
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
        return result;
    }

    @Override
    public int generalUpdate(String setClause, String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String update = "UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + QueryTranslator.translateObjectQuery(String.valueOf(setClause) + " WHERE " + whereClause, pmd, provider);
            int n = dbc.executeUpdate(update);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public int generalDelete(String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String delete = "DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + QueryTranslator.translateObjectQuery(whereClause, pmd, provider);
            int n = dbc.executeUpdate(delete);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public Asset getFirstObject(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create();
        }
        int prevMax = query.getMaxObjects();
        query.setMaxObjects(1);
        try {
            Asset asset = (Asset)((QueryImplementation)query).execute(this, (short)0);
            return asset;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            query.setMaxObjects(prevMax);
        }
    }

    @Override
    public Collection getCollection(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Collection)queryImpl.execute(this, (short)-1);
    }

    public ListIterator getListIterator(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ListIterator)queryImpl.execute(this, (short)-2);
    }

    @Override
    public Document getDocument(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Document)queryImpl.execute(this, (short)-3);
    }

    @Override
    public DocumentFragment getDocumentFragment(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (DocumentFragment)queryImpl.execute(this, (short)-4);
    }

    @Override
    public ArrayList getDocumentFragmentArrayList(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ArrayList)queryImpl.execute(this, (short)-5);
    }

    @Override
    protected Collection getCollection(ResultSet rs) throws Exception {
        ArrayListImpl result = new ArrayListImpl();
        while (rs.next()) {
            ((ArrayList)result).add(this.getBusinessObject(rs));
        }
        return result;
    }

    @Override
    protected Document getDocument(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        Element root = document.getDocumentElement();
        this.collectResultElements(resultSet, root, this.getConnectionProvider());
        return document;
    }

    @Override
    protected DocumentFragment getDocumentFragment(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.collectResultElements(resultSet, documentFragment, this.getConnectionProvider());
        return documentFragment;
    }

    @Override
    protected ArrayList getDocumentFragmentArrayList(ResultSet resultSet) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        Document document = domImplementation.createDocument("", "data", null);
        ArrayListImpl arrayList = new ArrayListImpl();
        while (resultSet.next()) {
            DocumentFragment documentFragment = document.createDocumentFragment();
            Node rec = documentFragment.appendChild(document.createElement("asset"));
            AssetManager_Impl.addBOFieldsToElement(resultSet, rec, provider);
            ((ArrayList)arrayList).add(documentFragment);
        }
        return arrayList;
    }

    @Override
    protected ListIterator getListIterator(ResultSet rs) throws Exception {
        ListIteratorImpl result = new ListIteratorImpl();
        while (rs.next()) {
            result.add(this.getBusinessObject(rs));
        }
        result.pointer = 0;
        return result;
    }

    @Override
    protected Object getBusinessObject(ResultSet rs) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache != null) {
            ConnectionProvider provider = this.getConnectionProvider();
            Object o = cache.get(new String("-959831382_" + this.dbd.getDBId() + rs.getObject(pmd.getFieldName("CompanyId", provider)) + rs.getObject(pmd.getFieldName("Cora", provider)) + rs.getObject(pmd.getFieldName("Id", provider))));
            if (o != null) {
                return o;
            }
        }
        return DBPersistenceManager.cache(this.createBusinessObject(rs));
    }

    private Object createBusinessObject(ResultSet rs) throws Exception {
        return new Asset_Impl(this.dbd, rs);
    }

    private void collectResultElements(ResultSet rs, Node root, ConnectionProvider provider) throws Exception {
        Document doc = root.getOwnerDocument();
        while (rs.next()) {
            Node rec = root.appendChild(doc.createElement("asset"));
            AssetManager_Impl.addBOFieldsToElement(rs, rec, provider);
        }
    }

    public static void addBOFieldsToElement(ResultSet rs, Node rec, ConnectionProvider provider) throws Exception {
        DBMapping mapping = provider.getDBMapping();
        Document doc = rec.getOwnerDocument();
        Object o = null;
        String s = null;
        s = rs.getString(pmd.getFieldName("CompanyId", provider));
        if (s != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("companyid")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("Cora", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("cora")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("Id", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("id")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("TypeCompanyId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("typecompanyid")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("TypeId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("typeid")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("Description", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("description")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("State", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("state")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("ParentCora", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("parentcora")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("ParentId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("parentid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("CurrentCapitalization", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("currentcapitalization")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("StartUseYear", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("startuseyear")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("StartUsePeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("startuseperiod")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("HistoricalYear", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("historicalyear")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("HistoricalPeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("historicalperiod")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getDate(pmd.getFieldName("AcquisitionDate", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("acquisitiondate")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("IncomingFinancialTransactionId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("incomingfinancialtransactionid")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId1", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid1")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId2", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid2")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId3", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid3")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId4", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid4")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId5", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid5")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("FinDimYearFrom", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimyearfrom")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("FinDimPeriodFrom", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimperiodfrom")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("Credit", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("credit")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("NegativeInvestment", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("negativeinvestment")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("CreditState", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("creditstate")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("CouncilDecision", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("councildecision")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getDate(pmd.getFieldName("CouncilDecisionDate", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("councildecisiondate")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("OriginCora", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("origincora")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("OriginId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("originid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("ParentAsset", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("parentasset")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("SubAsset", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("subasset")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("Loan", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("loan")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("HasMemo", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("hasmemo")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("DisinvestmentYear", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("disinvestmentyear")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("DisinvestmentPeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("disinvestmentperiod")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("FinDisinvestmentYear", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("findisinvestmentyear")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("FinDisinvestmentPeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("findisinvestmentperiod")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("CreditId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("creditid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("PayOffYearAmount", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("payoffyearamount")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("BookValue", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("bookvalue")).appendChild(doc.createTextNode(s));
        }
    }

    public ExecutableQuery getExecutableQuery() {
        return QueryFactory.create(this);
    }

    public String[] getKeyNames() {
        return keys;
    }

    public AttributeMeta[] getAttributes() {
        return attributes;
    }

    public Class getClassType() {
        return Asset.class;
    }

    public String getNameField() {
        return "id";
    }

    public String getDescriptionField() {
        return "id";
    }

    public String getTextKey() {
        return "txt-asset";
    }

    public String getTextKeyShort() {
        return "txt-asset-short";
    }

    public String getTextKeyDescription() {
        return "txt-asset-description";
    }

    public AttributeMeta getAttribute(String name) {
        if (attributes == null || name == null) {
            return null;
        }
        int i = 0;
        while (i < attributes.length) {
            if (name.equals(attributes[i].getName())) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }
}

