/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.CreditBalanceDataBean;
import nl.ibs.fac.db.CreditBalanceDetail;
import nl.ibs.fac.db.CreditBalancePK;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.CreditBalanceDetailManager_Impl;
import nl.ibs.fac.db.impl.CreditBalanceManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataCreditBalance;
import nl.ibs.fac.db.impl.PersistenceMetaDataCreditBalanceDetail;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class CreditBalance_Impl
implements CreditBalance,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataCreditBalance.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected String gLAccountId;
    protected String description;
    protected String creditId;
    protected int state;
    protected BigDecimal totalBalanceAmount;
    protected BigDecimal totalEstimationAmount;
    protected BigDecimal totalInterestAmount;
    protected boolean isDirty;
    protected boolean isDeletable;

    protected CreditBalance_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected CreditBalance_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected CreditBalance_Impl(DBData _dbd, String _companyId, String _gLAccountId) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setGLAccountId(_gLAccountId);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected CreditBalance_Impl(DBData _dbd, CreditBalanceDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.CreditBalanceDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate CreditBalance with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.CreditBalanceDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setGLAccountId(bean.getGLAccountId());
            this.setDescription(bean.getDescription());
            this.setCreditId(bean.getCreditId());
            this.setState(bean.getState());
            this.setTotalBalanceAmount(bean.getTotalBalanceAmount());
            this.setTotalEstimationAmount(bean.getTotalEstimationAmount());
            this.setTotalInterestAmount(bean.getTotalInterestAmount());
            this.setIsDirty(bean.getIsDirty());
            this.setIsDeletable(bean.getIsDeletable());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public CreditBalance_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.gLAccountId = rs.getString(pmd.getFieldName("GLAccountId", provider));
        this.description = rs.getString(pmd.getFieldName("Description", provider));
        this.creditId = rs.getString(pmd.getFieldName("CreditId", provider));
        this.state = rs.getInt(pmd.getFieldName("State", provider));
        this.totalBalanceAmount = rs.getBigDecimal(pmd.getFieldName("TotalBalanceAmount", provider));
        this.totalEstimationAmount = rs.getBigDecimal(pmd.getFieldName("TotalEstimationAmount", provider));
        this.totalInterestAmount = rs.getBigDecimal(pmd.getFieldName("TotalInterestAmount", provider));
        this.isDirty = rs.getBoolean(pmd.getFieldName("IsDirty", provider));
        this.isDeletable = rs.getBoolean(pmd.getFieldName("IsDeletable", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        CreditBalancePK key = new CreditBalancePK();
        key.setCompanyId(this.getCompanyId());
        key.setGLAccountId(this.getGLAccountId());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public String getGLAccountId() throws Exception {
        this.assureStorage();
        return this.gLAccountId;
    }

    @Override
    public String getDescription() throws Exception {
        return this.description;
    }

    @Override
    public String getCreditId() throws Exception {
        return this.creditId;
    }

    @Override
    public int getState() throws Exception {
        return this.state;
    }

    @Override
    public BigDecimal getTotalBalanceAmount() throws Exception {
        return this.totalBalanceAmount;
    }

    @Override
    public BigDecimal getTotalEstimationAmount() throws Exception {
        return this.totalEstimationAmount;
    }

    @Override
    public BigDecimal getTotalInterestAmount() throws Exception {
        return this.totalInterestAmount;
    }

    @Override
    public boolean getIsDirty() throws Exception {
        return this.isDirty;
    }

    @Override
    public boolean getIsDeletable() throws Exception {
        return this.isDeletable;
    }

    @Override
    public CreditBalanceDetail getCreditBalanceDetailsObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "companyId = ?companyId AND gLAccountId = ?gLAccountId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("gLAccountId", this.getGLAccountId());
        queryImpl.setRelationFilter("companyId = ?companyId AND gLAccountId = ?gLAccountId");
        return CreditBalanceDetailManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getCreditBalanceDetailsCollection(Query query) throws Exception {
        boolean nullQuery;
        boolean bl = nullQuery = query == null;
        if (nullQuery && this.isCachedRelation("CreditBalanceDetailsCollection")) {
            return (Collection)this.getCachedRelationObject("CreditBalanceDetailsCollection");
        }
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND gLAccountId = ?gLAccountId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("gLAccountId", this.getGLAccountId());
        queryImpl.setRelationFilter("companyId = ?companyId AND gLAccountId = ?gLAccountId");
        if (nullQuery) {
            return (Collection)this.addCachedRelationObject("CreditBalanceDetailsCollection", CreditBalanceDetailManager_Impl.getInstance(this.dbd).getCollection(query));
        }
        return CreditBalanceDetailManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getCreditBalanceDetailsDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "companyId = ?companyId AND gLAccountId = ?gLAccountId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("gLAccountId", this.getGLAccountId());
        queryImpl.setRelationFilter("companyId = ?companyId AND gLAccountId = ?gLAccountId");
        return CreditBalanceDetailManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getCreditBalanceDetailsDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "companyId = ?companyId AND gLAccountId = ?gLAccountId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("gLAccountId", this.getGLAccountId());
        queryImpl.setRelationFilter("companyId = ?companyId AND gLAccountId = ?gLAccountId");
        return CreditBalanceDetailManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getCreditBalanceDetailsDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND gLAccountId = ?gLAccountId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("gLAccountId", this.getGLAccountId());
        queryImpl.setRelationFilter("companyId = ?companyId AND gLAccountId = ?gLAccountId");
        return CreditBalanceDetailManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public Company getOwnedByCompanyAsCreditBalances() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsCreditBalances")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsCreditBalances");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsCreditBalances", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Company owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsCreditBalances();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setGLAccountId(String _gLAccountId) throws Exception {
        if (_gLAccountId == null ? this.getGLAccountId() == null : _gLAccountId.equals(this.getGLAccountId())) {
            return;
        }
        this.preSet();
        this.gLAccountId = _gLAccountId;
        this.autoUpdate();
    }

    @Override
    public void setDescription(String _description) throws Exception {
        if (_description == null) {
            _description = "";
        }
        if (_description.equals(this.getDescription())) {
            return;
        }
        this.preSet();
        this.description = _description;
        this.autoUpdate();
    }

    @Override
    public void setCreditId(String _creditId) throws Exception {
        if (_creditId == null ? this.getCreditId() == null : _creditId.equals(this.getCreditId())) {
            return;
        }
        this.preSet();
        this.creditId = _creditId;
        this.autoUpdate();
    }

    @Override
    public void setState(int _state) throws Exception {
        if (_state == this.getState()) {
            return;
        }
        this.preSet();
        this.state = _state;
        this.autoUpdate();
    }

    @Override
    public void setTotalBalanceAmount(BigDecimal _totalBalanceAmount) throws Exception {
        if (_totalBalanceAmount == null) {
            _totalBalanceAmount = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_totalBalanceAmount.equals(this.getTotalBalanceAmount())) {
            return;
        }
        this.preSet();
        this.totalBalanceAmount = _totalBalanceAmount;
        this.autoUpdate();
    }

    @Override
    public void setTotalEstimationAmount(BigDecimal _totalEstimationAmount) throws Exception {
        if (_totalEstimationAmount == null) {
            _totalEstimationAmount = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_totalEstimationAmount.equals(this.getTotalEstimationAmount())) {
            return;
        }
        this.preSet();
        this.totalEstimationAmount = _totalEstimationAmount;
        this.autoUpdate();
    }

    @Override
    public void setTotalInterestAmount(BigDecimal _totalInterestAmount) throws Exception {
        if (_totalInterestAmount == null) {
            _totalInterestAmount = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_totalInterestAmount.equals(this.getTotalInterestAmount())) {
            return;
        }
        this.preSet();
        this.totalInterestAmount = _totalInterestAmount;
        this.autoUpdate();
    }

    @Override
    public void setIsDirty(boolean _isDirty) throws Exception {
        if (_isDirty == this.getIsDirty()) {
            return;
        }
        this.preSet();
        this.isDirty = _isDirty;
        this.autoUpdate();
    }

    @Override
    public void setIsDeletable(boolean _isDeletable) throws Exception {
        if (_isDeletable == this.getIsDeletable()) {
            return;
        }
        this.preSet();
        this.isDeletable = _isDeletable;
        this.autoUpdate();
    }

    @Override
    public void addCreditBalanceDetails(Collection collection) throws Exception {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.addCreditBalanceDetails((CreditBalanceDetail)it.next());
        }
    }

    @Override
    public void addCreditBalanceDetails(CreditBalanceDetail object) throws Exception {
        if (object != null) {
            if (!PersistenceMetaDataCreditBalanceDetail.getInstance().isPersistable(object)) {
                throw new Exception("Tried to attach to a CreditBalance an CreditBalanceDetail that is not valid implementation class!!");
            }
            if (generalAccessor.getObjectAttribute(object, "companyId") != null || generalAccessor.getObjectAttribute(object, "gLAccountId") != null) {
                throw new Exception("Tried to attach to a CreditBalance a CreditBalanceDetail that is allready owned (by a CreditBalance");
            }
            this.assureStorage();
            object.preSet();
            generalAccessor.setAttribute((Object)object, "companyId", this.getCompanyId());
            generalAccessor.setAttribute((Object)object, "gLAccountId", this.getGLAccountId());
            ((BusinessObject_Impl)((Object)object)).save();
            ((BusinessObject_Impl)((Object)object)).addCachedRelationObject("ownedByCreditBalanceAsCreditBalanceDetails", this);
        }
        this.clearCachedRelation("CreditBalanceDetailsCollection");
    }

    @Override
    public void removeCreditBalanceDetails(Collection collection) throws Exception {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.removeCreditBalanceDetails((CreditBalanceDetail)it.next());
        }
    }

    @Override
    public void removeCreditBalanceDetails(CreditBalanceDetail object) throws Exception {
        if (object != null) {
            object.delete();
            this.clearCachedRelation("CreditBalanceDetailsCollection");
            ((BusinessObject_Impl)((Object)object)).clearCachedRelation("ownedByCreditBalanceAsCreditBalanceDetails");
        }
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.description = "";
        this.state = 0;
        this.totalBalanceAmount = new BigDecimal("0.00").setScale(2, 6);
        this.totalEstimationAmount = new BigDecimal("0.00").setScale(2, 6);
        this.totalInterestAmount = new BigDecimal("0.00").setScale(2, 6);
        this.isDirty = true;
        this.isDeletable = false;
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.gLAccountId = this.gLAccountId;
        this.currentDBImage.description = this.description;
        this.currentDBImage.creditId = this.creditId;
        this.currentDBImage.state = this.state;
        this.currentDBImage.totalBalanceAmount = this.totalBalanceAmount;
        this.currentDBImage.totalEstimationAmount = this.totalEstimationAmount;
        this.currentDBImage.totalInterestAmount = this.totalInterestAmount;
        this.currentDBImage.isDirty = this.isDirty;
        this.currentDBImage.isDeletable = this.isDeletable;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("CreditBalance is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            CreditBalancePK key = new CreditBalancePK();
            key.setCompanyId(this.getCompanyId());
            key.setGLAccountId(this.getGLAccountId());
            ((CreditBalanceManager_Impl)CreditBalanceManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((CreditBalanceManager_Impl)CreditBalanceManager_Impl.getInstance(this.dbd)).getResultSet((CreditBalancePK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("-1482973347_" + this.dbd.getDBId() + this.companyId + this.gLAccountId).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public CreditBalanceDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public CreditBalanceDataBean getCreditBalanceDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private CreditBalanceDataBean getDataBean(CreditBalanceDataBean bean) throws Exception {
        if (bean == null) {
            bean = new CreditBalanceDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setGLAccountId(this.getGLAccountId());
        bean.setDescription(this.getDescription());
        bean.setCreditId(this.getCreditId());
        bean.setState(this.getState());
        bean.setTotalBalanceAmount(this.getTotalBalanceAmount());
        bean.setTotalEstimationAmount(this.getTotalEstimationAmount());
        bean.setTotalInterestAmount(this.getTotalInterestAmount());
        bean.setIsDirty(this.getIsDirty());
        bean.setIsDeletable(this.getIsDeletable());
        return bean;
    }

    public boolean equals(Object object) {
        CreditBalance_Impl bo;
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                try {
                                    if (object != null && object instanceof CreditBalance_Impl) break block10;
                                    return false;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e.getMessage());
                                }
                            }
                            bo = (CreditBalance_Impl)object;
                            if (bo.getCompanyId() != null) break block11;
                            if (this.getCompanyId() != null) {
                                return false;
                            }
                            break block12;
                        }
                        if (bo.getCompanyId().equals(this.getCompanyId())) break block12;
                        return false;
                    }
                    if (bo.getGLAccountId() != null) break block13;
                    if (this.getGLAccountId() != null) {
                        return false;
                    }
                    break block14;
                }
                if (bo.getGLAccountId().equals(this.getGLAccountId())) break block14;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block15;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(CreditBalanceDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(CreditBalanceDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setGLAccountId(bean.getGLAccountId());
            this.setDescription(bean.getDescription());
            this.setCreditId(bean.getCreditId());
            this.setState(bean.getState());
            this.setTotalBalanceAmount(bean.getTotalBalanceAmount());
            this.setTotalEstimationAmount(bean.getTotalEstimationAmount());
            this.setTotalInterestAmount(bean.getTotalInterestAmount());
            this.setIsDirty(bean.getIsDirty());
            this.setIsDeletable(bean.getIsDeletable());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "CreditBalance is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.CreditBalance.save");
        key.append(image.gLAccountId == null ? "0" : "1");
        key.append(image.creditId == null ? "0" : "1");
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("GLAccountId", provider) + " = ? " + ", " + pmd.getFieldName("Description", provider) + " = ? " + ", " + pmd.getFieldName("CreditId", provider) + " = ? " + ", " + pmd.getFieldName("State", provider) + " = ? " + ", " + pmd.getFieldName("TotalBalanceAmount", provider) + " = ? " + ", " + pmd.getFieldName("TotalEstimationAmount", provider) + " = ? " + ", " + pmd.getFieldName("TotalInterestAmount", provider) + " = ? " + ", " + pmd.getFieldName("IsDirty", provider) + " = ? " + ", " + pmd.getFieldName("IsDeletable", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("GLAccountId", provider) + (image.gLAccountId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("Description", provider) + " = ? " + " AND  " + pmd.getFieldName("CreditId", provider) + (image.creditId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("State", provider) + " = ? " + " AND  " + pmd.getFieldName("TotalBalanceAmount", provider) + " = ? " + " AND  " + pmd.getFieldName("TotalEstimationAmount", provider) + " = ? " + " AND  " + pmd.getFieldName("TotalInterestAmount", provider) + " = ? " + " AND  " + pmd.getFieldName("IsDirty", provider) + " = ? " + " AND  " + pmd.getFieldName("IsDeletable", provider) + " = ? ");
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                if (this.gLAccountId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.gLAccountId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)this.description, mapping.getJDBCTypeFor("String"));
                if (this.creditId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.creditId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(this.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.totalBalanceAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.totalEstimationAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.totalInterestAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Boolean(this.isDirty), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.isDeletable), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                if (image.gLAccountId != null) {
                    prep.setObject(parmIndex++, (Object)image.gLAccountId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)image.description, mapping.getJDBCTypeFor("String"));
                if (image.creditId != null) {
                    prep.setObject(parmIndex++, (Object)image.creditId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(image.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.totalBalanceAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.totalEstimationAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.totalInterestAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Boolean(image.isDirty), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.isDeletable), mapping.getJDBCTypeFor("boolean"));
                int n = prep.executeUpdate();
                if (n == 0) {
                    this.rollback(true);
                    throw new UpdateException("CreditBalance modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.CreditBalance.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.CreditBalance.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("GLAccountId", provider) + ", " + pmd.getFieldName("Description", provider) + ", " + pmd.getFieldName("CreditId", provider) + ", " + pmd.getFieldName("State", provider) + ", " + pmd.getFieldName("TotalBalanceAmount", provider) + ", " + pmd.getFieldName("TotalEstimationAmount", provider) + ", " + pmd.getFieldName("TotalInterestAmount", provider) + ", " + pmd.getFieldName("IsDirty", provider) + ", " + pmd.getFieldName("IsDeletable", provider) + ") VALUES (?,?,?,?,?,?,?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                if (this.gLAccountId == null) {
                    prep.setNull(2, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(2, (Object)this.gLAccountId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(3, (Object)this.description, mapping.getJDBCTypeFor("String"));
                if (this.creditId == null) {
                    prep.setNull(4, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(4, (Object)this.creditId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(5, (Object)new Integer(this.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(6, (Object)this.totalBalanceAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(7, (Object)this.totalEstimationAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(8, (Object)this.totalInterestAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(9, (Object)new Boolean(this.isDirty), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(10, (Object)new Boolean(this.isDeletable), mapping.getJDBCTypeFor("boolean"));
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.gLAccountId = this.currentDBImage.gLAccountId;
            this.transactionImage.dbImage.description = this.currentDBImage.description;
            this.transactionImage.dbImage.creditId = this.currentDBImage.creditId;
            this.transactionImage.dbImage.state = this.currentDBImage.state;
            this.transactionImage.dbImage.totalBalanceAmount = this.currentDBImage.totalBalanceAmount;
            this.transactionImage.dbImage.totalEstimationAmount = this.currentDBImage.totalEstimationAmount;
            this.transactionImage.dbImage.totalInterestAmount = this.currentDBImage.totalInterestAmount;
            this.transactionImage.dbImage.isDirty = this.currentDBImage.isDirty;
            this.transactionImage.dbImage.isDeletable = this.currentDBImage.isDeletable;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.gLAccountId = this.transactionImage.dbImage.gLAccountId;
        this.currentDBImage.description = this.transactionImage.dbImage.description;
        this.currentDBImage.creditId = this.transactionImage.dbImage.creditId;
        this.currentDBImage.state = this.transactionImage.dbImage.state;
        this.currentDBImage.totalBalanceAmount = this.transactionImage.dbImage.totalBalanceAmount;
        this.currentDBImage.totalEstimationAmount = this.transactionImage.dbImage.totalEstimationAmount;
        this.currentDBImage.totalInterestAmount = this.transactionImage.dbImage.totalInterestAmount;
        this.currentDBImage.isDirty = this.transactionImage.dbImage.isDirty;
        this.currentDBImage.isDeletable = this.transactionImage.dbImage.isDeletable;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.gLAccountId = this.transactionImage.dbImage.gLAccountId;
            this.description = this.transactionImage.dbImage.description;
            this.creditId = this.transactionImage.dbImage.creditId;
            this.state = this.transactionImage.dbImage.state;
            this.totalBalanceAmount = this.transactionImage.dbImage.totalBalanceAmount;
            this.totalEstimationAmount = this.transactionImage.dbImage.totalEstimationAmount;
            this.totalInterestAmount = this.transactionImage.dbImage.totalInterestAmount;
            this.isDirty = this.transactionImage.dbImage.isDirty;
            this.isDeletable = this.transactionImage.dbImage.isDeletable;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    @Override
    public BigDecimal getCreditBalanceDetailAmount1() throws Exception {
        return CreditBalanceBO.retrieveCreditBalanceDetailAmount1(this);
    }

    @Override
    public BigDecimal getCreditBalanceDetailAmount2() throws Exception {
        return CreditBalanceBO.retrieveCreditBalanceDetailAmount2(this);
    }

    @Override
    public BigDecimal getCreditBalanceDetailAmount3() throws Exception {
        return CreditBalanceBO.retrieveCreditBalanceDetailAmount3(this);
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private String gLAccountId;
        private String description;
        private String creditId;
        private int state;
        private BigDecimal totalBalanceAmount;
        private BigDecimal totalEstimationAmount;
        private BigDecimal totalInterestAmount;
        private boolean isDirty;
        private boolean isDeletable;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

