/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.IncomingFinancialTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditDataBean;
import nl.ibs.fac.db.CreditPK;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.CreditManager_Impl;
import nl.ibs.fac.db.impl.InterestTableManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataCredit;
import nl.ibs.fac.db.impl.TotalEstimationTransactionManager_Impl;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class Credit_Impl
implements Credit,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataCredit.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected String id;
    protected int creditBalanceReferenceCounter;
    protected int initialProjectCostsReferenceCounter;
    protected String preferedGLAccountId;
    protected int state;
    protected String description;
    protected int startYear;
    protected int startPeriod;
    protected int endYear;
    protected int endPeriod;
    protected int benefitType;
    protected int gLBalanceType;
    protected boolean isResultAccountItem;
    protected BigDecimal originalInvestmentCreditAmount;
    protected boolean hasMemo;
    protected int closingYear;
    protected int closingPeriod;
    protected int finClosingYear;
    protected int finClosingPeriod;
    protected String proFormaTypeId;
    protected String decisionId;
    protected Date decisionDate;
    protected String finDimId1;
    protected String finDimId2;
    protected String finDimId3;
    protected String finDimId4;
    protected int interestCalculationMethod;
    protected String interestTableId;
    protected BigDecimal interestPercentage;
    protected int interestStartYear;
    protected int interestStartPeriod;
    protected int lastInterestYear;
    protected int lastInterestPeriod;
    protected BigDecimal allocatedValue;
    protected BigDecimal allocatedDepreciationValue;
    protected String dimValue1;
    protected String dimValue2;
    protected String dimValue3;
    protected String dimValue4;
    protected String dimValue5;
    protected String dimValue6;
    protected transient InterestTable transientInterestTable;

    protected Credit_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected Credit_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected Credit_Impl(DBData _dbd, String _companyId, String _id) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setId(_id);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected Credit_Impl(DBData _dbd, CreditDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.CreditDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate Credit with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.CreditDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setId(bean.getId());
            this.setCreditBalanceReferenceCounter(bean.getCreditBalanceReferenceCounter());
            this.setInitialProjectCostsReferenceCounter(bean.getInitialProjectCostsReferenceCounter());
            this.setPreferedGLAccountId(bean.getPreferedGLAccountId());
            this.setState(bean.getState());
            this.setDescription(bean.getDescription());
            this.setStartYear(bean.getStartYear());
            this.setStartPeriod(bean.getStartPeriod());
            this.setEndYear(bean.getEndYear());
            this.setEndPeriod(bean.getEndPeriod());
            this.setBenefitType(bean.getBenefitType());
            this.setGLBalanceType(bean.getGLBalanceType());
            this.setIsResultAccountItem(bean.getIsResultAccountItem());
            this.setOriginalInvestmentCreditAmount(bean.getOriginalInvestmentCreditAmount());
            this.setHasMemo(bean.getHasMemo());
            this.setClosingYear(bean.getClosingYear());
            this.setClosingPeriod(bean.getClosingPeriod());
            this.setFinClosingYear(bean.getFinClosingYear());
            this.setFinClosingPeriod(bean.getFinClosingPeriod());
            this.setProFormaTypeId(bean.getProFormaTypeId());
            this.setDecisionId(bean.getDecisionId());
            this.setDecisionDate(bean.getDecisionDate());
            this.setFinDimId1(bean.getFinDimId1());
            this.setFinDimId2(bean.getFinDimId2());
            this.setFinDimId3(bean.getFinDimId3());
            this.setFinDimId4(bean.getFinDimId4());
            this.setInterestCalculationMethod(bean.getInterestCalculationMethod());
            this.setInterestTableId(bean.getInterestTableId());
            this.setInterestPercentage(bean.getInterestPercentage());
            this.setInterestStartYear(bean.getInterestStartYear());
            this.setInterestStartPeriod(bean.getInterestStartPeriod());
            this.setLastInterestYear(bean.getLastInterestYear());
            this.setLastInterestPeriod(bean.getLastInterestPeriod());
            this.setAllocatedValue(bean.getAllocatedValue());
            this.setAllocatedDepreciationValue(bean.getAllocatedDepreciationValue());
            this.setDimValue1(bean.getDimValue1());
            this.setDimValue2(bean.getDimValue2());
            this.setDimValue3(bean.getDimValue3());
            this.setDimValue4(bean.getDimValue4());
            this.setDimValue5(bean.getDimValue5());
            this.setDimValue6(bean.getDimValue6());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public Credit_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.id = rs.getString(pmd.getFieldName("Id", provider));
        this.creditBalanceReferenceCounter = rs.getInt(pmd.getFieldName("CreditBalanceReferenceCounter", provider));
        this.initialProjectCostsReferenceCounter = rs.getInt(pmd.getFieldName("InitialProjectCostsReferenceCounter", provider));
        this.preferedGLAccountId = rs.getString(pmd.getFieldName("PreferedGLAccountId", provider));
        this.state = rs.getInt(pmd.getFieldName("State", provider));
        this.description = rs.getString(pmd.getFieldName("Description", provider));
        this.startYear = rs.getInt(pmd.getFieldName("StartYear", provider));
        this.startPeriod = rs.getInt(pmd.getFieldName("StartPeriod", provider));
        this.endYear = rs.getInt(pmd.getFieldName("EndYear", provider));
        this.endPeriod = rs.getInt(pmd.getFieldName("EndPeriod", provider));
        this.benefitType = rs.getInt(pmd.getFieldName("BenefitType", provider));
        this.gLBalanceType = rs.getInt(pmd.getFieldName("GLBalanceType", provider));
        this.isResultAccountItem = rs.getBoolean(pmd.getFieldName("IsResultAccountItem", provider));
        this.originalInvestmentCreditAmount = rs.getBigDecimal(pmd.getFieldName("OriginalInvestmentCreditAmount", provider));
        this.hasMemo = rs.getBoolean(pmd.getFieldName("HasMemo", provider));
        this.closingYear = rs.getInt(pmd.getFieldName("ClosingYear", provider));
        this.closingPeriod = rs.getInt(pmd.getFieldName("ClosingPeriod", provider));
        this.finClosingYear = rs.getInt(pmd.getFieldName("FinClosingYear", provider));
        this.finClosingPeriod = rs.getInt(pmd.getFieldName("FinClosingPeriod", provider));
        this.proFormaTypeId = rs.getString(pmd.getFieldName("ProFormaTypeId", provider));
        this.decisionId = rs.getString(pmd.getFieldName("DecisionId", provider));
        this.decisionDate = rs.getDate(pmd.getFieldName("DecisionDate", provider));
        this.finDimId1 = rs.getString(pmd.getFieldName("FinDimId1", provider));
        this.finDimId2 = rs.getString(pmd.getFieldName("FinDimId2", provider));
        this.finDimId3 = rs.getString(pmd.getFieldName("FinDimId3", provider));
        this.finDimId4 = rs.getString(pmd.getFieldName("FinDimId4", provider));
        this.interestCalculationMethod = rs.getInt(pmd.getFieldName("InterestCalculationMethod", provider));
        this.interestTableId = rs.getString(pmd.getFieldName("InterestTableId", provider));
        this.interestPercentage = rs.getBigDecimal(pmd.getFieldName("InterestPercentage", provider));
        this.interestStartYear = rs.getInt(pmd.getFieldName("InterestStartYear", provider));
        this.interestStartPeriod = rs.getInt(pmd.getFieldName("InterestStartPeriod", provider));
        this.lastInterestYear = rs.getInt(pmd.getFieldName("LastInterestYear", provider));
        this.lastInterestPeriod = rs.getInt(pmd.getFieldName("LastInterestPeriod", provider));
        this.allocatedValue = rs.getBigDecimal(pmd.getFieldName("AllocatedValue", provider));
        this.allocatedDepreciationValue = rs.getBigDecimal(pmd.getFieldName("AllocatedDepreciationValue", provider));
        this.dimValue1 = rs.getString(pmd.getFieldName("DimValue1", provider));
        this.dimValue2 = rs.getString(pmd.getFieldName("DimValue2", provider));
        this.dimValue3 = rs.getString(pmd.getFieldName("DimValue3", provider));
        this.dimValue4 = rs.getString(pmd.getFieldName("DimValue4", provider));
        this.dimValue5 = rs.getString(pmd.getFieldName("DimValue5", provider));
        this.dimValue6 = rs.getString(pmd.getFieldName("DimValue6", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        CreditPK key = new CreditPK();
        key.setCompanyId(this.getCompanyId());
        key.setId(this.getId());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public String getId() throws Exception {
        this.assureStorage();
        return this.id;
    }

    @Override
    public int getCreditBalanceReferenceCounter() throws Exception {
        return this.creditBalanceReferenceCounter;
    }

    @Override
    public int getInitialProjectCostsReferenceCounter() throws Exception {
        return this.initialProjectCostsReferenceCounter;
    }

    @Override
    public String getPreferedGLAccountId() throws Exception {
        return this.preferedGLAccountId;
    }

    @Override
    public int getState() throws Exception {
        return this.state;
    }

    @Override
    public String getDescription() throws Exception {
        return this.description;
    }

    @Override
    public int getStartYear() throws Exception {
        return this.startYear;
    }

    @Override
    public int getStartPeriod() throws Exception {
        return this.startPeriod;
    }

    @Override
    public int getEndYear() throws Exception {
        return this.endYear;
    }

    @Override
    public int getEndPeriod() throws Exception {
        return this.endPeriod;
    }

    @Override
    public int getBenefitType() throws Exception {
        return this.benefitType;
    }

    @Override
    public int getGLBalanceType() throws Exception {
        return this.gLBalanceType;
    }

    @Override
    public boolean getIsResultAccountItem() throws Exception {
        return this.isResultAccountItem;
    }

    @Override
    public BigDecimal getOriginalInvestmentCreditAmount() throws Exception {
        return this.originalInvestmentCreditAmount;
    }

    @Override
    public boolean getHasMemo() throws Exception {
        return this.hasMemo;
    }

    @Override
    public int getClosingYear() throws Exception {
        return this.closingYear;
    }

    @Override
    public int getClosingPeriod() throws Exception {
        return this.closingPeriod;
    }

    @Override
    public int getFinClosingYear() throws Exception {
        return this.finClosingYear;
    }

    @Override
    public int getFinClosingPeriod() throws Exception {
        return this.finClosingPeriod;
    }

    @Override
    public String getProFormaTypeId() throws Exception {
        return this.proFormaTypeId;
    }

    @Override
    public String getDecisionId() throws Exception {
        return this.decisionId;
    }

    @Override
    public java.util.Date getDecisionDate() throws Exception {
        java.util.Date obj = this.decisionDate == null ? null : new java.util.Date(this.decisionDate.getTime());
        return obj;
    }

    @Override
    public String getFinDimId1() throws Exception {
        return this.finDimId1;
    }

    @Override
    public String getFinDimId2() throws Exception {
        return this.finDimId2;
    }

    @Override
    public String getFinDimId3() throws Exception {
        return this.finDimId3;
    }

    @Override
    public String getFinDimId4() throws Exception {
        return this.finDimId4;
    }

    @Override
    public int getInterestCalculationMethod() throws Exception {
        return this.interestCalculationMethod;
    }

    @Override
    public String getInterestTableId() throws Exception {
        return this.interestTableId;
    }

    @Override
    public BigDecimal getInterestPercentage() throws Exception {
        return this.interestPercentage;
    }

    @Override
    public int getInterestStartYear() throws Exception {
        return this.interestStartYear;
    }

    @Override
    public int getInterestStartPeriod() throws Exception {
        return this.interestStartPeriod;
    }

    @Override
    public int getLastInterestYear() throws Exception {
        return this.lastInterestYear;
    }

    @Override
    public int getLastInterestPeriod() throws Exception {
        return this.lastInterestPeriod;
    }

    @Override
    public BigDecimal getAllocatedValue() throws Exception {
        return this.allocatedValue;
    }

    @Override
    public BigDecimal getAllocatedDepreciationValue() throws Exception {
        return this.allocatedDepreciationValue;
    }

    @Override
    public String getDimValue1() throws Exception {
        return this.dimValue1;
    }

    @Override
    public String getDimValue2() throws Exception {
        return this.dimValue2;
    }

    @Override
    public String getDimValue3() throws Exception {
        return this.dimValue3;
    }

    @Override
    public String getDimValue4() throws Exception {
        return this.dimValue4;
    }

    @Override
    public String getDimValue5() throws Exception {
        return this.dimValue5;
    }

    @Override
    public String getDimValue6() throws Exception {
        return this.dimValue6;
    }

    @Override
    public InterestTable getInterestTable() throws Exception {
        if (this.isCachedRelation("InterestTable")) {
            return (InterestTable)this.getCachedRelationObject("InterestTable");
        }
        if (this.getInterestTableId() == null) {
            return (InterestTable)this.addCachedRelationObject("InterestTable", null);
        }
        try {
            return (InterestTable)this.addCachedRelationObject("InterestTable", ((InterestTableManager_Impl)InterestTableManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getInterestTableId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public Company getOwnedByCompanyAsCredits() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsCredits")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsCredits");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsCredits", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Company owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsCredits();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    @Override
    public TotalEstimationTransaction getTotalEstimationTransactionsReferencingCreditAsCreditObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "companyId = ?companyId AND creditId = ?creditId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("creditId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND creditId = ?creditId");
        return TotalEstimationTransactionManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getTotalEstimationTransactionsReferencingCreditAsCreditCollection(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND creditId = ?creditId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("creditId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND creditId = ?creditId");
        return TotalEstimationTransactionManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getTotalEstimationTransactionsReferencingCreditAsCreditDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "companyId = ?companyId AND creditId = ?creditId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("creditId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND creditId = ?creditId");
        return TotalEstimationTransactionManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getTotalEstimationTransactionsReferencingCreditAsCreditDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "companyId = ?companyId AND creditId = ?creditId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("creditId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND creditId = ?creditId");
        return TotalEstimationTransactionManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getTotalEstimationTransactionsReferencingCreditAsCreditDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND creditId = ?creditId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("creditId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND creditId = ?creditId");
        return TotalEstimationTransactionManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public Collection referencedByBusinessObjects() throws Exception {
        ArrayList list = new ArrayList();
        list.addAll(this.getTotalEstimationTransactionsReferencingCreditAsCreditCollection(null));
        return list;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setId(String _id) throws Exception {
        if (_id == null) {
            _id = "";
        }
        if (_id.equals(this.getId())) {
            return;
        }
        this.preSet();
        this.id = _id;
        this.autoUpdate();
    }

    @Override
    public void setCreditBalanceReferenceCounter(int _creditBalanceReferenceCounter) throws Exception {
        if (_creditBalanceReferenceCounter == this.getCreditBalanceReferenceCounter()) {
            return;
        }
        this.preSet();
        this.creditBalanceReferenceCounter = _creditBalanceReferenceCounter;
        this.autoUpdate();
    }

    @Override
    public void setInitialProjectCostsReferenceCounter(int _initialProjectCostsReferenceCounter) throws Exception {
        if (_initialProjectCostsReferenceCounter == this.getInitialProjectCostsReferenceCounter()) {
            return;
        }
        this.preSet();
        this.initialProjectCostsReferenceCounter = _initialProjectCostsReferenceCounter;
        this.autoUpdate();
    }

    @Override
    public void setPreferedGLAccountId(String _preferedGLAccountId) throws Exception {
        if (_preferedGLAccountId == null ? this.getPreferedGLAccountId() == null : _preferedGLAccountId.equals(this.getPreferedGLAccountId())) {
            return;
        }
        this.preSet();
        this.preferedGLAccountId = _preferedGLAccountId;
        this.autoUpdate();
    }

    @Override
    public void setState(int _state) throws Exception {
        if (_state == this.getState()) {
            return;
        }
        this.preSet();
        this.state = _state;
        this.autoUpdate();
    }

    @Override
    public void setDescription(String _description) throws Exception {
        if (_description == null) {
            _description = "";
        }
        if (_description.equals(this.getDescription())) {
            return;
        }
        this.preSet();
        this.description = _description;
        this.autoUpdate();
    }

    @Override
    public void setStartYear(int _startYear) throws Exception {
        if (_startYear == this.getStartYear()) {
            return;
        }
        this.preSet();
        this.startYear = _startYear;
        this.autoUpdate();
    }

    @Override
    public void setStartPeriod(int _startPeriod) throws Exception {
        if (_startPeriod == this.getStartPeriod()) {
            return;
        }
        this.preSet();
        this.startPeriod = _startPeriod;
        this.autoUpdate();
    }

    @Override
    public void setEndYear(int _endYear) throws Exception {
        if (_endYear == this.getEndYear()) {
            return;
        }
        this.preSet();
        this.endYear = _endYear;
        this.autoUpdate();
    }

    @Override
    public void setEndPeriod(int _endPeriod) throws Exception {
        if (_endPeriod == this.getEndPeriod()) {
            return;
        }
        this.preSet();
        this.endPeriod = _endPeriod;
        this.autoUpdate();
    }

    @Override
    public void setBenefitType(int _benefitType) throws Exception {
        if (_benefitType == this.getBenefitType()) {
            return;
        }
        this.preSet();
        this.benefitType = _benefitType;
        this.autoUpdate();
    }

    @Override
    public void setGLBalanceType(int _gLBalanceType) throws Exception {
        if (_gLBalanceType == this.getGLBalanceType()) {
            return;
        }
        this.preSet();
        this.gLBalanceType = _gLBalanceType;
        this.autoUpdate();
    }

    @Override
    public void setIsResultAccountItem(boolean _isResultAccountItem) throws Exception {
        if (_isResultAccountItem == this.getIsResultAccountItem()) {
            return;
        }
        this.preSet();
        this.isResultAccountItem = _isResultAccountItem;
        this.autoUpdate();
    }

    @Override
    public void setOriginalInvestmentCreditAmount(BigDecimal _originalInvestmentCreditAmount) throws Exception {
        if (_originalInvestmentCreditAmount == null) {
            _originalInvestmentCreditAmount = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_originalInvestmentCreditAmount.equals(this.getOriginalInvestmentCreditAmount())) {
            return;
        }
        this.preSet();
        this.originalInvestmentCreditAmount = _originalInvestmentCreditAmount;
        this.autoUpdate();
    }

    @Override
    public void setHasMemo(boolean _hasMemo) throws Exception {
        if (_hasMemo == this.getHasMemo()) {
            return;
        }
        this.preSet();
        this.hasMemo = _hasMemo;
        this.autoUpdate();
    }

    @Override
    public void setClosingYear(int _closingYear) throws Exception {
        if (_closingYear == this.getClosingYear()) {
            return;
        }
        this.preSet();
        this.closingYear = _closingYear;
        this.autoUpdate();
    }

    @Override
    public void setClosingPeriod(int _closingPeriod) throws Exception {
        if (_closingPeriod == this.getClosingPeriod()) {
            return;
        }
        this.preSet();
        this.closingPeriod = _closingPeriod;
        this.autoUpdate();
    }

    @Override
    public void setFinClosingYear(int _finClosingYear) throws Exception {
        if (_finClosingYear == this.getFinClosingYear()) {
            return;
        }
        this.preSet();
        this.finClosingYear = _finClosingYear;
        this.autoUpdate();
    }

    @Override
    public void setFinClosingPeriod(int _finClosingPeriod) throws Exception {
        if (_finClosingPeriod == this.getFinClosingPeriod()) {
            return;
        }
        this.preSet();
        this.finClosingPeriod = _finClosingPeriod;
        this.autoUpdate();
    }

    @Override
    public void setProFormaTypeId(String _proFormaTypeId) throws Exception {
        if (_proFormaTypeId == null) {
            _proFormaTypeId = "";
        }
        if (_proFormaTypeId.equals(this.getProFormaTypeId())) {
            return;
        }
        this.preSet();
        this.proFormaTypeId = _proFormaTypeId;
        this.autoUpdate();
    }

    @Override
    public void setDecisionId(String _decisionId) throws Exception {
        if (_decisionId == null) {
            _decisionId = "";
        }
        if (_decisionId.equals(this.getDecisionId())) {
            return;
        }
        this.preSet();
        this.decisionId = _decisionId;
        this.autoUpdate();
    }

    @Override
    public void setDecisionDate(java.util.Date _decisionDate) throws Exception {
        if (_decisionDate == null ? this.getDecisionDate() == null : _decisionDate.equals(this.getDecisionDate())) {
            return;
        }
        this.preSet();
        this.decisionDate = _decisionDate == null ? null : new Date(_decisionDate.getTime());
        this.autoUpdate();
    }

    @Override
    public void setFinDimId1(String _finDimId1) throws Exception {
        if (_finDimId1 == null) {
            _finDimId1 = "";
        }
        if (_finDimId1.equals(this.getFinDimId1())) {
            return;
        }
        this.preSet();
        this.finDimId1 = _finDimId1;
        this.autoUpdate();
    }

    @Override
    public void setFinDimId2(String _finDimId2) throws Exception {
        if (_finDimId2 == null) {
            _finDimId2 = "";
        }
        if (_finDimId2.equals(this.getFinDimId2())) {
            return;
        }
        this.preSet();
        this.finDimId2 = _finDimId2;
        this.autoUpdate();
    }

    @Override
    public void setFinDimId3(String _finDimId3) throws Exception {
        if (_finDimId3 == null) {
            _finDimId3 = "";
        }
        if (_finDimId3.equals(this.getFinDimId3())) {
            return;
        }
        this.preSet();
        this.finDimId3 = _finDimId3;
        this.autoUpdate();
    }

    @Override
    public void setFinDimId4(String _finDimId4) throws Exception {
        if (_finDimId4 == null) {
            _finDimId4 = "";
        }
        if (_finDimId4.equals(this.getFinDimId4())) {
            return;
        }
        this.preSet();
        this.finDimId4 = _finDimId4;
        this.autoUpdate();
    }

    @Override
    public void setInterestCalculationMethod(int _interestCalculationMethod) throws Exception {
        if (_interestCalculationMethod == this.getInterestCalculationMethod()) {
            return;
        }
        this.preSet();
        this.interestCalculationMethod = _interestCalculationMethod;
        this.autoUpdate();
    }

    public void setInterestTableId(String _interestTableId) throws Exception {
        if (_interestTableId == null ? this.getInterestTableId() == null : _interestTableId.equals(this.getInterestTableId())) {
            return;
        }
        this.preSet();
        this.interestTableId = _interestTableId;
        this.autoUpdate();
    }

    @Override
    public void setInterestPercentage(BigDecimal _interestPercentage) throws Exception {
        if (_interestPercentage == null) {
            _interestPercentage = new BigDecimal("0.000").setScale(3, 6);
        }
        if (_interestPercentage.equals(this.getInterestPercentage())) {
            return;
        }
        this.preSet();
        this.interestPercentage = _interestPercentage;
        this.autoUpdate();
    }

    @Override
    public void setInterestStartYear(int _interestStartYear) throws Exception {
        if (_interestStartYear == this.getInterestStartYear()) {
            return;
        }
        this.preSet();
        this.interestStartYear = _interestStartYear;
        this.autoUpdate();
    }

    @Override
    public void setInterestStartPeriod(int _interestStartPeriod) throws Exception {
        if (_interestStartPeriod == this.getInterestStartPeriod()) {
            return;
        }
        this.preSet();
        this.interestStartPeriod = _interestStartPeriod;
        this.autoUpdate();
    }

    @Override
    public void setLastInterestYear(int _lastInterestYear) throws Exception {
        if (_lastInterestYear == this.getLastInterestYear()) {
            return;
        }
        this.preSet();
        this.lastInterestYear = _lastInterestYear;
        this.autoUpdate();
    }

    @Override
    public void setLastInterestPeriod(int _lastInterestPeriod) throws Exception {
        if (_lastInterestPeriod == this.getLastInterestPeriod()) {
            return;
        }
        this.preSet();
        this.lastInterestPeriod = _lastInterestPeriod;
        this.autoUpdate();
    }

    @Override
    public void setAllocatedValue(BigDecimal _allocatedValue) throws Exception {
        if (_allocatedValue == null) {
            _allocatedValue = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_allocatedValue.equals(this.getAllocatedValue())) {
            return;
        }
        this.preSet();
        this.allocatedValue = _allocatedValue;
        this.autoUpdate();
    }

    @Override
    public void setAllocatedDepreciationValue(BigDecimal _allocatedDepreciationValue) throws Exception {
        if (_allocatedDepreciationValue == null) {
            _allocatedDepreciationValue = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_allocatedDepreciationValue.equals(this.getAllocatedDepreciationValue())) {
            return;
        }
        this.preSet();
        this.allocatedDepreciationValue = _allocatedDepreciationValue;
        this.autoUpdate();
    }

    @Override
    public void setDimValue1(String _dimValue1) throws Exception {
        if (_dimValue1 == null) {
            _dimValue1 = "";
        }
        if (_dimValue1.equals(this.getDimValue1())) {
            return;
        }
        this.preSet();
        this.dimValue1 = _dimValue1;
        this.autoUpdate();
    }

    @Override
    public void setDimValue2(String _dimValue2) throws Exception {
        if (_dimValue2 == null) {
            _dimValue2 = "";
        }
        if (_dimValue2.equals(this.getDimValue2())) {
            return;
        }
        this.preSet();
        this.dimValue2 = _dimValue2;
        this.autoUpdate();
    }

    @Override
    public void setDimValue3(String _dimValue3) throws Exception {
        if (_dimValue3 == null) {
            _dimValue3 = "";
        }
        if (_dimValue3.equals(this.getDimValue3())) {
            return;
        }
        this.preSet();
        this.dimValue3 = _dimValue3;
        this.autoUpdate();
    }

    @Override
    public void setDimValue4(String _dimValue4) throws Exception {
        if (_dimValue4 == null) {
            _dimValue4 = "";
        }
        if (_dimValue4.equals(this.getDimValue4())) {
            return;
        }
        this.preSet();
        this.dimValue4 = _dimValue4;
        this.autoUpdate();
    }

    @Override
    public void setDimValue5(String _dimValue5) throws Exception {
        if (_dimValue5 == null) {
            _dimValue5 = "";
        }
        if (_dimValue5.equals(this.getDimValue5())) {
            return;
        }
        this.preSet();
        this.dimValue5 = _dimValue5;
        this.autoUpdate();
    }

    @Override
    public void setDimValue6(String _dimValue6) throws Exception {
        if (_dimValue6 == null) {
            _dimValue6 = "";
        }
        if (_dimValue6.equals(this.getDimValue6())) {
            return;
        }
        this.preSet();
        this.dimValue6 = _dimValue6;
        this.autoUpdate();
    }

    @Override
    public void setInterestTable(InterestTable object) throws Exception {
        this.transientInterestTable = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "interestTableId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "interestTableId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("InterestTable", object);
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.id = "";
        this.creditBalanceReferenceCounter = 0;
        this.initialProjectCostsReferenceCounter = 0;
        this.state = 0;
        this.description = "";
        this.startYear = 0;
        this.startPeriod = 0;
        this.endYear = 0;
        this.endPeriod = 0;
        this.benefitType = 0;
        this.gLBalanceType = 0;
        this.isResultAccountItem = false;
        this.originalInvestmentCreditAmount = new BigDecimal("0.00").setScale(2, 6);
        this.hasMemo = false;
        this.closingYear = 0;
        this.closingPeriod = 0;
        this.finClosingYear = 0;
        this.finClosingPeriod = 0;
        this.proFormaTypeId = "";
        this.decisionId = "";
        this.finDimId1 = "";
        this.finDimId2 = "";
        this.finDimId3 = "";
        this.finDimId4 = "";
        this.interestCalculationMethod = 0;
        this.interestPercentage = new BigDecimal("0.000").setScale(3, 6);
        this.interestStartYear = 0;
        this.interestStartPeriod = 0;
        this.lastInterestYear = 0;
        this.lastInterestPeriod = 0;
        this.allocatedValue = new BigDecimal("0.00").setScale(2, 6);
        this.allocatedDepreciationValue = new BigDecimal("0.00").setScale(2, 6);
        this.dimValue1 = "";
        this.dimValue2 = "";
        this.dimValue3 = "";
        this.dimValue4 = "";
        this.dimValue5 = "";
        this.dimValue6 = "";
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.id = this.id;
        this.currentDBImage.creditBalanceReferenceCounter = this.creditBalanceReferenceCounter;
        this.currentDBImage.initialProjectCostsReferenceCounter = this.initialProjectCostsReferenceCounter;
        this.currentDBImage.preferedGLAccountId = this.preferedGLAccountId;
        this.currentDBImage.state = this.state;
        this.currentDBImage.description = this.description;
        this.currentDBImage.startYear = this.startYear;
        this.currentDBImage.startPeriod = this.startPeriod;
        this.currentDBImage.endYear = this.endYear;
        this.currentDBImage.endPeriod = this.endPeriod;
        this.currentDBImage.benefitType = this.benefitType;
        this.currentDBImage.gLBalanceType = this.gLBalanceType;
        this.currentDBImage.isResultAccountItem = this.isResultAccountItem;
        this.currentDBImage.originalInvestmentCreditAmount = this.originalInvestmentCreditAmount;
        this.currentDBImage.hasMemo = this.hasMemo;
        this.currentDBImage.closingYear = this.closingYear;
        this.currentDBImage.closingPeriod = this.closingPeriod;
        this.currentDBImage.finClosingYear = this.finClosingYear;
        this.currentDBImage.finClosingPeriod = this.finClosingPeriod;
        this.currentDBImage.proFormaTypeId = this.proFormaTypeId;
        this.currentDBImage.decisionId = this.decisionId;
        this.currentDBImage.decisionDate = this.decisionDate;
        this.currentDBImage.finDimId1 = this.finDimId1;
        this.currentDBImage.finDimId2 = this.finDimId2;
        this.currentDBImage.finDimId3 = this.finDimId3;
        this.currentDBImage.finDimId4 = this.finDimId4;
        this.currentDBImage.interestCalculationMethod = this.interestCalculationMethod;
        this.currentDBImage.interestTableId = this.interestTableId;
        this.currentDBImage.interestPercentage = this.interestPercentage;
        this.currentDBImage.interestStartYear = this.interestStartYear;
        this.currentDBImage.interestStartPeriod = this.interestStartPeriod;
        this.currentDBImage.lastInterestYear = this.lastInterestYear;
        this.currentDBImage.lastInterestPeriod = this.lastInterestPeriod;
        this.currentDBImage.allocatedValue = this.allocatedValue;
        this.currentDBImage.allocatedDepreciationValue = this.allocatedDepreciationValue;
        this.currentDBImage.dimValue1 = this.dimValue1;
        this.currentDBImage.dimValue2 = this.dimValue2;
        this.currentDBImage.dimValue3 = this.dimValue3;
        this.currentDBImage.dimValue4 = this.dimValue4;
        this.currentDBImage.dimValue5 = this.dimValue5;
        this.currentDBImage.dimValue6 = this.dimValue6;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("Credit is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            CreditPK key = new CreditPK();
            key.setCompanyId(this.getCompanyId());
            key.setId(this.getId());
            ((CreditManager_Impl)CreditManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((CreditManager_Impl)CreditManager_Impl.getInstance(this.dbd)).getResultSet((CreditPK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("365914751_" + this.dbd.getDBId() + this.companyId + this.id).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public CreditDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public CreditDataBean getCreditDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private CreditDataBean getDataBean(CreditDataBean bean) throws Exception {
        if (bean == null) {
            bean = new CreditDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setId(this.getId());
        bean.setCreditBalanceReferenceCounter(this.getCreditBalanceReferenceCounter());
        bean.setInitialProjectCostsReferenceCounter(this.getInitialProjectCostsReferenceCounter());
        bean.setPreferedGLAccountId(this.getPreferedGLAccountId());
        bean.setState(this.getState());
        bean.setDescription(this.getDescription());
        bean.setStartYear(this.getStartYear());
        bean.setStartPeriod(this.getStartPeriod());
        bean.setEndYear(this.getEndYear());
        bean.setEndPeriod(this.getEndPeriod());
        bean.setBenefitType(this.getBenefitType());
        bean.setGLBalanceType(this.getGLBalanceType());
        bean.setIsResultAccountItem(this.getIsResultAccountItem());
        bean.setOriginalInvestmentCreditAmount(this.getOriginalInvestmentCreditAmount());
        bean.setHasMemo(this.getHasMemo());
        bean.setClosingYear(this.getClosingYear());
        bean.setClosingPeriod(this.getClosingPeriod());
        bean.setFinClosingYear(this.getFinClosingYear());
        bean.setFinClosingPeriod(this.getFinClosingPeriod());
        bean.setProFormaTypeId(this.getProFormaTypeId());
        bean.setDecisionId(this.getDecisionId());
        bean.setDecisionDate(this.getDecisionDate());
        bean.setFinDimId1(this.getFinDimId1());
        bean.setFinDimId2(this.getFinDimId2());
        bean.setFinDimId3(this.getFinDimId3());
        bean.setFinDimId4(this.getFinDimId4());
        bean.setInterestCalculationMethod(this.getInterestCalculationMethod());
        bean.setInterestTableId(this.getInterestTableId());
        bean.setInterestPercentage(this.getInterestPercentage());
        bean.setInterestStartYear(this.getInterestStartYear());
        bean.setInterestStartPeriod(this.getInterestStartPeriod());
        bean.setLastInterestYear(this.getLastInterestYear());
        bean.setLastInterestPeriod(this.getLastInterestPeriod());
        bean.setAllocatedValue(this.getAllocatedValue());
        bean.setAllocatedDepreciationValue(this.getAllocatedDepreciationValue());
        bean.setDimValue1(this.getDimValue1());
        bean.setDimValue2(this.getDimValue2());
        bean.setDimValue3(this.getDimValue3());
        bean.setDimValue4(this.getDimValue4());
        bean.setDimValue5(this.getDimValue5());
        bean.setDimValue6(this.getDimValue6());
        return bean;
    }

    public boolean equals(Object object) {
        Credit_Impl bo;
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                try {
                                    if (object != null && object instanceof Credit_Impl) break block10;
                                    return false;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e.getMessage());
                                }
                            }
                            bo = (Credit_Impl)object;
                            if (bo.getCompanyId() != null) break block11;
                            if (this.getCompanyId() != null) {
                                return false;
                            }
                            break block12;
                        }
                        if (bo.getCompanyId().equals(this.getCompanyId())) break block12;
                        return false;
                    }
                    if (bo.getId() != null) break block13;
                    if (this.getId() != null) {
                        return false;
                    }
                    break block14;
                }
                if (bo.getId().equals(this.getId())) break block14;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block15;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(CreditDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(CreditDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setId(bean.getId());
            this.setCreditBalanceReferenceCounter(bean.getCreditBalanceReferenceCounter());
            this.setInitialProjectCostsReferenceCounter(bean.getInitialProjectCostsReferenceCounter());
            this.setPreferedGLAccountId(bean.getPreferedGLAccountId());
            this.setState(bean.getState());
            this.setDescription(bean.getDescription());
            this.setStartYear(bean.getStartYear());
            this.setStartPeriod(bean.getStartPeriod());
            this.setEndYear(bean.getEndYear());
            this.setEndPeriod(bean.getEndPeriod());
            this.setBenefitType(bean.getBenefitType());
            this.setGLBalanceType(bean.getGLBalanceType());
            this.setIsResultAccountItem(bean.getIsResultAccountItem());
            this.setOriginalInvestmentCreditAmount(bean.getOriginalInvestmentCreditAmount());
            this.setHasMemo(bean.getHasMemo());
            this.setClosingYear(bean.getClosingYear());
            this.setClosingPeriod(bean.getClosingPeriod());
            this.setFinClosingYear(bean.getFinClosingYear());
            this.setFinClosingPeriod(bean.getFinClosingPeriod());
            this.setProFormaTypeId(bean.getProFormaTypeId());
            this.setDecisionId(bean.getDecisionId());
            this.setDecisionDate(bean.getDecisionDate());
            this.setFinDimId1(bean.getFinDimId1());
            this.setFinDimId2(bean.getFinDimId2());
            this.setFinDimId3(bean.getFinDimId3());
            this.setFinDimId4(bean.getFinDimId4());
            this.setInterestCalculationMethod(bean.getInterestCalculationMethod());
            this.setInterestTableId(bean.getInterestTableId());
            this.setInterestPercentage(bean.getInterestPercentage());
            this.setInterestStartYear(bean.getInterestStartYear());
            this.setInterestStartPeriod(bean.getInterestStartPeriod());
            this.setLastInterestYear(bean.getLastInterestYear());
            this.setLastInterestPeriod(bean.getLastInterestPeriod());
            this.setAllocatedValue(bean.getAllocatedValue());
            this.setAllocatedDepreciationValue(bean.getAllocatedDepreciationValue());
            this.setDimValue1(bean.getDimValue1());
            this.setDimValue2(bean.getDimValue2());
            this.setDimValue3(bean.getDimValue3());
            this.setDimValue4(bean.getDimValue4());
            this.setDimValue5(bean.getDimValue5());
            this.setDimValue6(bean.getDimValue6());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "Credit is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.Credit.save");
        key.append(image.preferedGLAccountId == null ? "0" : "1");
        key.append(image.decisionDate == null ? "0" : "1");
        key.append(image.interestTableId == null ? "0" : "1");
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("Id", provider) + " = ? " + ", " + pmd.getFieldName("CreditBalanceReferenceCounter", provider) + " = ? " + ", " + pmd.getFieldName("InitialProjectCostsReferenceCounter", provider) + " = ? " + ", " + pmd.getFieldName("PreferedGLAccountId", provider) + " = ? " + ", " + pmd.getFieldName("State", provider) + " = ? " + ", " + pmd.getFieldName("Description", provider) + " = ? " + ", " + pmd.getFieldName("StartYear", provider) + " = ? " + ", " + pmd.getFieldName("StartPeriod", provider) + " = ? " + ", " + pmd.getFieldName("EndYear", provider) + " = ? " + ", " + pmd.getFieldName("EndPeriod", provider) + " = ? " + ", " + pmd.getFieldName("BenefitType", provider) + " = ? " + ", " + pmd.getFieldName("GLBalanceType", provider) + " = ? " + ", " + pmd.getFieldName("IsResultAccountItem", provider) + " = ? " + ", " + pmd.getFieldName("OriginalInvestmentCreditAmount", provider) + " = ? " + ", " + pmd.getFieldName("HasMemo", provider) + " = ? " + ", " + pmd.getFieldName("ClosingYear", provider) + " = ? " + ", " + pmd.getFieldName("ClosingPeriod", provider) + " = ? " + ", " + pmd.getFieldName("FinClosingYear", provider) + " = ? " + ", " + pmd.getFieldName("FinClosingPeriod", provider) + " = ? " + ", " + pmd.getFieldName("ProFormaTypeId", provider) + " = ? " + ", " + pmd.getFieldName("DecisionId", provider) + " = ? " + ", " + pmd.getFieldName("DecisionDate", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId1", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId2", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId3", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId4", provider) + " = ? " + ", " + pmd.getFieldName("InterestCalculationMethod", provider) + " = ? " + ", " + pmd.getFieldName("InterestTableId", provider) + " = ? " + ", " + pmd.getFieldName("InterestPercentage", provider) + " = ? " + ", " + pmd.getFieldName("InterestStartYear", provider) + " = ? " + ", " + pmd.getFieldName("InterestStartPeriod", provider) + " = ? " + ", " + pmd.getFieldName("LastInterestYear", provider) + " = ? " + ", " + pmd.getFieldName("LastInterestPeriod", provider) + " = ? " + ", " + pmd.getFieldName("AllocatedValue", provider) + " = ? " + ", " + pmd.getFieldName("AllocatedDepreciationValue", provider) + " = ? " + ", " + pmd.getFieldName("DimValue1", provider) + " = ? " + ", " + pmd.getFieldName("DimValue2", provider) + " = ? " + ", " + pmd.getFieldName("DimValue3", provider) + " = ? " + ", " + pmd.getFieldName("DimValue4", provider) + " = ? " + ", " + pmd.getFieldName("DimValue5", provider) + " = ? " + ", " + pmd.getFieldName("DimValue6", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("Id", provider) + " = ? " + " AND  " + pmd.getFieldName("CreditBalanceReferenceCounter", provider) + " = ? " + " AND  " + pmd.getFieldName("InitialProjectCostsReferenceCounter", provider) + " = ? " + " AND  " + pmd.getFieldName("PreferedGLAccountId", provider) + (image.preferedGLAccountId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("State", provider) + " = ? " + " AND  " + pmd.getFieldName("Description", provider) + " = ? " + " AND  " + pmd.getFieldName("StartYear", provider) + " = ? " + " AND  " + pmd.getFieldName("StartPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("EndYear", provider) + " = ? " + " AND  " + pmd.getFieldName("EndPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("BenefitType", provider) + " = ? " + " AND  " + pmd.getFieldName("GLBalanceType", provider) + " = ? " + " AND  " + pmd.getFieldName("IsResultAccountItem", provider) + " = ? " + " AND  " + pmd.getFieldName("OriginalInvestmentCreditAmount", provider) + " = ? " + " AND  " + pmd.getFieldName("HasMemo", provider) + " = ? " + " AND  " + pmd.getFieldName("ClosingYear", provider) + " = ? " + " AND  " + pmd.getFieldName("ClosingPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("FinClosingYear", provider) + " = ? " + " AND  " + pmd.getFieldName("FinClosingPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("ProFormaTypeId", provider) + " = ? " + " AND  " + pmd.getFieldName("DecisionId", provider) + " = ? " + " AND  " + pmd.getFieldName("DecisionDate", provider) + (image.decisionDate == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("FinDimId1", provider) + " = ? " + " AND  " + pmd.getFieldName("FinDimId2", provider) + " = ? " + " AND  " + pmd.getFieldName("FinDimId3", provider) + " = ? " + " AND  " + pmd.getFieldName("FinDimId4", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestCalculationMethod", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestTableId", provider) + (image.interestTableId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("InterestPercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestStartYear", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestStartPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("LastInterestYear", provider) + " = ? " + " AND  " + pmd.getFieldName("LastInterestPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("AllocatedValue", provider) + " = ? " + " AND  " + pmd.getFieldName("AllocatedDepreciationValue", provider) + " = ? " + " AND  " + pmd.getFieldName("DimValue1", provider) + " = ? " + " AND  " + pmd.getFieldName("DimValue2", provider) + " = ? " + " AND  " + pmd.getFieldName("DimValue3", provider) + " = ? " + " AND  " + pmd.getFieldName("DimValue4", provider) + " = ? " + " AND  " + pmd.getFieldName("DimValue5", provider) + " = ? " + " AND  " + pmd.getFieldName("DimValue6", provider) + " = ? ");
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.id, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.creditBalanceReferenceCounter), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.initialProjectCostsReferenceCounter), mapping.getJDBCTypeFor("int"));
                if (this.preferedGLAccountId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.preferedGLAccountId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(this.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.startYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.startPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.endYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.endPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.benefitType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.gLBalanceType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.isResultAccountItem), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)this.originalInvestmentCreditAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Boolean(this.hasMemo), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(this.closingYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.closingPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.finClosingYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.finClosingPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.proFormaTypeId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.decisionId, mapping.getJDBCTypeFor("String"));
                if (this.decisionDate == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.decisionDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)this.finDimId1, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.finDimId2, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.finDimId3, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.finDimId4, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                if (this.interestTableId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)this.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(parmIndex++, (Object)new Integer(this.interestStartYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.interestStartPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.lastInterestYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.lastInterestPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.allocatedValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.allocatedDepreciationValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.dimValue1, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.dimValue2, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.dimValue3, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.dimValue4, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.dimValue5, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.dimValue6, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.id, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.creditBalanceReferenceCounter), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.initialProjectCostsReferenceCounter), mapping.getJDBCTypeFor("int"));
                if (image.preferedGLAccountId != null) {
                    prep.setObject(parmIndex++, (Object)image.preferedGLAccountId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(image.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.startYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.startPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.endYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.endPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.benefitType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.gLBalanceType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.isResultAccountItem), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)image.originalInvestmentCreditAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Boolean(image.hasMemo), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(image.closingYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.closingPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.finClosingYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.finClosingPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.proFormaTypeId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.decisionId, mapping.getJDBCTypeFor("String"));
                if (image.decisionDate != null) {
                    prep.setObject(parmIndex++, (Object)image.decisionDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)image.finDimId1, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.finDimId2, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.finDimId3, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.finDimId4, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                if (image.interestTableId != null) {
                    prep.setObject(parmIndex++, (Object)image.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)image.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(parmIndex++, (Object)new Integer(image.interestStartYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.interestStartPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.lastInterestYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.lastInterestPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.allocatedValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.allocatedDepreciationValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.dimValue1, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.dimValue2, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.dimValue3, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.dimValue4, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.dimValue5, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.dimValue6, mapping.getJDBCTypeFor("String"));
                int n = prep.executeUpdate();
                if (n == 0) {
                    this.rollback(true);
                    throw new UpdateException("Credit modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.Credit.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.Credit.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("Id", provider) + ", " + pmd.getFieldName("CreditBalanceReferenceCounter", provider) + ", " + pmd.getFieldName("InitialProjectCostsReferenceCounter", provider) + ", " + pmd.getFieldName("PreferedGLAccountId", provider) + ", " + pmd.getFieldName("State", provider) + ", " + pmd.getFieldName("Description", provider) + ", " + pmd.getFieldName("StartYear", provider) + ", " + pmd.getFieldName("StartPeriod", provider) + ", " + pmd.getFieldName("EndYear", provider) + ", " + pmd.getFieldName("EndPeriod", provider) + ", " + pmd.getFieldName("BenefitType", provider) + ", " + pmd.getFieldName("GLBalanceType", provider) + ", " + pmd.getFieldName("IsResultAccountItem", provider) + ", " + pmd.getFieldName("OriginalInvestmentCreditAmount", provider) + ", " + pmd.getFieldName("HasMemo", provider) + ", " + pmd.getFieldName("ClosingYear", provider) + ", " + pmd.getFieldName("ClosingPeriod", provider) + ", " + pmd.getFieldName("FinClosingYear", provider) + ", " + pmd.getFieldName("FinClosingPeriod", provider) + ", " + pmd.getFieldName("ProFormaTypeId", provider) + ", " + pmd.getFieldName("DecisionId", provider) + ", " + pmd.getFieldName("DecisionDate", provider) + ", " + pmd.getFieldName("FinDimId1", provider) + ", " + pmd.getFieldName("FinDimId2", provider) + ", " + pmd.getFieldName("FinDimId3", provider) + ", " + pmd.getFieldName("FinDimId4", provider) + ", " + pmd.getFieldName("InterestCalculationMethod", provider) + ", " + pmd.getFieldName("InterestTableId", provider) + ", " + pmd.getFieldName("InterestPercentage", provider) + ", " + pmd.getFieldName("InterestStartYear", provider) + ", " + pmd.getFieldName("InterestStartPeriod", provider) + ", " + pmd.getFieldName("LastInterestYear", provider) + ", " + pmd.getFieldName("LastInterestPeriod", provider) + ", " + pmd.getFieldName("AllocatedValue", provider) + ", " + pmd.getFieldName("AllocatedDepreciationValue", provider) + ", " + pmd.getFieldName("DimValue1", provider) + ", " + pmd.getFieldName("DimValue2", provider) + ", " + pmd.getFieldName("DimValue3", provider) + ", " + pmd.getFieldName("DimValue4", provider) + ", " + pmd.getFieldName("DimValue5", provider) + ", " + pmd.getFieldName("DimValue6", provider) + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)this.id, mapping.getJDBCTypeFor("String"));
                prep.setObject(3, (Object)new Integer(this.creditBalanceReferenceCounter), mapping.getJDBCTypeFor("int"));
                prep.setObject(4, (Object)new Integer(this.initialProjectCostsReferenceCounter), mapping.getJDBCTypeFor("int"));
                if (this.preferedGLAccountId == null) {
                    prep.setNull(5, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(5, (Object)this.preferedGLAccountId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(6, (Object)new Integer(this.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(7, (Object)this.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(8, (Object)new Integer(this.startYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(9, (Object)new Integer(this.startPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(10, (Object)new Integer(this.endYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(11, (Object)new Integer(this.endPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(12, (Object)new Integer(this.benefitType), mapping.getJDBCTypeFor("int"));
                prep.setObject(13, (Object)new Integer(this.gLBalanceType), mapping.getJDBCTypeFor("int"));
                prep.setObject(14, (Object)new Boolean(this.isResultAccountItem), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(15, (Object)this.originalInvestmentCreditAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(16, (Object)new Boolean(this.hasMemo), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(17, (Object)new Integer(this.closingYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(18, (Object)new Integer(this.closingPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(19, (Object)new Integer(this.finClosingYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(20, (Object)new Integer(this.finClosingPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(21, (Object)this.proFormaTypeId, mapping.getJDBCTypeFor("String"));
                prep.setObject(22, (Object)this.decisionId, mapping.getJDBCTypeFor("String"));
                if (this.decisionDate == null) {
                    prep.setNull(23, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(23, (Object)this.decisionDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(24, (Object)this.finDimId1, mapping.getJDBCTypeFor("String"));
                prep.setObject(25, (Object)this.finDimId2, mapping.getJDBCTypeFor("String"));
                prep.setObject(26, (Object)this.finDimId3, mapping.getJDBCTypeFor("String"));
                prep.setObject(27, (Object)this.finDimId4, mapping.getJDBCTypeFor("String"));
                prep.setObject(28, (Object)new Integer(this.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                if (this.interestTableId == null) {
                    prep.setNull(29, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(29, (Object)this.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(30, (Object)this.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(31, (Object)new Integer(this.interestStartYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(32, (Object)new Integer(this.interestStartPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(33, (Object)new Integer(this.lastInterestYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(34, (Object)new Integer(this.lastInterestPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(35, (Object)this.allocatedValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(36, (Object)this.allocatedDepreciationValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(37, (Object)this.dimValue1, mapping.getJDBCTypeFor("String"));
                prep.setObject(38, (Object)this.dimValue2, mapping.getJDBCTypeFor("String"));
                prep.setObject(39, (Object)this.dimValue3, mapping.getJDBCTypeFor("String"));
                prep.setObject(40, (Object)this.dimValue4, mapping.getJDBCTypeFor("String"));
                prep.setObject(41, (Object)this.dimValue5, mapping.getJDBCTypeFor("String"));
                prep.setObject(42, (Object)this.dimValue6, mapping.getJDBCTypeFor("String"));
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.id = this.currentDBImage.id;
            this.transactionImage.dbImage.creditBalanceReferenceCounter = this.currentDBImage.creditBalanceReferenceCounter;
            this.transactionImage.dbImage.initialProjectCostsReferenceCounter = this.currentDBImage.initialProjectCostsReferenceCounter;
            this.transactionImage.dbImage.preferedGLAccountId = this.currentDBImage.preferedGLAccountId;
            this.transactionImage.dbImage.state = this.currentDBImage.state;
            this.transactionImage.dbImage.description = this.currentDBImage.description;
            this.transactionImage.dbImage.startYear = this.currentDBImage.startYear;
            this.transactionImage.dbImage.startPeriod = this.currentDBImage.startPeriod;
            this.transactionImage.dbImage.endYear = this.currentDBImage.endYear;
            this.transactionImage.dbImage.endPeriod = this.currentDBImage.endPeriod;
            this.transactionImage.dbImage.benefitType = this.currentDBImage.benefitType;
            this.transactionImage.dbImage.gLBalanceType = this.currentDBImage.gLBalanceType;
            this.transactionImage.dbImage.isResultAccountItem = this.currentDBImage.isResultAccountItem;
            this.transactionImage.dbImage.originalInvestmentCreditAmount = this.currentDBImage.originalInvestmentCreditAmount;
            this.transactionImage.dbImage.hasMemo = this.currentDBImage.hasMemo;
            this.transactionImage.dbImage.closingYear = this.currentDBImage.closingYear;
            this.transactionImage.dbImage.closingPeriod = this.currentDBImage.closingPeriod;
            this.transactionImage.dbImage.finClosingYear = this.currentDBImage.finClosingYear;
            this.transactionImage.dbImage.finClosingPeriod = this.currentDBImage.finClosingPeriod;
            this.transactionImage.dbImage.proFormaTypeId = this.currentDBImage.proFormaTypeId;
            this.transactionImage.dbImage.decisionId = this.currentDBImage.decisionId;
            this.transactionImage.dbImage.decisionDate = this.currentDBImage.decisionDate;
            this.transactionImage.dbImage.finDimId1 = this.currentDBImage.finDimId1;
            this.transactionImage.dbImage.finDimId2 = this.currentDBImage.finDimId2;
            this.transactionImage.dbImage.finDimId3 = this.currentDBImage.finDimId3;
            this.transactionImage.dbImage.finDimId4 = this.currentDBImage.finDimId4;
            this.transactionImage.dbImage.interestCalculationMethod = this.currentDBImage.interestCalculationMethod;
            this.transactionImage.dbImage.interestTableId = this.currentDBImage.interestTableId;
            this.transactionImage.dbImage.interestPercentage = this.currentDBImage.interestPercentage;
            this.transactionImage.dbImage.interestStartYear = this.currentDBImage.interestStartYear;
            this.transactionImage.dbImage.interestStartPeriod = this.currentDBImage.interestStartPeriod;
            this.transactionImage.dbImage.lastInterestYear = this.currentDBImage.lastInterestYear;
            this.transactionImage.dbImage.lastInterestPeriod = this.currentDBImage.lastInterestPeriod;
            this.transactionImage.dbImage.allocatedValue = this.currentDBImage.allocatedValue;
            this.transactionImage.dbImage.allocatedDepreciationValue = this.currentDBImage.allocatedDepreciationValue;
            this.transactionImage.dbImage.dimValue1 = this.currentDBImage.dimValue1;
            this.transactionImage.dbImage.dimValue2 = this.currentDBImage.dimValue2;
            this.transactionImage.dbImage.dimValue3 = this.currentDBImage.dimValue3;
            this.transactionImage.dbImage.dimValue4 = this.currentDBImage.dimValue4;
            this.transactionImage.dbImage.dimValue5 = this.currentDBImage.dimValue5;
            this.transactionImage.dbImage.dimValue6 = this.currentDBImage.dimValue6;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.id = this.transactionImage.dbImage.id;
        this.currentDBImage.creditBalanceReferenceCounter = this.transactionImage.dbImage.creditBalanceReferenceCounter;
        this.currentDBImage.initialProjectCostsReferenceCounter = this.transactionImage.dbImage.initialProjectCostsReferenceCounter;
        this.currentDBImage.preferedGLAccountId = this.transactionImage.dbImage.preferedGLAccountId;
        this.currentDBImage.state = this.transactionImage.dbImage.state;
        this.currentDBImage.description = this.transactionImage.dbImage.description;
        this.currentDBImage.startYear = this.transactionImage.dbImage.startYear;
        this.currentDBImage.startPeriod = this.transactionImage.dbImage.startPeriod;
        this.currentDBImage.endYear = this.transactionImage.dbImage.endYear;
        this.currentDBImage.endPeriod = this.transactionImage.dbImage.endPeriod;
        this.currentDBImage.benefitType = this.transactionImage.dbImage.benefitType;
        this.currentDBImage.gLBalanceType = this.transactionImage.dbImage.gLBalanceType;
        this.currentDBImage.isResultAccountItem = this.transactionImage.dbImage.isResultAccountItem;
        this.currentDBImage.originalInvestmentCreditAmount = this.transactionImage.dbImage.originalInvestmentCreditAmount;
        this.currentDBImage.hasMemo = this.transactionImage.dbImage.hasMemo;
        this.currentDBImage.closingYear = this.transactionImage.dbImage.closingYear;
        this.currentDBImage.closingPeriod = this.transactionImage.dbImage.closingPeriod;
        this.currentDBImage.finClosingYear = this.transactionImage.dbImage.finClosingYear;
        this.currentDBImage.finClosingPeriod = this.transactionImage.dbImage.finClosingPeriod;
        this.currentDBImage.proFormaTypeId = this.transactionImage.dbImage.proFormaTypeId;
        this.currentDBImage.decisionId = this.transactionImage.dbImage.decisionId;
        this.currentDBImage.decisionDate = this.transactionImage.dbImage.decisionDate;
        this.currentDBImage.finDimId1 = this.transactionImage.dbImage.finDimId1;
        this.currentDBImage.finDimId2 = this.transactionImage.dbImage.finDimId2;
        this.currentDBImage.finDimId3 = this.transactionImage.dbImage.finDimId3;
        this.currentDBImage.finDimId4 = this.transactionImage.dbImage.finDimId4;
        this.currentDBImage.interestCalculationMethod = this.transactionImage.dbImage.interestCalculationMethod;
        this.currentDBImage.interestTableId = this.transactionImage.dbImage.interestTableId;
        this.currentDBImage.interestPercentage = this.transactionImage.dbImage.interestPercentage;
        this.currentDBImage.interestStartYear = this.transactionImage.dbImage.interestStartYear;
        this.currentDBImage.interestStartPeriod = this.transactionImage.dbImage.interestStartPeriod;
        this.currentDBImage.lastInterestYear = this.transactionImage.dbImage.lastInterestYear;
        this.currentDBImage.lastInterestPeriod = this.transactionImage.dbImage.lastInterestPeriod;
        this.currentDBImage.allocatedValue = this.transactionImage.dbImage.allocatedValue;
        this.currentDBImage.allocatedDepreciationValue = this.transactionImage.dbImage.allocatedDepreciationValue;
        this.currentDBImage.dimValue1 = this.transactionImage.dbImage.dimValue1;
        this.currentDBImage.dimValue2 = this.transactionImage.dbImage.dimValue2;
        this.currentDBImage.dimValue3 = this.transactionImage.dbImage.dimValue3;
        this.currentDBImage.dimValue4 = this.transactionImage.dbImage.dimValue4;
        this.currentDBImage.dimValue5 = this.transactionImage.dbImage.dimValue5;
        this.currentDBImage.dimValue6 = this.transactionImage.dbImage.dimValue6;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.id = this.transactionImage.dbImage.id;
            this.creditBalanceReferenceCounter = this.transactionImage.dbImage.creditBalanceReferenceCounter;
            this.initialProjectCostsReferenceCounter = this.transactionImage.dbImage.initialProjectCostsReferenceCounter;
            this.preferedGLAccountId = this.transactionImage.dbImage.preferedGLAccountId;
            this.state = this.transactionImage.dbImage.state;
            this.description = this.transactionImage.dbImage.description;
            this.startYear = this.transactionImage.dbImage.startYear;
            this.startPeriod = this.transactionImage.dbImage.startPeriod;
            this.endYear = this.transactionImage.dbImage.endYear;
            this.endPeriod = this.transactionImage.dbImage.endPeriod;
            this.benefitType = this.transactionImage.dbImage.benefitType;
            this.gLBalanceType = this.transactionImage.dbImage.gLBalanceType;
            this.isResultAccountItem = this.transactionImage.dbImage.isResultAccountItem;
            this.originalInvestmentCreditAmount = this.transactionImage.dbImage.originalInvestmentCreditAmount;
            this.hasMemo = this.transactionImage.dbImage.hasMemo;
            this.closingYear = this.transactionImage.dbImage.closingYear;
            this.closingPeriod = this.transactionImage.dbImage.closingPeriod;
            this.finClosingYear = this.transactionImage.dbImage.finClosingYear;
            this.finClosingPeriod = this.transactionImage.dbImage.finClosingPeriod;
            this.proFormaTypeId = this.transactionImage.dbImage.proFormaTypeId;
            this.decisionId = this.transactionImage.dbImage.decisionId;
            this.decisionDate = this.transactionImage.dbImage.decisionDate;
            this.finDimId1 = this.transactionImage.dbImage.finDimId1;
            this.finDimId2 = this.transactionImage.dbImage.finDimId2;
            this.finDimId3 = this.transactionImage.dbImage.finDimId3;
            this.finDimId4 = this.transactionImage.dbImage.finDimId4;
            this.interestCalculationMethod = this.transactionImage.dbImage.interestCalculationMethod;
            this.interestTableId = this.transactionImage.dbImage.interestTableId;
            this.interestPercentage = this.transactionImage.dbImage.interestPercentage;
            this.interestStartYear = this.transactionImage.dbImage.interestStartYear;
            this.interestStartPeriod = this.transactionImage.dbImage.interestStartPeriod;
            this.lastInterestYear = this.transactionImage.dbImage.lastInterestYear;
            this.lastInterestPeriod = this.transactionImage.dbImage.lastInterestPeriod;
            this.allocatedValue = this.transactionImage.dbImage.allocatedValue;
            this.allocatedDepreciationValue = this.transactionImage.dbImage.allocatedDepreciationValue;
            this.dimValue1 = this.transactionImage.dbImage.dimValue1;
            this.dimValue2 = this.transactionImage.dbImage.dimValue2;
            this.dimValue3 = this.transactionImage.dbImage.dimValue3;
            this.dimValue4 = this.transactionImage.dbImage.dimValue4;
            this.dimValue5 = this.transactionImage.dbImage.dimValue5;
            this.dimValue6 = this.transactionImage.dbImage.dimValue6;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    @Override
    public BigDecimal getTotalEstimationAmount() throws Exception {
        return TotalEstimationTransactionBO.getTotalCreditAmount(this);
    }

    @Override
    public BigDecimal getTotalCostAmount() throws Exception {
        return CreditBalanceBO.getBalanceAmounts(this)[0];
    }

    @Override
    public BigDecimal getTotalInterestAmount() throws Exception {
        return CreditBalanceBO.getBalanceAmounts(this)[2];
    }

    @Override
    public BigDecimal getExpenditureLeftAmount() throws Exception {
        return this.getTotalEstimationAmount().subtract(this.getTotalCostAmount());
    }

    @Override
    public BigDecimal getManualInterestAmount() throws Exception {
        return TransactionBO.getManualCapitalCosts(this)[1];
    }

    @Override
    public BigDecimal getManualDepreciationAmount() throws Exception {
        return TransactionBO.getManualCapitalCosts(this)[0];
    }

    @Override
    public boolean getHasTransactions() throws Exception {
        return TransactionBO.hasTransactions(this);
    }

    @Override
    public BigDecimal getInitialProjectCostAmount() throws Exception {
        return IncomingFinancialTransactionBP.getTotalIPCAmount(this);
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private String id;
        private int creditBalanceReferenceCounter;
        private int initialProjectCostsReferenceCounter;
        private String preferedGLAccountId;
        private int state;
        private String description;
        private int startYear;
        private int startPeriod;
        private int endYear;
        private int endPeriod;
        private int benefitType;
        private int gLBalanceType;
        private boolean isResultAccountItem;
        private BigDecimal originalInvestmentCreditAmount;
        private boolean hasMemo;
        private int closingYear;
        private int closingPeriod;
        private int finClosingYear;
        private int finClosingPeriod;
        private String proFormaTypeId;
        private String decisionId;
        private Date decisionDate;
        private String finDimId1;
        private String finDimId2;
        private String finDimId3;
        private String finDimId4;
        private int interestCalculationMethod;
        private String interestTableId;
        private BigDecimal interestPercentage;
        private int interestStartYear;
        private int interestStartPeriod;
        private int lastInterestYear;
        private int lastInterestPeriod;
        private BigDecimal allocatedValue;
        private BigDecimal allocatedDepreciationValue;
        private String dimValue1;
        private String dimValue2;
        private String dimValue3;
        private String dimValue4;
        private String dimValue5;
        private String dimValue6;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

