/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.IncomingFinancialTransactionDataBean;
import nl.ibs.fac.db.IncomingFinancialTransactionPK;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.impl.AssetManager_Impl;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.IncomingFinancialTransactionManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataIncomingFinancialTransaction;
import nl.ibs.fac.db.impl.TransactionManager_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class IncomingFinancialTransaction_Impl
implements IncomingFinancialTransaction,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataIncomingFinancialTransaction.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected String id;
    protected String description;
    protected int bookYear;
    protected int period;
    protected Date bookDate;
    protected long internalInvoiceId;
    protected String voucherId;
    protected String documentId;
    protected String daybookId;
    protected String mainAccount;
    protected String finDimId1;
    protected String finDimId2;
    protected String finDimId3;
    protected String finDimId4;
    protected String finDimId5;
    protected String suspenseAccount;
    protected String suspenseType;
    protected BigDecimal transactionValue;
    protected BigDecimal unAllocatedValue;
    protected boolean confirmed;
    protected int systemItemNumber;
    protected int systemItemSequencenumber;
    protected Date invoiceDate;
    protected boolean deletedTransactions;
    protected String description2;
    protected int iFTType;
    protected int governmentCode;
    protected int bBVCategory;
    protected boolean isNew;
    protected String creditId;

    protected IncomingFinancialTransaction_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected IncomingFinancialTransaction_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected IncomingFinancialTransaction_Impl(DBData _dbd, String _companyId, String _id) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setId(_id);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected IncomingFinancialTransaction_Impl(DBData _dbd, IncomingFinancialTransactionDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.IncomingFinancialTransactionDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate IncomingFinancialTransaction with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.IncomingFinancialTransactionDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setId(bean.getId());
            this.setDescription(bean.getDescription());
            this.setBookYear(bean.getBookYear());
            this.setPeriod(bean.getPeriod());
            this.setBookDate(bean.getBookDate());
            this.setInternalInvoiceId(bean.getInternalInvoiceId());
            this.setVoucherId(bean.getVoucherId());
            this.setDocumentId(bean.getDocumentId());
            this.setDaybookId(bean.getDaybookId());
            this.setMainAccount(bean.getMainAccount());
            this.setFinDimId1(bean.getFinDimId1());
            this.setFinDimId2(bean.getFinDimId2());
            this.setFinDimId3(bean.getFinDimId3());
            this.setFinDimId4(bean.getFinDimId4());
            this.setFinDimId5(bean.getFinDimId5());
            this.setSuspenseAccount(bean.getSuspenseAccount());
            this.setSuspenseType(bean.getSuspenseType());
            this.setTransactionValue(bean.getTransactionValue());
            this.setUnAllocatedValue(bean.getUnAllocatedValue());
            this.setConfirmed(bean.getConfirmed());
            this.setSystemItemNumber(bean.getSystemItemNumber());
            this.setSystemItemSequencenumber(bean.getSystemItemSequencenumber());
            this.setInvoiceDate(bean.getInvoiceDate());
            this.setDeletedTransactions(bean.getDeletedTransactions());
            this.setDescription2(bean.getDescription2());
            this.setIFTType(bean.getIFTType());
            this.setGovernmentCode(bean.getGovernmentCode());
            this.setBBVCategory(bean.getBBVCategory());
            this.setIsNew(bean.getIsNew());
            this.setCreditId(bean.getCreditId());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public IncomingFinancialTransaction_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.id = rs.getString(pmd.getFieldName("Id", provider));
        this.description = rs.getString(pmd.getFieldName("Description", provider));
        this.bookYear = rs.getInt(pmd.getFieldName("BookYear", provider));
        this.period = rs.getInt(pmd.getFieldName("Period", provider));
        this.bookDate = rs.getDate(pmd.getFieldName("BookDate", provider));
        this.internalInvoiceId = rs.getLong(pmd.getFieldName("InternalInvoiceId", provider));
        this.voucherId = rs.getString(pmd.getFieldName("VoucherId", provider));
        this.documentId = rs.getString(pmd.getFieldName("DocumentId", provider));
        this.daybookId = rs.getString(pmd.getFieldName("DaybookId", provider));
        this.mainAccount = rs.getString(pmd.getFieldName("MainAccount", provider));
        this.finDimId1 = rs.getString(pmd.getFieldName("FinDimId1", provider));
        this.finDimId2 = rs.getString(pmd.getFieldName("FinDimId2", provider));
        this.finDimId3 = rs.getString(pmd.getFieldName("FinDimId3", provider));
        this.finDimId4 = rs.getString(pmd.getFieldName("FinDimId4", provider));
        this.finDimId5 = rs.getString(pmd.getFieldName("FinDimId5", provider));
        this.suspenseAccount = rs.getString(pmd.getFieldName("SuspenseAccount", provider));
        this.suspenseType = rs.getString(pmd.getFieldName("SuspenseType", provider));
        this.transactionValue = rs.getBigDecimal(pmd.getFieldName("TransactionValue", provider));
        this.unAllocatedValue = rs.getBigDecimal(pmd.getFieldName("UnAllocatedValue", provider));
        this.confirmed = rs.getBoolean(pmd.getFieldName("confirmed", provider));
        this.systemItemNumber = rs.getInt(pmd.getFieldName("System item number", provider));
        this.systemItemSequencenumber = rs.getInt(pmd.getFieldName("System item sequencenumber", provider));
        this.invoiceDate = rs.getDate(pmd.getFieldName("InvoiceDate", provider));
        this.deletedTransactions = rs.getBoolean(pmd.getFieldName("DeletedTransactions", provider));
        this.description2 = rs.getString(pmd.getFieldName("Description_2", provider));
        this.iFTType = rs.getInt(pmd.getFieldName("IFTType", provider));
        this.governmentCode = rs.getInt(pmd.getFieldName("GovernmentCode", provider));
        this.bBVCategory = rs.getInt(pmd.getFieldName("BBVCategory", provider));
        this.isNew = rs.getBoolean(pmd.getFieldName("IsNew", provider));
        this.creditId = rs.getString(pmd.getFieldName("CreditId", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        IncomingFinancialTransactionPK key = new IncomingFinancialTransactionPK();
        key.setCompanyId(this.getCompanyId());
        key.setId(this.getId());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public String getId() throws Exception {
        this.assureStorage();
        return this.id;
    }

    @Override
    public String getDescription() throws Exception {
        return this.description;
    }

    @Override
    public int getBookYear() throws Exception {
        return this.bookYear;
    }

    @Override
    public int getPeriod() throws Exception {
        return this.period;
    }

    @Override
    public java.util.Date getBookDate() throws Exception {
        java.util.Date obj = this.bookDate == null ? null : new java.util.Date(this.bookDate.getTime());
        return obj;
    }

    @Override
    public long getInternalInvoiceId() throws Exception {
        return this.internalInvoiceId;
    }

    @Override
    public String getVoucherId() throws Exception {
        return this.voucherId;
    }

    @Override
    public String getDocumentId() throws Exception {
        return this.documentId;
    }

    @Override
    public String getDaybookId() throws Exception {
        return this.daybookId;
    }

    @Override
    public String getMainAccount() throws Exception {
        return this.mainAccount;
    }

    @Override
    public String getFinDimId1() throws Exception {
        return this.finDimId1;
    }

    @Override
    public String getFinDimId2() throws Exception {
        return this.finDimId2;
    }

    @Override
    public String getFinDimId3() throws Exception {
        return this.finDimId3;
    }

    @Override
    public String getFinDimId4() throws Exception {
        return this.finDimId4;
    }

    @Override
    public String getFinDimId5() throws Exception {
        return this.finDimId5;
    }

    @Override
    public String getSuspenseAccount() throws Exception {
        return this.suspenseAccount;
    }

    @Override
    public String getSuspenseType() throws Exception {
        return this.suspenseType;
    }

    @Override
    public BigDecimal getTransactionValue() throws Exception {
        return this.transactionValue;
    }

    @Override
    public BigDecimal getUnAllocatedValue() throws Exception {
        return this.unAllocatedValue;
    }

    @Override
    public boolean getConfirmed() throws Exception {
        return this.confirmed;
    }

    @Override
    public int getSystemItemNumber() throws Exception {
        return this.systemItemNumber;
    }

    @Override
    public int getSystemItemSequencenumber() throws Exception {
        return this.systemItemSequencenumber;
    }

    @Override
    public java.util.Date getInvoiceDate() throws Exception {
        java.util.Date obj = this.invoiceDate == null ? null : new java.util.Date(this.invoiceDate.getTime());
        return obj;
    }

    @Override
    public boolean getDeletedTransactions() throws Exception {
        return this.deletedTransactions;
    }

    @Override
    public String getDescription2() throws Exception {
        return this.description2;
    }

    @Override
    public int getIFTType() throws Exception {
        return this.iFTType;
    }

    @Override
    public int getGovernmentCode() throws Exception {
        return this.governmentCode;
    }

    @Override
    public int getBBVCategory() throws Exception {
        return this.bBVCategory;
    }

    @Override
    public boolean getIsNew() throws Exception {
        return this.isNew;
    }

    @Override
    public String getCreditId() throws Exception {
        return this.creditId;
    }

    @Override
    public Company getOwnedByCompanyAsIncomingFinancialTransactions() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsIncomingFinancialTransactions")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsIncomingFinancialTransactions");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsIncomingFinancialTransactions", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Company owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsIncomingFinancialTransactions();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    @Override
    public Asset getAssetsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return AssetManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getAssetsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionCollection(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return AssetManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getAssetsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return AssetManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getAssetsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return AssetManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getAssetsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return AssetManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public Transaction getTransactionsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return TransactionManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getTransactionsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionCollection(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return TransactionManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getTransactionsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return TransactionManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getTransactionsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return TransactionManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getTransactionsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("incomingFinancialTransactionId", this.getId());
        queryImpl.setRelationFilter("companyId = ?companyId AND incomingFinancialTransactionId = ?incomingFinancialTransactionId");
        return TransactionManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public Collection referencedByBusinessObjects() throws Exception {
        ArrayList list = new ArrayList();
        list.addAll(this.getAssetsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionCollection(null));
        list.addAll(this.getTransactionsReferencingIncomingFinancialTransactionAsIncomingFinancialTransactionCollection(null));
        return list;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setId(String _id) throws Exception {
        if (_id == null) {
            _id = "";
        }
        if (_id.equals(this.getId())) {
            return;
        }
        this.preSet();
        this.id = _id;
        this.autoUpdate();
    }

    @Override
    public void setDescription(String _description) throws Exception {
        if (_description == null) {
            _description = "";
        }
        if (_description.equals(this.getDescription())) {
            return;
        }
        this.preSet();
        this.description = _description;
        this.autoUpdate();
    }

    @Override
    public void setBookYear(int _bookYear) throws Exception {
        if (_bookYear == this.getBookYear()) {
            return;
        }
        this.preSet();
        this.bookYear = _bookYear;
        this.autoUpdate();
    }

    @Override
    public void setPeriod(int _period) throws Exception {
        if (_period == this.getPeriod()) {
            return;
        }
        this.preSet();
        this.period = _period;
        this.autoUpdate();
    }

    @Override
    public void setBookDate(java.util.Date _bookDate) throws Exception {
        if (_bookDate == null ? this.getBookDate() == null : _bookDate.equals(this.getBookDate())) {
            return;
        }
        this.preSet();
        this.bookDate = _bookDate == null ? null : new Date(_bookDate.getTime());
        this.autoUpdate();
    }

    @Override
    public void setInternalInvoiceId(long _internalInvoiceId) throws Exception {
        if (_internalInvoiceId == this.getInternalInvoiceId()) {
            return;
        }
        this.preSet();
        this.internalInvoiceId = _internalInvoiceId;
        this.autoUpdate();
    }

    @Override
    public void setVoucherId(String _voucherId) throws Exception {
        if (_voucherId == null) {
            _voucherId = "";
        }
        if (_voucherId.equals(this.getVoucherId())) {
            return;
        }
        this.preSet();
        this.voucherId = _voucherId;
        this.autoUpdate();
    }

    @Override
    public void setDocumentId(String _documentId) throws Exception {
        if (_documentId == null) {
            _documentId = "";
        }
        if (_documentId.equals(this.getDocumentId())) {
            return;
        }
        this.preSet();
        this.documentId = _documentId;
        this.autoUpdate();
    }

    @Override
    public void setDaybookId(String _daybookId) throws Exception {
        if (_daybookId == null) {
            _daybookId = "";
        }
        if (_daybookId.equals(this.getDaybookId())) {
            return;
        }
        this.preSet();
        this.daybookId = _daybookId;
        this.autoUpdate();
    }

    @Override
    public void setMainAccount(String _mainAccount) throws Exception {
        if (_mainAccount == null) {
            _mainAccount = "";
        }
        if (_mainAccount.equals(this.getMainAccount())) {
            return;
        }
        this.preSet();
        this.mainAccount = _mainAccount;
        this.autoUpdate();
    }

    @Override
    public void setFinDimId1(String _finDimId1) throws Exception {
        if (_finDimId1 == null) {
            _finDimId1 = "";
        }
        if (_finDimId1.equals(this.getFinDimId1())) {
            return;
        }
        this.preSet();
        this.finDimId1 = _finDimId1;
        this.autoUpdate();
    }

    @Override
    public void setFinDimId2(String _finDimId2) throws Exception {
        if (_finDimId2 == null) {
            _finDimId2 = "";
        }
        if (_finDimId2.equals(this.getFinDimId2())) {
            return;
        }
        this.preSet();
        this.finDimId2 = _finDimId2;
        this.autoUpdate();
    }

    @Override
    public void setFinDimId3(String _finDimId3) throws Exception {
        if (_finDimId3 == null) {
            _finDimId3 = "";
        }
        if (_finDimId3.equals(this.getFinDimId3())) {
            return;
        }
        this.preSet();
        this.finDimId3 = _finDimId3;
        this.autoUpdate();
    }

    @Override
    public void setFinDimId4(String _finDimId4) throws Exception {
        if (_finDimId4 == null) {
            _finDimId4 = "";
        }
        if (_finDimId4.equals(this.getFinDimId4())) {
            return;
        }
        this.preSet();
        this.finDimId4 = _finDimId4;
        this.autoUpdate();
    }

    @Override
    public void setFinDimId5(String _finDimId5) throws Exception {
        if (_finDimId5 == null) {
            _finDimId5 = "";
        }
        if (_finDimId5.equals(this.getFinDimId5())) {
            return;
        }
        this.preSet();
        this.finDimId5 = _finDimId5;
        this.autoUpdate();
    }

    @Override
    public void setSuspenseAccount(String _suspenseAccount) throws Exception {
        if (_suspenseAccount == null) {
            _suspenseAccount = "";
        }
        if (_suspenseAccount.equals(this.getSuspenseAccount())) {
            return;
        }
        this.preSet();
        this.suspenseAccount = _suspenseAccount;
        this.autoUpdate();
    }

    @Override
    public void setSuspenseType(String _suspenseType) throws Exception {
        if (_suspenseType == null) {
            _suspenseType = "";
        }
        if (_suspenseType.equals(this.getSuspenseType())) {
            return;
        }
        this.preSet();
        this.suspenseType = _suspenseType;
        this.autoUpdate();
    }

    @Override
    public void setTransactionValue(BigDecimal _transactionValue) throws Exception {
        if (_transactionValue == null) {
            _transactionValue = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_transactionValue.equals(this.getTransactionValue())) {
            return;
        }
        this.preSet();
        this.transactionValue = _transactionValue;
        this.autoUpdate();
    }

    @Override
    public void setUnAllocatedValue(BigDecimal _unAllocatedValue) throws Exception {
        if (_unAllocatedValue == null) {
            _unAllocatedValue = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_unAllocatedValue.equals(this.getUnAllocatedValue())) {
            return;
        }
        this.preSet();
        this.unAllocatedValue = _unAllocatedValue;
        this.autoUpdate();
    }

    @Override
    public void setConfirmed(boolean _confirmed) throws Exception {
        if (_confirmed == this.getConfirmed()) {
            return;
        }
        this.preSet();
        this.confirmed = _confirmed;
        this.autoUpdate();
    }

    @Override
    public void setSystemItemNumber(int _systemItemNumber) throws Exception {
        if (_systemItemNumber == this.getSystemItemNumber()) {
            return;
        }
        this.preSet();
        this.systemItemNumber = _systemItemNumber;
        this.autoUpdate();
    }

    @Override
    public void setSystemItemSequencenumber(int _systemItemSequencenumber) throws Exception {
        if (_systemItemSequencenumber == this.getSystemItemSequencenumber()) {
            return;
        }
        this.preSet();
        this.systemItemSequencenumber = _systemItemSequencenumber;
        this.autoUpdate();
    }

    @Override
    public void setInvoiceDate(java.util.Date _invoiceDate) throws Exception {
        if (_invoiceDate == null ? this.getInvoiceDate() == null : _invoiceDate.equals(this.getInvoiceDate())) {
            return;
        }
        this.preSet();
        this.invoiceDate = _invoiceDate == null ? null : new Date(_invoiceDate.getTime());
        this.autoUpdate();
    }

    @Override
    public void setDeletedTransactions(boolean _deletedTransactions) throws Exception {
        if (_deletedTransactions == this.getDeletedTransactions()) {
            return;
        }
        this.preSet();
        this.deletedTransactions = _deletedTransactions;
        this.autoUpdate();
    }

    @Override
    public void setDescription2(String _description2) throws Exception {
        if (_description2 == null) {
            _description2 = "";
        }
        if (_description2.equals(this.getDescription2())) {
            return;
        }
        this.preSet();
        this.description2 = _description2;
        this.autoUpdate();
    }

    @Override
    public void setIFTType(int _iFTType) throws Exception {
        if (_iFTType == this.getIFTType()) {
            return;
        }
        this.preSet();
        this.iFTType = _iFTType;
        this.autoUpdate();
    }

    @Override
    public void setGovernmentCode(int _governmentCode) throws Exception {
        if (_governmentCode == this.getGovernmentCode()) {
            return;
        }
        this.preSet();
        this.governmentCode = _governmentCode;
        this.autoUpdate();
    }

    @Override
    public void setBBVCategory(int _bBVCategory) throws Exception {
        if (_bBVCategory == this.getBBVCategory()) {
            return;
        }
        this.preSet();
        this.bBVCategory = _bBVCategory;
        this.autoUpdate();
    }

    @Override
    public void setIsNew(boolean _isNew) throws Exception {
        if (_isNew == this.getIsNew()) {
            return;
        }
        this.preSet();
        this.isNew = _isNew;
        this.autoUpdate();
    }

    @Override
    public void setCreditId(String _creditId) throws Exception {
        if (_creditId == null ? this.getCreditId() == null : _creditId.equals(this.getCreditId())) {
            return;
        }
        this.preSet();
        this.creditId = _creditId;
        this.autoUpdate();
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.id = "";
        this.description = "";
        this.bookYear = 0;
        this.period = 0;
        this.internalInvoiceId = 0L;
        this.voucherId = "";
        this.documentId = "";
        this.daybookId = "";
        this.mainAccount = "";
        this.finDimId1 = "";
        this.finDimId2 = "";
        this.finDimId3 = "";
        this.finDimId4 = "";
        this.finDimId5 = "";
        this.suspenseAccount = "";
        this.suspenseType = "";
        this.transactionValue = new BigDecimal("0.00").setScale(2, 6);
        this.unAllocatedValue = new BigDecimal("0.00").setScale(2, 6);
        this.confirmed = false;
        this.systemItemNumber = 0;
        this.systemItemSequencenumber = 0;
        this.deletedTransactions = false;
        this.description2 = "";
        this.iFTType = 0;
        this.governmentCode = 0;
        this.bBVCategory = 0;
        this.isNew = true;
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.id = this.id;
        this.currentDBImage.description = this.description;
        this.currentDBImage.bookYear = this.bookYear;
        this.currentDBImage.period = this.period;
        this.currentDBImage.bookDate = this.bookDate;
        this.currentDBImage.internalInvoiceId = this.internalInvoiceId;
        this.currentDBImage.voucherId = this.voucherId;
        this.currentDBImage.documentId = this.documentId;
        this.currentDBImage.daybookId = this.daybookId;
        this.currentDBImage.mainAccount = this.mainAccount;
        this.currentDBImage.finDimId1 = this.finDimId1;
        this.currentDBImage.finDimId2 = this.finDimId2;
        this.currentDBImage.finDimId3 = this.finDimId3;
        this.currentDBImage.finDimId4 = this.finDimId4;
        this.currentDBImage.finDimId5 = this.finDimId5;
        this.currentDBImage.suspenseAccount = this.suspenseAccount;
        this.currentDBImage.suspenseType = this.suspenseType;
        this.currentDBImage.transactionValue = this.transactionValue;
        this.currentDBImage.unAllocatedValue = this.unAllocatedValue;
        this.currentDBImage.confirmed = this.confirmed;
        this.currentDBImage.systemItemNumber = this.systemItemNumber;
        this.currentDBImage.systemItemSequencenumber = this.systemItemSequencenumber;
        this.currentDBImage.invoiceDate = this.invoiceDate;
        this.currentDBImage.deletedTransactions = this.deletedTransactions;
        this.currentDBImage.description2 = this.description2;
        this.currentDBImage.iFTType = this.iFTType;
        this.currentDBImage.governmentCode = this.governmentCode;
        this.currentDBImage.bBVCategory = this.bBVCategory;
        this.currentDBImage.isNew = this.isNew;
        this.currentDBImage.creditId = this.creditId;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("IncomingFinancialTransaction is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            IncomingFinancialTransactionPK key = new IncomingFinancialTransactionPK();
            key.setCompanyId(this.getCompanyId());
            key.setId(this.getId());
            ((IncomingFinancialTransactionManager_Impl)IncomingFinancialTransactionManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((IncomingFinancialTransactionManager_Impl)IncomingFinancialTransactionManager_Impl.getInstance(this.dbd)).getResultSet((IncomingFinancialTransactionPK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("735507169_" + this.dbd.getDBId() + this.companyId + this.id).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public IncomingFinancialTransactionDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public IncomingFinancialTransactionDataBean getIncomingFinancialTransactionDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private IncomingFinancialTransactionDataBean getDataBean(IncomingFinancialTransactionDataBean bean) throws Exception {
        if (bean == null) {
            bean = new IncomingFinancialTransactionDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setId(this.getId());
        bean.setDescription(this.getDescription());
        bean.setBookYear(this.getBookYear());
        bean.setPeriod(this.getPeriod());
        bean.setBookDate(this.getBookDate());
        bean.setInternalInvoiceId(this.getInternalInvoiceId());
        bean.setVoucherId(this.getVoucherId());
        bean.setDocumentId(this.getDocumentId());
        bean.setDaybookId(this.getDaybookId());
        bean.setMainAccount(this.getMainAccount());
        bean.setFinDimId1(this.getFinDimId1());
        bean.setFinDimId2(this.getFinDimId2());
        bean.setFinDimId3(this.getFinDimId3());
        bean.setFinDimId4(this.getFinDimId4());
        bean.setFinDimId5(this.getFinDimId5());
        bean.setSuspenseAccount(this.getSuspenseAccount());
        bean.setSuspenseType(this.getSuspenseType());
        bean.setTransactionValue(this.getTransactionValue());
        bean.setUnAllocatedValue(this.getUnAllocatedValue());
        bean.setConfirmed(this.getConfirmed());
        bean.setSystemItemNumber(this.getSystemItemNumber());
        bean.setSystemItemSequencenumber(this.getSystemItemSequencenumber());
        bean.setInvoiceDate(this.getInvoiceDate());
        bean.setDeletedTransactions(this.getDeletedTransactions());
        bean.setDescription2(this.getDescription2());
        bean.setIFTType(this.getIFTType());
        bean.setGovernmentCode(this.getGovernmentCode());
        bean.setBBVCategory(this.getBBVCategory());
        bean.setIsNew(this.getIsNew());
        bean.setCreditId(this.getCreditId());
        return bean;
    }

    public boolean equals(Object object) {
        IncomingFinancialTransaction_Impl bo;
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                try {
                                    if (object != null && object instanceof IncomingFinancialTransaction_Impl) break block10;
                                    return false;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e.getMessage());
                                }
                            }
                            bo = (IncomingFinancialTransaction_Impl)object;
                            if (bo.getCompanyId() != null) break block11;
                            if (this.getCompanyId() != null) {
                                return false;
                            }
                            break block12;
                        }
                        if (bo.getCompanyId().equals(this.getCompanyId())) break block12;
                        return false;
                    }
                    if (bo.getId() != null) break block13;
                    if (this.getId() != null) {
                        return false;
                    }
                    break block14;
                }
                if (bo.getId().equals(this.getId())) break block14;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block15;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(IncomingFinancialTransactionDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(IncomingFinancialTransactionDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setId(bean.getId());
            this.setDescription(bean.getDescription());
            this.setBookYear(bean.getBookYear());
            this.setPeriod(bean.getPeriod());
            this.setBookDate(bean.getBookDate());
            this.setInternalInvoiceId(bean.getInternalInvoiceId());
            this.setVoucherId(bean.getVoucherId());
            this.setDocumentId(bean.getDocumentId());
            this.setDaybookId(bean.getDaybookId());
            this.setMainAccount(bean.getMainAccount());
            this.setFinDimId1(bean.getFinDimId1());
            this.setFinDimId2(bean.getFinDimId2());
            this.setFinDimId3(bean.getFinDimId3());
            this.setFinDimId4(bean.getFinDimId4());
            this.setFinDimId5(bean.getFinDimId5());
            this.setSuspenseAccount(bean.getSuspenseAccount());
            this.setSuspenseType(bean.getSuspenseType());
            this.setTransactionValue(bean.getTransactionValue());
            this.setUnAllocatedValue(bean.getUnAllocatedValue());
            this.setConfirmed(bean.getConfirmed());
            this.setSystemItemNumber(bean.getSystemItemNumber());
            this.setSystemItemSequencenumber(bean.getSystemItemSequencenumber());
            this.setInvoiceDate(bean.getInvoiceDate());
            this.setDeletedTransactions(bean.getDeletedTransactions());
            this.setDescription2(bean.getDescription2());
            this.setIFTType(bean.getIFTType());
            this.setGovernmentCode(bean.getGovernmentCode());
            this.setBBVCategory(bean.getBBVCategory());
            this.setIsNew(bean.getIsNew());
            this.setCreditId(bean.getCreditId());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "IncomingFinancialTransaction is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.IncomingFinancialTransaction.save");
        key.append(image.bookDate == null ? "0" : "1");
        key.append(image.invoiceDate == null ? "0" : "1");
        key.append(image.creditId == null ? "0" : "1");
        try {
            try {
                int n;
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("Id", provider) + " = ? " + ", " + pmd.getFieldName("Description", provider) + " = ? " + ", " + pmd.getFieldName("BookYear", provider) + " = ? " + ", " + pmd.getFieldName("Period", provider) + " = ? " + ", " + pmd.getFieldName("BookDate", provider) + " = ? " + ", " + pmd.getFieldName("InternalInvoiceId", provider) + " = ? " + ", " + pmd.getFieldName("VoucherId", provider) + " = ? " + ", " + pmd.getFieldName("DocumentId", provider) + " = ? " + ", " + pmd.getFieldName("DaybookId", provider) + " = ? " + ", " + pmd.getFieldName("MainAccount", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId1", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId2", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId3", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId4", provider) + " = ? " + ", " + pmd.getFieldName("FinDimId5", provider) + " = ? " + ", " + pmd.getFieldName("SuspenseAccount", provider) + " = ? " + ", " + pmd.getFieldName("SuspenseType", provider) + " = ? " + ", " + pmd.getFieldName("TransactionValue", provider) + " = ? " + ", " + pmd.getFieldName("UnAllocatedValue", provider) + " = ? " + ", " + pmd.getFieldName("confirmed", provider) + " = ? " + ", " + pmd.getFieldName("System item number", provider) + " = ? " + ", " + pmd.getFieldName("System item sequencenumber", provider) + " = ? " + ", " + pmd.getFieldName("InvoiceDate", provider) + " = ? " + ", " + pmd.getFieldName("DeletedTransactions", provider) + " = ? " + ", " + pmd.getFieldName("Description_2", provider) + " = ? " + ", " + pmd.getFieldName("IFTType", provider) + " = ? " + ", " + pmd.getFieldName("GovernmentCode", provider) + " = ? " + ", " + pmd.getFieldName("BBVCategory", provider) + " = ? " + ", " + pmd.getFieldName("IsNew", provider) + " = ? " + ", " + pmd.getFieldName("CreditId", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("Id", provider) + " = ? " + " AND  " + pmd.getFieldName("Description", provider) + " = ? " + " AND  " + pmd.getFieldName("BookYear", provider) + " = ? " + " AND  " + pmd.getFieldName("Period", provider) + " = ? " + " AND  " + pmd.getFieldName("BookDate", provider) + (image.bookDate == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("InternalInvoiceId", provider) + " = ? " + " AND  " + pmd.getFieldName("VoucherId", provider) + " = ? " + " AND  " + pmd.getFieldName("DocumentId", provider) + " = ? " + " AND  " + pmd.getFieldName("DaybookId", provider) + " = ? " + " AND  " + pmd.getFieldName("MainAccount", provider) + " = ? " + " AND  " + pmd.getFieldName("FinDimId1", provider) + " = ? " + " AND  " + pmd.getFieldName("FinDimId2", provider) + " = ? " + " AND  " + pmd.getFieldName("FinDimId3", provider) + " = ? " + " AND  " + pmd.getFieldName("FinDimId4", provider) + " = ? " + " AND  " + pmd.getFieldName("FinDimId5", provider) + " = ? " + " AND  " + pmd.getFieldName("SuspenseAccount", provider) + " = ? " + " AND  " + pmd.getFieldName("SuspenseType", provider) + " = ? " + " AND  " + pmd.getFieldName("TransactionValue", provider) + " = ? " + " AND  " + pmd.getFieldName("UnAllocatedValue", provider) + " = ? " + " AND  " + pmd.getFieldName("confirmed", provider) + " = ? " + " AND  " + pmd.getFieldName("System item number", provider) + " = ? " + " AND  " + pmd.getFieldName("System item sequencenumber", provider) + " = ? " + " AND  " + pmd.getFieldName("InvoiceDate", provider) + (image.invoiceDate == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("DeletedTransactions", provider) + " = ? " + " AND  " + pmd.getFieldName("Description_2", provider) + " = ? " + " AND  " + pmd.getFieldName("IFTType", provider) + " = ? " + " AND  " + pmd.getFieldName("GovernmentCode", provider) + " = ? " + " AND  " + pmd.getFieldName("BBVCategory", provider) + " = ? " + " AND  " + pmd.getFieldName("IsNew", provider) + " = ? " + " AND  " + pmd.getFieldName("CreditId", provider) + (image.creditId == null ? " IS NULL" : " = ?"));
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.id, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.bookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.period), mapping.getJDBCTypeFor("int"));
                if (this.bookDate == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.bookDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)new Long(this.internalInvoiceId), mapping.getJDBCTypeFor("long"));
                prep.setObject(parmIndex++, (Object)this.voucherId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.documentId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.daybookId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.mainAccount, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.finDimId1, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.finDimId2, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.finDimId3, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.finDimId4, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.finDimId5, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.suspenseAccount, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.suspenseType, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.transactionValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.unAllocatedValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Boolean(this.confirmed), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(this.systemItemNumber), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.systemItemSequencenumber), mapping.getJDBCTypeFor("int"));
                if (this.invoiceDate == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.invoiceDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)new Boolean(this.deletedTransactions), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)this.description2, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.iFTType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.governmentCode), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.bBVCategory), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.isNew), mapping.getJDBCTypeFor("boolean"));
                if (this.creditId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.creditId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.id, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.bookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.period), mapping.getJDBCTypeFor("int"));
                if (image.bookDate != null) {
                    prep.setObject(parmIndex++, (Object)image.bookDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)new Long(image.internalInvoiceId), mapping.getJDBCTypeFor("long"));
                prep.setObject(parmIndex++, (Object)image.voucherId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.documentId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.daybookId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.mainAccount, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.finDimId1, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.finDimId2, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.finDimId3, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.finDimId4, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.finDimId5, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.suspenseAccount, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.suspenseType, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.transactionValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.unAllocatedValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Boolean(image.confirmed), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(image.systemItemNumber), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.systemItemSequencenumber), mapping.getJDBCTypeFor("int"));
                if (image.invoiceDate != null) {
                    prep.setObject(parmIndex++, (Object)image.invoiceDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)new Boolean(image.deletedTransactions), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)image.description2, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.iFTType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.governmentCode), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.bBVCategory), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.isNew), mapping.getJDBCTypeFor("boolean"));
                if (image.creditId != null) {
                    prep.setObject(parmIndex++, (Object)image.creditId, mapping.getJDBCTypeFor("String"));
                }
                if ((n = prep.executeUpdate()) == 0) {
                    this.rollback(true);
                    throw new UpdateException("IncomingFinancialTransaction modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.IncomingFinancialTransaction.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.IncomingFinancialTransaction.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("Id", provider) + ", " + pmd.getFieldName("Description", provider) + ", " + pmd.getFieldName("BookYear", provider) + ", " + pmd.getFieldName("Period", provider) + ", " + pmd.getFieldName("BookDate", provider) + ", " + pmd.getFieldName("InternalInvoiceId", provider) + ", " + pmd.getFieldName("VoucherId", provider) + ", " + pmd.getFieldName("DocumentId", provider) + ", " + pmd.getFieldName("DaybookId", provider) + ", " + pmd.getFieldName("MainAccount", provider) + ", " + pmd.getFieldName("FinDimId1", provider) + ", " + pmd.getFieldName("FinDimId2", provider) + ", " + pmd.getFieldName("FinDimId3", provider) + ", " + pmd.getFieldName("FinDimId4", provider) + ", " + pmd.getFieldName("FinDimId5", provider) + ", " + pmd.getFieldName("SuspenseAccount", provider) + ", " + pmd.getFieldName("SuspenseType", provider) + ", " + pmd.getFieldName("TransactionValue", provider) + ", " + pmd.getFieldName("UnAllocatedValue", provider) + ", " + pmd.getFieldName("confirmed", provider) + ", " + pmd.getFieldName("System item number", provider) + ", " + pmd.getFieldName("System item sequencenumber", provider) + ", " + pmd.getFieldName("InvoiceDate", provider) + ", " + pmd.getFieldName("DeletedTransactions", provider) + ", " + pmd.getFieldName("Description_2", provider) + ", " + pmd.getFieldName("IFTType", provider) + ", " + pmd.getFieldName("GovernmentCode", provider) + ", " + pmd.getFieldName("BBVCategory", provider) + ", " + pmd.getFieldName("IsNew", provider) + ", " + pmd.getFieldName("CreditId", provider) + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)this.id, mapping.getJDBCTypeFor("String"));
                prep.setObject(3, (Object)this.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(4, (Object)new Integer(this.bookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(5, (Object)new Integer(this.period), mapping.getJDBCTypeFor("int"));
                if (this.bookDate == null) {
                    prep.setNull(6, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(6, (Object)this.bookDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(7, (Object)new Long(this.internalInvoiceId), mapping.getJDBCTypeFor("long"));
                prep.setObject(8, (Object)this.voucherId, mapping.getJDBCTypeFor("String"));
                prep.setObject(9, (Object)this.documentId, mapping.getJDBCTypeFor("String"));
                prep.setObject(10, (Object)this.daybookId, mapping.getJDBCTypeFor("String"));
                prep.setObject(11, (Object)this.mainAccount, mapping.getJDBCTypeFor("String"));
                prep.setObject(12, (Object)this.finDimId1, mapping.getJDBCTypeFor("String"));
                prep.setObject(13, (Object)this.finDimId2, mapping.getJDBCTypeFor("String"));
                prep.setObject(14, (Object)this.finDimId3, mapping.getJDBCTypeFor("String"));
                prep.setObject(15, (Object)this.finDimId4, mapping.getJDBCTypeFor("String"));
                prep.setObject(16, (Object)this.finDimId5, mapping.getJDBCTypeFor("String"));
                prep.setObject(17, (Object)this.suspenseAccount, mapping.getJDBCTypeFor("String"));
                prep.setObject(18, (Object)this.suspenseType, mapping.getJDBCTypeFor("String"));
                prep.setObject(19, (Object)this.transactionValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(20, (Object)this.unAllocatedValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(21, (Object)new Boolean(this.confirmed), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(22, (Object)new Integer(this.systemItemNumber), mapping.getJDBCTypeFor("int"));
                prep.setObject(23, (Object)new Integer(this.systemItemSequencenumber), mapping.getJDBCTypeFor("int"));
                if (this.invoiceDate == null) {
                    prep.setNull(24, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(24, (Object)this.invoiceDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(25, (Object)new Boolean(this.deletedTransactions), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(26, (Object)this.description2, mapping.getJDBCTypeFor("String"));
                prep.setObject(27, (Object)new Integer(this.iFTType), mapping.getJDBCTypeFor("int"));
                prep.setObject(28, (Object)new Integer(this.governmentCode), mapping.getJDBCTypeFor("int"));
                prep.setObject(29, (Object)new Integer(this.bBVCategory), mapping.getJDBCTypeFor("int"));
                prep.setObject(30, (Object)new Boolean(this.isNew), mapping.getJDBCTypeFor("boolean"));
                if (this.creditId == null) {
                    prep.setNull(31, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(31, (Object)this.creditId, mapping.getJDBCTypeFor("String"));
                }
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.id = this.currentDBImage.id;
            this.transactionImage.dbImage.description = this.currentDBImage.description;
            this.transactionImage.dbImage.bookYear = this.currentDBImage.bookYear;
            this.transactionImage.dbImage.period = this.currentDBImage.period;
            this.transactionImage.dbImage.bookDate = this.currentDBImage.bookDate;
            this.transactionImage.dbImage.internalInvoiceId = this.currentDBImage.internalInvoiceId;
            this.transactionImage.dbImage.voucherId = this.currentDBImage.voucherId;
            this.transactionImage.dbImage.documentId = this.currentDBImage.documentId;
            this.transactionImage.dbImage.daybookId = this.currentDBImage.daybookId;
            this.transactionImage.dbImage.mainAccount = this.currentDBImage.mainAccount;
            this.transactionImage.dbImage.finDimId1 = this.currentDBImage.finDimId1;
            this.transactionImage.dbImage.finDimId2 = this.currentDBImage.finDimId2;
            this.transactionImage.dbImage.finDimId3 = this.currentDBImage.finDimId3;
            this.transactionImage.dbImage.finDimId4 = this.currentDBImage.finDimId4;
            this.transactionImage.dbImage.finDimId5 = this.currentDBImage.finDimId5;
            this.transactionImage.dbImage.suspenseAccount = this.currentDBImage.suspenseAccount;
            this.transactionImage.dbImage.suspenseType = this.currentDBImage.suspenseType;
            this.transactionImage.dbImage.transactionValue = this.currentDBImage.transactionValue;
            this.transactionImage.dbImage.unAllocatedValue = this.currentDBImage.unAllocatedValue;
            this.transactionImage.dbImage.confirmed = this.currentDBImage.confirmed;
            this.transactionImage.dbImage.systemItemNumber = this.currentDBImage.systemItemNumber;
            this.transactionImage.dbImage.systemItemSequencenumber = this.currentDBImage.systemItemSequencenumber;
            this.transactionImage.dbImage.invoiceDate = this.currentDBImage.invoiceDate;
            this.transactionImage.dbImage.deletedTransactions = this.currentDBImage.deletedTransactions;
            this.transactionImage.dbImage.description2 = this.currentDBImage.description2;
            this.transactionImage.dbImage.iFTType = this.currentDBImage.iFTType;
            this.transactionImage.dbImage.governmentCode = this.currentDBImage.governmentCode;
            this.transactionImage.dbImage.bBVCategory = this.currentDBImage.bBVCategory;
            this.transactionImage.dbImage.isNew = this.currentDBImage.isNew;
            this.transactionImage.dbImage.creditId = this.currentDBImage.creditId;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.id = this.transactionImage.dbImage.id;
        this.currentDBImage.description = this.transactionImage.dbImage.description;
        this.currentDBImage.bookYear = this.transactionImage.dbImage.bookYear;
        this.currentDBImage.period = this.transactionImage.dbImage.period;
        this.currentDBImage.bookDate = this.transactionImage.dbImage.bookDate;
        this.currentDBImage.internalInvoiceId = this.transactionImage.dbImage.internalInvoiceId;
        this.currentDBImage.voucherId = this.transactionImage.dbImage.voucherId;
        this.currentDBImage.documentId = this.transactionImage.dbImage.documentId;
        this.currentDBImage.daybookId = this.transactionImage.dbImage.daybookId;
        this.currentDBImage.mainAccount = this.transactionImage.dbImage.mainAccount;
        this.currentDBImage.finDimId1 = this.transactionImage.dbImage.finDimId1;
        this.currentDBImage.finDimId2 = this.transactionImage.dbImage.finDimId2;
        this.currentDBImage.finDimId3 = this.transactionImage.dbImage.finDimId3;
        this.currentDBImage.finDimId4 = this.transactionImage.dbImage.finDimId4;
        this.currentDBImage.finDimId5 = this.transactionImage.dbImage.finDimId5;
        this.currentDBImage.suspenseAccount = this.transactionImage.dbImage.suspenseAccount;
        this.currentDBImage.suspenseType = this.transactionImage.dbImage.suspenseType;
        this.currentDBImage.transactionValue = this.transactionImage.dbImage.transactionValue;
        this.currentDBImage.unAllocatedValue = this.transactionImage.dbImage.unAllocatedValue;
        this.currentDBImage.confirmed = this.transactionImage.dbImage.confirmed;
        this.currentDBImage.systemItemNumber = this.transactionImage.dbImage.systemItemNumber;
        this.currentDBImage.systemItemSequencenumber = this.transactionImage.dbImage.systemItemSequencenumber;
        this.currentDBImage.invoiceDate = this.transactionImage.dbImage.invoiceDate;
        this.currentDBImage.deletedTransactions = this.transactionImage.dbImage.deletedTransactions;
        this.currentDBImage.description2 = this.transactionImage.dbImage.description2;
        this.currentDBImage.iFTType = this.transactionImage.dbImage.iFTType;
        this.currentDBImage.governmentCode = this.transactionImage.dbImage.governmentCode;
        this.currentDBImage.bBVCategory = this.transactionImage.dbImage.bBVCategory;
        this.currentDBImage.isNew = this.transactionImage.dbImage.isNew;
        this.currentDBImage.creditId = this.transactionImage.dbImage.creditId;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.id = this.transactionImage.dbImage.id;
            this.description = this.transactionImage.dbImage.description;
            this.bookYear = this.transactionImage.dbImage.bookYear;
            this.period = this.transactionImage.dbImage.period;
            this.bookDate = this.transactionImage.dbImage.bookDate;
            this.internalInvoiceId = this.transactionImage.dbImage.internalInvoiceId;
            this.voucherId = this.transactionImage.dbImage.voucherId;
            this.documentId = this.transactionImage.dbImage.documentId;
            this.daybookId = this.transactionImage.dbImage.daybookId;
            this.mainAccount = this.transactionImage.dbImage.mainAccount;
            this.finDimId1 = this.transactionImage.dbImage.finDimId1;
            this.finDimId2 = this.transactionImage.dbImage.finDimId2;
            this.finDimId3 = this.transactionImage.dbImage.finDimId3;
            this.finDimId4 = this.transactionImage.dbImage.finDimId4;
            this.finDimId5 = this.transactionImage.dbImage.finDimId5;
            this.suspenseAccount = this.transactionImage.dbImage.suspenseAccount;
            this.suspenseType = this.transactionImage.dbImage.suspenseType;
            this.transactionValue = this.transactionImage.dbImage.transactionValue;
            this.unAllocatedValue = this.transactionImage.dbImage.unAllocatedValue;
            this.confirmed = this.transactionImage.dbImage.confirmed;
            this.systemItemNumber = this.transactionImage.dbImage.systemItemNumber;
            this.systemItemSequencenumber = this.transactionImage.dbImage.systemItemSequencenumber;
            this.invoiceDate = this.transactionImage.dbImage.invoiceDate;
            this.deletedTransactions = this.transactionImage.dbImage.deletedTransactions;
            this.description2 = this.transactionImage.dbImage.description2;
            this.iFTType = this.transactionImage.dbImage.iFTType;
            this.governmentCode = this.transactionImage.dbImage.governmentCode;
            this.bBVCategory = this.transactionImage.dbImage.bBVCategory;
            this.isNew = this.transactionImage.dbImage.isNew;
            this.creditId = this.transactionImage.dbImage.creditId;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private String id;
        private String description;
        private int bookYear;
        private int period;
        private Date bookDate;
        private long internalInvoiceId;
        private String voucherId;
        private String documentId;
        private String daybookId;
        private String mainAccount;
        private String finDimId1;
        private String finDimId2;
        private String finDimId3;
        private String finDimId4;
        private String finDimId5;
        private String suspenseAccount;
        private String suspenseType;
        private BigDecimal transactionValue;
        private BigDecimal unAllocatedValue;
        private boolean confirmed;
        private int systemItemNumber;
        private int systemItemSequencenumber;
        private Date invoiceDate;
        private boolean deletedTransactions;
        private String description2;
        private int iFTType;
        private int governmentCode;
        private int bBVCategory;
        private boolean isNew;
        private String creditId;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

