/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Memo;
import nl.ibs.fac.db.MemoDataBean;
import nl.ibs.fac.db.MemoPK;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.MemoManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataMemo;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;

public class Memo_Impl
implements Memo,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataMemo.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected String cora;
    protected String assetId;
    protected int transactionNumber;
    protected String memo;

    protected Memo_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected Memo_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected Memo_Impl(DBData _dbd, String _companyId, String _cora, String _assetId, int _transactionNumber) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setCora(_cora);
            this.setAssetId(_assetId);
            this.setTransactionNumber(_transactionNumber);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected Memo_Impl(DBData _dbd, MemoDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.MemoDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate Memo with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.MemoDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setCora(bean.getCora());
            this.setAssetId(bean.getAssetId());
            this.setTransactionNumber(bean.getTransactionNumber());
            this.setMemo(bean.getMemo());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public Memo_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.cora = rs.getString(pmd.getFieldName("Cora", provider));
        this.assetId = rs.getString(pmd.getFieldName("AssetId", provider));
        this.transactionNumber = rs.getInt(pmd.getFieldName("TransactionNumber", provider));
        this.memo = rs.getString(pmd.getFieldName("Memo", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        MemoPK key = new MemoPK();
        key.setCompanyId(this.getCompanyId());
        key.setCora(this.getCora());
        key.setAssetId(this.getAssetId());
        key.setTransactionNumber(this.getTransactionNumber());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public String getCora() throws Exception {
        this.assureStorage();
        return this.cora;
    }

    @Override
    public String getAssetId() throws Exception {
        this.assureStorage();
        return this.assetId;
    }

    @Override
    public int getTransactionNumber() throws Exception {
        this.assureStorage();
        return this.transactionNumber;
    }

    @Override
    public String getMemo() throws Exception {
        return this.memo;
    }

    @Override
    public Company getOwnedByCompanyAsMemos() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsMemos")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsMemos");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsMemos", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Company owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsMemos();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setCora(String _cora) throws Exception {
        if (_cora == null) {
            _cora = "";
        }
        if (_cora.equals(this.getCora())) {
            return;
        }
        this.preSet();
        this.cora = _cora;
        this.autoUpdate();
    }

    public void setAssetId(String _assetId) throws Exception {
        if (_assetId == null) {
            _assetId = "";
        }
        if (_assetId.equals(this.getAssetId())) {
            return;
        }
        this.preSet();
        this.assetId = _assetId;
        this.autoUpdate();
    }

    public void setTransactionNumber(int _transactionNumber) throws Exception {
        if (_transactionNumber == this.getTransactionNumber()) {
            return;
        }
        this.preSet();
        this.transactionNumber = _transactionNumber;
        this.autoUpdate();
    }

    @Override
    public void setMemo(String _memo) throws Exception {
        if (_memo == null) {
            _memo = "";
        }
        if (_memo.equals(this.getMemo())) {
            return;
        }
        this.preSet();
        this.memo = _memo;
        this.autoUpdate();
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.cora = "";
        this.assetId = "";
        this.transactionNumber = 0;
        this.memo = "";
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.cora = this.cora;
        this.currentDBImage.assetId = this.assetId;
        this.currentDBImage.transactionNumber = this.transactionNumber;
        this.currentDBImage.memo = this.memo;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("Memo is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            MemoPK key = new MemoPK();
            key.setCompanyId(this.getCompanyId());
            key.setCora(this.getCora());
            key.setAssetId(this.getAssetId());
            key.setTransactionNumber(this.getTransactionNumber());
            ((MemoManager_Impl)MemoManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((MemoManager_Impl)MemoManager_Impl.getInstance(this.dbd)).getResultSet((MemoPK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("385023552_" + this.dbd.getDBId() + this.companyId + this.cora + this.assetId + this.transactionNumber).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public MemoDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public MemoDataBean getMemoDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private MemoDataBean getDataBean(MemoDataBean bean) throws Exception {
        if (bean == null) {
            bean = new MemoDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setCora(this.getCora());
        bean.setAssetId(this.getAssetId());
        bean.setTransactionNumber(this.getTransactionNumber());
        bean.setMemo(this.getMemo());
        return bean;
    }

    public boolean equals(Object object) {
        Memo_Impl bo;
        block22: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            try {
                                                if (object != null && object instanceof Memo_Impl) break block14;
                                                return false;
                                            }
                                            catch (Exception e) {
                                                throw new RuntimeException(e.getMessage());
                                            }
                                        }
                                        bo = (Memo_Impl)object;
                                        if (bo.getCompanyId() != null) break block15;
                                        if (this.getCompanyId() != null) {
                                            return false;
                                        }
                                        break block16;
                                    }
                                    if (bo.getCompanyId().equals(this.getCompanyId())) break block16;
                                    return false;
                                }
                                if (bo.getCora() != null) break block17;
                                if (this.getCora() != null) {
                                    return false;
                                }
                                break block18;
                            }
                            if (bo.getCora().equals(this.getCora())) break block18;
                            return false;
                        }
                        if (bo.getAssetId() != null) break block19;
                        if (this.getAssetId() != null) {
                            return false;
                        }
                        break block20;
                    }
                    if (bo.getAssetId().equals(this.getAssetId())) break block20;
                    return false;
                }
                if (bo.getTransactionNumber() == this.getTransactionNumber()) break block21;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block22;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(MemoDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(MemoDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setCora(bean.getCora());
            this.setAssetId(bean.getAssetId());
            this.setTransactionNumber(bean.getTransactionNumber());
            this.setMemo(bean.getMemo());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "Memo is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.Memo.save");
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("Cora", provider) + " = ? " + ", " + pmd.getFieldName("AssetId", provider) + " = ? " + ", " + pmd.getFieldName("TransactionNumber", provider) + " = ? " + ", " + pmd.getFieldName("Memo", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("Cora", provider) + " = ? " + " AND  " + pmd.getFieldName("AssetId", provider) + " = ? " + " AND  " + pmd.getFieldName("TransactionNumber", provider) + " = ? " + " AND  " + pmd.getFieldName("Memo", provider) + " = ? ");
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.cora, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.assetId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.transactionNumber), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.memo, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.cora, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.assetId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.transactionNumber), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.memo, mapping.getJDBCTypeFor("String"));
                int n = prep.executeUpdate();
                if (n == 0) {
                    this.rollback(true);
                    throw new UpdateException("Memo modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.Memo.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.Memo.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("Cora", provider) + ", " + pmd.getFieldName("AssetId", provider) + ", " + pmd.getFieldName("TransactionNumber", provider) + ", " + pmd.getFieldName("Memo", provider) + ") VALUES (?,?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)this.cora, mapping.getJDBCTypeFor("String"));
                prep.setObject(3, (Object)this.assetId, mapping.getJDBCTypeFor("String"));
                prep.setObject(4, (Object)new Integer(this.transactionNumber), mapping.getJDBCTypeFor("int"));
                prep.setObject(5, (Object)this.memo, mapping.getJDBCTypeFor("String"));
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.cora = this.currentDBImage.cora;
            this.transactionImage.dbImage.assetId = this.currentDBImage.assetId;
            this.transactionImage.dbImage.transactionNumber = this.currentDBImage.transactionNumber;
            this.transactionImage.dbImage.memo = this.currentDBImage.memo;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.cora = this.transactionImage.dbImage.cora;
        this.currentDBImage.assetId = this.transactionImage.dbImage.assetId;
        this.currentDBImage.transactionNumber = this.transactionImage.dbImage.transactionNumber;
        this.currentDBImage.memo = this.transactionImage.dbImage.memo;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.cora = this.transactionImage.dbImage.cora;
            this.assetId = this.transactionImage.dbImage.assetId;
            this.transactionNumber = this.transactionImage.dbImage.transactionNumber;
            this.memo = this.transactionImage.dbImage.memo;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private String cora;
        private String assetId;
        private int transactionNumber;
        private String memo;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

