/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.fac.db.MenuOption;
import nl.ibs.fac.db.MenuOptionDataBean;
import nl.ibs.fac.db.MenuOptionPK;
import nl.ibs.fac.db.UserGroup;
import nl.ibs.fac.db.impl.MenuOptionManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataMenuOption;
import nl.ibs.fac.db.impl.UserGroupManager_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;

public class MenuOption_Impl
implements MenuOption,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataMenuOption.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String userGroupId;
    protected String menuOption;

    protected MenuOption_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected MenuOption_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected MenuOption_Impl(DBData _dbd, String _userGroupId, String _menuOption) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setUserGroupId(_userGroupId);
            this.setMenuOption(_menuOption);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected MenuOption_Impl(DBData _dbd, MenuOptionDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.MenuOptionDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate MenuOption with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.MenuOptionDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setUserGroupId(bean.getUserGroupId());
            this.setMenuOption(bean.getMenuOption());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public MenuOption_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.userGroupId = rs.getString(pmd.getFieldName("UserGroupId", provider));
        this.menuOption = rs.getString(pmd.getFieldName("MenuOption", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        MenuOptionPK key = new MenuOptionPK();
        key.setUserGroupId(this.getUserGroupId());
        key.setMenuOption(this.getMenuOption());
        return key;
    }

    @Override
    public String getUserGroupId() throws Exception {
        this.assureStorage();
        return this.userGroupId;
    }

    @Override
    public String getMenuOption() throws Exception {
        this.assureStorage();
        return this.menuOption;
    }

    @Override
    public UserGroup getOwnedByUserGroupAsMenuOptions() throws Exception {
        if (this.isCachedRelation("ownedByUserGroupAsMenuOptions")) {
            return (UserGroup)this.getCachedRelationObject("ownedByUserGroupAsMenuOptions");
        }
        if (this.getUserGroupId() == null) {
            return null;
        }
        try {
            return (UserGroup)this.addCachedRelationObject("ownedByUserGroupAsMenuOptions", ((UserGroupManager_Impl)UserGroupManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getUserGroupId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        UserGroup owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByUserGroupAsMenuOptions();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setUserGroupId(String _userGroupId) throws Exception {
        if (_userGroupId == null) {
            _userGroupId = "";
        }
        if (_userGroupId.equals(this.getUserGroupId())) {
            return;
        }
        this.preSet();
        this.userGroupId = _userGroupId;
        this.autoUpdate();
    }

    public void setMenuOption(String _menuOption) throws Exception {
        if (_menuOption == null) {
            _menuOption = "";
        }
        if (_menuOption.equals(this.getMenuOption())) {
            return;
        }
        this.preSet();
        this.menuOption = _menuOption;
        this.autoUpdate();
    }

    private void initializeTheImplementationClass() throws Exception {
        this.userGroupId = "";
        this.menuOption = "";
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.userGroupId = this.userGroupId;
        this.currentDBImage.menuOption = this.menuOption;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("MenuOption is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            MenuOptionPK key = new MenuOptionPK();
            key.setUserGroupId(this.getUserGroupId());
            key.setMenuOption(this.getMenuOption());
            ((MenuOptionManager_Impl)MenuOptionManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((MenuOptionManager_Impl)MenuOptionManager_Impl.getInstance(this.dbd)).getResultSet((MenuOptionPK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("1950438202_" + this.dbd.getDBId() + this.userGroupId + this.menuOption).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public MenuOptionDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public MenuOptionDataBean getMenuOptionDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private MenuOptionDataBean getDataBean(MenuOptionDataBean bean) throws Exception {
        if (bean == null) {
            bean = new MenuOptionDataBean();
        }
        bean.setUserGroupId(this.getUserGroupId());
        bean.setMenuOption(this.getMenuOption());
        return bean;
    }

    public boolean equals(Object object) {
        MenuOption_Impl bo;
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                try {
                                    if (object != null && object instanceof MenuOption_Impl) break block10;
                                    return false;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e.getMessage());
                                }
                            }
                            bo = (MenuOption_Impl)object;
                            if (bo.getUserGroupId() != null) break block11;
                            if (this.getUserGroupId() != null) {
                                return false;
                            }
                            break block12;
                        }
                        if (bo.getUserGroupId().equals(this.getUserGroupId())) break block12;
                        return false;
                    }
                    if (bo.getMenuOption() != null) break block13;
                    if (this.getMenuOption() != null) {
                        return false;
                    }
                    break block14;
                }
                if (bo.getMenuOption().equals(this.getMenuOption())) break block14;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block15;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(MenuOptionDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(MenuOptionDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setUserGroupId(bean.getUserGroupId());
            this.setMenuOption(bean.getMenuOption());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "MenuOption is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.MenuOption.save");
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("UserGroupId", provider) + " = ? " + ", " + pmd.getFieldName("MenuOption", provider) + " = ? " + " WHERE " + pmd.getFieldName("UserGroupId", provider) + " = ? " + " AND  " + pmd.getFieldName("MenuOption", provider) + " = ? ");
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.userGroupId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.menuOption, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.userGroupId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.menuOption, mapping.getJDBCTypeFor("String"));
                int n = prep.executeUpdate();
                if (n == 0) {
                    this.rollback(true);
                    throw new UpdateException("MenuOption modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.MenuOption.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.MenuOption.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("UserGroupId", provider) + ", " + pmd.getFieldName("MenuOption", provider) + ") VALUES (?,?)");
                }
                prep.setObject(1, (Object)this.userGroupId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)this.menuOption, mapping.getJDBCTypeFor("String"));
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.userGroupId = this.currentDBImage.userGroupId;
            this.transactionImage.dbImage.menuOption = this.currentDBImage.menuOption;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.userGroupId = this.transactionImage.dbImage.userGroupId;
        this.currentDBImage.menuOption = this.transactionImage.dbImage.menuOption;
        if (includeBOFields) {
            this.userGroupId = this.transactionImage.dbImage.userGroupId;
            this.menuOption = this.transactionImage.dbImage.menuOption;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String userGroupId;
        private String menuOption;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

