/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.ProcessParametersDataBean;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataProcessParameters;
import nl.ibs.fac.db.impl.ProcessParametersManager_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;

public class ProcessParameters_Impl
implements ProcessParameters,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataProcessParameters.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected boolean defaultValueInBookPeriod;
    protected boolean journalizeCurrentAssets;
    protected boolean autoUpdateBlockedPeriods;
    protected boolean useCorrectionCodeDC;
    protected int standardVoucherDate;
    protected boolean warningForDifferentType;
    protected boolean warningForDifferentDimensions;
    protected boolean autoConfirmIFT;
    protected int voucherDateIFTT;
    protected boolean summarizeOnKey;
    protected int voucherDateDIR;
    protected int startMonth;
    protected int calendarYearCorrection;
    protected boolean fullInterestIn1stPeriod;
    protected boolean useDifferentAcquisitionValues;
    protected boolean assetIdInDescription;
    protected boolean useRCTableForMOVIC;
    protected boolean use445Correction;
    protected boolean balanceAccountsOnIndividualLevel;
    protected boolean gLBookValueRegistration;
    protected boolean isTestCompany;
    protected boolean depreciateBeyondEconomicLife;
    protected boolean assetDescriptionInDescription;

    protected ProcessParameters_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected ProcessParameters_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected ProcessParameters_Impl(DBData _dbd, String _companyId) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected ProcessParameters_Impl(DBData _dbd, ProcessParametersDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.ProcessParametersDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate ProcessParameters with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.ProcessParametersDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setDefaultValueInBookPeriod(bean.getDefaultValueInBookPeriod());
            this.setJournalizeCurrentAssets(bean.getJournalizeCurrentAssets());
            this.setAutoUpdateBlockedPeriods(bean.getAutoUpdateBlockedPeriods());
            this.setUseCorrectionCodeDC(bean.getUseCorrectionCodeDC());
            this.setStandardVoucherDate(bean.getStandardVoucherDate());
            this.setWarningForDifferentType(bean.getWarningForDifferentType());
            this.setWarningForDifferentDimensions(bean.getWarningForDifferentDimensions());
            this.setAutoConfirmIFT(bean.getAutoConfirmIFT());
            this.setVoucherDateIFTT(bean.getVoucherDateIFTT());
            this.setSummarizeOnKey(bean.getSummarizeOnKey());
            this.setVoucherDateDIR(bean.getVoucherDateDIR());
            this.setStartMonth(bean.getStartMonth());
            this.setCalendarYearCorrection(bean.getCalendarYearCorrection());
            this.setFullInterestIn1stPeriod(bean.getFullInterestIn1stPeriod());
            this.setUseDifferentAcquisitionValues(bean.getUseDifferentAcquisitionValues());
            this.setAssetIdInDescription(bean.getAssetIdInDescription());
            this.setUseRCTableForMOVIC(bean.getUseRCTableForMOVIC());
            this.setUse445Correction(bean.getUse445Correction());
            this.setBalanceAccountsOnIndividualLevel(bean.getBalanceAccountsOnIndividualLevel());
            this.setGLBookValueRegistration(bean.getGLBookValueRegistration());
            this.setIsTestCompany(bean.getIsTestCompany());
            this.setDepreciateBeyondEconomicLife(bean.getDepreciateBeyondEconomicLife());
            this.setAssetDescriptionInDescription(bean.getAssetDescriptionInDescription());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public ProcessParameters_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.defaultValueInBookPeriod = rs.getBoolean(pmd.getFieldName("DefaultValueInBookPeriod", provider));
        this.journalizeCurrentAssets = rs.getBoolean(pmd.getFieldName("JournalizeCurrentAssets", provider));
        this.autoUpdateBlockedPeriods = rs.getBoolean(pmd.getFieldName("AutoUpdateBlockedPeriods", provider));
        this.useCorrectionCodeDC = rs.getBoolean(pmd.getFieldName("UseCorrectionCodeDC", provider));
        this.standardVoucherDate = rs.getInt(pmd.getFieldName("StandardVoucherDate", provider));
        this.warningForDifferentType = rs.getBoolean(pmd.getFieldName("WarningForDifferentType", provider));
        this.warningForDifferentDimensions = rs.getBoolean(pmd.getFieldName("WarningForDifferentDimensions", provider));
        this.autoConfirmIFT = rs.getBoolean(pmd.getFieldName("AutoConfirmIFT", provider));
        this.voucherDateIFTT = rs.getInt(pmd.getFieldName("VoucherDateIFTT", provider));
        this.summarizeOnKey = rs.getBoolean(pmd.getFieldName("SummarizeOnKey", provider));
        this.voucherDateDIR = rs.getInt(pmd.getFieldName("VoucherDateDIR", provider));
        this.startMonth = rs.getInt(pmd.getFieldName("StartMonth", provider));
        this.calendarYearCorrection = rs.getInt(pmd.getFieldName("CalendarYearCorrection", provider));
        this.fullInterestIn1stPeriod = rs.getBoolean(pmd.getFieldName("FullInterestIn1stPeriod", provider));
        this.useDifferentAcquisitionValues = rs.getBoolean(pmd.getFieldName("UseDifferentAcquisitionValues", provider));
        this.assetIdInDescription = rs.getBoolean(pmd.getFieldName("AssetIdInDescription", provider));
        this.useRCTableForMOVIC = rs.getBoolean(pmd.getFieldName("UseRCTableForMOV_IC", provider));
        this.use445Correction = rs.getBoolean(pmd.getFieldName("Use445Correction", provider));
        this.balanceAccountsOnIndividualLevel = rs.getBoolean(pmd.getFieldName("BalanceAccountsOnIndividualLevel", provider));
        this.gLBookValueRegistration = rs.getBoolean(pmd.getFieldName("GLBookValueRegistration", provider));
        this.isTestCompany = rs.getBoolean(pmd.getFieldName("IsTestCompany", provider));
        this.depreciateBeyondEconomicLife = rs.getBoolean(pmd.getFieldName("DepreciateBeyondEconomicLife", provider));
        this.assetDescriptionInDescription = rs.getBoolean(pmd.getFieldName("AssetDescriptionInDescription", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        return this.getCompanyId();
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public boolean getDefaultValueInBookPeriod() throws Exception {
        return this.defaultValueInBookPeriod;
    }

    @Override
    public boolean getJournalizeCurrentAssets() throws Exception {
        return this.journalizeCurrentAssets;
    }

    @Override
    public boolean getAutoUpdateBlockedPeriods() throws Exception {
        return this.autoUpdateBlockedPeriods;
    }

    @Override
    public boolean getUseCorrectionCodeDC() throws Exception {
        return this.useCorrectionCodeDC;
    }

    @Override
    public int getStandardVoucherDate() throws Exception {
        return this.standardVoucherDate;
    }

    @Override
    public boolean getWarningForDifferentType() throws Exception {
        return this.warningForDifferentType;
    }

    @Override
    public boolean getWarningForDifferentDimensions() throws Exception {
        return this.warningForDifferentDimensions;
    }

    @Override
    public boolean getAutoConfirmIFT() throws Exception {
        return this.autoConfirmIFT;
    }

    @Override
    public int getVoucherDateIFTT() throws Exception {
        return this.voucherDateIFTT;
    }

    @Override
    public boolean getSummarizeOnKey() throws Exception {
        return this.summarizeOnKey;
    }

    @Override
    public int getVoucherDateDIR() throws Exception {
        return this.voucherDateDIR;
    }

    @Override
    public int getStartMonth() throws Exception {
        return this.startMonth;
    }

    @Override
    public int getCalendarYearCorrection() throws Exception {
        return this.calendarYearCorrection;
    }

    @Override
    public boolean getFullInterestIn1stPeriod() throws Exception {
        return this.fullInterestIn1stPeriod;
    }

    @Override
    public boolean getUseDifferentAcquisitionValues() throws Exception {
        return this.useDifferentAcquisitionValues;
    }

    @Override
    public boolean getAssetIdInDescription() throws Exception {
        return this.assetIdInDescription;
    }

    @Override
    public boolean getUseRCTableForMOVIC() throws Exception {
        return this.useRCTableForMOVIC;
    }

    @Override
    public boolean getUse445Correction() throws Exception {
        return this.use445Correction;
    }

    @Override
    public boolean getBalanceAccountsOnIndividualLevel() throws Exception {
        return this.balanceAccountsOnIndividualLevel;
    }

    @Override
    public boolean getGLBookValueRegistration() throws Exception {
        return this.gLBookValueRegistration;
    }

    @Override
    public boolean getIsTestCompany() throws Exception {
        return this.isTestCompany;
    }

    @Override
    public boolean getDepreciateBeyondEconomicLife() throws Exception {
        return this.depreciateBeyondEconomicLife;
    }

    @Override
    public boolean getAssetDescriptionInDescription() throws Exception {
        return this.assetDescriptionInDescription;
    }

    @Override
    public Company getOwnedByCompanyAsProcessParameters() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsProcessParameters")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsProcessParameters");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsProcessParameters", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Company owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsProcessParameters();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    @Override
    public void setDefaultValueInBookPeriod(boolean _defaultValueInBookPeriod) throws Exception {
        if (_defaultValueInBookPeriod == this.getDefaultValueInBookPeriod()) {
            return;
        }
        this.preSet();
        this.defaultValueInBookPeriod = _defaultValueInBookPeriod;
        this.autoUpdate();
    }

    @Override
    public void setJournalizeCurrentAssets(boolean _journalizeCurrentAssets) throws Exception {
        if (_journalizeCurrentAssets == this.getJournalizeCurrentAssets()) {
            return;
        }
        this.preSet();
        this.journalizeCurrentAssets = _journalizeCurrentAssets;
        this.autoUpdate();
    }

    @Override
    public void setAutoUpdateBlockedPeriods(boolean _autoUpdateBlockedPeriods) throws Exception {
        if (_autoUpdateBlockedPeriods == this.getAutoUpdateBlockedPeriods()) {
            return;
        }
        this.preSet();
        this.autoUpdateBlockedPeriods = _autoUpdateBlockedPeriods;
        this.autoUpdate();
    }

    @Override
    public void setUseCorrectionCodeDC(boolean _useCorrectionCodeDC) throws Exception {
        if (_useCorrectionCodeDC == this.getUseCorrectionCodeDC()) {
            return;
        }
        this.preSet();
        this.useCorrectionCodeDC = _useCorrectionCodeDC;
        this.autoUpdate();
    }

    @Override
    public void setStandardVoucherDate(int _standardVoucherDate) throws Exception {
        if (_standardVoucherDate == this.getStandardVoucherDate()) {
            return;
        }
        this.preSet();
        this.standardVoucherDate = _standardVoucherDate;
        this.autoUpdate();
    }

    @Override
    public void setWarningForDifferentType(boolean _warningForDifferentType) throws Exception {
        if (_warningForDifferentType == this.getWarningForDifferentType()) {
            return;
        }
        this.preSet();
        this.warningForDifferentType = _warningForDifferentType;
        this.autoUpdate();
    }

    @Override
    public void setWarningForDifferentDimensions(boolean _warningForDifferentDimensions) throws Exception {
        if (_warningForDifferentDimensions == this.getWarningForDifferentDimensions()) {
            return;
        }
        this.preSet();
        this.warningForDifferentDimensions = _warningForDifferentDimensions;
        this.autoUpdate();
    }

    @Override
    public void setAutoConfirmIFT(boolean _autoConfirmIFT) throws Exception {
        if (_autoConfirmIFT == this.getAutoConfirmIFT()) {
            return;
        }
        this.preSet();
        this.autoConfirmIFT = _autoConfirmIFT;
        this.autoUpdate();
    }

    @Override
    public void setVoucherDateIFTT(int _voucherDateIFTT) throws Exception {
        if (_voucherDateIFTT == this.getVoucherDateIFTT()) {
            return;
        }
        this.preSet();
        this.voucherDateIFTT = _voucherDateIFTT;
        this.autoUpdate();
    }

    @Override
    public void setSummarizeOnKey(boolean _summarizeOnKey) throws Exception {
        if (_summarizeOnKey == this.getSummarizeOnKey()) {
            return;
        }
        this.preSet();
        this.summarizeOnKey = _summarizeOnKey;
        this.autoUpdate();
    }

    @Override
    public void setVoucherDateDIR(int _voucherDateDIR) throws Exception {
        if (_voucherDateDIR == this.getVoucherDateDIR()) {
            return;
        }
        this.preSet();
        this.voucherDateDIR = _voucherDateDIR;
        this.autoUpdate();
    }

    @Override
    public void setStartMonth(int _startMonth) throws Exception {
        if (_startMonth == this.getStartMonth()) {
            return;
        }
        this.preSet();
        this.startMonth = _startMonth;
        this.autoUpdate();
    }

    @Override
    public void setCalendarYearCorrection(int _calendarYearCorrection) throws Exception {
        if (_calendarYearCorrection == this.getCalendarYearCorrection()) {
            return;
        }
        this.preSet();
        this.calendarYearCorrection = _calendarYearCorrection;
        this.autoUpdate();
    }

    @Override
    public void setFullInterestIn1stPeriod(boolean _fullInterestIn1stPeriod) throws Exception {
        if (_fullInterestIn1stPeriod == this.getFullInterestIn1stPeriod()) {
            return;
        }
        this.preSet();
        this.fullInterestIn1stPeriod = _fullInterestIn1stPeriod;
        this.autoUpdate();
    }

    @Override
    public void setUseDifferentAcquisitionValues(boolean _useDifferentAcquisitionValues) throws Exception {
        if (_useDifferentAcquisitionValues == this.getUseDifferentAcquisitionValues()) {
            return;
        }
        this.preSet();
        this.useDifferentAcquisitionValues = _useDifferentAcquisitionValues;
        this.autoUpdate();
    }

    @Override
    public void setAssetIdInDescription(boolean _assetIdInDescription) throws Exception {
        if (_assetIdInDescription == this.getAssetIdInDescription()) {
            return;
        }
        this.preSet();
        this.assetIdInDescription = _assetIdInDescription;
        this.autoUpdate();
    }

    @Override
    public void setUseRCTableForMOVIC(boolean _useRCTableForMOVIC) throws Exception {
        if (_useRCTableForMOVIC == this.getUseRCTableForMOVIC()) {
            return;
        }
        this.preSet();
        this.useRCTableForMOVIC = _useRCTableForMOVIC;
        this.autoUpdate();
    }

    @Override
    public void setUse445Correction(boolean _use445Correction) throws Exception {
        if (_use445Correction == this.getUse445Correction()) {
            return;
        }
        this.preSet();
        this.use445Correction = _use445Correction;
        this.autoUpdate();
    }

    @Override
    public void setBalanceAccountsOnIndividualLevel(boolean _balanceAccountsOnIndividualLevel) throws Exception {
        if (_balanceAccountsOnIndividualLevel == this.getBalanceAccountsOnIndividualLevel()) {
            return;
        }
        this.preSet();
        this.balanceAccountsOnIndividualLevel = _balanceAccountsOnIndividualLevel;
        this.autoUpdate();
    }

    @Override
    public void setGLBookValueRegistration(boolean _gLBookValueRegistration) throws Exception {
        if (_gLBookValueRegistration == this.getGLBookValueRegistration()) {
            return;
        }
        this.preSet();
        this.gLBookValueRegistration = _gLBookValueRegistration;
        this.autoUpdate();
    }

    @Override
    public void setIsTestCompany(boolean _isTestCompany) throws Exception {
        if (_isTestCompany == this.getIsTestCompany()) {
            return;
        }
        this.preSet();
        this.isTestCompany = _isTestCompany;
        this.autoUpdate();
    }

    @Override
    public void setDepreciateBeyondEconomicLife(boolean _depreciateBeyondEconomicLife) throws Exception {
        if (_depreciateBeyondEconomicLife == this.getDepreciateBeyondEconomicLife()) {
            return;
        }
        this.preSet();
        this.depreciateBeyondEconomicLife = _depreciateBeyondEconomicLife;
        this.autoUpdate();
    }

    @Override
    public void setAssetDescriptionInDescription(boolean _assetDescriptionInDescription) throws Exception {
        if (_assetDescriptionInDescription == this.getAssetDescriptionInDescription()) {
            return;
        }
        this.preSet();
        this.assetDescriptionInDescription = _assetDescriptionInDescription;
        this.autoUpdate();
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.defaultValueInBookPeriod = false;
        this.journalizeCurrentAssets = false;
        this.autoUpdateBlockedPeriods = false;
        this.useCorrectionCodeDC = false;
        this.standardVoucherDate = 0;
        this.warningForDifferentType = false;
        this.warningForDifferentDimensions = false;
        this.autoConfirmIFT = false;
        this.voucherDateIFTT = 0;
        this.summarizeOnKey = false;
        this.voucherDateDIR = 0;
        this.startMonth = 0;
        this.calendarYearCorrection = 0;
        this.fullInterestIn1stPeriod = false;
        this.useDifferentAcquisitionValues = false;
        this.assetIdInDescription = false;
        this.useRCTableForMOVIC = false;
        this.use445Correction = false;
        this.balanceAccountsOnIndividualLevel = false;
        this.gLBookValueRegistration = false;
        this.isTestCompany = false;
        this.depreciateBeyondEconomicLife = false;
        this.assetDescriptionInDescription = false;
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.defaultValueInBookPeriod = this.defaultValueInBookPeriod;
        this.currentDBImage.journalizeCurrentAssets = this.journalizeCurrentAssets;
        this.currentDBImage.autoUpdateBlockedPeriods = this.autoUpdateBlockedPeriods;
        this.currentDBImage.useCorrectionCodeDC = this.useCorrectionCodeDC;
        this.currentDBImage.standardVoucherDate = this.standardVoucherDate;
        this.currentDBImage.warningForDifferentType = this.warningForDifferentType;
        this.currentDBImage.warningForDifferentDimensions = this.warningForDifferentDimensions;
        this.currentDBImage.autoConfirmIFT = this.autoConfirmIFT;
        this.currentDBImage.voucherDateIFTT = this.voucherDateIFTT;
        this.currentDBImage.summarizeOnKey = this.summarizeOnKey;
        this.currentDBImage.voucherDateDIR = this.voucherDateDIR;
        this.currentDBImage.startMonth = this.startMonth;
        this.currentDBImage.calendarYearCorrection = this.calendarYearCorrection;
        this.currentDBImage.fullInterestIn1stPeriod = this.fullInterestIn1stPeriod;
        this.currentDBImage.useDifferentAcquisitionValues = this.useDifferentAcquisitionValues;
        this.currentDBImage.assetIdInDescription = this.assetIdInDescription;
        this.currentDBImage.useRCTableForMOVIC = this.useRCTableForMOVIC;
        this.currentDBImage.use445Correction = this.use445Correction;
        this.currentDBImage.balanceAccountsOnIndividualLevel = this.balanceAccountsOnIndividualLevel;
        this.currentDBImage.gLBookValueRegistration = this.gLBookValueRegistration;
        this.currentDBImage.isTestCompany = this.isTestCompany;
        this.currentDBImage.depreciateBeyondEconomicLife = this.depreciateBeyondEconomicLife;
        this.currentDBImage.assetDescriptionInDescription = this.assetDescriptionInDescription;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("ProcessParameters is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            ((ProcessParametersManager_Impl)ProcessParametersManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(this.getCompanyId());
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((ProcessParametersManager_Impl)ProcessParametersManager_Impl.getInstance(this.dbd)).getResultSet((String)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("1323839091_" + this.dbd.getDBId() + this.companyId).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public ProcessParametersDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public ProcessParametersDataBean getProcessParametersDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private ProcessParametersDataBean getDataBean(ProcessParametersDataBean bean) throws Exception {
        if (bean == null) {
            bean = new ProcessParametersDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setDefaultValueInBookPeriod(this.getDefaultValueInBookPeriod());
        bean.setJournalizeCurrentAssets(this.getJournalizeCurrentAssets());
        bean.setAutoUpdateBlockedPeriods(this.getAutoUpdateBlockedPeriods());
        bean.setUseCorrectionCodeDC(this.getUseCorrectionCodeDC());
        bean.setStandardVoucherDate(this.getStandardVoucherDate());
        bean.setWarningForDifferentType(this.getWarningForDifferentType());
        bean.setWarningForDifferentDimensions(this.getWarningForDifferentDimensions());
        bean.setAutoConfirmIFT(this.getAutoConfirmIFT());
        bean.setVoucherDateIFTT(this.getVoucherDateIFTT());
        bean.setSummarizeOnKey(this.getSummarizeOnKey());
        bean.setVoucherDateDIR(this.getVoucherDateDIR());
        bean.setStartMonth(this.getStartMonth());
        bean.setCalendarYearCorrection(this.getCalendarYearCorrection());
        bean.setFullInterestIn1stPeriod(this.getFullInterestIn1stPeriod());
        bean.setUseDifferentAcquisitionValues(this.getUseDifferentAcquisitionValues());
        bean.setAssetIdInDescription(this.getAssetIdInDescription());
        bean.setUseRCTableForMOVIC(this.getUseRCTableForMOVIC());
        bean.setUse445Correction(this.getUse445Correction());
        bean.setBalanceAccountsOnIndividualLevel(this.getBalanceAccountsOnIndividualLevel());
        bean.setGLBookValueRegistration(this.getGLBookValueRegistration());
        bean.setIsTestCompany(this.getIsTestCompany());
        bean.setDepreciateBeyondEconomicLife(this.getDepreciateBeyondEconomicLife());
        bean.setAssetDescriptionInDescription(this.getAssetDescriptionInDescription());
        return bean;
    }

    public boolean equals(Object object) {
        ProcessParameters_Impl bo;
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            if (object != null && object instanceof ProcessParameters_Impl) break block7;
                            return false;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                    bo = (ProcessParameters_Impl)object;
                    if (bo.getCompanyId() != null) break block8;
                    if (this.getCompanyId() != null) {
                        return false;
                    }
                    break block9;
                }
                if (bo.getCompanyId().equals(this.getCompanyId())) break block9;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block10;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(ProcessParametersDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(ProcessParametersDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setDefaultValueInBookPeriod(bean.getDefaultValueInBookPeriod());
            this.setJournalizeCurrentAssets(bean.getJournalizeCurrentAssets());
            this.setAutoUpdateBlockedPeriods(bean.getAutoUpdateBlockedPeriods());
            this.setUseCorrectionCodeDC(bean.getUseCorrectionCodeDC());
            this.setStandardVoucherDate(bean.getStandardVoucherDate());
            this.setWarningForDifferentType(bean.getWarningForDifferentType());
            this.setWarningForDifferentDimensions(bean.getWarningForDifferentDimensions());
            this.setAutoConfirmIFT(bean.getAutoConfirmIFT());
            this.setVoucherDateIFTT(bean.getVoucherDateIFTT());
            this.setSummarizeOnKey(bean.getSummarizeOnKey());
            this.setVoucherDateDIR(bean.getVoucherDateDIR());
            this.setStartMonth(bean.getStartMonth());
            this.setCalendarYearCorrection(bean.getCalendarYearCorrection());
            this.setFullInterestIn1stPeriod(bean.getFullInterestIn1stPeriod());
            this.setUseDifferentAcquisitionValues(bean.getUseDifferentAcquisitionValues());
            this.setAssetIdInDescription(bean.getAssetIdInDescription());
            this.setUseRCTableForMOVIC(bean.getUseRCTableForMOVIC());
            this.setUse445Correction(bean.getUse445Correction());
            this.setBalanceAccountsOnIndividualLevel(bean.getBalanceAccountsOnIndividualLevel());
            this.setGLBookValueRegistration(bean.getGLBookValueRegistration());
            this.setIsTestCompany(bean.getIsTestCompany());
            this.setDepreciateBeyondEconomicLife(bean.getDepreciateBeyondEconomicLife());
            this.setAssetDescriptionInDescription(bean.getAssetDescriptionInDescription());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "ProcessParameters is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.ProcessParameters.save");
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("DefaultValueInBookPeriod", provider) + " = ? " + ", " + pmd.getFieldName("JournalizeCurrentAssets", provider) + " = ? " + ", " + pmd.getFieldName("AutoUpdateBlockedPeriods", provider) + " = ? " + ", " + pmd.getFieldName("UseCorrectionCodeDC", provider) + " = ? " + ", " + pmd.getFieldName("StandardVoucherDate", provider) + " = ? " + ", " + pmd.getFieldName("WarningForDifferentType", provider) + " = ? " + ", " + pmd.getFieldName("WarningForDifferentDimensions", provider) + " = ? " + ", " + pmd.getFieldName("AutoConfirmIFT", provider) + " = ? " + ", " + pmd.getFieldName("VoucherDateIFTT", provider) + " = ? " + ", " + pmd.getFieldName("SummarizeOnKey", provider) + " = ? " + ", " + pmd.getFieldName("VoucherDateDIR", provider) + " = ? " + ", " + pmd.getFieldName("StartMonth", provider) + " = ? " + ", " + pmd.getFieldName("CalendarYearCorrection", provider) + " = ? " + ", " + pmd.getFieldName("FullInterestIn1stPeriod", provider) + " = ? " + ", " + pmd.getFieldName("UseDifferentAcquisitionValues", provider) + " = ? " + ", " + pmd.getFieldName("AssetIdInDescription", provider) + " = ? " + ", " + pmd.getFieldName("UseRCTableForMOV_IC", provider) + " = ? " + ", " + pmd.getFieldName("Use445Correction", provider) + " = ? " + ", " + pmd.getFieldName("BalanceAccountsOnIndividualLevel", provider) + " = ? " + ", " + pmd.getFieldName("GLBookValueRegistration", provider) + " = ? " + ", " + pmd.getFieldName("IsTestCompany", provider) + " = ? " + ", " + pmd.getFieldName("DepreciateBeyondEconomicLife", provider) + " = ? " + ", " + pmd.getFieldName("AssetDescriptionInDescription", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("DefaultValueInBookPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("JournalizeCurrentAssets", provider) + " = ? " + " AND  " + pmd.getFieldName("AutoUpdateBlockedPeriods", provider) + " = ? " + " AND  " + pmd.getFieldName("UseCorrectionCodeDC", provider) + " = ? " + " AND  " + pmd.getFieldName("StandardVoucherDate", provider) + " = ? " + " AND  " + pmd.getFieldName("WarningForDifferentType", provider) + " = ? " + " AND  " + pmd.getFieldName("WarningForDifferentDimensions", provider) + " = ? " + " AND  " + pmd.getFieldName("AutoConfirmIFT", provider) + " = ? " + " AND  " + pmd.getFieldName("VoucherDateIFTT", provider) + " = ? " + " AND  " + pmd.getFieldName("SummarizeOnKey", provider) + " = ? " + " AND  " + pmd.getFieldName("VoucherDateDIR", provider) + " = ? " + " AND  " + pmd.getFieldName("StartMonth", provider) + " = ? " + " AND  " + pmd.getFieldName("CalendarYearCorrection", provider) + " = ? " + " AND  " + pmd.getFieldName("FullInterestIn1stPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("UseDifferentAcquisitionValues", provider) + " = ? " + " AND  " + pmd.getFieldName("AssetIdInDescription", provider) + " = ? " + " AND  " + pmd.getFieldName("UseRCTableForMOV_IC", provider) + " = ? " + " AND  " + pmd.getFieldName("Use445Correction", provider) + " = ? " + " AND  " + pmd.getFieldName("BalanceAccountsOnIndividualLevel", provider) + " = ? " + " AND  " + pmd.getFieldName("GLBookValueRegistration", provider) + " = ? " + " AND  " + pmd.getFieldName("IsTestCompany", provider) + " = ? " + " AND  " + pmd.getFieldName("DepreciateBeyondEconomicLife", provider) + " = ? " + " AND  " + pmd.getFieldName("AssetDescriptionInDescription", provider) + " = ? ");
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.defaultValueInBookPeriod), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.journalizeCurrentAssets), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.autoUpdateBlockedPeriods), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.useCorrectionCodeDC), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(this.standardVoucherDate), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.warningForDifferentType), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.warningForDifferentDimensions), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.autoConfirmIFT), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(this.voucherDateIFTT), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.summarizeOnKey), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(this.voucherDateDIR), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.startMonth), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.calendarYearCorrection), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.fullInterestIn1stPeriod), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.useDifferentAcquisitionValues), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.assetIdInDescription), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.useRCTableForMOVIC), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.use445Correction), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.balanceAccountsOnIndividualLevel), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.gLBookValueRegistration), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.isTestCompany), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.depreciateBeyondEconomicLife), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.assetDescriptionInDescription), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.defaultValueInBookPeriod), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.journalizeCurrentAssets), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.autoUpdateBlockedPeriods), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.useCorrectionCodeDC), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(image.standardVoucherDate), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.warningForDifferentType), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.warningForDifferentDimensions), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.autoConfirmIFT), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(image.voucherDateIFTT), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.summarizeOnKey), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(image.voucherDateDIR), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.startMonth), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.calendarYearCorrection), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.fullInterestIn1stPeriod), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.useDifferentAcquisitionValues), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.assetIdInDescription), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.useRCTableForMOVIC), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.use445Correction), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.balanceAccountsOnIndividualLevel), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.gLBookValueRegistration), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.isTestCompany), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.depreciateBeyondEconomicLife), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.assetDescriptionInDescription), mapping.getJDBCTypeFor("boolean"));
                int n = prep.executeUpdate();
                if (n == 0) {
                    this.rollback(true);
                    throw new UpdateException("ProcessParameters modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.ProcessParameters.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.ProcessParameters.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("DefaultValueInBookPeriod", provider) + ", " + pmd.getFieldName("JournalizeCurrentAssets", provider) + ", " + pmd.getFieldName("AutoUpdateBlockedPeriods", provider) + ", " + pmd.getFieldName("UseCorrectionCodeDC", provider) + ", " + pmd.getFieldName("StandardVoucherDate", provider) + ", " + pmd.getFieldName("WarningForDifferentType", provider) + ", " + pmd.getFieldName("WarningForDifferentDimensions", provider) + ", " + pmd.getFieldName("AutoConfirmIFT", provider) + ", " + pmd.getFieldName("VoucherDateIFTT", provider) + ", " + pmd.getFieldName("SummarizeOnKey", provider) + ", " + pmd.getFieldName("VoucherDateDIR", provider) + ", " + pmd.getFieldName("StartMonth", provider) + ", " + pmd.getFieldName("CalendarYearCorrection", provider) + ", " + pmd.getFieldName("FullInterestIn1stPeriod", provider) + ", " + pmd.getFieldName("UseDifferentAcquisitionValues", provider) + ", " + pmd.getFieldName("AssetIdInDescription", provider) + ", " + pmd.getFieldName("UseRCTableForMOV_IC", provider) + ", " + pmd.getFieldName("Use445Correction", provider) + ", " + pmd.getFieldName("BalanceAccountsOnIndividualLevel", provider) + ", " + pmd.getFieldName("GLBookValueRegistration", provider) + ", " + pmd.getFieldName("IsTestCompany", provider) + ", " + pmd.getFieldName("DepreciateBeyondEconomicLife", provider) + ", " + pmd.getFieldName("AssetDescriptionInDescription", provider) + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)new Boolean(this.defaultValueInBookPeriod), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(3, (Object)new Boolean(this.journalizeCurrentAssets), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(4, (Object)new Boolean(this.autoUpdateBlockedPeriods), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(5, (Object)new Boolean(this.useCorrectionCodeDC), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(6, (Object)new Integer(this.standardVoucherDate), mapping.getJDBCTypeFor("int"));
                prep.setObject(7, (Object)new Boolean(this.warningForDifferentType), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(8, (Object)new Boolean(this.warningForDifferentDimensions), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(9, (Object)new Boolean(this.autoConfirmIFT), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(10, (Object)new Integer(this.voucherDateIFTT), mapping.getJDBCTypeFor("int"));
                prep.setObject(11, (Object)new Boolean(this.summarizeOnKey), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(12, (Object)new Integer(this.voucherDateDIR), mapping.getJDBCTypeFor("int"));
                prep.setObject(13, (Object)new Integer(this.startMonth), mapping.getJDBCTypeFor("int"));
                prep.setObject(14, (Object)new Integer(this.calendarYearCorrection), mapping.getJDBCTypeFor("int"));
                prep.setObject(15, (Object)new Boolean(this.fullInterestIn1stPeriod), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(16, (Object)new Boolean(this.useDifferentAcquisitionValues), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(17, (Object)new Boolean(this.assetIdInDescription), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(18, (Object)new Boolean(this.useRCTableForMOVIC), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(19, (Object)new Boolean(this.use445Correction), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(20, (Object)new Boolean(this.balanceAccountsOnIndividualLevel), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(21, (Object)new Boolean(this.gLBookValueRegistration), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(22, (Object)new Boolean(this.isTestCompany), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(23, (Object)new Boolean(this.depreciateBeyondEconomicLife), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(24, (Object)new Boolean(this.assetDescriptionInDescription), mapping.getJDBCTypeFor("boolean"));
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.defaultValueInBookPeriod = this.currentDBImage.defaultValueInBookPeriod;
            this.transactionImage.dbImage.journalizeCurrentAssets = this.currentDBImage.journalizeCurrentAssets;
            this.transactionImage.dbImage.autoUpdateBlockedPeriods = this.currentDBImage.autoUpdateBlockedPeriods;
            this.transactionImage.dbImage.useCorrectionCodeDC = this.currentDBImage.useCorrectionCodeDC;
            this.transactionImage.dbImage.standardVoucherDate = this.currentDBImage.standardVoucherDate;
            this.transactionImage.dbImage.warningForDifferentType = this.currentDBImage.warningForDifferentType;
            this.transactionImage.dbImage.warningForDifferentDimensions = this.currentDBImage.warningForDifferentDimensions;
            this.transactionImage.dbImage.autoConfirmIFT = this.currentDBImage.autoConfirmIFT;
            this.transactionImage.dbImage.voucherDateIFTT = this.currentDBImage.voucherDateIFTT;
            this.transactionImage.dbImage.summarizeOnKey = this.currentDBImage.summarizeOnKey;
            this.transactionImage.dbImage.voucherDateDIR = this.currentDBImage.voucherDateDIR;
            this.transactionImage.dbImage.startMonth = this.currentDBImage.startMonth;
            this.transactionImage.dbImage.calendarYearCorrection = this.currentDBImage.calendarYearCorrection;
            this.transactionImage.dbImage.fullInterestIn1stPeriod = this.currentDBImage.fullInterestIn1stPeriod;
            this.transactionImage.dbImage.useDifferentAcquisitionValues = this.currentDBImage.useDifferentAcquisitionValues;
            this.transactionImage.dbImage.assetIdInDescription = this.currentDBImage.assetIdInDescription;
            this.transactionImage.dbImage.useRCTableForMOVIC = this.currentDBImage.useRCTableForMOVIC;
            this.transactionImage.dbImage.use445Correction = this.currentDBImage.use445Correction;
            this.transactionImage.dbImage.balanceAccountsOnIndividualLevel = this.currentDBImage.balanceAccountsOnIndividualLevel;
            this.transactionImage.dbImage.gLBookValueRegistration = this.currentDBImage.gLBookValueRegistration;
            this.transactionImage.dbImage.isTestCompany = this.currentDBImage.isTestCompany;
            this.transactionImage.dbImage.depreciateBeyondEconomicLife = this.currentDBImage.depreciateBeyondEconomicLife;
            this.transactionImage.dbImage.assetDescriptionInDescription = this.currentDBImage.assetDescriptionInDescription;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.defaultValueInBookPeriod = this.transactionImage.dbImage.defaultValueInBookPeriod;
        this.currentDBImage.journalizeCurrentAssets = this.transactionImage.dbImage.journalizeCurrentAssets;
        this.currentDBImage.autoUpdateBlockedPeriods = this.transactionImage.dbImage.autoUpdateBlockedPeriods;
        this.currentDBImage.useCorrectionCodeDC = this.transactionImage.dbImage.useCorrectionCodeDC;
        this.currentDBImage.standardVoucherDate = this.transactionImage.dbImage.standardVoucherDate;
        this.currentDBImage.warningForDifferentType = this.transactionImage.dbImage.warningForDifferentType;
        this.currentDBImage.warningForDifferentDimensions = this.transactionImage.dbImage.warningForDifferentDimensions;
        this.currentDBImage.autoConfirmIFT = this.transactionImage.dbImage.autoConfirmIFT;
        this.currentDBImage.voucherDateIFTT = this.transactionImage.dbImage.voucherDateIFTT;
        this.currentDBImage.summarizeOnKey = this.transactionImage.dbImage.summarizeOnKey;
        this.currentDBImage.voucherDateDIR = this.transactionImage.dbImage.voucherDateDIR;
        this.currentDBImage.startMonth = this.transactionImage.dbImage.startMonth;
        this.currentDBImage.calendarYearCorrection = this.transactionImage.dbImage.calendarYearCorrection;
        this.currentDBImage.fullInterestIn1stPeriod = this.transactionImage.dbImage.fullInterestIn1stPeriod;
        this.currentDBImage.useDifferentAcquisitionValues = this.transactionImage.dbImage.useDifferentAcquisitionValues;
        this.currentDBImage.assetIdInDescription = this.transactionImage.dbImage.assetIdInDescription;
        this.currentDBImage.useRCTableForMOVIC = this.transactionImage.dbImage.useRCTableForMOVIC;
        this.currentDBImage.use445Correction = this.transactionImage.dbImage.use445Correction;
        this.currentDBImage.balanceAccountsOnIndividualLevel = this.transactionImage.dbImage.balanceAccountsOnIndividualLevel;
        this.currentDBImage.gLBookValueRegistration = this.transactionImage.dbImage.gLBookValueRegistration;
        this.currentDBImage.isTestCompany = this.transactionImage.dbImage.isTestCompany;
        this.currentDBImage.depreciateBeyondEconomicLife = this.transactionImage.dbImage.depreciateBeyondEconomicLife;
        this.currentDBImage.assetDescriptionInDescription = this.transactionImage.dbImage.assetDescriptionInDescription;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.defaultValueInBookPeriod = this.transactionImage.dbImage.defaultValueInBookPeriod;
            this.journalizeCurrentAssets = this.transactionImage.dbImage.journalizeCurrentAssets;
            this.autoUpdateBlockedPeriods = this.transactionImage.dbImage.autoUpdateBlockedPeriods;
            this.useCorrectionCodeDC = this.transactionImage.dbImage.useCorrectionCodeDC;
            this.standardVoucherDate = this.transactionImage.dbImage.standardVoucherDate;
            this.warningForDifferentType = this.transactionImage.dbImage.warningForDifferentType;
            this.warningForDifferentDimensions = this.transactionImage.dbImage.warningForDifferentDimensions;
            this.autoConfirmIFT = this.transactionImage.dbImage.autoConfirmIFT;
            this.voucherDateIFTT = this.transactionImage.dbImage.voucherDateIFTT;
            this.summarizeOnKey = this.transactionImage.dbImage.summarizeOnKey;
            this.voucherDateDIR = this.transactionImage.dbImage.voucherDateDIR;
            this.startMonth = this.transactionImage.dbImage.startMonth;
            this.calendarYearCorrection = this.transactionImage.dbImage.calendarYearCorrection;
            this.fullInterestIn1stPeriod = this.transactionImage.dbImage.fullInterestIn1stPeriod;
            this.useDifferentAcquisitionValues = this.transactionImage.dbImage.useDifferentAcquisitionValues;
            this.assetIdInDescription = this.transactionImage.dbImage.assetIdInDescription;
            this.useRCTableForMOVIC = this.transactionImage.dbImage.useRCTableForMOVIC;
            this.use445Correction = this.transactionImage.dbImage.use445Correction;
            this.balanceAccountsOnIndividualLevel = this.transactionImage.dbImage.balanceAccountsOnIndividualLevel;
            this.gLBookValueRegistration = this.transactionImage.dbImage.gLBookValueRegistration;
            this.isTestCompany = this.transactionImage.dbImage.isTestCompany;
            this.depreciateBeyondEconomicLife = this.transactionImage.dbImage.depreciateBeyondEconomicLife;
            this.assetDescriptionInDescription = this.transactionImage.dbImage.assetDescriptionInDescription;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private boolean defaultValueInBookPeriod;
        private boolean journalizeCurrentAssets;
        private boolean autoUpdateBlockedPeriods;
        private boolean useCorrectionCodeDC;
        private int standardVoucherDate;
        private boolean warningForDifferentType;
        private boolean warningForDifferentDimensions;
        private boolean autoConfirmIFT;
        private int voucherDateIFTT;
        private boolean summarizeOnKey;
        private int voucherDateDIR;
        private int startMonth;
        private int calendarYearCorrection;
        private boolean fullInterestIn1stPeriod;
        private boolean useDifferentAcquisitionValues;
        private boolean assetIdInDescription;
        private boolean useRCTableForMOVIC;
        private boolean use445Correction;
        private boolean balanceAccountsOnIndividualLevel;
        private boolean gLBookValueRegistration;
        private boolean isTestCompany;
        private boolean depreciateBeyondEconomicLife;
        private boolean assetDescriptionInDescription;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

