/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditPK;
import nl.ibs.fac.db.DetailEstimationTransaction;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.db.TotalEstimationTransactionDataBean;
import nl.ibs.fac.db.TotalEstimationTransactionPK;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.CreditManager_Impl;
import nl.ibs.fac.db.impl.DetailEstimationTransactionManager_Impl;
import nl.ibs.fac.db.impl.InterestTableManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataDetailEstimationTransaction;
import nl.ibs.fac.db.impl.PersistenceMetaDataTotalEstimationTransaction;
import nl.ibs.fac.db.impl.TotalEstimationTransactionManager_Impl;
import nl.ibs.fac.db.impl.YearPercentageTableManager_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class TotalEstimationTransaction_Impl
implements TotalEstimationTransaction,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataTotalEstimationTransaction.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected int internalNumber;
    protected String creditId;
    protected String description;
    protected String assetTypeId;
    protected int estimationTransactionType;
    protected int bBVCategory;
    protected BigDecimal totalTransactionAmount;
    protected boolean hasMemo;
    protected int state;
    protected int depreciationMethod;
    protected int startPeriodHandlingMethod;
    protected BigDecimal degressivePercentage;
    protected String yearPercentageTableId;
    protected BigDecimal annuityPercentage;
    protected String annuityInterestTableId;
    protected int depreciatableLife;
    protected BigDecimal residualValue;
    protected BigDecimal residualPercentage;
    protected int interestCalculationMethod;
    protected BigDecimal interestPercentage;
    protected String interestTableId;
    protected transient Credit transientCredit;
    protected transient InterestTable transientAnnuityInterestTable;
    protected transient InterestTable transientInterestTable;
    protected transient YearPercentageTable transientYearPercentageTable;

    protected TotalEstimationTransaction_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected TotalEstimationTransaction_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected TotalEstimationTransaction_Impl(DBData _dbd, String _companyId, int _internalNumber) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setInternalNumber(_internalNumber);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected TotalEstimationTransaction_Impl(DBData _dbd, TotalEstimationTransactionDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.TotalEstimationTransactionDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate TotalEstimationTransaction with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.TotalEstimationTransactionDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setInternalNumber(bean.getInternalNumber());
            this.setCreditId(bean.getCreditId());
            this.setDescription(bean.getDescription());
            this.setAssetTypeId(bean.getAssetTypeId());
            this.setEstimationTransactionType(bean.getEstimationTransactionType());
            this.setBBVCategory(bean.getBBVCategory());
            this.setTotalTransactionAmount(bean.getTotalTransactionAmount());
            this.setHasMemo(bean.getHasMemo());
            this.setState(bean.getState());
            this.setDepreciationMethod(bean.getDepreciationMethod());
            this.setStartPeriodHandlingMethod(bean.getStartPeriodHandlingMethod());
            this.setDegressivePercentage(bean.getDegressivePercentage());
            this.setYearPercentageTableId(bean.getYearPercentageTableId());
            this.setAnnuityPercentage(bean.getAnnuityPercentage());
            this.setAnnuityInterestTableId(bean.getAnnuityInterestTableId());
            this.setDepreciatableLife(bean.getDepreciatableLife());
            this.setResidualValue(bean.getResidualValue());
            this.setResidualPercentage(bean.getResidualPercentage());
            this.setInterestCalculationMethod(bean.getInterestCalculationMethod());
            this.setInterestPercentage(bean.getInterestPercentage());
            this.setInterestTableId(bean.getInterestTableId());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public TotalEstimationTransaction_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.internalNumber = rs.getInt(pmd.getFieldName("InternalNumber", provider));
        this.creditId = rs.getString(pmd.getFieldName("CreditId", provider));
        this.description = rs.getString(pmd.getFieldName("Description", provider));
        this.assetTypeId = rs.getString(pmd.getFieldName("AssetTypeId", provider));
        this.estimationTransactionType = rs.getInt(pmd.getFieldName("EstimationTransactionType", provider));
        this.bBVCategory = rs.getInt(pmd.getFieldName("BBVCategory", provider));
        this.totalTransactionAmount = rs.getBigDecimal(pmd.getFieldName("TotalTransactionAmount", provider));
        this.hasMemo = rs.getBoolean(pmd.getFieldName("HasMemo", provider));
        this.state = rs.getInt(pmd.getFieldName("State", provider));
        this.depreciationMethod = rs.getInt(pmd.getFieldName("DepreciationMethod", provider));
        this.startPeriodHandlingMethod = rs.getInt(pmd.getFieldName("StartPeriodHandlingMethod", provider));
        this.degressivePercentage = rs.getBigDecimal(pmd.getFieldName("DegressivePercentage", provider));
        this.yearPercentageTableId = rs.getString(pmd.getFieldName("YearPercentageTableId", provider));
        this.annuityPercentage = rs.getBigDecimal(pmd.getFieldName("AnnuityPercentage", provider));
        this.annuityInterestTableId = rs.getString(pmd.getFieldName("AnnuityInterestTableId", provider));
        this.depreciatableLife = rs.getInt(pmd.getFieldName("DepreciatableLife", provider));
        this.residualValue = rs.getBigDecimal(pmd.getFieldName("ResidualValue", provider));
        this.residualPercentage = rs.getBigDecimal(pmd.getFieldName("ResidualPercentage", provider));
        this.interestCalculationMethod = rs.getInt(pmd.getFieldName("InterestCalculationMethod", provider));
        this.interestPercentage = rs.getBigDecimal(pmd.getFieldName("InterestPercentage", provider));
        this.interestTableId = rs.getString(pmd.getFieldName("InterestTableId", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        TotalEstimationTransactionPK key = new TotalEstimationTransactionPK();
        key.setCompanyId(this.getCompanyId());
        key.setInternalNumber(this.getInternalNumber());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public int getInternalNumber() throws Exception {
        this.assureStorage();
        return this.internalNumber;
    }

    @Override
    public String getCreditId() throws Exception {
        return this.creditId;
    }

    @Override
    public String getDescription() throws Exception {
        return this.description;
    }

    @Override
    public String getAssetTypeId() throws Exception {
        return this.assetTypeId;
    }

    @Override
    public int getEstimationTransactionType() throws Exception {
        return this.estimationTransactionType;
    }

    @Override
    public int getBBVCategory() throws Exception {
        return this.bBVCategory;
    }

    @Override
    public BigDecimal getTotalTransactionAmount() throws Exception {
        return this.totalTransactionAmount;
    }

    @Override
    public boolean getHasMemo() throws Exception {
        return this.hasMemo;
    }

    @Override
    public int getState() throws Exception {
        return this.state;
    }

    @Override
    public int getDepreciationMethod() throws Exception {
        return this.depreciationMethod;
    }

    @Override
    public int getStartPeriodHandlingMethod() throws Exception {
        return this.startPeriodHandlingMethod;
    }

    @Override
    public BigDecimal getDegressivePercentage() throws Exception {
        return this.degressivePercentage;
    }

    @Override
    public String getYearPercentageTableId() throws Exception {
        return this.yearPercentageTableId;
    }

    @Override
    public BigDecimal getAnnuityPercentage() throws Exception {
        return this.annuityPercentage;
    }

    @Override
    public String getAnnuityInterestTableId() throws Exception {
        return this.annuityInterestTableId;
    }

    @Override
    public int getDepreciatableLife() throws Exception {
        return this.depreciatableLife;
    }

    @Override
    public BigDecimal getResidualValue() throws Exception {
        return this.residualValue;
    }

    @Override
    public BigDecimal getResidualPercentage() throws Exception {
        return this.residualPercentage;
    }

    @Override
    public int getInterestCalculationMethod() throws Exception {
        return this.interestCalculationMethod;
    }

    @Override
    public BigDecimal getInterestPercentage() throws Exception {
        return this.interestPercentage;
    }

    @Override
    public String getInterestTableId() throws Exception {
        return this.interestTableId;
    }

    @Override
    public Credit getCredit() throws Exception {
        if (this.isCachedRelation("Credit")) {
            return (Credit)this.getCachedRelationObject("Credit");
        }
        CreditPK primaryKey = new CreditPK();
        if (this.getCompanyId() == null) {
            return (Credit)this.addCachedRelationObject("Credit", null);
        }
        primaryKey.setCompanyId(this.getCompanyId());
        if (this.getCreditId() == null) {
            return (Credit)this.addCachedRelationObject("Credit", null);
        }
        primaryKey.setId(this.getCreditId());
        try {
            return (Credit)this.addCachedRelationObject("Credit", ((CreditManager_Impl)CreditManager_Impl.getInstance(this.dbd)).findByPrimaryKey(primaryKey));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public InterestTable getAnnuityInterestTable() throws Exception {
        if (this.isCachedRelation("AnnuityInterestTable")) {
            return (InterestTable)this.getCachedRelationObject("AnnuityInterestTable");
        }
        if (this.getAnnuityInterestTableId() == null) {
            return (InterestTable)this.addCachedRelationObject("AnnuityInterestTable", null);
        }
        try {
            return (InterestTable)this.addCachedRelationObject("AnnuityInterestTable", ((InterestTableManager_Impl)InterestTableManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getAnnuityInterestTableId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public InterestTable getInterestTable() throws Exception {
        if (this.isCachedRelation("InterestTable")) {
            return (InterestTable)this.getCachedRelationObject("InterestTable");
        }
        if (this.getInterestTableId() == null) {
            return (InterestTable)this.addCachedRelationObject("InterestTable", null);
        }
        try {
            return (InterestTable)this.addCachedRelationObject("InterestTable", ((InterestTableManager_Impl)InterestTableManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getInterestTableId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public YearPercentageTable getYearPercentageTable() throws Exception {
        if (this.isCachedRelation("YearPercentageTable")) {
            return (YearPercentageTable)this.getCachedRelationObject("YearPercentageTable");
        }
        if (this.getYearPercentageTableId() == null) {
            return (YearPercentageTable)this.addCachedRelationObject("YearPercentageTable", null);
        }
        try {
            return (YearPercentageTable)this.addCachedRelationObject("YearPercentageTable", ((YearPercentageTableManager_Impl)YearPercentageTableManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getYearPercentageTableId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public DetailEstimationTransaction getDetailEstimationTransactionsObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "companyId = ?companyId AND parentNumber = ?parentNumber";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("parentNumber", this.getInternalNumber());
        queryImpl.setRelationFilter("companyId = ?companyId AND parentNumber = ?parentNumber");
        return DetailEstimationTransactionManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getDetailEstimationTransactionsCollection(Query query) throws Exception {
        boolean nullQuery;
        boolean bl = nullQuery = query == null;
        if (nullQuery && this.isCachedRelation("DetailEstimationTransactionsCollection")) {
            return (Collection)this.getCachedRelationObject("DetailEstimationTransactionsCollection");
        }
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND parentNumber = ?parentNumber";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("parentNumber", this.getInternalNumber());
        queryImpl.setRelationFilter("companyId = ?companyId AND parentNumber = ?parentNumber");
        if (nullQuery) {
            return (Collection)this.addCachedRelationObject("DetailEstimationTransactionsCollection", DetailEstimationTransactionManager_Impl.getInstance(this.dbd).getCollection(query));
        }
        return DetailEstimationTransactionManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getDetailEstimationTransactionsDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "companyId = ?companyId AND parentNumber = ?parentNumber";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("parentNumber", this.getInternalNumber());
        queryImpl.setRelationFilter("companyId = ?companyId AND parentNumber = ?parentNumber");
        return DetailEstimationTransactionManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getDetailEstimationTransactionsDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "companyId = ?companyId AND parentNumber = ?parentNumber";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("parentNumber", this.getInternalNumber());
        queryImpl.setRelationFilter("companyId = ?companyId AND parentNumber = ?parentNumber");
        return DetailEstimationTransactionManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getDetailEstimationTransactionsDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND parentNumber = ?parentNumber";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("parentNumber", this.getInternalNumber());
        queryImpl.setRelationFilter("companyId = ?companyId AND parentNumber = ?parentNumber");
        return DetailEstimationTransactionManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public Company getOwnedByCompanyAsTotalEstimationTransactions() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsTotalEstimationTransactions")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsTotalEstimationTransactions");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsTotalEstimationTransactions", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Company owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsTotalEstimationTransactions();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setInternalNumber(int _internalNumber) throws Exception {
        if (_internalNumber == this.getInternalNumber()) {
            return;
        }
        this.preSet();
        this.internalNumber = _internalNumber;
        this.autoUpdate();
    }

    public void setCreditId(String _creditId) throws Exception {
        if (_creditId == null ? this.getCreditId() == null : _creditId.equals(this.getCreditId())) {
            return;
        }
        this.preSet();
        this.creditId = _creditId;
        this.autoUpdate();
    }

    @Override
    public void setDescription(String _description) throws Exception {
        if (_description == null) {
            _description = "";
        }
        if (_description.equals(this.getDescription())) {
            return;
        }
        this.preSet();
        this.description = _description;
        this.autoUpdate();
    }

    @Override
    public void setAssetTypeId(String _assetTypeId) throws Exception {
        if (_assetTypeId == null) {
            _assetTypeId = "";
        }
        if (_assetTypeId.equals(this.getAssetTypeId())) {
            return;
        }
        this.preSet();
        this.assetTypeId = _assetTypeId;
        this.autoUpdate();
    }

    @Override
    public void setEstimationTransactionType(int _estimationTransactionType) throws Exception {
        if (_estimationTransactionType == this.getEstimationTransactionType()) {
            return;
        }
        this.preSet();
        this.estimationTransactionType = _estimationTransactionType;
        this.autoUpdate();
    }

    @Override
    public void setBBVCategory(int _bBVCategory) throws Exception {
        if (_bBVCategory == this.getBBVCategory()) {
            return;
        }
        this.preSet();
        this.bBVCategory = _bBVCategory;
        this.autoUpdate();
    }

    @Override
    public void setTotalTransactionAmount(BigDecimal _totalTransactionAmount) throws Exception {
        if (_totalTransactionAmount == null) {
            _totalTransactionAmount = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_totalTransactionAmount.equals(this.getTotalTransactionAmount())) {
            return;
        }
        this.preSet();
        this.totalTransactionAmount = _totalTransactionAmount;
        this.autoUpdate();
    }

    @Override
    public void setHasMemo(boolean _hasMemo) throws Exception {
        if (_hasMemo == this.getHasMemo()) {
            return;
        }
        this.preSet();
        this.hasMemo = _hasMemo;
        this.autoUpdate();
    }

    @Override
    public void setState(int _state) throws Exception {
        if (_state == this.getState()) {
            return;
        }
        this.preSet();
        this.state = _state;
        this.autoUpdate();
    }

    @Override
    public void setDepreciationMethod(int _depreciationMethod) throws Exception {
        if (_depreciationMethod == this.getDepreciationMethod()) {
            return;
        }
        this.preSet();
        this.depreciationMethod = _depreciationMethod;
        this.autoUpdate();
    }

    @Override
    public void setStartPeriodHandlingMethod(int _startPeriodHandlingMethod) throws Exception {
        if (_startPeriodHandlingMethod == this.getStartPeriodHandlingMethod()) {
            return;
        }
        this.preSet();
        this.startPeriodHandlingMethod = _startPeriodHandlingMethod;
        this.autoUpdate();
    }

    @Override
    public void setDegressivePercentage(BigDecimal _degressivePercentage) throws Exception {
        if (_degressivePercentage == null) {
            _degressivePercentage = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_degressivePercentage.equals(this.getDegressivePercentage())) {
            return;
        }
        this.preSet();
        this.degressivePercentage = _degressivePercentage;
        this.autoUpdate();
    }

    public void setYearPercentageTableId(String _yearPercentageTableId) throws Exception {
        if (_yearPercentageTableId == null ? this.getYearPercentageTableId() == null : _yearPercentageTableId.equals(this.getYearPercentageTableId())) {
            return;
        }
        this.preSet();
        this.yearPercentageTableId = _yearPercentageTableId;
        this.autoUpdate();
    }

    @Override
    public void setAnnuityPercentage(BigDecimal _annuityPercentage) throws Exception {
        if (_annuityPercentage == null) {
            _annuityPercentage = new BigDecimal("0.000").setScale(3, 6);
        }
        if (_annuityPercentage.equals(this.getAnnuityPercentage())) {
            return;
        }
        this.preSet();
        this.annuityPercentage = _annuityPercentage;
        this.autoUpdate();
    }

    public void setAnnuityInterestTableId(String _annuityInterestTableId) throws Exception {
        if (_annuityInterestTableId == null ? this.getAnnuityInterestTableId() == null : _annuityInterestTableId.equals(this.getAnnuityInterestTableId())) {
            return;
        }
        this.preSet();
        this.annuityInterestTableId = _annuityInterestTableId;
        this.autoUpdate();
    }

    @Override
    public void setDepreciatableLife(int _depreciatableLife) throws Exception {
        if (_depreciatableLife == this.getDepreciatableLife()) {
            return;
        }
        this.preSet();
        this.depreciatableLife = _depreciatableLife;
        this.autoUpdate();
    }

    @Override
    public void setResidualValue(BigDecimal _residualValue) throws Exception {
        if (_residualValue == null) {
            _residualValue = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_residualValue.equals(this.getResidualValue())) {
            return;
        }
        this.preSet();
        this.residualValue = _residualValue;
        this.autoUpdate();
    }

    @Override
    public void setResidualPercentage(BigDecimal _residualPercentage) throws Exception {
        if (_residualPercentage == null) {
            _residualPercentage = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_residualPercentage.equals(this.getResidualPercentage())) {
            return;
        }
        this.preSet();
        this.residualPercentage = _residualPercentage;
        this.autoUpdate();
    }

    @Override
    public void setInterestCalculationMethod(int _interestCalculationMethod) throws Exception {
        if (_interestCalculationMethod == this.getInterestCalculationMethod()) {
            return;
        }
        this.preSet();
        this.interestCalculationMethod = _interestCalculationMethod;
        this.autoUpdate();
    }

    @Override
    public void setInterestPercentage(BigDecimal _interestPercentage) throws Exception {
        if (_interestPercentage == null) {
            _interestPercentage = new BigDecimal("0.000").setScale(3, 6);
        }
        if (_interestPercentage.equals(this.getInterestPercentage())) {
            return;
        }
        this.preSet();
        this.interestPercentage = _interestPercentage;
        this.autoUpdate();
    }

    public void setInterestTableId(String _interestTableId) throws Exception {
        if (_interestTableId == null ? this.getInterestTableId() == null : _interestTableId.equals(this.getInterestTableId())) {
            return;
        }
        this.preSet();
        this.interestTableId = _interestTableId;
        this.autoUpdate();
    }

    @Override
    public void setCredit(Credit object) throws Exception {
        this.transientCredit = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "creditId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "companyId", generalAccessor.getObjectAttribute(object, "companyId"));
            generalAccessor.setAttribute((Object)this, "creditId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("Credit", object);
    }

    @Override
    public void setAnnuityInterestTable(InterestTable object) throws Exception {
        this.transientAnnuityInterestTable = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "annuityInterestTableId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "annuityInterestTableId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("AnnuityInterestTable", object);
    }

    @Override
    public void setInterestTable(InterestTable object) throws Exception {
        this.transientInterestTable = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "interestTableId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "interestTableId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("InterestTable", object);
    }

    @Override
    public void setYearPercentageTable(YearPercentageTable object) throws Exception {
        this.transientYearPercentageTable = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "yearPercentageTableId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "yearPercentageTableId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("YearPercentageTable", object);
    }

    @Override
    public void addDetailEstimationTransactions(Collection collection) throws Exception {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.addDetailEstimationTransactions((DetailEstimationTransaction)it.next());
        }
    }

    @Override
    public void addDetailEstimationTransactions(DetailEstimationTransaction object) throws Exception {
        if (object != null) {
            if (!PersistenceMetaDataDetailEstimationTransaction.getInstance().isPersistable(object)) {
                throw new Exception("Tried to attach to a TotalEstimationTransaction an DetailEstimationTransaction that is not valid implementation class!!");
            }
            if (generalAccessor.getObjectAttribute(object, "companyId") != null) {
                throw new Exception("Tried to attach to a TotalEstimationTransaction a DetailEstimationTransaction that is allready owned (by a TotalEstimationTransaction");
            }
            this.assureStorage();
            object.preSet();
            generalAccessor.setAttribute((Object)object, "companyId", this.getCompanyId());
            generalAccessor.setAttribute((Object)object, "parentNumber", this.getInternalNumber());
            ((BusinessObject_Impl)((Object)object)).save();
            ((BusinessObject_Impl)((Object)object)).addCachedRelationObject("ownedByTotalEstimationTransactionAsDetailEstimationTransactions", this);
        }
        this.clearCachedRelation("DetailEstimationTransactionsCollection");
    }

    @Override
    public void removeDetailEstimationTransactions(Collection collection) throws Exception {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.removeDetailEstimationTransactions((DetailEstimationTransaction)it.next());
        }
    }

    @Override
    public void removeDetailEstimationTransactions(DetailEstimationTransaction object) throws Exception {
        if (object != null) {
            object.delete();
            this.clearCachedRelation("DetailEstimationTransactionsCollection");
            ((BusinessObject_Impl)((Object)object)).clearCachedRelation("ownedByTotalEstimationTransactionAsDetailEstimationTransactions");
        }
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.internalNumber = 0;
        this.description = "";
        this.assetTypeId = "";
        this.estimationTransactionType = 0;
        this.bBVCategory = 0;
        this.totalTransactionAmount = new BigDecimal("0.00").setScale(2, 6);
        this.hasMemo = false;
        this.state = 0;
        this.depreciationMethod = 0;
        this.startPeriodHandlingMethod = 0;
        this.degressivePercentage = new BigDecimal("0.00").setScale(2, 6);
        this.annuityPercentage = new BigDecimal("0.000").setScale(3, 6);
        this.depreciatableLife = 0;
        this.residualValue = new BigDecimal("0.00").setScale(2, 6);
        this.residualPercentage = new BigDecimal("0.00").setScale(2, 6);
        this.interestCalculationMethod = 0;
        this.interestPercentage = new BigDecimal("0.000").setScale(3, 6);
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.internalNumber = this.internalNumber;
        this.currentDBImage.creditId = this.creditId;
        this.currentDBImage.description = this.description;
        this.currentDBImage.assetTypeId = this.assetTypeId;
        this.currentDBImage.estimationTransactionType = this.estimationTransactionType;
        this.currentDBImage.bBVCategory = this.bBVCategory;
        this.currentDBImage.totalTransactionAmount = this.totalTransactionAmount;
        this.currentDBImage.hasMemo = this.hasMemo;
        this.currentDBImage.state = this.state;
        this.currentDBImage.depreciationMethod = this.depreciationMethod;
        this.currentDBImage.startPeriodHandlingMethod = this.startPeriodHandlingMethod;
        this.currentDBImage.degressivePercentage = this.degressivePercentage;
        this.currentDBImage.yearPercentageTableId = this.yearPercentageTableId;
        this.currentDBImage.annuityPercentage = this.annuityPercentage;
        this.currentDBImage.annuityInterestTableId = this.annuityInterestTableId;
        this.currentDBImage.depreciatableLife = this.depreciatableLife;
        this.currentDBImage.residualValue = this.residualValue;
        this.currentDBImage.residualPercentage = this.residualPercentage;
        this.currentDBImage.interestCalculationMethod = this.interestCalculationMethod;
        this.currentDBImage.interestPercentage = this.interestPercentage;
        this.currentDBImage.interestTableId = this.interestTableId;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("TotalEstimationTransaction is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            TotalEstimationTransactionPK key = new TotalEstimationTransactionPK();
            key.setCompanyId(this.getCompanyId());
            key.setInternalNumber(this.getInternalNumber());
            ((TotalEstimationTransactionManager_Impl)TotalEstimationTransactionManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((TotalEstimationTransactionManager_Impl)TotalEstimationTransactionManager_Impl.getInstance(this.dbd)).getResultSet((TotalEstimationTransactionPK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("278766965_" + this.dbd.getDBId() + this.companyId + this.internalNumber).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public TotalEstimationTransactionDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public TotalEstimationTransactionDataBean getTotalEstimationTransactionDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private TotalEstimationTransactionDataBean getDataBean(TotalEstimationTransactionDataBean bean) throws Exception {
        if (bean == null) {
            bean = new TotalEstimationTransactionDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setInternalNumber(this.getInternalNumber());
        bean.setCreditId(this.getCreditId());
        bean.setDescription(this.getDescription());
        bean.setAssetTypeId(this.getAssetTypeId());
        bean.setEstimationTransactionType(this.getEstimationTransactionType());
        bean.setBBVCategory(this.getBBVCategory());
        bean.setTotalTransactionAmount(this.getTotalTransactionAmount());
        bean.setHasMemo(this.getHasMemo());
        bean.setState(this.getState());
        bean.setDepreciationMethod(this.getDepreciationMethod());
        bean.setStartPeriodHandlingMethod(this.getStartPeriodHandlingMethod());
        bean.setDegressivePercentage(this.getDegressivePercentage());
        bean.setYearPercentageTableId(this.getYearPercentageTableId());
        bean.setAnnuityPercentage(this.getAnnuityPercentage());
        bean.setAnnuityInterestTableId(this.getAnnuityInterestTableId());
        bean.setDepreciatableLife(this.getDepreciatableLife());
        bean.setResidualValue(this.getResidualValue());
        bean.setResidualPercentage(this.getResidualPercentage());
        bean.setInterestCalculationMethod(this.getInterestCalculationMethod());
        bean.setInterestPercentage(this.getInterestPercentage());
        bean.setInterestTableId(this.getInterestTableId());
        return bean;
    }

    public boolean equals(Object object) {
        TotalEstimationTransaction_Impl bo;
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            try {
                                if (object != null && object instanceof TotalEstimationTransaction_Impl) break block8;
                                return false;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e.getMessage());
                            }
                        }
                        bo = (TotalEstimationTransaction_Impl)object;
                        if (bo.getCompanyId() != null) break block9;
                        if (this.getCompanyId() != null) {
                            return false;
                        }
                        break block10;
                    }
                    if (bo.getCompanyId().equals(this.getCompanyId())) break block10;
                    return false;
                }
                if (bo.getInternalNumber() == this.getInternalNumber()) break block11;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block12;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(TotalEstimationTransactionDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(TotalEstimationTransactionDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setInternalNumber(bean.getInternalNumber());
            this.setCreditId(bean.getCreditId());
            this.setDescription(bean.getDescription());
            this.setAssetTypeId(bean.getAssetTypeId());
            this.setEstimationTransactionType(bean.getEstimationTransactionType());
            this.setBBVCategory(bean.getBBVCategory());
            this.setTotalTransactionAmount(bean.getTotalTransactionAmount());
            this.setHasMemo(bean.getHasMemo());
            this.setState(bean.getState());
            this.setDepreciationMethod(bean.getDepreciationMethod());
            this.setStartPeriodHandlingMethod(bean.getStartPeriodHandlingMethod());
            this.setDegressivePercentage(bean.getDegressivePercentage());
            this.setYearPercentageTableId(bean.getYearPercentageTableId());
            this.setAnnuityPercentage(bean.getAnnuityPercentage());
            this.setAnnuityInterestTableId(bean.getAnnuityInterestTableId());
            this.setDepreciatableLife(bean.getDepreciatableLife());
            this.setResidualValue(bean.getResidualValue());
            this.setResidualPercentage(bean.getResidualPercentage());
            this.setInterestCalculationMethod(bean.getInterestCalculationMethod());
            this.setInterestPercentage(bean.getInterestPercentage());
            this.setInterestTableId(bean.getInterestTableId());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "TotalEstimationTransaction is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.TotalEstimationTransaction.save");
        key.append(image.creditId == null ? "0" : "1");
        key.append(image.yearPercentageTableId == null ? "0" : "1");
        key.append(image.annuityInterestTableId == null ? "0" : "1");
        key.append(image.interestTableId == null ? "0" : "1");
        try {
            try {
                int n;
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("InternalNumber", provider) + " = ? " + ", " + pmd.getFieldName("CreditId", provider) + " = ? " + ", " + pmd.getFieldName("Description", provider) + " = ? " + ", " + pmd.getFieldName("AssetTypeId", provider) + " = ? " + ", " + pmd.getFieldName("EstimationTransactionType", provider) + " = ? " + ", " + pmd.getFieldName("BBVCategory", provider) + " = ? " + ", " + pmd.getFieldName("TotalTransactionAmount", provider) + " = ? " + ", " + pmd.getFieldName("HasMemo", provider) + " = ? " + ", " + pmd.getFieldName("State", provider) + " = ? " + ", " + pmd.getFieldName("DepreciationMethod", provider) + " = ? " + ", " + pmd.getFieldName("StartPeriodHandlingMethod", provider) + " = ? " + ", " + pmd.getFieldName("DegressivePercentage", provider) + " = ? " + ", " + pmd.getFieldName("YearPercentageTableId", provider) + " = ? " + ", " + pmd.getFieldName("AnnuityPercentage", provider) + " = ? " + ", " + pmd.getFieldName("AnnuityInterestTableId", provider) + " = ? " + ", " + pmd.getFieldName("DepreciatableLife", provider) + " = ? " + ", " + pmd.getFieldName("ResidualValue", provider) + " = ? " + ", " + pmd.getFieldName("ResidualPercentage", provider) + " = ? " + ", " + pmd.getFieldName("InterestCalculationMethod", provider) + " = ? " + ", " + pmd.getFieldName("InterestPercentage", provider) + " = ? " + ", " + pmd.getFieldName("InterestTableId", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("InternalNumber", provider) + " = ? " + " AND  " + pmd.getFieldName("CreditId", provider) + (image.creditId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("Description", provider) + " = ? " + " AND  " + pmd.getFieldName("AssetTypeId", provider) + " = ? " + " AND  " + pmd.getFieldName("EstimationTransactionType", provider) + " = ? " + " AND  " + pmd.getFieldName("BBVCategory", provider) + " = ? " + " AND  " + pmd.getFieldName("TotalTransactionAmount", provider) + " = ? " + " AND  " + pmd.getFieldName("HasMemo", provider) + " = ? " + " AND  " + pmd.getFieldName("State", provider) + " = ? " + " AND  " + pmd.getFieldName("DepreciationMethod", provider) + " = ? " + " AND  " + pmd.getFieldName("StartPeriodHandlingMethod", provider) + " = ? " + " AND  " + pmd.getFieldName("DegressivePercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("YearPercentageTableId", provider) + (image.yearPercentageTableId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("AnnuityPercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("AnnuityInterestTableId", provider) + (image.annuityInterestTableId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("DepreciatableLife", provider) + " = ? " + " AND  " + pmd.getFieldName("ResidualValue", provider) + " = ? " + " AND  " + pmd.getFieldName("ResidualPercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestCalculationMethod", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestPercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestTableId", provider) + (image.interestTableId == null ? " IS NULL" : " = ?"));
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.internalNumber), mapping.getJDBCTypeFor("int"));
                if (this.creditId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.creditId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)this.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.assetTypeId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.estimationTransactionType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.bBVCategory), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.totalTransactionAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Boolean(this.hasMemo), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(this.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.depreciationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.startPeriodHandlingMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.degressivePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                if (this.yearPercentageTableId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.yearPercentageTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)this.annuityPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (this.annuityInterestTableId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.annuityInterestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(this.depreciatableLife), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.residualValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.residualPercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Integer(this.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (this.interestTableId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.internalNumber), mapping.getJDBCTypeFor("int"));
                if (image.creditId != null) {
                    prep.setObject(parmIndex++, (Object)image.creditId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)image.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.assetTypeId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.estimationTransactionType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.bBVCategory), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.totalTransactionAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Boolean(image.hasMemo), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(image.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.depreciationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.startPeriodHandlingMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.degressivePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                if (image.yearPercentageTableId != null) {
                    prep.setObject(parmIndex++, (Object)image.yearPercentageTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)image.annuityPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (image.annuityInterestTableId != null) {
                    prep.setObject(parmIndex++, (Object)image.annuityInterestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(image.depreciatableLife), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.residualValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.residualPercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Integer(image.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (image.interestTableId != null) {
                    prep.setObject(parmIndex++, (Object)image.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                if ((n = prep.executeUpdate()) == 0) {
                    this.rollback(true);
                    throw new UpdateException("TotalEstimationTransaction modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.TotalEstimationTransaction.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.TotalEstimationTransaction.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("InternalNumber", provider) + ", " + pmd.getFieldName("CreditId", provider) + ", " + pmd.getFieldName("Description", provider) + ", " + pmd.getFieldName("AssetTypeId", provider) + ", " + pmd.getFieldName("EstimationTransactionType", provider) + ", " + pmd.getFieldName("BBVCategory", provider) + ", " + pmd.getFieldName("TotalTransactionAmount", provider) + ", " + pmd.getFieldName("HasMemo", provider) + ", " + pmd.getFieldName("State", provider) + ", " + pmd.getFieldName("DepreciationMethod", provider) + ", " + pmd.getFieldName("StartPeriodHandlingMethod", provider) + ", " + pmd.getFieldName("DegressivePercentage", provider) + ", " + pmd.getFieldName("YearPercentageTableId", provider) + ", " + pmd.getFieldName("AnnuityPercentage", provider) + ", " + pmd.getFieldName("AnnuityInterestTableId", provider) + ", " + pmd.getFieldName("DepreciatableLife", provider) + ", " + pmd.getFieldName("ResidualValue", provider) + ", " + pmd.getFieldName("ResidualPercentage", provider) + ", " + pmd.getFieldName("InterestCalculationMethod", provider) + ", " + pmd.getFieldName("InterestPercentage", provider) + ", " + pmd.getFieldName("InterestTableId", provider) + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)new Integer(this.internalNumber), mapping.getJDBCTypeFor("int"));
                if (this.creditId == null) {
                    prep.setNull(3, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(3, (Object)this.creditId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(4, (Object)this.description, mapping.getJDBCTypeFor("String"));
                prep.setObject(5, (Object)this.assetTypeId, mapping.getJDBCTypeFor("String"));
                prep.setObject(6, (Object)new Integer(this.estimationTransactionType), mapping.getJDBCTypeFor("int"));
                prep.setObject(7, (Object)new Integer(this.bBVCategory), mapping.getJDBCTypeFor("int"));
                prep.setObject(8, (Object)this.totalTransactionAmount, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(9, (Object)new Boolean(this.hasMemo), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(10, (Object)new Integer(this.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(11, (Object)new Integer(this.depreciationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(12, (Object)new Integer(this.startPeriodHandlingMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(13, (Object)this.degressivePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                if (this.yearPercentageTableId == null) {
                    prep.setNull(14, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(14, (Object)this.yearPercentageTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(15, (Object)this.annuityPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (this.annuityInterestTableId == null) {
                    prep.setNull(16, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(16, (Object)this.annuityInterestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(17, (Object)new Integer(this.depreciatableLife), mapping.getJDBCTypeFor("int"));
                prep.setObject(18, (Object)this.residualValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(19, (Object)this.residualPercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(20, (Object)new Integer(this.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(21, (Object)this.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (this.interestTableId == null) {
                    prep.setNull(22, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(22, (Object)this.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.internalNumber = this.currentDBImage.internalNumber;
            this.transactionImage.dbImage.creditId = this.currentDBImage.creditId;
            this.transactionImage.dbImage.description = this.currentDBImage.description;
            this.transactionImage.dbImage.assetTypeId = this.currentDBImage.assetTypeId;
            this.transactionImage.dbImage.estimationTransactionType = this.currentDBImage.estimationTransactionType;
            this.transactionImage.dbImage.bBVCategory = this.currentDBImage.bBVCategory;
            this.transactionImage.dbImage.totalTransactionAmount = this.currentDBImage.totalTransactionAmount;
            this.transactionImage.dbImage.hasMemo = this.currentDBImage.hasMemo;
            this.transactionImage.dbImage.state = this.currentDBImage.state;
            this.transactionImage.dbImage.depreciationMethod = this.currentDBImage.depreciationMethod;
            this.transactionImage.dbImage.startPeriodHandlingMethod = this.currentDBImage.startPeriodHandlingMethod;
            this.transactionImage.dbImage.degressivePercentage = this.currentDBImage.degressivePercentage;
            this.transactionImage.dbImage.yearPercentageTableId = this.currentDBImage.yearPercentageTableId;
            this.transactionImage.dbImage.annuityPercentage = this.currentDBImage.annuityPercentage;
            this.transactionImage.dbImage.annuityInterestTableId = this.currentDBImage.annuityInterestTableId;
            this.transactionImage.dbImage.depreciatableLife = this.currentDBImage.depreciatableLife;
            this.transactionImage.dbImage.residualValue = this.currentDBImage.residualValue;
            this.transactionImage.dbImage.residualPercentage = this.currentDBImage.residualPercentage;
            this.transactionImage.dbImage.interestCalculationMethod = this.currentDBImage.interestCalculationMethod;
            this.transactionImage.dbImage.interestPercentage = this.currentDBImage.interestPercentage;
            this.transactionImage.dbImage.interestTableId = this.currentDBImage.interestTableId;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.internalNumber = this.transactionImage.dbImage.internalNumber;
        this.currentDBImage.creditId = this.transactionImage.dbImage.creditId;
        this.currentDBImage.description = this.transactionImage.dbImage.description;
        this.currentDBImage.assetTypeId = this.transactionImage.dbImage.assetTypeId;
        this.currentDBImage.estimationTransactionType = this.transactionImage.dbImage.estimationTransactionType;
        this.currentDBImage.bBVCategory = this.transactionImage.dbImage.bBVCategory;
        this.currentDBImage.totalTransactionAmount = this.transactionImage.dbImage.totalTransactionAmount;
        this.currentDBImage.hasMemo = this.transactionImage.dbImage.hasMemo;
        this.currentDBImage.state = this.transactionImage.dbImage.state;
        this.currentDBImage.depreciationMethod = this.transactionImage.dbImage.depreciationMethod;
        this.currentDBImage.startPeriodHandlingMethod = this.transactionImage.dbImage.startPeriodHandlingMethod;
        this.currentDBImage.degressivePercentage = this.transactionImage.dbImage.degressivePercentage;
        this.currentDBImage.yearPercentageTableId = this.transactionImage.dbImage.yearPercentageTableId;
        this.currentDBImage.annuityPercentage = this.transactionImage.dbImage.annuityPercentage;
        this.currentDBImage.annuityInterestTableId = this.transactionImage.dbImage.annuityInterestTableId;
        this.currentDBImage.depreciatableLife = this.transactionImage.dbImage.depreciatableLife;
        this.currentDBImage.residualValue = this.transactionImage.dbImage.residualValue;
        this.currentDBImage.residualPercentage = this.transactionImage.dbImage.residualPercentage;
        this.currentDBImage.interestCalculationMethod = this.transactionImage.dbImage.interestCalculationMethod;
        this.currentDBImage.interestPercentage = this.transactionImage.dbImage.interestPercentage;
        this.currentDBImage.interestTableId = this.transactionImage.dbImage.interestTableId;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.internalNumber = this.transactionImage.dbImage.internalNumber;
            this.creditId = this.transactionImage.dbImage.creditId;
            this.description = this.transactionImage.dbImage.description;
            this.assetTypeId = this.transactionImage.dbImage.assetTypeId;
            this.estimationTransactionType = this.transactionImage.dbImage.estimationTransactionType;
            this.bBVCategory = this.transactionImage.dbImage.bBVCategory;
            this.totalTransactionAmount = this.transactionImage.dbImage.totalTransactionAmount;
            this.hasMemo = this.transactionImage.dbImage.hasMemo;
            this.state = this.transactionImage.dbImage.state;
            this.depreciationMethod = this.transactionImage.dbImage.depreciationMethod;
            this.startPeriodHandlingMethod = this.transactionImage.dbImage.startPeriodHandlingMethod;
            this.degressivePercentage = this.transactionImage.dbImage.degressivePercentage;
            this.yearPercentageTableId = this.transactionImage.dbImage.yearPercentageTableId;
            this.annuityPercentage = this.transactionImage.dbImage.annuityPercentage;
            this.annuityInterestTableId = this.transactionImage.dbImage.annuityInterestTableId;
            this.depreciatableLife = this.transactionImage.dbImage.depreciatableLife;
            this.residualValue = this.transactionImage.dbImage.residualValue;
            this.residualPercentage = this.transactionImage.dbImage.residualPercentage;
            this.interestCalculationMethod = this.transactionImage.dbImage.interestCalculationMethod;
            this.interestPercentage = this.transactionImage.dbImage.interestPercentage;
            this.interestTableId = this.transactionImage.dbImage.interestTableId;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private int internalNumber;
        private String creditId;
        private String description;
        private String assetTypeId;
        private int estimationTransactionType;
        private int bBVCategory;
        private BigDecimal totalTransactionAmount;
        private boolean hasMemo;
        private int state;
        private int depreciationMethod;
        private int startPeriodHandlingMethod;
        private BigDecimal degressivePercentage;
        private String yearPercentageTableId;
        private BigDecimal annuityPercentage;
        private String annuityInterestTableId;
        private int depreciatableLife;
        private BigDecimal residualValue;
        private BigDecimal residualPercentage;
        private int interestCalculationMethod;
        private BigDecimal interestPercentage;
        private String interestTableId;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

