/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.ListIterator;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchDataBean;
import nl.ibs.fac.db.TransactionBatchManager;
import nl.ibs.fac.db.TransactionBatchPK;
import nl.ibs.fac.db.TransactionBatchParameterManagerFactory;
import nl.ibs.fac.db.impl.PersistenceMetaDataTransactionBatch;
import nl.ibs.fac.db.impl.TransactionBatch_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.Cache;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.RemoveException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.ListIteratorImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.QueryTranslator;
import nl.ibs.vegas.ExecutableQuery;
import nl.ibs.vegas.meta.AttributeMeta;
import nl.ibs.vegas.meta.impl.CollectionRelationMetaImpl;
import nl.ibs.vegas.meta.impl.FieldMetaImpl;
import nl.ibs.vegas.persistence.Manager;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransactionBatchManager_Impl
extends BusinessObjectManager
implements TransactionBatchManager {
    private static final String APPLICATION = "fac";
    private static DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    private static AttributeAccessor generalAccessor = new AttributeAccessor();
    private static boolean verbose = Log.debug();
    private static PersistenceMetaData pmd = PersistenceMetaDataTransactionBatch.getInstance();
    private static Hashtable instances = new Hashtable();
    private DBData dbd;
    static final String[] keys = new String[]{"companyId", "batchId"};
    static final AttributeMeta[] attributes = new AttributeMeta[]{new FieldMetaImpl("companyId", "txt-company-id", "txt-company-id-short", "txt-company-id-description", "text", String.class, 7, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("batchId", "txt-batch-id", "txt-batch-id-short", "txt-batch-id-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("creationDate", "txt-creation-date", "txt-creation-date-short", "txt-creation-date-description", "date", Date.class, 0, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("createdBy", "txt-created-by", "txt-created-by-short", "txt-created-by-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("processingDate", "txt-processing-date", "txt-processing-date-short", "txt-processing-date-description", "date", Date.class, 0, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("processedBy", "txt-processed-by", "txt-processed-by-short", "txt-processed-by-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("endYear", "txt-end-year", "txt-end-year-short", "txt-end-year-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("endPeriod", "txt-end-period", "txt-end-period-short", "txt-end-period-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "false", "", false, false, null, null), new FieldMetaImpl("finYear", "txt-fin-year", "txt-fin-year-short", "txt-fin-year-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "false", "", false, false, null, null), new FieldMetaImpl("finPeriod", "txt-fin-period", "txt-fin-period-short", "txt-fin-period-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("codeFiscal", "txt-code-fiscal", "txt-code-fiscal-short", "txt-code-fiscal-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("codeAccountingPrinciple2", "txt-code-accounting-principle2", "txt-code-accounting-principle2-short", "txt-code-accounting-principle2-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("batchCode", "txt-batch-code", "txt-batch-code-short", "txt-batch-code-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("state", "txt-state", "txt-state-short", "txt-state-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("recalcInterestPercentage", "txt-recalc-interest-percentage", "txt-recalc-interest-percentage-short", "txt-recalc-interest-percentage-description", "decimal", BigDecimal.class, 6, 3, "0.000", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("financialBatchId", "txt-financial-batch-id", "txt-financial-batch-id-short", "txt-financial-batch-id-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("memberNameFIS", "txt-member-name-f-is", "txt-member-name-f-is-short", "txt-member-name-f-is-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("originatingFACBatchId", "txt-originating-f-a-c-batch-id", "txt-originating-f-a-c-batch-id-short", "txt-originating-f-a-c-batch-id-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("massTransactionProcessType", "txt-mass-transaction-process-type", "txt-mass-transaction-process-type-short", "txt-mass-transaction-process-type-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("voucherId", "txt-voucher-id", "txt-voucher-id-short", "txt-voucher-id-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("voucherDate", "txt-voucher-date", "txt-voucher-date-short", "txt-voucher-date-description", "date", Date.class, 0, 0, null, "false", "false", "", "", false, false, null, null), new CollectionRelationMetaImpl("transactionBatchParameters", "txt-transaction-batch-parameters", "txt-transaction-batch-parameters-short", "txt-transaction-batch-parameters-description", (Manager)TransactionBatchParameterManagerFactory.getInstance(), true)};

    private TransactionBatchManager_Impl(DBData dbData) {
        this.dbd = dbData;
    }

    public static TransactionBatchManager getInstance() {
        return TransactionBatchManager_Impl.getInstance(DBData.getDefaultDBData(APPLICATION));
    }

    public static TransactionBatchManager getInstance(DBData dbd) {
        if (dbd == null) {
            throw new IllegalArgumentException("Tried to instantiate a Manager it DBData = null!");
        }
        TransactionBatchManager_Impl inst = (TransactionBatchManager_Impl)instances.get(dbd);
        if (inst == null) {
            inst = new TransactionBatchManager_Impl(dbd);
            instances.put(dbd, inst);
        }
        return inst;
    }

    public DBData getDBData() {
        return this.dbd;
    }

    @Override
    public TransactionBatch create(TransactionBatchDataBean bean) throws Exception {
        TransactionBatch_Impl impl = new TransactionBatch_Impl(this.dbd, bean);
        impl.assureStorage();
        return impl;
    }

    @Override
    public TransactionBatch create(String _companyId, int _batchId) throws Exception {
        TransactionBatch_Impl obj = new TransactionBatch_Impl(this.dbd, _companyId, _batchId);
        obj.assureStorage();
        return obj;
    }

    private TransactionBatchPK getPK(ResultSet rs) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        TransactionBatchPK inst = new TransactionBatchPK();
        inst.setCompanyId(rs.getString(pmd.getFieldName("CompanyId", provider)));
        inst.setBatchId(rs.getInt(pmd.getFieldName("BatchId", provider)));
        return inst;
    }

    @Override
    public TransactionBatch findOrCreate(TransactionBatchPK key) throws Exception {
        TransactionBatch obj;
        try {
            obj = this.findByPrimaryKey(key);
        }
        catch (FinderException e) {
            obj = this.create(key.getCompanyId(), key.getBatchId());
        }
        return obj;
    }

    @Override
    public void add(TransactionBatchDataBean inst) throws Exception {
        TransactionBatch_Impl impl = new TransactionBatch_Impl(this.dbd, inst);
        impl.assureStorage();
    }

    @Override
    public void removeByPrimaryKey(TransactionBatchPK key) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        TransactionBatch cachedObject = this.getCachedObjectByPrimaryKey(key);
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate((BusinessObject_Impl)((Object)cachedObject)) : provider.getConnection();
        String pskey = "nl.ibs.fac.db.TransactionBatch.removeByPrimaryKey";
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(pskey);
                if (prep == null) {
                    prep = dbc.getPreparedStatement(pskey, " DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=?" + " AND " + pmd.getFieldName("BatchId", provider) + "=?");
                }
                prep.setString(1, key.getCompanyId());
                prep.setInt(2, key.getBatchId());
                int x = prep.executeUpdate();
                if (x == 0) {
                    throw new RemoveException("Key not found");
                }
                if (cachedObject != null) {
                    DBPersistenceManager.removeFromCache(cachedObject);
                }
            }
            catch (SQLException e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public TransactionBatch findByPrimaryKey(TransactionBatchPK key) throws Exception {
        TransactionBatch transactionBatch = this.getCachedObjectByPrimaryKey(key);
        if (transactionBatch != null) {
            return transactionBatch;
        }
        ResultSet rs = null;
        try {
            rs = this.getResultSet(key);
            TransactionBatch transactionBatch2 = (TransactionBatch)this.getBusinessObject(rs);
            return transactionBatch2;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public ResultSet getResultSet(TransactionBatchPK key) throws Exception {
        ResultSet rs = null;
        String pskey = "nl.ibs.fac.db.TransactionBatch.findByPrimaryKey1";
        Object inst = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(pskey);
                if (prep == null) {
                    prep = dbc.getPreparedStatement(pskey, " SELECT *  FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=?" + " AND " + pmd.getFieldName("BatchId", provider) + "=?");
                }
                prep.setString(1, key.getCompanyId());
                prep.setInt(2, key.getBatchId());
                prep.executeQuery();
                rs = prep.getResultSet();
                if (!rs.next()) {
                    throw new FinderException("Key not found");
                }
            }
            catch (SQLException e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
        return rs;
    }

    public TransactionBatch getCachedObjectByPrimaryKey(TransactionBatchPK key) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache == null) {
            return null;
        }
        Object o = cache.get(new String("-453853438_" + this.dbd.getDBId() + key.getCompanyId() + key.getBatchId()));
        return (TransactionBatch)o;
    }

    @Override
    public ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public int getBatchIdMax(String _companyId) throws Exception {
        ResultSet rs = null;
        int result = 0;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            try {
                String pskey = "nl.ibs.fac.db.TransactionBatch.getBatchIdMax_1737665094";
                PreparedStatement prep = dbc.getPreparedStatement(pskey);
                if (prep == null) {
                    prep = dbc.getPreparedStatement(pskey, " SELECT   MAX(" + pmd.getFieldName("BatchId", provider) + ")" + " FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? ", 0);
                }
                prep.setObject(1, (Object)_companyId, mapping.getJDBCTypeFor("String"));
                rs = prep.executeQuery();
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
        return result;
    }

    @Override
    public int generalUpdate(String setClause, String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String update = "UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + QueryTranslator.translateObjectQuery(String.valueOf(setClause) + " WHERE " + whereClause, pmd, provider);
            int n = dbc.executeUpdate(update);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public int generalDelete(String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String delete = "DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + QueryTranslator.translateObjectQuery(whereClause, pmd, provider);
            int n = dbc.executeUpdate(delete);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public TransactionBatch getFirstObject(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create();
        }
        int prevMax = query.getMaxObjects();
        query.setMaxObjects(1);
        try {
            TransactionBatch transactionBatch = (TransactionBatch)((QueryImplementation)query).execute(this, (short)0);
            return transactionBatch;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            query.setMaxObjects(prevMax);
        }
    }

    @Override
    public Collection getCollection(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Collection)queryImpl.execute(this, (short)-1);
    }

    public ListIterator getListIterator(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ListIterator)queryImpl.execute(this, (short)-2);
    }

    @Override
    public Document getDocument(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Document)queryImpl.execute(this, (short)-3);
    }

    @Override
    public DocumentFragment getDocumentFragment(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (DocumentFragment)queryImpl.execute(this, (short)-4);
    }

    @Override
    public ArrayList getDocumentFragmentArrayList(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ArrayList)queryImpl.execute(this, (short)-5);
    }

    @Override
    protected Collection getCollection(ResultSet rs) throws Exception {
        ArrayListImpl result = new ArrayListImpl();
        while (rs.next()) {
            ((ArrayList)result).add(this.getBusinessObject(rs));
        }
        return result;
    }

    @Override
    protected Document getDocument(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        Element root = document.getDocumentElement();
        this.collectResultElements(resultSet, root, this.getConnectionProvider());
        return document;
    }

    @Override
    protected DocumentFragment getDocumentFragment(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.collectResultElements(resultSet, documentFragment, this.getConnectionProvider());
        return documentFragment;
    }

    @Override
    protected ArrayList getDocumentFragmentArrayList(ResultSet resultSet) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        Document document = domImplementation.createDocument("", "data", null);
        ArrayListImpl arrayList = new ArrayListImpl();
        while (resultSet.next()) {
            DocumentFragment documentFragment = document.createDocumentFragment();
            Node rec = documentFragment.appendChild(document.createElement("transactionbatch"));
            TransactionBatchManager_Impl.addBOFieldsToElement(resultSet, rec, provider);
            ((ArrayList)arrayList).add(documentFragment);
        }
        return arrayList;
    }

    @Override
    protected ListIterator getListIterator(ResultSet rs) throws Exception {
        ListIteratorImpl result = new ListIteratorImpl();
        while (rs.next()) {
            result.add(this.getBusinessObject(rs));
        }
        result.pointer = 0;
        return result;
    }

    @Override
    protected Object getBusinessObject(ResultSet rs) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache != null) {
            ConnectionProvider provider = this.getConnectionProvider();
            Object o = cache.get(new String("-453853438_" + this.dbd.getDBId() + rs.getObject(pmd.getFieldName("CompanyId", provider)) + rs.getObject(pmd.getFieldName("BatchId", provider))));
            if (o != null) {
                return o;
            }
        }
        return DBPersistenceManager.cache(this.createBusinessObject(rs));
    }

    private Object createBusinessObject(ResultSet rs) throws Exception {
        return new TransactionBatch_Impl(this.dbd, rs);
    }

    private void collectResultElements(ResultSet rs, Node root, ConnectionProvider provider) throws Exception {
        Document doc = root.getOwnerDocument();
        while (rs.next()) {
            Node rec = root.appendChild(doc.createElement("transactionbatch"));
            TransactionBatchManager_Impl.addBOFieldsToElement(rs, rec, provider);
        }
    }

    public static void addBOFieldsToElement(ResultSet rs, Node rec, ConnectionProvider provider) throws Exception {
        DBMapping mapping = provider.getDBMapping();
        Document doc = rec.getOwnerDocument();
        Object o = null;
        String s = null;
        s = rs.getString(pmd.getFieldName("CompanyId", provider));
        if (s != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("companyid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("BatchId", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("batchid")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getDate(pmd.getFieldName("CreationDate", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("creationdate")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("CreatedBy", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("createdby")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getDate(pmd.getFieldName("ProcessingDate", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("processingdate")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("ProcessedBy", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("processedby")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("EndYear", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("endyear")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("EndPeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("endperiod")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("FinYear", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("finyear")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("FinPeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("finperiod")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("CodeFiscal", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("codefiscal")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("CodeAccountingPrinciple2", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("codeaccountingprinciple2")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("BatchCode", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("batchcode")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("State", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("state")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("RecalcInterestPercentage", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("recalcinterestpercentage")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("FinancialBatchId", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("financialbatchid")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("MemberNameFIS", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("membernamefis")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("OriginatingFACBatchId", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("originatingfacbatchid")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("MassTransactionProcessType", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("masstransactionprocesstype")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("VoucherId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("voucherid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getDate(pmd.getFieldName("VoucherDate", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("voucherdate")).appendChild(doc.createTextNode(s));
        }
    }

    public ExecutableQuery getExecutableQuery() {
        return QueryFactory.create(this);
    }

    public String[] getKeyNames() {
        return keys;
    }

    public AttributeMeta[] getAttributes() {
        return attributes;
    }

    public Class getClassType() {
        return TransactionBatch.class;
    }

    public String getNameField() {
        return "batchId";
    }

    public String getDescriptionField() {
        return "batchId";
    }

    public String getTextKey() {
        return "txt-transaction-batch";
    }

    public String getTextKeyShort() {
        return "txt-transaction-batch-short";
    }

    public String getTextKeyDescription() {
        return "txt-transaction-batch-description";
    }

    public AttributeMeta getAttribute(String name) {
        if (attributes == null || name == null) {
            return null;
        }
        int i = 0;
        while (i < attributes.length) {
            if (name.equals(attributes[i].getName())) {
                return attributes[i];
            }
            ++i;
        }
        return null;
    }
}

