/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchPK;
import nl.ibs.fac.db.TransactionBatchParameter;
import nl.ibs.fac.db.TransactionBatchParameterDataBean;
import nl.ibs.fac.db.TransactionBatchParameterPK;
import nl.ibs.fac.db.impl.PersistenceMetaDataTransactionBatchParameter;
import nl.ibs.fac.db.impl.TransactionBatchManager_Impl;
import nl.ibs.fac.db.impl.TransactionBatchParameterManager_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;

public class TransactionBatchParameter_Impl
implements TransactionBatchParameter,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataTransactionBatchParameter.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected int batchId;
    protected String parameterName;
    protected String parameterValue;

    protected TransactionBatchParameter_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected TransactionBatchParameter_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected TransactionBatchParameter_Impl(DBData _dbd, String _companyId, int _batchId, String _parameterName) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setBatchId(_batchId);
            this.setParameterName(_parameterName);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected TransactionBatchParameter_Impl(DBData _dbd, TransactionBatchParameterDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.TransactionBatchParameterDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate TransactionBatchParameter with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.TransactionBatchParameterDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setBatchId(bean.getBatchId());
            this.setParameterName(bean.getParameterName());
            this.setParameterValue(bean.getParameterValue());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public TransactionBatchParameter_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.batchId = rs.getInt(pmd.getFieldName("BatchId", provider));
        this.parameterName = rs.getString(pmd.getFieldName("ParameterName", provider));
        this.parameterValue = rs.getString(pmd.getFieldName("ParameterValue", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        TransactionBatchParameterPK key = new TransactionBatchParameterPK();
        key.setCompanyId(this.getCompanyId());
        key.setBatchId(this.getBatchId());
        key.setParameterName(this.getParameterName());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public int getBatchId() throws Exception {
        this.assureStorage();
        return this.batchId;
    }

    @Override
    public String getParameterName() throws Exception {
        this.assureStorage();
        return this.parameterName;
    }

    @Override
    public String getParameterValue() throws Exception {
        return this.parameterValue;
    }

    @Override
    public TransactionBatch getOwnedByTransactionBatchAsTransactionBatchParameters() throws Exception {
        if (this.isCachedRelation("ownedByTransactionBatchAsTransactionBatchParameters")) {
            return (TransactionBatch)this.getCachedRelationObject("ownedByTransactionBatchAsTransactionBatchParameters");
        }
        TransactionBatchPK primaryKey = new TransactionBatchPK();
        primaryKey.setCompanyId(this.getCompanyId());
        primaryKey.setBatchId(this.getBatchId());
        try {
            return (TransactionBatch)this.addCachedRelationObject("ownedByTransactionBatchAsTransactionBatchParameters", ((TransactionBatchManager_Impl)TransactionBatchManager_Impl.getInstance(this.dbd)).findByPrimaryKey(primaryKey));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        TransactionBatch owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByTransactionBatchAsTransactionBatchParameters();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setBatchId(int _batchId) throws Exception {
        if (_batchId == this.getBatchId()) {
            return;
        }
        this.preSet();
        this.batchId = _batchId;
        this.autoUpdate();
    }

    public void setParameterName(String _parameterName) throws Exception {
        if (_parameterName == null) {
            _parameterName = "";
        }
        if (_parameterName.equals(this.getParameterName())) {
            return;
        }
        this.preSet();
        this.parameterName = _parameterName;
        this.autoUpdate();
    }

    @Override
    public void setParameterValue(String _parameterValue) throws Exception {
        if (_parameterValue == null) {
            _parameterValue = "";
        }
        if (_parameterValue.equals(this.getParameterValue())) {
            return;
        }
        this.preSet();
        this.parameterValue = _parameterValue;
        this.autoUpdate();
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.batchId = 0;
        this.parameterName = "";
        this.parameterValue = "";
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.batchId = this.batchId;
        this.currentDBImage.parameterName = this.parameterName;
        this.currentDBImage.parameterValue = this.parameterValue;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("TransactionBatchParameter is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            TransactionBatchParameterPK key = new TransactionBatchParameterPK();
            key.setCompanyId(this.getCompanyId());
            key.setBatchId(this.getBatchId());
            key.setParameterName(this.getParameterName());
            ((TransactionBatchParameterManager_Impl)TransactionBatchParameterManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((TransactionBatchParameterManager_Impl)TransactionBatchParameterManager_Impl.getInstance(this.dbd)).getResultSet((TransactionBatchParameterPK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("725079751_" + this.dbd.getDBId() + this.companyId + this.batchId + this.parameterName).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public TransactionBatchParameterDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public TransactionBatchParameterDataBean getTransactionBatchParameterDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private TransactionBatchParameterDataBean getDataBean(TransactionBatchParameterDataBean bean) throws Exception {
        if (bean == null) {
            bean = new TransactionBatchParameterDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setBatchId(this.getBatchId());
        bean.setParameterName(this.getParameterName());
        bean.setParameterValue(this.getParameterValue());
        return bean;
    }

    public boolean equals(Object object) {
        TransactionBatchParameter_Impl bo;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    try {
                                        if (object != null && object instanceof TransactionBatchParameter_Impl) break block11;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e.getMessage());
                                    }
                                }
                                bo = (TransactionBatchParameter_Impl)object;
                                if (bo.getCompanyId() != null) break block12;
                                if (this.getCompanyId() != null) {
                                    return false;
                                }
                                break block13;
                            }
                            if (bo.getCompanyId().equals(this.getCompanyId())) break block13;
                            return false;
                        }
                        if (bo.getBatchId() == this.getBatchId()) break block14;
                        return false;
                    }
                    if (bo.getParameterName() != null) break block15;
                    if (this.getParameterName() != null) {
                        return false;
                    }
                    break block16;
                }
                if (bo.getParameterName().equals(this.getParameterName())) break block16;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block17;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(TransactionBatchParameterDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(TransactionBatchParameterDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setBatchId(bean.getBatchId());
            this.setParameterName(bean.getParameterName());
            this.setParameterValue(bean.getParameterValue());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "TransactionBatchParameter is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.TransactionBatchParameter.save");
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("BatchId", provider) + " = ? " + ", " + pmd.getFieldName("ParameterName", provider) + " = ? " + ", " + pmd.getFieldName("ParameterValue", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("BatchId", provider) + " = ? " + " AND  " + pmd.getFieldName("ParameterName", provider) + " = ? " + " AND  " + pmd.getFieldName("ParameterValue", provider) + " = ? ");
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.batchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.parameterName, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.parameterValue, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.batchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.parameterName, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.parameterValue, mapping.getJDBCTypeFor("String"));
                int n = prep.executeUpdate();
                if (n == 0) {
                    this.rollback(true);
                    throw new UpdateException("TransactionBatchParameter modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.TransactionBatchParameter.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.TransactionBatchParameter.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("BatchId", provider) + ", " + pmd.getFieldName("ParameterName", provider) + ", " + pmd.getFieldName("ParameterValue", provider) + ") VALUES (?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)new Integer(this.batchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(3, (Object)this.parameterName, mapping.getJDBCTypeFor("String"));
                prep.setObject(4, (Object)this.parameterValue, mapping.getJDBCTypeFor("String"));
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.batchId = this.currentDBImage.batchId;
            this.transactionImage.dbImage.parameterName = this.currentDBImage.parameterName;
            this.transactionImage.dbImage.parameterValue = this.currentDBImage.parameterValue;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.batchId = this.transactionImage.dbImage.batchId;
        this.currentDBImage.parameterName = this.transactionImage.dbImage.parameterName;
        this.currentDBImage.parameterValue = this.transactionImage.dbImage.parameterValue;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.batchId = this.transactionImage.dbImage.batchId;
            this.parameterName = this.transactionImage.dbImage.parameterName;
            this.parameterValue = this.transactionImage.dbImage.parameterValue;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private int batchId;
        private String parameterName;
        private String parameterValue;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

