/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchDataBean;
import nl.ibs.fac.db.TransactionBatchPK;
import nl.ibs.fac.db.TransactionBatchParameter;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataTransactionBatch;
import nl.ibs.fac.db.impl.PersistenceMetaDataTransactionBatchParameter;
import nl.ibs.fac.db.impl.TransactionBatchManager_Impl;
import nl.ibs.fac.db.impl.TransactionBatchParameterManager_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class TransactionBatch_Impl
implements TransactionBatch,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataTransactionBatch.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected int batchId;
    protected Date creationDate;
    protected String createdBy;
    protected Date processingDate;
    protected String processedBy;
    protected int endYear;
    protected int endPeriod;
    protected int finYear;
    protected int finPeriod;
    protected boolean codeFiscal;
    protected boolean codeAccountingPrinciple2;
    protected int batchCode;
    protected int state;
    protected BigDecimal recalcInterestPercentage;
    protected int financialBatchId;
    protected String memberNameFIS;
    protected int originatingFACBatchId;
    protected int massTransactionProcessType;
    protected String voucherId;
    protected Date voucherDate;

    protected TransactionBatch_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected TransactionBatch_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected TransactionBatch_Impl(DBData _dbd, String _companyId, int _batchId) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setBatchId(_batchId);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected TransactionBatch_Impl(DBData _dbd, TransactionBatchDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.TransactionBatchDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate TransactionBatch with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.TransactionBatchDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setBatchId(bean.getBatchId());
            this.setCreationDate(bean.getCreationDate());
            this.setCreatedBy(bean.getCreatedBy());
            this.setProcessingDate(bean.getProcessingDate());
            this.setProcessedBy(bean.getProcessedBy());
            this.setEndYear(bean.getEndYear());
            this.setEndPeriod(bean.getEndPeriod());
            this.setFinYear(bean.getFinYear());
            this.setFinPeriod(bean.getFinPeriod());
            this.setCodeFiscal(bean.getCodeFiscal());
            this.setCodeAccountingPrinciple2(bean.getCodeAccountingPrinciple2());
            this.setBatchCode(bean.getBatchCode());
            this.setState(bean.getState());
            this.setRecalcInterestPercentage(bean.getRecalcInterestPercentage());
            this.setFinancialBatchId(bean.getFinancialBatchId());
            this.setMemberNameFIS(bean.getMemberNameFIS());
            this.setOriginatingFACBatchId(bean.getOriginatingFACBatchId());
            this.setMassTransactionProcessType(bean.getMassTransactionProcessType());
            this.setVoucherId(bean.getVoucherId());
            this.setVoucherDate(bean.getVoucherDate());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public TransactionBatch_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.batchId = rs.getInt(pmd.getFieldName("BatchId", provider));
        this.creationDate = rs.getDate(pmd.getFieldName("CreationDate", provider));
        this.createdBy = rs.getString(pmd.getFieldName("CreatedBy", provider));
        this.processingDate = rs.getDate(pmd.getFieldName("ProcessingDate", provider));
        this.processedBy = rs.getString(pmd.getFieldName("ProcessedBy", provider));
        this.endYear = rs.getInt(pmd.getFieldName("EndYear", provider));
        this.endPeriod = rs.getInt(pmd.getFieldName("EndPeriod", provider));
        this.finYear = rs.getInt(pmd.getFieldName("FinYear", provider));
        this.finPeriod = rs.getInt(pmd.getFieldName("FinPeriod", provider));
        this.codeFiscal = rs.getBoolean(pmd.getFieldName("CodeFiscal", provider));
        this.codeAccountingPrinciple2 = rs.getBoolean(pmd.getFieldName("CodeAccountingPrinciple2", provider));
        this.batchCode = rs.getInt(pmd.getFieldName("BatchCode", provider));
        this.state = rs.getInt(pmd.getFieldName("State", provider));
        this.recalcInterestPercentage = rs.getBigDecimal(pmd.getFieldName("RecalcInterestPercentage", provider));
        this.financialBatchId = rs.getInt(pmd.getFieldName("FinancialBatchId", provider));
        this.memberNameFIS = rs.getString(pmd.getFieldName("MemberNameFIS", provider));
        this.originatingFACBatchId = rs.getInt(pmd.getFieldName("OriginatingFACBatchId", provider));
        this.massTransactionProcessType = rs.getInt(pmd.getFieldName("MassTransactionProcessType", provider));
        this.voucherId = rs.getString(pmd.getFieldName("VoucherId", provider));
        this.voucherDate = rs.getDate(pmd.getFieldName("VoucherDate", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        TransactionBatchPK key = new TransactionBatchPK();
        key.setCompanyId(this.getCompanyId());
        key.setBatchId(this.getBatchId());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public int getBatchId() throws Exception {
        this.assureStorage();
        return this.batchId;
    }

    @Override
    public java.util.Date getCreationDate() throws Exception {
        java.util.Date obj = this.creationDate == null ? null : new java.util.Date(this.creationDate.getTime());
        return obj;
    }

    @Override
    public String getCreatedBy() throws Exception {
        return this.createdBy;
    }

    @Override
    public java.util.Date getProcessingDate() throws Exception {
        java.util.Date obj = this.processingDate == null ? null : new java.util.Date(this.processingDate.getTime());
        return obj;
    }

    @Override
    public String getProcessedBy() throws Exception {
        return this.processedBy;
    }

    @Override
    public int getEndYear() throws Exception {
        return this.endYear;
    }

    @Override
    public int getEndPeriod() throws Exception {
        return this.endPeriod;
    }

    @Override
    public int getFinYear() throws Exception {
        return this.finYear;
    }

    @Override
    public int getFinPeriod() throws Exception {
        return this.finPeriod;
    }

    @Override
    public boolean getCodeFiscal() throws Exception {
        return this.codeFiscal;
    }

    @Override
    public boolean getCodeAccountingPrinciple2() throws Exception {
        return this.codeAccountingPrinciple2;
    }

    @Override
    public int getBatchCode() throws Exception {
        return this.batchCode;
    }

    @Override
    public int getState() throws Exception {
        return this.state;
    }

    @Override
    public BigDecimal getRecalcInterestPercentage() throws Exception {
        return this.recalcInterestPercentage;
    }

    @Override
    public int getFinancialBatchId() throws Exception {
        return this.financialBatchId;
    }

    @Override
    public String getMemberNameFIS() throws Exception {
        return this.memberNameFIS;
    }

    @Override
    public int getOriginatingFACBatchId() throws Exception {
        return this.originatingFACBatchId;
    }

    @Override
    public int getMassTransactionProcessType() throws Exception {
        return this.massTransactionProcessType;
    }

    @Override
    public String getVoucherId() throws Exception {
        return this.voucherId;
    }

    @Override
    public java.util.Date getVoucherDate() throws Exception {
        java.util.Date obj = this.voucherDate == null ? null : new java.util.Date(this.voucherDate.getTime());
        return obj;
    }

    @Override
    public TransactionBatchParameter getTransactionBatchParametersObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "companyId = ?companyId AND batchId = ?batchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("batchId", this.getBatchId());
        queryImpl.setRelationFilter("companyId = ?companyId AND batchId = ?batchId");
        return TransactionBatchParameterManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getTransactionBatchParametersCollection(Query query) throws Exception {
        boolean nullQuery;
        boolean bl = nullQuery = query == null;
        if (nullQuery && this.isCachedRelation("TransactionBatchParametersCollection")) {
            return (Collection)this.getCachedRelationObject("TransactionBatchParametersCollection");
        }
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND batchId = ?batchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("batchId", this.getBatchId());
        queryImpl.setRelationFilter("companyId = ?companyId AND batchId = ?batchId");
        if (nullQuery) {
            return (Collection)this.addCachedRelationObject("TransactionBatchParametersCollection", TransactionBatchParameterManager_Impl.getInstance(this.dbd).getCollection(query));
        }
        return TransactionBatchParameterManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getTransactionBatchParametersDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "companyId = ?companyId AND batchId = ?batchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("batchId", this.getBatchId());
        queryImpl.setRelationFilter("companyId = ?companyId AND batchId = ?batchId");
        return TransactionBatchParameterManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getTransactionBatchParametersDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "companyId = ?companyId AND batchId = ?batchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("batchId", this.getBatchId());
        queryImpl.setRelationFilter("companyId = ?companyId AND batchId = ?batchId");
        return TransactionBatchParameterManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getTransactionBatchParametersDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "companyId = ?companyId AND batchId = ?batchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("companyId", this.getCompanyId());
        queryImpl.setParameter("batchId", this.getBatchId());
        queryImpl.setRelationFilter("companyId = ?companyId AND batchId = ?batchId");
        return TransactionBatchParameterManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public Company getOwnedByCompanyAsTransactionBatches() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsTransactionBatches")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsTransactionBatches");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsTransactionBatches", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Company owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsTransactionBatches();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    @Override
    public Company getCompanysReferencingTransactionBatchAsCurrentTransactionBatchObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "id = ?id AND currentBatchId = ?currentBatchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("id", this.getCompanyId());
        queryImpl.setParameter("currentBatchId", this.getBatchId());
        queryImpl.setRelationFilter("id = ?id AND currentBatchId = ?currentBatchId");
        return CompanyManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getCompanysReferencingTransactionBatchAsCurrentTransactionBatchCollection(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "id = ?id AND currentBatchId = ?currentBatchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("id", this.getCompanyId());
        queryImpl.setParameter("currentBatchId", this.getBatchId());
        queryImpl.setRelationFilter("id = ?id AND currentBatchId = ?currentBatchId");
        return CompanyManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getCompanysReferencingTransactionBatchAsCurrentTransactionBatchDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "id = ?id AND currentBatchId = ?currentBatchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("id", this.getCompanyId());
        queryImpl.setParameter("currentBatchId", this.getBatchId());
        queryImpl.setRelationFilter("id = ?id AND currentBatchId = ?currentBatchId");
        return CompanyManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getCompanysReferencingTransactionBatchAsCurrentTransactionBatchDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "id = ?id AND currentBatchId = ?currentBatchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("id", this.getCompanyId());
        queryImpl.setParameter("currentBatchId", this.getBatchId());
        queryImpl.setRelationFilter("id = ?id AND currentBatchId = ?currentBatchId");
        return CompanyManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getCompanysReferencingTransactionBatchAsCurrentTransactionBatchDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "id = ?id AND currentBatchId = ?currentBatchId";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("id", this.getCompanyId());
        queryImpl.setParameter("currentBatchId", this.getBatchId());
        queryImpl.setRelationFilter("id = ?id AND currentBatchId = ?currentBatchId");
        return CompanyManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public Collection referencedByBusinessObjects() throws Exception {
        ArrayList list = new ArrayList();
        list.addAll(this.getCompanysReferencingTransactionBatchAsCurrentTransactionBatchCollection(null));
        return list;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setBatchId(int _batchId) throws Exception {
        if (_batchId == this.getBatchId()) {
            return;
        }
        this.preSet();
        this.batchId = _batchId;
        this.autoUpdate();
    }

    @Override
    public void setCreationDate(java.util.Date _creationDate) throws Exception {
        if (_creationDate == null ? this.getCreationDate() == null : _creationDate.equals(this.getCreationDate())) {
            return;
        }
        this.preSet();
        this.creationDate = _creationDate == null ? null : new Date(_creationDate.getTime());
        this.autoUpdate();
    }

    @Override
    public void setCreatedBy(String _createdBy) throws Exception {
        if (_createdBy == null) {
            _createdBy = "";
        }
        if (_createdBy.equals(this.getCreatedBy())) {
            return;
        }
        this.preSet();
        this.createdBy = _createdBy;
        this.autoUpdate();
    }

    @Override
    public void setProcessingDate(java.util.Date _processingDate) throws Exception {
        if (_processingDate == null ? this.getProcessingDate() == null : _processingDate.equals(this.getProcessingDate())) {
            return;
        }
        this.preSet();
        this.processingDate = _processingDate == null ? null : new Date(_processingDate.getTime());
        this.autoUpdate();
    }

    @Override
    public void setProcessedBy(String _processedBy) throws Exception {
        if (_processedBy == null) {
            _processedBy = "";
        }
        if (_processedBy.equals(this.getProcessedBy())) {
            return;
        }
        this.preSet();
        this.processedBy = _processedBy;
        this.autoUpdate();
    }

    @Override
    public void setEndYear(int _endYear) throws Exception {
        if (_endYear == this.getEndYear()) {
            return;
        }
        this.preSet();
        this.endYear = _endYear;
        this.autoUpdate();
    }

    @Override
    public void setEndPeriod(int _endPeriod) throws Exception {
        if (_endPeriod == this.getEndPeriod()) {
            return;
        }
        this.preSet();
        this.endPeriod = _endPeriod;
        this.autoUpdate();
    }

    @Override
    public void setFinYear(int _finYear) throws Exception {
        if (_finYear == this.getFinYear()) {
            return;
        }
        this.preSet();
        this.finYear = _finYear;
        this.autoUpdate();
    }

    @Override
    public void setFinPeriod(int _finPeriod) throws Exception {
        if (_finPeriod == this.getFinPeriod()) {
            return;
        }
        this.preSet();
        this.finPeriod = _finPeriod;
        this.autoUpdate();
    }

    @Override
    public void setCodeFiscal(boolean _codeFiscal) throws Exception {
        if (_codeFiscal == this.getCodeFiscal()) {
            return;
        }
        this.preSet();
        this.codeFiscal = _codeFiscal;
        this.autoUpdate();
    }

    @Override
    public void setCodeAccountingPrinciple2(boolean _codeAccountingPrinciple2) throws Exception {
        if (_codeAccountingPrinciple2 == this.getCodeAccountingPrinciple2()) {
            return;
        }
        this.preSet();
        this.codeAccountingPrinciple2 = _codeAccountingPrinciple2;
        this.autoUpdate();
    }

    @Override
    public void setBatchCode(int _batchCode) throws Exception {
        if (_batchCode == this.getBatchCode()) {
            return;
        }
        this.preSet();
        this.batchCode = _batchCode;
        this.autoUpdate();
    }

    @Override
    public void setState(int _state) throws Exception {
        if (_state == this.getState()) {
            return;
        }
        this.preSet();
        this.state = _state;
        this.autoUpdate();
    }

    @Override
    public void setRecalcInterestPercentage(BigDecimal _recalcInterestPercentage) throws Exception {
        if (_recalcInterestPercentage == null) {
            _recalcInterestPercentage = new BigDecimal("0.000").setScale(3, 6);
        }
        if (_recalcInterestPercentage.equals(this.getRecalcInterestPercentage())) {
            return;
        }
        this.preSet();
        this.recalcInterestPercentage = _recalcInterestPercentage;
        this.autoUpdate();
    }

    @Override
    public void setFinancialBatchId(int _financialBatchId) throws Exception {
        if (_financialBatchId == this.getFinancialBatchId()) {
            return;
        }
        this.preSet();
        this.financialBatchId = _financialBatchId;
        this.autoUpdate();
    }

    @Override
    public void setMemberNameFIS(String _memberNameFIS) throws Exception {
        if (_memberNameFIS == null) {
            _memberNameFIS = "";
        }
        if (_memberNameFIS.equals(this.getMemberNameFIS())) {
            return;
        }
        this.preSet();
        this.memberNameFIS = _memberNameFIS;
        this.autoUpdate();
    }

    @Override
    public void setOriginatingFACBatchId(int _originatingFACBatchId) throws Exception {
        if (_originatingFACBatchId == this.getOriginatingFACBatchId()) {
            return;
        }
        this.preSet();
        this.originatingFACBatchId = _originatingFACBatchId;
        this.autoUpdate();
    }

    @Override
    public void setMassTransactionProcessType(int _massTransactionProcessType) throws Exception {
        if (_massTransactionProcessType == this.getMassTransactionProcessType()) {
            return;
        }
        this.preSet();
        this.massTransactionProcessType = _massTransactionProcessType;
        this.autoUpdate();
    }

    @Override
    public void setVoucherId(String _voucherId) throws Exception {
        if (_voucherId == null) {
            _voucherId = "";
        }
        if (_voucherId.equals(this.getVoucherId())) {
            return;
        }
        this.preSet();
        this.voucherId = _voucherId;
        this.autoUpdate();
    }

    @Override
    public void setVoucherDate(java.util.Date _voucherDate) throws Exception {
        if (_voucherDate == null ? this.getVoucherDate() == null : _voucherDate.equals(this.getVoucherDate())) {
            return;
        }
        this.preSet();
        this.voucherDate = _voucherDate == null ? null : new Date(_voucherDate.getTime());
        this.autoUpdate();
    }

    @Override
    public void addTransactionBatchParameters(Collection collection) throws Exception {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.addTransactionBatchParameters((TransactionBatchParameter)it.next());
        }
    }

    @Override
    public void addTransactionBatchParameters(TransactionBatchParameter object) throws Exception {
        if (object != null) {
            if (!PersistenceMetaDataTransactionBatchParameter.getInstance().isPersistable(object)) {
                throw new Exception("Tried to attach to a TransactionBatch an TransactionBatchParameter that is not valid implementation class!!");
            }
            if (generalAccessor.getObjectAttribute(object, "companyId") != null) {
                throw new Exception("Tried to attach to a TransactionBatch a TransactionBatchParameter that is allready owned (by a TransactionBatch");
            }
            this.assureStorage();
            object.preSet();
            generalAccessor.setAttribute((Object)object, "companyId", this.getCompanyId());
            generalAccessor.setAttribute((Object)object, "batchId", this.getBatchId());
            ((BusinessObject_Impl)((Object)object)).save();
            ((BusinessObject_Impl)((Object)object)).addCachedRelationObject("ownedByTransactionBatchAsTransactionBatchParameters", this);
        }
        this.clearCachedRelation("TransactionBatchParametersCollection");
    }

    @Override
    public void removeTransactionBatchParameters(Collection collection) throws Exception {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.removeTransactionBatchParameters((TransactionBatchParameter)it.next());
        }
    }

    @Override
    public void removeTransactionBatchParameters(TransactionBatchParameter object) throws Exception {
        if (object != null) {
            object.delete();
            this.clearCachedRelation("TransactionBatchParametersCollection");
            ((BusinessObject_Impl)((Object)object)).clearCachedRelation("ownedByTransactionBatchAsTransactionBatchParameters");
        }
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.batchId = 0;
        this.createdBy = "";
        this.processedBy = "";
        this.endYear = 0;
        this.endPeriod = 0;
        this.finYear = 0;
        this.finPeriod = 0;
        this.codeFiscal = false;
        this.codeAccountingPrinciple2 = false;
        this.batchCode = 0;
        this.state = 0;
        this.recalcInterestPercentage = new BigDecimal("0.000").setScale(3, 6);
        this.financialBatchId = 0;
        this.memberNameFIS = "";
        this.originatingFACBatchId = 0;
        this.massTransactionProcessType = 0;
        this.voucherId = "";
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.batchId = this.batchId;
        this.currentDBImage.creationDate = this.creationDate;
        this.currentDBImage.createdBy = this.createdBy;
        this.currentDBImage.processingDate = this.processingDate;
        this.currentDBImage.processedBy = this.processedBy;
        this.currentDBImage.endYear = this.endYear;
        this.currentDBImage.endPeriod = this.endPeriod;
        this.currentDBImage.finYear = this.finYear;
        this.currentDBImage.finPeriod = this.finPeriod;
        this.currentDBImage.codeFiscal = this.codeFiscal;
        this.currentDBImage.codeAccountingPrinciple2 = this.codeAccountingPrinciple2;
        this.currentDBImage.batchCode = this.batchCode;
        this.currentDBImage.state = this.state;
        this.currentDBImage.recalcInterestPercentage = this.recalcInterestPercentage;
        this.currentDBImage.financialBatchId = this.financialBatchId;
        this.currentDBImage.memberNameFIS = this.memberNameFIS;
        this.currentDBImage.originatingFACBatchId = this.originatingFACBatchId;
        this.currentDBImage.massTransactionProcessType = this.massTransactionProcessType;
        this.currentDBImage.voucherId = this.voucherId;
        this.currentDBImage.voucherDate = this.voucherDate;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("TransactionBatch is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            TransactionBatchPK key = new TransactionBatchPK();
            key.setCompanyId(this.getCompanyId());
            key.setBatchId(this.getBatchId());
            ((TransactionBatchManager_Impl)TransactionBatchManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((TransactionBatchManager_Impl)TransactionBatchManager_Impl.getInstance(this.dbd)).getResultSet((TransactionBatchPK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("-453853438_" + this.dbd.getDBId() + this.companyId + this.batchId).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public TransactionBatchDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public TransactionBatchDataBean getTransactionBatchDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private TransactionBatchDataBean getDataBean(TransactionBatchDataBean bean) throws Exception {
        if (bean == null) {
            bean = new TransactionBatchDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setBatchId(this.getBatchId());
        bean.setCreationDate(this.getCreationDate());
        bean.setCreatedBy(this.getCreatedBy());
        bean.setProcessingDate(this.getProcessingDate());
        bean.setProcessedBy(this.getProcessedBy());
        bean.setEndYear(this.getEndYear());
        bean.setEndPeriod(this.getEndPeriod());
        bean.setFinYear(this.getFinYear());
        bean.setFinPeriod(this.getFinPeriod());
        bean.setCodeFiscal(this.getCodeFiscal());
        bean.setCodeAccountingPrinciple2(this.getCodeAccountingPrinciple2());
        bean.setBatchCode(this.getBatchCode());
        bean.setState(this.getState());
        bean.setRecalcInterestPercentage(this.getRecalcInterestPercentage());
        bean.setFinancialBatchId(this.getFinancialBatchId());
        bean.setMemberNameFIS(this.getMemberNameFIS());
        bean.setOriginatingFACBatchId(this.getOriginatingFACBatchId());
        bean.setMassTransactionProcessType(this.getMassTransactionProcessType());
        bean.setVoucherId(this.getVoucherId());
        bean.setVoucherDate(this.getVoucherDate());
        return bean;
    }

    public boolean equals(Object object) {
        TransactionBatch_Impl bo;
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            try {
                                if (object != null && object instanceof TransactionBatch_Impl) break block8;
                                return false;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e.getMessage());
                            }
                        }
                        bo = (TransactionBatch_Impl)object;
                        if (bo.getCompanyId() != null) break block9;
                        if (this.getCompanyId() != null) {
                            return false;
                        }
                        break block10;
                    }
                    if (bo.getCompanyId().equals(this.getCompanyId())) break block10;
                    return false;
                }
                if (bo.getBatchId() == this.getBatchId()) break block11;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block12;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(TransactionBatchDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(TransactionBatchDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setBatchId(bean.getBatchId());
            this.setCreationDate(bean.getCreationDate());
            this.setCreatedBy(bean.getCreatedBy());
            this.setProcessingDate(bean.getProcessingDate());
            this.setProcessedBy(bean.getProcessedBy());
            this.setEndYear(bean.getEndYear());
            this.setEndPeriod(bean.getEndPeriod());
            this.setFinYear(bean.getFinYear());
            this.setFinPeriod(bean.getFinPeriod());
            this.setCodeFiscal(bean.getCodeFiscal());
            this.setCodeAccountingPrinciple2(bean.getCodeAccountingPrinciple2());
            this.setBatchCode(bean.getBatchCode());
            this.setState(bean.getState());
            this.setRecalcInterestPercentage(bean.getRecalcInterestPercentage());
            this.setFinancialBatchId(bean.getFinancialBatchId());
            this.setMemberNameFIS(bean.getMemberNameFIS());
            this.setOriginatingFACBatchId(bean.getOriginatingFACBatchId());
            this.setMassTransactionProcessType(bean.getMassTransactionProcessType());
            this.setVoucherId(bean.getVoucherId());
            this.setVoucherDate(bean.getVoucherDate());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "TransactionBatch is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.TransactionBatch.save");
        key.append(image.creationDate == null ? "0" : "1");
        key.append(image.processingDate == null ? "0" : "1");
        key.append(image.voucherDate == null ? "0" : "1");
        try {
            try {
                int n;
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("BatchId", provider) + " = ? " + ", " + pmd.getFieldName("CreationDate", provider) + " = ? " + ", " + pmd.getFieldName("CreatedBy", provider) + " = ? " + ", " + pmd.getFieldName("ProcessingDate", provider) + " = ? " + ", " + pmd.getFieldName("ProcessedBy", provider) + " = ? " + ", " + pmd.getFieldName("EndYear", provider) + " = ? " + ", " + pmd.getFieldName("EndPeriod", provider) + " = ? " + ", " + pmd.getFieldName("FinYear", provider) + " = ? " + ", " + pmd.getFieldName("FinPeriod", provider) + " = ? " + ", " + pmd.getFieldName("CodeFiscal", provider) + " = ? " + ", " + pmd.getFieldName("CodeAccountingPrinciple2", provider) + " = ? " + ", " + pmd.getFieldName("BatchCode", provider) + " = ? " + ", " + pmd.getFieldName("State", provider) + " = ? " + ", " + pmd.getFieldName("RecalcInterestPercentage", provider) + " = ? " + ", " + pmd.getFieldName("FinancialBatchId", provider) + " = ? " + ", " + pmd.getFieldName("MemberNameFIS", provider) + " = ? " + ", " + pmd.getFieldName("OriginatingFACBatchId", provider) + " = ? " + ", " + pmd.getFieldName("MassTransactionProcessType", provider) + " = ? " + ", " + pmd.getFieldName("VoucherId", provider) + " = ? " + ", " + pmd.getFieldName("VoucherDate", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("BatchId", provider) + " = ? " + " AND  " + pmd.getFieldName("CreationDate", provider) + (image.creationDate == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("CreatedBy", provider) + " = ? " + " AND  " + pmd.getFieldName("ProcessingDate", provider) + (image.processingDate == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("ProcessedBy", provider) + " = ? " + " AND  " + pmd.getFieldName("EndYear", provider) + " = ? " + " AND  " + pmd.getFieldName("EndPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("FinYear", provider) + " = ? " + " AND  " + pmd.getFieldName("FinPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("CodeFiscal", provider) + " = ? " + " AND  " + pmd.getFieldName("CodeAccountingPrinciple2", provider) + " = ? " + " AND  " + pmd.getFieldName("BatchCode", provider) + " = ? " + " AND  " + pmd.getFieldName("State", provider) + " = ? " + " AND  " + pmd.getFieldName("RecalcInterestPercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("FinancialBatchId", provider) + " = ? " + " AND  " + pmd.getFieldName("MemberNameFIS", provider) + " = ? " + " AND  " + pmd.getFieldName("OriginatingFACBatchId", provider) + " = ? " + " AND  " + pmd.getFieldName("MassTransactionProcessType", provider) + " = ? " + " AND  " + pmd.getFieldName("VoucherId", provider) + " = ? " + " AND  " + pmd.getFieldName("VoucherDate", provider) + (image.voucherDate == null ? " IS NULL" : " = ?"));
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.batchId), mapping.getJDBCTypeFor("int"));
                if (this.creationDate == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.creationDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)this.createdBy, mapping.getJDBCTypeFor("String"));
                if (this.processingDate == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.processingDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)this.processedBy, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.endYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.endPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.finYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.finPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.codeFiscal), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.codeAccountingPrinciple2), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(this.batchCode), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.recalcInterestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(parmIndex++, (Object)new Integer(this.financialBatchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.memberNameFIS, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.originatingFACBatchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.massTransactionProcessType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.voucherId, mapping.getJDBCTypeFor("String"));
                if (this.voucherDate == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.voucherDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.batchId), mapping.getJDBCTypeFor("int"));
                if (image.creationDate != null) {
                    prep.setObject(parmIndex++, (Object)image.creationDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)image.createdBy, mapping.getJDBCTypeFor("String"));
                if (image.processingDate != null) {
                    prep.setObject(parmIndex++, (Object)image.processingDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(parmIndex++, (Object)image.processedBy, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.endYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.endPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.finYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.finPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.codeFiscal), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.codeAccountingPrinciple2), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)new Integer(image.batchCode), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.recalcInterestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(parmIndex++, (Object)new Integer(image.financialBatchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.memberNameFIS, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.originatingFACBatchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.massTransactionProcessType), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.voucherId, mapping.getJDBCTypeFor("String"));
                if (image.voucherDate != null) {
                    prep.setObject(parmIndex++, (Object)image.voucherDate, mapping.getJDBCTypeFor("Date"));
                }
                if ((n = prep.executeUpdate()) == 0) {
                    this.rollback(true);
                    throw new UpdateException("TransactionBatch modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.TransactionBatch.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.TransactionBatch.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("BatchId", provider) + ", " + pmd.getFieldName("CreationDate", provider) + ", " + pmd.getFieldName("CreatedBy", provider) + ", " + pmd.getFieldName("ProcessingDate", provider) + ", " + pmd.getFieldName("ProcessedBy", provider) + ", " + pmd.getFieldName("EndYear", provider) + ", " + pmd.getFieldName("EndPeriod", provider) + ", " + pmd.getFieldName("FinYear", provider) + ", " + pmd.getFieldName("FinPeriod", provider) + ", " + pmd.getFieldName("CodeFiscal", provider) + ", " + pmd.getFieldName("CodeAccountingPrinciple2", provider) + ", " + pmd.getFieldName("BatchCode", provider) + ", " + pmd.getFieldName("State", provider) + ", " + pmd.getFieldName("RecalcInterestPercentage", provider) + ", " + pmd.getFieldName("FinancialBatchId", provider) + ", " + pmd.getFieldName("MemberNameFIS", provider) + ", " + pmd.getFieldName("OriginatingFACBatchId", provider) + ", " + pmd.getFieldName("MassTransactionProcessType", provider) + ", " + pmd.getFieldName("VoucherId", provider) + ", " + pmd.getFieldName("VoucherDate", provider) + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)new Integer(this.batchId), mapping.getJDBCTypeFor("int"));
                if (this.creationDate == null) {
                    prep.setNull(3, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(3, (Object)this.creationDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(4, (Object)this.createdBy, mapping.getJDBCTypeFor("String"));
                if (this.processingDate == null) {
                    prep.setNull(5, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(5, (Object)this.processingDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.setObject(6, (Object)this.processedBy, mapping.getJDBCTypeFor("String"));
                prep.setObject(7, (Object)new Integer(this.endYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(8, (Object)new Integer(this.endPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(9, (Object)new Integer(this.finYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(10, (Object)new Integer(this.finPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(11, (Object)new Boolean(this.codeFiscal), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(12, (Object)new Boolean(this.codeAccountingPrinciple2), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(13, (Object)new Integer(this.batchCode), mapping.getJDBCTypeFor("int"));
                prep.setObject(14, (Object)new Integer(this.state), mapping.getJDBCTypeFor("int"));
                prep.setObject(15, (Object)this.recalcInterestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(16, (Object)new Integer(this.financialBatchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(17, (Object)this.memberNameFIS, mapping.getJDBCTypeFor("String"));
                prep.setObject(18, (Object)new Integer(this.originatingFACBatchId), mapping.getJDBCTypeFor("int"));
                prep.setObject(19, (Object)new Integer(this.massTransactionProcessType), mapping.getJDBCTypeFor("int"));
                prep.setObject(20, (Object)this.voucherId, mapping.getJDBCTypeFor("String"));
                if (this.voucherDate == null) {
                    prep.setNull(21, mapping.getJDBCTypeFor("Date"));
                } else {
                    prep.setObject(21, (Object)this.voucherDate, mapping.getJDBCTypeFor("Date"));
                }
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.batchId = this.currentDBImage.batchId;
            this.transactionImage.dbImage.creationDate = this.currentDBImage.creationDate;
            this.transactionImage.dbImage.createdBy = this.currentDBImage.createdBy;
            this.transactionImage.dbImage.processingDate = this.currentDBImage.processingDate;
            this.transactionImage.dbImage.processedBy = this.currentDBImage.processedBy;
            this.transactionImage.dbImage.endYear = this.currentDBImage.endYear;
            this.transactionImage.dbImage.endPeriod = this.currentDBImage.endPeriod;
            this.transactionImage.dbImage.finYear = this.currentDBImage.finYear;
            this.transactionImage.dbImage.finPeriod = this.currentDBImage.finPeriod;
            this.transactionImage.dbImage.codeFiscal = this.currentDBImage.codeFiscal;
            this.transactionImage.dbImage.codeAccountingPrinciple2 = this.currentDBImage.codeAccountingPrinciple2;
            this.transactionImage.dbImage.batchCode = this.currentDBImage.batchCode;
            this.transactionImage.dbImage.state = this.currentDBImage.state;
            this.transactionImage.dbImage.recalcInterestPercentage = this.currentDBImage.recalcInterestPercentage;
            this.transactionImage.dbImage.financialBatchId = this.currentDBImage.financialBatchId;
            this.transactionImage.dbImage.memberNameFIS = this.currentDBImage.memberNameFIS;
            this.transactionImage.dbImage.originatingFACBatchId = this.currentDBImage.originatingFACBatchId;
            this.transactionImage.dbImage.massTransactionProcessType = this.currentDBImage.massTransactionProcessType;
            this.transactionImage.dbImage.voucherId = this.currentDBImage.voucherId;
            this.transactionImage.dbImage.voucherDate = this.currentDBImage.voucherDate;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.batchId = this.transactionImage.dbImage.batchId;
        this.currentDBImage.creationDate = this.transactionImage.dbImage.creationDate;
        this.currentDBImage.createdBy = this.transactionImage.dbImage.createdBy;
        this.currentDBImage.processingDate = this.transactionImage.dbImage.processingDate;
        this.currentDBImage.processedBy = this.transactionImage.dbImage.processedBy;
        this.currentDBImage.endYear = this.transactionImage.dbImage.endYear;
        this.currentDBImage.endPeriod = this.transactionImage.dbImage.endPeriod;
        this.currentDBImage.finYear = this.transactionImage.dbImage.finYear;
        this.currentDBImage.finPeriod = this.transactionImage.dbImage.finPeriod;
        this.currentDBImage.codeFiscal = this.transactionImage.dbImage.codeFiscal;
        this.currentDBImage.codeAccountingPrinciple2 = this.transactionImage.dbImage.codeAccountingPrinciple2;
        this.currentDBImage.batchCode = this.transactionImage.dbImage.batchCode;
        this.currentDBImage.state = this.transactionImage.dbImage.state;
        this.currentDBImage.recalcInterestPercentage = this.transactionImage.dbImage.recalcInterestPercentage;
        this.currentDBImage.financialBatchId = this.transactionImage.dbImage.financialBatchId;
        this.currentDBImage.memberNameFIS = this.transactionImage.dbImage.memberNameFIS;
        this.currentDBImage.originatingFACBatchId = this.transactionImage.dbImage.originatingFACBatchId;
        this.currentDBImage.massTransactionProcessType = this.transactionImage.dbImage.massTransactionProcessType;
        this.currentDBImage.voucherId = this.transactionImage.dbImage.voucherId;
        this.currentDBImage.voucherDate = this.transactionImage.dbImage.voucherDate;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.batchId = this.transactionImage.dbImage.batchId;
            this.creationDate = this.transactionImage.dbImage.creationDate;
            this.createdBy = this.transactionImage.dbImage.createdBy;
            this.processingDate = this.transactionImage.dbImage.processingDate;
            this.processedBy = this.transactionImage.dbImage.processedBy;
            this.endYear = this.transactionImage.dbImage.endYear;
            this.endPeriod = this.transactionImage.dbImage.endPeriod;
            this.finYear = this.transactionImage.dbImage.finYear;
            this.finPeriod = this.transactionImage.dbImage.finPeriod;
            this.codeFiscal = this.transactionImage.dbImage.codeFiscal;
            this.codeAccountingPrinciple2 = this.transactionImage.dbImage.codeAccountingPrinciple2;
            this.batchCode = this.transactionImage.dbImage.batchCode;
            this.state = this.transactionImage.dbImage.state;
            this.recalcInterestPercentage = this.transactionImage.dbImage.recalcInterestPercentage;
            this.financialBatchId = this.transactionImage.dbImage.financialBatchId;
            this.memberNameFIS = this.transactionImage.dbImage.memberNameFIS;
            this.originatingFACBatchId = this.transactionImage.dbImage.originatingFACBatchId;
            this.massTransactionProcessType = this.transactionImage.dbImage.massTransactionProcessType;
            this.voucherId = this.transactionImage.dbImage.voucherId;
            this.voucherDate = this.transactionImage.dbImage.voucherDate;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private int batchId;
        private Date creationDate;
        private String createdBy;
        private Date processingDate;
        private String processedBy;
        private int endYear;
        private int endPeriod;
        private int finYear;
        private int finPeriod;
        private boolean codeFiscal;
        private boolean codeAccountingPrinciple2;
        private int batchCode;
        private int state;
        private BigDecimal recalcInterestPercentage;
        private int financialBatchId;
        private String memberNameFIS;
        private int originatingFACBatchId;
        private int massTransactionProcessType;
        private String voucherId;
        private Date voucherDate;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

