/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetPK;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.ValuationDataBean;
import nl.ibs.fac.db.ValuationPK;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.db.impl.AssetManager_Impl;
import nl.ibs.fac.db.impl.InterestTableManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataValuation;
import nl.ibs.fac.db.impl.ValuationManager_Impl;
import nl.ibs.fac.db.impl.YearPercentageTableManager_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;

public class Valuation_Impl
implements Valuation,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataValuation.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected String cora;
    protected String assetId;
    protected int accountingPrinciple;
    protected int documentNr1stTransaction;
    protected int seqNr1stTransaction;
    protected BigDecimal postedAcquisitionBalance;
    protected int lastAcquisitionBookYear;
    protected int lastAcquisitionPeriod;
    protected BigDecimal postedDepreciationBalance;
    protected int lastDepreciationBookYear;
    protected int lastDepreciationPeriod;
    protected BigDecimal currentBookvalueBalance;
    protected BigDecimal previousBookvalueBalance;
    protected int depreciationMethod;
    protected int interestCalculationMethod;
    protected String interestTableId;
    protected BigDecimal residualValue;
    protected BigDecimal residualPercentage;
    protected String yearPercentageTableId;
    protected int startPeriodHandlingMethod;
    protected BigDecimal degressivePercentage;
    protected BigDecimal annuityPercentage;
    protected String annuityInterestTableId;
    protected int startDepreciationBookYear;
    protected int startDepreciationPeriod;
    protected int numberOfDepreciatedPeriods;
    protected int depreciatableLife;
    protected boolean depreciationPaused;
    protected BigDecimal interestPercentage;
    protected int interestBookYear;
    protected int interestPeriod;
    protected BigDecimal correctionAmount445A;
    protected BigDecimal correctionAmount445B;
    protected BigDecimal beyondEconomicLifePercentage;
    protected BigDecimal postedDepreciationBalanceBeyondEconomicLife;
    protected transient InterestTable transientAnnuityInterestTable;
    protected transient InterestTable transientInterestTable;
    protected transient YearPercentageTable transientYearPercentageTable;

    protected Valuation_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected Valuation_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected Valuation_Impl(DBData _dbd, String _companyId, String _cora, String _assetId, int _accountingPrinciple) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setCora(_cora);
            this.setAssetId(_assetId);
            this.setAccountingPrinciple(_accountingPrinciple);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected Valuation_Impl(DBData _dbd, ValuationDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.ValuationDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate Valuation with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.ValuationDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setCora(bean.getCora());
            this.setAssetId(bean.getAssetId());
            this.setAccountingPrinciple(bean.getAccountingPrinciple());
            this.setDocumentNr1stTransaction(bean.getDocumentNr1stTransaction());
            this.setSeqNr1stTransaction(bean.getSeqNr1stTransaction());
            this.setPostedAcquisitionBalance(bean.getPostedAcquisitionBalance());
            this.setLastAcquisitionBookYear(bean.getLastAcquisitionBookYear());
            this.setLastAcquisitionPeriod(bean.getLastAcquisitionPeriod());
            this.setPostedDepreciationBalance(bean.getPostedDepreciationBalance());
            this.setLastDepreciationBookYear(bean.getLastDepreciationBookYear());
            this.setLastDepreciationPeriod(bean.getLastDepreciationPeriod());
            this.setCurrentBookvalueBalance(bean.getCurrentBookvalueBalance());
            this.setPreviousBookvalueBalance(bean.getPreviousBookvalueBalance());
            this.setDepreciationMethod(bean.getDepreciationMethod());
            this.setInterestCalculationMethod(bean.getInterestCalculationMethod());
            this.setInterestTableId(bean.getInterestTableId());
            this.setResidualValue(bean.getResidualValue());
            this.setResidualPercentage(bean.getResidualPercentage());
            this.setYearPercentageTableId(bean.getYearPercentageTableId());
            this.setStartPeriodHandlingMethod(bean.getStartPeriodHandlingMethod());
            this.setDegressivePercentage(bean.getDegressivePercentage());
            this.setAnnuityPercentage(bean.getAnnuityPercentage());
            this.setAnnuityInterestTableId(bean.getAnnuityInterestTableId());
            this.setStartDepreciationBookYear(bean.getStartDepreciationBookYear());
            this.setStartDepreciationPeriod(bean.getStartDepreciationPeriod());
            this.setNumberOfDepreciatedPeriods(bean.getNumberOfDepreciatedPeriods());
            this.setDepreciatableLife(bean.getDepreciatableLife());
            this.setDepreciationPaused(bean.getDepreciationPaused());
            this.setInterestPercentage(bean.getInterestPercentage());
            this.setInterestBookYear(bean.getInterestBookYear());
            this.setInterestPeriod(bean.getInterestPeriod());
            this.setCorrectionAmount445A(bean.getCorrectionAmount445A());
            this.setCorrectionAmount445B(bean.getCorrectionAmount445B());
            this.setBeyondEconomicLifePercentage(bean.getBeyondEconomicLifePercentage());
            this.setPostedDepreciationBalanceBeyondEconomicLife(bean.getPostedDepreciationBalanceBeyondEconomicLife());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public Valuation_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.cora = rs.getString(pmd.getFieldName("Cora", provider));
        this.assetId = rs.getString(pmd.getFieldName("AssetId", provider));
        this.accountingPrinciple = rs.getInt(pmd.getFieldName("AccountingPrinciple", provider));
        this.documentNr1stTransaction = rs.getInt(pmd.getFieldName("DocumentNr1stTransaction", provider));
        this.seqNr1stTransaction = rs.getInt(pmd.getFieldName("SeqNr 1st transaction", provider));
        this.postedAcquisitionBalance = rs.getBigDecimal(pmd.getFieldName("PostedAcquisitionBalance", provider));
        this.lastAcquisitionBookYear = rs.getInt(pmd.getFieldName("LastAcquisitionBookYear", provider));
        this.lastAcquisitionPeriod = rs.getInt(pmd.getFieldName("LastAcquisitionPeriod", provider));
        this.postedDepreciationBalance = rs.getBigDecimal(pmd.getFieldName("PostedDepreciationBalance", provider));
        this.lastDepreciationBookYear = rs.getInt(pmd.getFieldName("LastDepreciationBookYear", provider));
        this.lastDepreciationPeriod = rs.getInt(pmd.getFieldName("LastDepreciationPeriod", provider));
        this.currentBookvalueBalance = rs.getBigDecimal(pmd.getFieldName("CurrentBookvalueBalance", provider));
        this.previousBookvalueBalance = rs.getBigDecimal(pmd.getFieldName("PreviousBookvalueBalance", provider));
        this.depreciationMethod = rs.getInt(pmd.getFieldName("DepreciationMethod", provider));
        this.interestCalculationMethod = rs.getInt(pmd.getFieldName("InterestCalculationMethod", provider));
        this.interestTableId = rs.getString(pmd.getFieldName("InterestTableId", provider));
        this.residualValue = rs.getBigDecimal(pmd.getFieldName("ResidualValue", provider));
        this.residualPercentage = rs.getBigDecimal(pmd.getFieldName("ResidualPercentage", provider));
        this.yearPercentageTableId = rs.getString(pmd.getFieldName("YearPercentageTableId", provider));
        this.startPeriodHandlingMethod = rs.getInt(pmd.getFieldName("StartPeriodHandlingMethod", provider));
        this.degressivePercentage = rs.getBigDecimal(pmd.getFieldName("DegressivePercentage", provider));
        this.annuityPercentage = rs.getBigDecimal(pmd.getFieldName("AnnuityPercentage", provider));
        this.annuityInterestTableId = rs.getString(pmd.getFieldName("AnnuityInterestTableId", provider));
        this.startDepreciationBookYear = rs.getInt(pmd.getFieldName("StartDepreciationBookYear", provider));
        this.startDepreciationPeriod = rs.getInt(pmd.getFieldName("StartDepreciationPeriod", provider));
        this.numberOfDepreciatedPeriods = rs.getInt(pmd.getFieldName("NumberOfDepreciatedPeriods", provider));
        this.depreciatableLife = rs.getInt(pmd.getFieldName("DepreciatableLife", provider));
        this.depreciationPaused = rs.getBoolean(pmd.getFieldName("DepreciationPaused", provider));
        this.interestPercentage = rs.getBigDecimal(pmd.getFieldName("InterestPercentage", provider));
        this.interestBookYear = rs.getInt(pmd.getFieldName("InterestBookYear", provider));
        this.interestPeriod = rs.getInt(pmd.getFieldName("InterestPeriod", provider));
        this.correctionAmount445A = rs.getBigDecimal(pmd.getFieldName("CorrectionAmount445A", provider));
        this.correctionAmount445B = rs.getBigDecimal(pmd.getFieldName("CorrectionAmount445B", provider));
        this.beyondEconomicLifePercentage = rs.getBigDecimal(pmd.getFieldName("BeyondEconomicLifePercentage", provider));
        this.postedDepreciationBalanceBeyondEconomicLife = rs.getBigDecimal(pmd.getFieldName("PostedDepreciationBalanceBeyondEconomicLife", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        ValuationPK key = new ValuationPK();
        key.setCompanyId(this.getCompanyId());
        key.setCora(this.getCora());
        key.setAssetId(this.getAssetId());
        key.setAccountingPrinciple(this.getAccountingPrinciple());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public String getCora() throws Exception {
        this.assureStorage();
        return this.cora;
    }

    @Override
    public String getAssetId() throws Exception {
        this.assureStorage();
        return this.assetId;
    }

    @Override
    public int getAccountingPrinciple() throws Exception {
        this.assureStorage();
        return this.accountingPrinciple;
    }

    @Override
    public int getDocumentNr1stTransaction() throws Exception {
        return this.documentNr1stTransaction;
    }

    @Override
    public int getSeqNr1stTransaction() throws Exception {
        return this.seqNr1stTransaction;
    }

    @Override
    public BigDecimal getPostedAcquisitionBalance() throws Exception {
        return this.postedAcquisitionBalance;
    }

    @Override
    public int getLastAcquisitionBookYear() throws Exception {
        return this.lastAcquisitionBookYear;
    }

    @Override
    public int getLastAcquisitionPeriod() throws Exception {
        return this.lastAcquisitionPeriod;
    }

    @Override
    public BigDecimal getPostedDepreciationBalance() throws Exception {
        return this.postedDepreciationBalance;
    }

    @Override
    public int getLastDepreciationBookYear() throws Exception {
        return this.lastDepreciationBookYear;
    }

    @Override
    public int getLastDepreciationPeriod() throws Exception {
        return this.lastDepreciationPeriod;
    }

    @Override
    public BigDecimal getCurrentBookvalueBalance() throws Exception {
        return this.currentBookvalueBalance;
    }

    @Override
    public BigDecimal getPreviousBookvalueBalance() throws Exception {
        return this.previousBookvalueBalance;
    }

    @Override
    public int getDepreciationMethod() throws Exception {
        return this.depreciationMethod;
    }

    @Override
    public int getInterestCalculationMethod() throws Exception {
        return this.interestCalculationMethod;
    }

    @Override
    public String getInterestTableId() throws Exception {
        return this.interestTableId;
    }

    @Override
    public BigDecimal getResidualValue() throws Exception {
        return this.residualValue;
    }

    @Override
    public BigDecimal getResidualPercentage() throws Exception {
        return this.residualPercentage;
    }

    @Override
    public String getYearPercentageTableId() throws Exception {
        return this.yearPercentageTableId;
    }

    @Override
    public int getStartPeriodHandlingMethod() throws Exception {
        return this.startPeriodHandlingMethod;
    }

    @Override
    public BigDecimal getDegressivePercentage() throws Exception {
        return this.degressivePercentage;
    }

    @Override
    public BigDecimal getAnnuityPercentage() throws Exception {
        return this.annuityPercentage;
    }

    @Override
    public String getAnnuityInterestTableId() throws Exception {
        return this.annuityInterestTableId;
    }

    @Override
    public int getStartDepreciationBookYear() throws Exception {
        return this.startDepreciationBookYear;
    }

    @Override
    public int getStartDepreciationPeriod() throws Exception {
        return this.startDepreciationPeriod;
    }

    @Override
    public int getNumberOfDepreciatedPeriods() throws Exception {
        return this.numberOfDepreciatedPeriods;
    }

    @Override
    public int getDepreciatableLife() throws Exception {
        return this.depreciatableLife;
    }

    @Override
    public boolean getDepreciationPaused() throws Exception {
        return this.depreciationPaused;
    }

    @Override
    public BigDecimal getInterestPercentage() throws Exception {
        return this.interestPercentage;
    }

    @Override
    public int getInterestBookYear() throws Exception {
        return this.interestBookYear;
    }

    @Override
    public int getInterestPeriod() throws Exception {
        return this.interestPeriod;
    }

    @Override
    public BigDecimal getCorrectionAmount445A() throws Exception {
        return this.correctionAmount445A;
    }

    @Override
    public BigDecimal getCorrectionAmount445B() throws Exception {
        return this.correctionAmount445B;
    }

    @Override
    public BigDecimal getBeyondEconomicLifePercentage() throws Exception {
        return this.beyondEconomicLifePercentage;
    }

    @Override
    public BigDecimal getPostedDepreciationBalanceBeyondEconomicLife() throws Exception {
        return this.postedDepreciationBalanceBeyondEconomicLife;
    }

    @Override
    public InterestTable getAnnuityInterestTable() throws Exception {
        if (this.isCachedRelation("AnnuityInterestTable")) {
            return (InterestTable)this.getCachedRelationObject("AnnuityInterestTable");
        }
        if (this.getAnnuityInterestTableId() == null) {
            return (InterestTable)this.addCachedRelationObject("AnnuityInterestTable", null);
        }
        try {
            return (InterestTable)this.addCachedRelationObject("AnnuityInterestTable", ((InterestTableManager_Impl)InterestTableManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getAnnuityInterestTableId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public InterestTable getInterestTable() throws Exception {
        if (this.isCachedRelation("InterestTable")) {
            return (InterestTable)this.getCachedRelationObject("InterestTable");
        }
        if (this.getInterestTableId() == null) {
            return (InterestTable)this.addCachedRelationObject("InterestTable", null);
        }
        try {
            return (InterestTable)this.addCachedRelationObject("InterestTable", ((InterestTableManager_Impl)InterestTableManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getInterestTableId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public YearPercentageTable getYearPercentageTable() throws Exception {
        if (this.isCachedRelation("YearPercentageTable")) {
            return (YearPercentageTable)this.getCachedRelationObject("YearPercentageTable");
        }
        if (this.getYearPercentageTableId() == null) {
            return (YearPercentageTable)this.addCachedRelationObject("YearPercentageTable", null);
        }
        try {
            return (YearPercentageTable)this.addCachedRelationObject("YearPercentageTable", ((YearPercentageTableManager_Impl)YearPercentageTableManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getYearPercentageTableId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public Asset getOwnedByAssetAsValuations() throws Exception {
        if (this.isCachedRelation("ownedByAssetAsValuations")) {
            return (Asset)this.getCachedRelationObject("ownedByAssetAsValuations");
        }
        AssetPK primaryKey = new AssetPK();
        primaryKey.setCompanyId(this.getCompanyId());
        primaryKey.setCora(this.getCora());
        primaryKey.setId(this.getAssetId());
        try {
            return (Asset)this.addCachedRelationObject("ownedByAssetAsValuations", ((AssetManager_Impl)AssetManager_Impl.getInstance(this.dbd)).findByPrimaryKey(primaryKey));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Asset owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByAssetAsValuations();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setCora(String _cora) throws Exception {
        if (_cora == null) {
            _cora = "";
        }
        if (_cora.equals(this.getCora())) {
            return;
        }
        this.preSet();
        this.cora = _cora;
        this.autoUpdate();
    }

    public void setAssetId(String _assetId) throws Exception {
        if (_assetId == null) {
            _assetId = "";
        }
        if (_assetId.equals(this.getAssetId())) {
            return;
        }
        this.preSet();
        this.assetId = _assetId;
        this.autoUpdate();
    }

    public void setAccountingPrinciple(int _accountingPrinciple) throws Exception {
        if (_accountingPrinciple == this.getAccountingPrinciple()) {
            return;
        }
        this.preSet();
        this.accountingPrinciple = _accountingPrinciple;
        this.autoUpdate();
    }

    @Override
    public void setDocumentNr1stTransaction(int _documentNr1stTransaction) throws Exception {
        if (_documentNr1stTransaction == this.getDocumentNr1stTransaction()) {
            return;
        }
        this.preSet();
        this.documentNr1stTransaction = _documentNr1stTransaction;
        this.autoUpdate();
    }

    @Override
    public void setSeqNr1stTransaction(int _seqNr1stTransaction) throws Exception {
        if (_seqNr1stTransaction == this.getSeqNr1stTransaction()) {
            return;
        }
        this.preSet();
        this.seqNr1stTransaction = _seqNr1stTransaction;
        this.autoUpdate();
    }

    @Override
    public void setPostedAcquisitionBalance(BigDecimal _postedAcquisitionBalance) throws Exception {
        if (_postedAcquisitionBalance == null) {
            _postedAcquisitionBalance = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_postedAcquisitionBalance.equals(this.getPostedAcquisitionBalance())) {
            return;
        }
        this.preSet();
        this.postedAcquisitionBalance = _postedAcquisitionBalance;
        this.autoUpdate();
    }

    @Override
    public void setLastAcquisitionBookYear(int _lastAcquisitionBookYear) throws Exception {
        if (_lastAcquisitionBookYear == this.getLastAcquisitionBookYear()) {
            return;
        }
        this.preSet();
        this.lastAcquisitionBookYear = _lastAcquisitionBookYear;
        this.autoUpdate();
    }

    @Override
    public void setLastAcquisitionPeriod(int _lastAcquisitionPeriod) throws Exception {
        if (_lastAcquisitionPeriod == this.getLastAcquisitionPeriod()) {
            return;
        }
        this.preSet();
        this.lastAcquisitionPeriod = _lastAcquisitionPeriod;
        this.autoUpdate();
    }

    @Override
    public void setPostedDepreciationBalance(BigDecimal _postedDepreciationBalance) throws Exception {
        if (_postedDepreciationBalance == null) {
            _postedDepreciationBalance = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_postedDepreciationBalance.equals(this.getPostedDepreciationBalance())) {
            return;
        }
        this.preSet();
        this.postedDepreciationBalance = _postedDepreciationBalance;
        this.autoUpdate();
    }

    @Override
    public void setLastDepreciationBookYear(int _lastDepreciationBookYear) throws Exception {
        if (_lastDepreciationBookYear == this.getLastDepreciationBookYear()) {
            return;
        }
        this.preSet();
        this.lastDepreciationBookYear = _lastDepreciationBookYear;
        this.autoUpdate();
    }

    @Override
    public void setLastDepreciationPeriod(int _lastDepreciationPeriod) throws Exception {
        if (_lastDepreciationPeriod == this.getLastDepreciationPeriod()) {
            return;
        }
        this.preSet();
        this.lastDepreciationPeriod = _lastDepreciationPeriod;
        this.autoUpdate();
    }

    @Override
    public void setCurrentBookvalueBalance(BigDecimal _currentBookvalueBalance) throws Exception {
        if (_currentBookvalueBalance == null) {
            _currentBookvalueBalance = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_currentBookvalueBalance.equals(this.getCurrentBookvalueBalance())) {
            return;
        }
        this.preSet();
        this.currentBookvalueBalance = _currentBookvalueBalance;
        this.autoUpdate();
    }

    @Override
    public void setPreviousBookvalueBalance(BigDecimal _previousBookvalueBalance) throws Exception {
        if (_previousBookvalueBalance == null) {
            _previousBookvalueBalance = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_previousBookvalueBalance.equals(this.getPreviousBookvalueBalance())) {
            return;
        }
        this.preSet();
        this.previousBookvalueBalance = _previousBookvalueBalance;
        this.autoUpdate();
    }

    @Override
    public void setDepreciationMethod(int _depreciationMethod) throws Exception {
        if (_depreciationMethod == this.getDepreciationMethod()) {
            return;
        }
        this.preSet();
        this.depreciationMethod = _depreciationMethod;
        this.autoUpdate();
    }

    @Override
    public void setInterestCalculationMethod(int _interestCalculationMethod) throws Exception {
        if (_interestCalculationMethod == this.getInterestCalculationMethod()) {
            return;
        }
        this.preSet();
        this.interestCalculationMethod = _interestCalculationMethod;
        this.autoUpdate();
    }

    public void setInterestTableId(String _interestTableId) throws Exception {
        if (_interestTableId == null ? this.getInterestTableId() == null : _interestTableId.equals(this.getInterestTableId())) {
            return;
        }
        this.preSet();
        this.interestTableId = _interestTableId;
        this.autoUpdate();
    }

    @Override
    public void setResidualValue(BigDecimal _residualValue) throws Exception {
        if (_residualValue == null) {
            _residualValue = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_residualValue.equals(this.getResidualValue())) {
            return;
        }
        this.preSet();
        this.residualValue = _residualValue;
        this.autoUpdate();
    }

    @Override
    public void setResidualPercentage(BigDecimal _residualPercentage) throws Exception {
        if (_residualPercentage == null) {
            _residualPercentage = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_residualPercentage.equals(this.getResidualPercentage())) {
            return;
        }
        this.preSet();
        this.residualPercentage = _residualPercentage;
        this.autoUpdate();
    }

    public void setYearPercentageTableId(String _yearPercentageTableId) throws Exception {
        if (_yearPercentageTableId == null ? this.getYearPercentageTableId() == null : _yearPercentageTableId.equals(this.getYearPercentageTableId())) {
            return;
        }
        this.preSet();
        this.yearPercentageTableId = _yearPercentageTableId;
        this.autoUpdate();
    }

    @Override
    public void setStartPeriodHandlingMethod(int _startPeriodHandlingMethod) throws Exception {
        if (_startPeriodHandlingMethod == this.getStartPeriodHandlingMethod()) {
            return;
        }
        this.preSet();
        this.startPeriodHandlingMethod = _startPeriodHandlingMethod;
        this.autoUpdate();
    }

    @Override
    public void setDegressivePercentage(BigDecimal _degressivePercentage) throws Exception {
        if (_degressivePercentage == null) {
            _degressivePercentage = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_degressivePercentage.equals(this.getDegressivePercentage())) {
            return;
        }
        this.preSet();
        this.degressivePercentage = _degressivePercentage;
        this.autoUpdate();
    }

    @Override
    public void setAnnuityPercentage(BigDecimal _annuityPercentage) throws Exception {
        if (_annuityPercentage == null) {
            _annuityPercentage = new BigDecimal("0.000").setScale(3, 6);
        }
        if (_annuityPercentage.equals(this.getAnnuityPercentage())) {
            return;
        }
        this.preSet();
        this.annuityPercentage = _annuityPercentage;
        this.autoUpdate();
    }

    public void setAnnuityInterestTableId(String _annuityInterestTableId) throws Exception {
        if (_annuityInterestTableId == null ? this.getAnnuityInterestTableId() == null : _annuityInterestTableId.equals(this.getAnnuityInterestTableId())) {
            return;
        }
        this.preSet();
        this.annuityInterestTableId = _annuityInterestTableId;
        this.autoUpdate();
    }

    @Override
    public void setStartDepreciationBookYear(int _startDepreciationBookYear) throws Exception {
        if (_startDepreciationBookYear == this.getStartDepreciationBookYear()) {
            return;
        }
        this.preSet();
        this.startDepreciationBookYear = _startDepreciationBookYear;
        this.autoUpdate();
    }

    @Override
    public void setStartDepreciationPeriod(int _startDepreciationPeriod) throws Exception {
        if (_startDepreciationPeriod == this.getStartDepreciationPeriod()) {
            return;
        }
        this.preSet();
        this.startDepreciationPeriod = _startDepreciationPeriod;
        this.autoUpdate();
    }

    @Override
    public void setNumberOfDepreciatedPeriods(int _numberOfDepreciatedPeriods) throws Exception {
        if (_numberOfDepreciatedPeriods == this.getNumberOfDepreciatedPeriods()) {
            return;
        }
        this.preSet();
        this.numberOfDepreciatedPeriods = _numberOfDepreciatedPeriods;
        this.autoUpdate();
    }

    @Override
    public void setDepreciatableLife(int _depreciatableLife) throws Exception {
        if (_depreciatableLife == this.getDepreciatableLife()) {
            return;
        }
        this.preSet();
        this.depreciatableLife = _depreciatableLife;
        this.autoUpdate();
    }

    @Override
    public void setDepreciationPaused(boolean _depreciationPaused) throws Exception {
        if (_depreciationPaused == this.getDepreciationPaused()) {
            return;
        }
        this.preSet();
        this.depreciationPaused = _depreciationPaused;
        this.autoUpdate();
    }

    @Override
    public void setInterestPercentage(BigDecimal _interestPercentage) throws Exception {
        if (_interestPercentage == null) {
            _interestPercentage = new BigDecimal("0.000").setScale(3, 6);
        }
        if (_interestPercentage.equals(this.getInterestPercentage())) {
            return;
        }
        this.preSet();
        this.interestPercentage = _interestPercentage;
        this.autoUpdate();
    }

    @Override
    public void setInterestBookYear(int _interestBookYear) throws Exception {
        if (_interestBookYear == this.getInterestBookYear()) {
            return;
        }
        this.preSet();
        this.interestBookYear = _interestBookYear;
        this.autoUpdate();
    }

    @Override
    public void setInterestPeriod(int _interestPeriod) throws Exception {
        if (_interestPeriod == this.getInterestPeriod()) {
            return;
        }
        this.preSet();
        this.interestPeriod = _interestPeriod;
        this.autoUpdate();
    }

    @Override
    public void setCorrectionAmount445A(BigDecimal _correctionAmount445A) throws Exception {
        if (_correctionAmount445A == null) {
            _correctionAmount445A = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_correctionAmount445A.equals(this.getCorrectionAmount445A())) {
            return;
        }
        this.preSet();
        this.correctionAmount445A = _correctionAmount445A;
        this.autoUpdate();
    }

    @Override
    public void setCorrectionAmount445B(BigDecimal _correctionAmount445B) throws Exception {
        if (_correctionAmount445B == null) {
            _correctionAmount445B = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_correctionAmount445B.equals(this.getCorrectionAmount445B())) {
            return;
        }
        this.preSet();
        this.correctionAmount445B = _correctionAmount445B;
        this.autoUpdate();
    }

    @Override
    public void setBeyondEconomicLifePercentage(BigDecimal _beyondEconomicLifePercentage) throws Exception {
        if (_beyondEconomicLifePercentage == null) {
            _beyondEconomicLifePercentage = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_beyondEconomicLifePercentage.equals(this.getBeyondEconomicLifePercentage())) {
            return;
        }
        this.preSet();
        this.beyondEconomicLifePercentage = _beyondEconomicLifePercentage;
        this.autoUpdate();
    }

    @Override
    public void setPostedDepreciationBalanceBeyondEconomicLife(BigDecimal _postedDepreciationBalanceBeyondEconomicLife) throws Exception {
        if (_postedDepreciationBalanceBeyondEconomicLife == null) {
            _postedDepreciationBalanceBeyondEconomicLife = new BigDecimal("0.00").setScale(2, 6);
        }
        if (_postedDepreciationBalanceBeyondEconomicLife.equals(this.getPostedDepreciationBalanceBeyondEconomicLife())) {
            return;
        }
        this.preSet();
        this.postedDepreciationBalanceBeyondEconomicLife = _postedDepreciationBalanceBeyondEconomicLife;
        this.autoUpdate();
    }

    @Override
    public void setAnnuityInterestTable(InterestTable object) throws Exception {
        this.transientAnnuityInterestTable = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "annuityInterestTableId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "annuityInterestTableId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("AnnuityInterestTable", object);
    }

    @Override
    public void setInterestTable(InterestTable object) throws Exception {
        this.transientInterestTable = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "interestTableId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "interestTableId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("InterestTable", object);
    }

    @Override
    public void setYearPercentageTable(YearPercentageTable object) throws Exception {
        this.transientYearPercentageTable = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "yearPercentageTableId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "yearPercentageTableId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("YearPercentageTable", object);
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.cora = "";
        this.assetId = "";
        this.accountingPrinciple = 0;
        this.documentNr1stTransaction = 0;
        this.seqNr1stTransaction = 0;
        this.postedAcquisitionBalance = new BigDecimal("0.00").setScale(2, 6);
        this.lastAcquisitionBookYear = 0;
        this.lastAcquisitionPeriod = 0;
        this.postedDepreciationBalance = new BigDecimal("0.00").setScale(2, 6);
        this.lastDepreciationBookYear = 0;
        this.lastDepreciationPeriod = 0;
        this.currentBookvalueBalance = new BigDecimal("0.00").setScale(2, 6);
        this.previousBookvalueBalance = new BigDecimal("0.00").setScale(2, 6);
        this.depreciationMethod = 0;
        this.interestCalculationMethod = 0;
        this.residualValue = new BigDecimal("0.00").setScale(2, 6);
        this.residualPercentage = new BigDecimal("0.00").setScale(2, 6);
        this.startPeriodHandlingMethod = 0;
        this.degressivePercentage = new BigDecimal("0.00").setScale(2, 6);
        this.annuityPercentage = new BigDecimal("0.000").setScale(3, 6);
        this.startDepreciationBookYear = 0;
        this.startDepreciationPeriod = 0;
        this.numberOfDepreciatedPeriods = 0;
        this.depreciatableLife = 0;
        this.depreciationPaused = false;
        this.interestPercentage = new BigDecimal("0.000").setScale(3, 6);
        this.interestBookYear = 0;
        this.interestPeriod = 0;
        this.correctionAmount445A = new BigDecimal("0.00").setScale(2, 6);
        this.correctionAmount445B = new BigDecimal("0.00").setScale(2, 6);
        this.beyondEconomicLifePercentage = new BigDecimal("0.00").setScale(2, 6);
        this.postedDepreciationBalanceBeyondEconomicLife = new BigDecimal("0.00").setScale(2, 6);
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.cora = this.cora;
        this.currentDBImage.assetId = this.assetId;
        this.currentDBImage.accountingPrinciple = this.accountingPrinciple;
        this.currentDBImage.documentNr1stTransaction = this.documentNr1stTransaction;
        this.currentDBImage.seqNr1stTransaction = this.seqNr1stTransaction;
        this.currentDBImage.postedAcquisitionBalance = this.postedAcquisitionBalance;
        this.currentDBImage.lastAcquisitionBookYear = this.lastAcquisitionBookYear;
        this.currentDBImage.lastAcquisitionPeriod = this.lastAcquisitionPeriod;
        this.currentDBImage.postedDepreciationBalance = this.postedDepreciationBalance;
        this.currentDBImage.lastDepreciationBookYear = this.lastDepreciationBookYear;
        this.currentDBImage.lastDepreciationPeriod = this.lastDepreciationPeriod;
        this.currentDBImage.currentBookvalueBalance = this.currentBookvalueBalance;
        this.currentDBImage.previousBookvalueBalance = this.previousBookvalueBalance;
        this.currentDBImage.depreciationMethod = this.depreciationMethod;
        this.currentDBImage.interestCalculationMethod = this.interestCalculationMethod;
        this.currentDBImage.interestTableId = this.interestTableId;
        this.currentDBImage.residualValue = this.residualValue;
        this.currentDBImage.residualPercentage = this.residualPercentage;
        this.currentDBImage.yearPercentageTableId = this.yearPercentageTableId;
        this.currentDBImage.startPeriodHandlingMethod = this.startPeriodHandlingMethod;
        this.currentDBImage.degressivePercentage = this.degressivePercentage;
        this.currentDBImage.annuityPercentage = this.annuityPercentage;
        this.currentDBImage.annuityInterestTableId = this.annuityInterestTableId;
        this.currentDBImage.startDepreciationBookYear = this.startDepreciationBookYear;
        this.currentDBImage.startDepreciationPeriod = this.startDepreciationPeriod;
        this.currentDBImage.numberOfDepreciatedPeriods = this.numberOfDepreciatedPeriods;
        this.currentDBImage.depreciatableLife = this.depreciatableLife;
        this.currentDBImage.depreciationPaused = this.depreciationPaused;
        this.currentDBImage.interestPercentage = this.interestPercentage;
        this.currentDBImage.interestBookYear = this.interestBookYear;
        this.currentDBImage.interestPeriod = this.interestPeriod;
        this.currentDBImage.correctionAmount445A = this.correctionAmount445A;
        this.currentDBImage.correctionAmount445B = this.correctionAmount445B;
        this.currentDBImage.beyondEconomicLifePercentage = this.beyondEconomicLifePercentage;
        this.currentDBImage.postedDepreciationBalanceBeyondEconomicLife = this.postedDepreciationBalanceBeyondEconomicLife;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("Valuation is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            ValuationPK key = new ValuationPK();
            key.setCompanyId(this.getCompanyId());
            key.setCora(this.getCora());
            key.setAssetId(this.getAssetId());
            key.setAccountingPrinciple(this.getAccountingPrinciple());
            ((ValuationManager_Impl)ValuationManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            try {
                rs = ((ValuationManager_Impl)ValuationManager_Impl.getInstance(this.dbd)).getResultSet((ValuationPK)this.getPrimaryKey());
                this.loadData(rs);
            }
            catch (FinderException e) {
                throw new DeletedException("Deleted by other user");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("-1103548229_" + this.dbd.getDBId() + this.companyId + this.cora + this.assetId + this.accountingPrinciple).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public ValuationDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public ValuationDataBean getValuationDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private ValuationDataBean getDataBean(ValuationDataBean bean) throws Exception {
        if (bean == null) {
            bean = new ValuationDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setCora(this.getCora());
        bean.setAssetId(this.getAssetId());
        bean.setAccountingPrinciple(this.getAccountingPrinciple());
        bean.setDocumentNr1stTransaction(this.getDocumentNr1stTransaction());
        bean.setSeqNr1stTransaction(this.getSeqNr1stTransaction());
        bean.setPostedAcquisitionBalance(this.getPostedAcquisitionBalance());
        bean.setLastAcquisitionBookYear(this.getLastAcquisitionBookYear());
        bean.setLastAcquisitionPeriod(this.getLastAcquisitionPeriod());
        bean.setPostedDepreciationBalance(this.getPostedDepreciationBalance());
        bean.setLastDepreciationBookYear(this.getLastDepreciationBookYear());
        bean.setLastDepreciationPeriod(this.getLastDepreciationPeriod());
        bean.setCurrentBookvalueBalance(this.getCurrentBookvalueBalance());
        bean.setPreviousBookvalueBalance(this.getPreviousBookvalueBalance());
        bean.setDepreciationMethod(this.getDepreciationMethod());
        bean.setInterestCalculationMethod(this.getInterestCalculationMethod());
        bean.setInterestTableId(this.getInterestTableId());
        bean.setResidualValue(this.getResidualValue());
        bean.setResidualPercentage(this.getResidualPercentage());
        bean.setYearPercentageTableId(this.getYearPercentageTableId());
        bean.setStartPeriodHandlingMethod(this.getStartPeriodHandlingMethod());
        bean.setDegressivePercentage(this.getDegressivePercentage());
        bean.setAnnuityPercentage(this.getAnnuityPercentage());
        bean.setAnnuityInterestTableId(this.getAnnuityInterestTableId());
        bean.setStartDepreciationBookYear(this.getStartDepreciationBookYear());
        bean.setStartDepreciationPeriod(this.getStartDepreciationPeriod());
        bean.setNumberOfDepreciatedPeriods(this.getNumberOfDepreciatedPeriods());
        bean.setDepreciatableLife(this.getDepreciatableLife());
        bean.setDepreciationPaused(this.getDepreciationPaused());
        bean.setInterestPercentage(this.getInterestPercentage());
        bean.setInterestBookYear(this.getInterestBookYear());
        bean.setInterestPeriod(this.getInterestPeriod());
        bean.setCorrectionAmount445A(this.getCorrectionAmount445A());
        bean.setCorrectionAmount445B(this.getCorrectionAmount445B());
        bean.setBeyondEconomicLifePercentage(this.getBeyondEconomicLifePercentage());
        bean.setPostedDepreciationBalanceBeyondEconomicLife(this.getPostedDepreciationBalanceBeyondEconomicLife());
        return bean;
    }

    public boolean equals(Object object) {
        Valuation_Impl bo;
        block22: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            try {
                                                if (object != null && object instanceof Valuation_Impl) break block14;
                                                return false;
                                            }
                                            catch (Exception e) {
                                                throw new RuntimeException(e.getMessage());
                                            }
                                        }
                                        bo = (Valuation_Impl)object;
                                        if (bo.getCompanyId() != null) break block15;
                                        if (this.getCompanyId() != null) {
                                            return false;
                                        }
                                        break block16;
                                    }
                                    if (bo.getCompanyId().equals(this.getCompanyId())) break block16;
                                    return false;
                                }
                                if (bo.getCora() != null) break block17;
                                if (this.getCora() != null) {
                                    return false;
                                }
                                break block18;
                            }
                            if (bo.getCora().equals(this.getCora())) break block18;
                            return false;
                        }
                        if (bo.getAssetId() != null) break block19;
                        if (this.getAssetId() != null) {
                            return false;
                        }
                        break block20;
                    }
                    if (bo.getAssetId().equals(this.getAssetId())) break block20;
                    return false;
                }
                if (bo.getAccountingPrinciple() == this.getAccountingPrinciple()) break block21;
                return false;
            }
            if (bo.getClass() == this.getClass()) break block22;
            return false;
        }
        return bo.getDBId() == this.getDBId();
    }

    @Override
    public void update(ValuationDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(ValuationDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setCora(bean.getCora());
            this.setAssetId(bean.getAssetId());
            this.setAccountingPrinciple(bean.getAccountingPrinciple());
            this.setDocumentNr1stTransaction(bean.getDocumentNr1stTransaction());
            this.setSeqNr1stTransaction(bean.getSeqNr1stTransaction());
            this.setPostedAcquisitionBalance(bean.getPostedAcquisitionBalance());
            this.setLastAcquisitionBookYear(bean.getLastAcquisitionBookYear());
            this.setLastAcquisitionPeriod(bean.getLastAcquisitionPeriod());
            this.setPostedDepreciationBalance(bean.getPostedDepreciationBalance());
            this.setLastDepreciationBookYear(bean.getLastDepreciationBookYear());
            this.setLastDepreciationPeriod(bean.getLastDepreciationPeriod());
            this.setCurrentBookvalueBalance(bean.getCurrentBookvalueBalance());
            this.setPreviousBookvalueBalance(bean.getPreviousBookvalueBalance());
            this.setDepreciationMethod(bean.getDepreciationMethod());
            this.setInterestCalculationMethod(bean.getInterestCalculationMethod());
            this.setInterestTableId(bean.getInterestTableId());
            this.setResidualValue(bean.getResidualValue());
            this.setResidualPercentage(bean.getResidualPercentage());
            this.setYearPercentageTableId(bean.getYearPercentageTableId());
            this.setStartPeriodHandlingMethod(bean.getStartPeriodHandlingMethod());
            this.setDegressivePercentage(bean.getDegressivePercentage());
            this.setAnnuityPercentage(bean.getAnnuityPercentage());
            this.setAnnuityInterestTableId(bean.getAnnuityInterestTableId());
            this.setStartDepreciationBookYear(bean.getStartDepreciationBookYear());
            this.setStartDepreciationPeriod(bean.getStartDepreciationPeriod());
            this.setNumberOfDepreciatedPeriods(bean.getNumberOfDepreciatedPeriods());
            this.setDepreciatableLife(bean.getDepreciatableLife());
            this.setDepreciationPaused(bean.getDepreciationPaused());
            this.setInterestPercentage(bean.getInterestPercentage());
            this.setInterestBookYear(bean.getInterestBookYear());
            this.setInterestPeriod(bean.getInterestPeriod());
            this.setCorrectionAmount445A(bean.getCorrectionAmount445A());
            this.setCorrectionAmount445B(bean.getCorrectionAmount445B());
            this.setBeyondEconomicLifePercentage(bean.getBeyondEconomicLifePercentage());
            this.setPostedDepreciationBalanceBeyondEconomicLife(bean.getPostedDepreciationBalanceBeyondEconomicLife());
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "Valuation is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.Valuation.save");
        key.append(image.interestTableId == null ? "0" : "1");
        key.append(image.yearPercentageTableId == null ? "0" : "1");
        key.append(image.annuityInterestTableId == null ? "0" : "1");
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(key.toString());
                if (prep == null) {
                    prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? " + ", " + pmd.getFieldName("Cora", provider) + " = ? " + ", " + pmd.getFieldName("AssetId", provider) + " = ? " + ", " + pmd.getFieldName("AccountingPrinciple", provider) + " = ? " + ", " + pmd.getFieldName("DocumentNr1stTransaction", provider) + " = ? " + ", " + pmd.getFieldName("SeqNr 1st transaction", provider) + " = ? " + ", " + pmd.getFieldName("PostedAcquisitionBalance", provider) + " = ? " + ", " + pmd.getFieldName("LastAcquisitionBookYear", provider) + " = ? " + ", " + pmd.getFieldName("LastAcquisitionPeriod", provider) + " = ? " + ", " + pmd.getFieldName("PostedDepreciationBalance", provider) + " = ? " + ", " + pmd.getFieldName("LastDepreciationBookYear", provider) + " = ? " + ", " + pmd.getFieldName("LastDepreciationPeriod", provider) + " = ? " + ", " + pmd.getFieldName("CurrentBookvalueBalance", provider) + " = ? " + ", " + pmd.getFieldName("PreviousBookvalueBalance", provider) + " = ? " + ", " + pmd.getFieldName("DepreciationMethod", provider) + " = ? " + ", " + pmd.getFieldName("InterestCalculationMethod", provider) + " = ? " + ", " + pmd.getFieldName("InterestTableId", provider) + " = ? " + ", " + pmd.getFieldName("ResidualValue", provider) + " = ? " + ", " + pmd.getFieldName("ResidualPercentage", provider) + " = ? " + ", " + pmd.getFieldName("YearPercentageTableId", provider) + " = ? " + ", " + pmd.getFieldName("StartPeriodHandlingMethod", provider) + " = ? " + ", " + pmd.getFieldName("DegressivePercentage", provider) + " = ? " + ", " + pmd.getFieldName("AnnuityPercentage", provider) + " = ? " + ", " + pmd.getFieldName("AnnuityInterestTableId", provider) + " = ? " + ", " + pmd.getFieldName("StartDepreciationBookYear", provider) + " = ? " + ", " + pmd.getFieldName("StartDepreciationPeriod", provider) + " = ? " + ", " + pmd.getFieldName("NumberOfDepreciatedPeriods", provider) + " = ? " + ", " + pmd.getFieldName("DepreciatableLife", provider) + " = ? " + ", " + pmd.getFieldName("DepreciationPaused", provider) + " = ? " + ", " + pmd.getFieldName("InterestPercentage", provider) + " = ? " + ", " + pmd.getFieldName("InterestBookYear", provider) + " = ? " + ", " + pmd.getFieldName("InterestPeriod", provider) + " = ? " + ", " + pmd.getFieldName("CorrectionAmount445A", provider) + " = ? " + ", " + pmd.getFieldName("CorrectionAmount445B", provider) + " = ? " + ", " + pmd.getFieldName("BeyondEconomicLifePercentage", provider) + " = ? " + ", " + pmd.getFieldName("PostedDepreciationBalanceBeyondEconomicLife", provider) + " = ? " + " WHERE " + pmd.getFieldName("CompanyId", provider) + " = ? " + " AND  " + pmd.getFieldName("Cora", provider) + " = ? " + " AND  " + pmd.getFieldName("AssetId", provider) + " = ? " + " AND  " + pmd.getFieldName("AccountingPrinciple", provider) + " = ? " + " AND  " + pmd.getFieldName("DocumentNr1stTransaction", provider) + " = ? " + " AND  " + pmd.getFieldName("SeqNr 1st transaction", provider) + " = ? " + " AND  " + pmd.getFieldName("PostedAcquisitionBalance", provider) + " = ? " + " AND  " + pmd.getFieldName("LastAcquisitionBookYear", provider) + " = ? " + " AND  " + pmd.getFieldName("LastAcquisitionPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("PostedDepreciationBalance", provider) + " = ? " + " AND  " + pmd.getFieldName("LastDepreciationBookYear", provider) + " = ? " + " AND  " + pmd.getFieldName("LastDepreciationPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("CurrentBookvalueBalance", provider) + " = ? " + " AND  " + pmd.getFieldName("PreviousBookvalueBalance", provider) + " = ? " + " AND  " + pmd.getFieldName("DepreciationMethod", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestCalculationMethod", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestTableId", provider) + (image.interestTableId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("ResidualValue", provider) + " = ? " + " AND  " + pmd.getFieldName("ResidualPercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("YearPercentageTableId", provider) + (image.yearPercentageTableId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("StartPeriodHandlingMethod", provider) + " = ? " + " AND  " + pmd.getFieldName("DegressivePercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("AnnuityPercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("AnnuityInterestTableId", provider) + (image.annuityInterestTableId == null ? " IS NULL" : " = ?") + " AND  " + pmd.getFieldName("StartDepreciationBookYear", provider) + " = ? " + " AND  " + pmd.getFieldName("StartDepreciationPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("NumberOfDepreciatedPeriods", provider) + " = ? " + " AND  " + pmd.getFieldName("DepreciatableLife", provider) + " = ? " + " AND  " + pmd.getFieldName("DepreciationPaused", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestPercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestBookYear", provider) + " = ? " + " AND  " + pmd.getFieldName("InterestPeriod", provider) + " = ? " + " AND  " + pmd.getFieldName("CorrectionAmount445A", provider) + " = ? " + " AND  " + pmd.getFieldName("CorrectionAmount445B", provider) + " = ? " + " AND  " + pmd.getFieldName("BeyondEconomicLifePercentage", provider) + " = ? " + " AND  " + pmd.getFieldName("PostedDepreciationBalanceBeyondEconomicLife", provider) + " = ? ");
                }
                int parmIndex = 1;
                prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.cora, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)this.assetId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(this.accountingPrinciple), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.documentNr1stTransaction), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.seqNr1stTransaction), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.postedAcquisitionBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Integer(this.lastAcquisitionBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.lastAcquisitionPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.postedDepreciationBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Integer(this.lastDepreciationBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.lastDepreciationPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.currentBookvalueBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.previousBookvalueBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Integer(this.depreciationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                if (this.interestTableId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)this.residualValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.residualPercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                if (this.yearPercentageTableId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.yearPercentageTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(this.startPeriodHandlingMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.degressivePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.annuityPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (this.annuityInterestTableId == null) {
                    prep.setNull(parmIndex++, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(parmIndex++, (Object)this.annuityInterestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(this.startDepreciationBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.startDepreciationPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.numberOfDepreciatedPeriods), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.depreciatableLife), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(this.depreciationPaused), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)this.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(parmIndex++, (Object)new Integer(this.interestBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(this.interestPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)this.correctionAmount445A, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.correctionAmount445B, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.beyondEconomicLifePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)this.postedDepreciationBalanceBeyondEconomicLife, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.cora, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)image.assetId, mapping.getJDBCTypeFor("String"));
                prep.setObject(parmIndex++, (Object)new Integer(image.accountingPrinciple), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.documentNr1stTransaction), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.seqNr1stTransaction), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.postedAcquisitionBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Integer(image.lastAcquisitionBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.lastAcquisitionPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.postedDepreciationBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Integer(image.lastDepreciationBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.lastDepreciationPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.currentBookvalueBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.previousBookvalueBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)new Integer(image.depreciationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                if (image.interestTableId != null) {
                    prep.setObject(parmIndex++, (Object)image.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)image.residualValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.residualPercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                if (image.yearPercentageTableId != null) {
                    prep.setObject(parmIndex++, (Object)image.yearPercentageTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(image.startPeriodHandlingMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.degressivePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.annuityPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (image.annuityInterestTableId != null) {
                    prep.setObject(parmIndex++, (Object)image.annuityInterestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(parmIndex++, (Object)new Integer(image.startDepreciationBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.startDepreciationPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.numberOfDepreciatedPeriods), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.depreciatableLife), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Boolean(image.depreciationPaused), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(parmIndex++, (Object)image.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(parmIndex++, (Object)new Integer(image.interestBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)new Integer(image.interestPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(parmIndex++, (Object)image.correctionAmount445A, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.correctionAmount445B, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.beyondEconomicLifePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(parmIndex++, (Object)image.postedDepreciationBalanceBeyondEconomicLife, mapping.getJDBCTypeFor("BigDecimal"), 2);
                int n = prep.executeUpdate();
                if (n == 0) {
                    this.rollback(true);
                    throw new UpdateException("Valuation modified by other user!", this);
                }
                this.updateDBImage();
                this.dirty = false;
                this.stored = true;
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof JSQLException)) {
                    Log.error((String)e.getMessage());
                }
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.Valuation.insert");
                if (prep == null) {
                    prep = dbc.getPreparedStatement("nl.ibs.fac.db.Valuation.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("Cora", provider) + ", " + pmd.getFieldName("AssetId", provider) + ", " + pmd.getFieldName("AccountingPrinciple", provider) + ", " + pmd.getFieldName("DocumentNr1stTransaction", provider) + ", " + pmd.getFieldName("SeqNr 1st transaction", provider) + ", " + pmd.getFieldName("PostedAcquisitionBalance", provider) + ", " + pmd.getFieldName("LastAcquisitionBookYear", provider) + ", " + pmd.getFieldName("LastAcquisitionPeriod", provider) + ", " + pmd.getFieldName("PostedDepreciationBalance", provider) + ", " + pmd.getFieldName("LastDepreciationBookYear", provider) + ", " + pmd.getFieldName("LastDepreciationPeriod", provider) + ", " + pmd.getFieldName("CurrentBookvalueBalance", provider) + ", " + pmd.getFieldName("PreviousBookvalueBalance", provider) + ", " + pmd.getFieldName("DepreciationMethod", provider) + ", " + pmd.getFieldName("InterestCalculationMethod", provider) + ", " + pmd.getFieldName("InterestTableId", provider) + ", " + pmd.getFieldName("ResidualValue", provider) + ", " + pmd.getFieldName("ResidualPercentage", provider) + ", " + pmd.getFieldName("YearPercentageTableId", provider) + ", " + pmd.getFieldName("StartPeriodHandlingMethod", provider) + ", " + pmd.getFieldName("DegressivePercentage", provider) + ", " + pmd.getFieldName("AnnuityPercentage", provider) + ", " + pmd.getFieldName("AnnuityInterestTableId", provider) + ", " + pmd.getFieldName("StartDepreciationBookYear", provider) + ", " + pmd.getFieldName("StartDepreciationPeriod", provider) + ", " + pmd.getFieldName("NumberOfDepreciatedPeriods", provider) + ", " + pmd.getFieldName("DepreciatableLife", provider) + ", " + pmd.getFieldName("DepreciationPaused", provider) + ", " + pmd.getFieldName("InterestPercentage", provider) + ", " + pmd.getFieldName("InterestBookYear", provider) + ", " + pmd.getFieldName("InterestPeriod", provider) + ", " + pmd.getFieldName("CorrectionAmount445A", provider) + ", " + pmd.getFieldName("CorrectionAmount445B", provider) + ", " + pmd.getFieldName("BeyondEconomicLifePercentage", provider) + ", " + pmd.getFieldName("PostedDepreciationBalanceBeyondEconomicLife", provider) + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                }
                prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
                prep.setObject(2, (Object)this.cora, mapping.getJDBCTypeFor("String"));
                prep.setObject(3, (Object)this.assetId, mapping.getJDBCTypeFor("String"));
                prep.setObject(4, (Object)new Integer(this.accountingPrinciple), mapping.getJDBCTypeFor("int"));
                prep.setObject(5, (Object)new Integer(this.documentNr1stTransaction), mapping.getJDBCTypeFor("int"));
                prep.setObject(6, (Object)new Integer(this.seqNr1stTransaction), mapping.getJDBCTypeFor("int"));
                prep.setObject(7, (Object)this.postedAcquisitionBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(8, (Object)new Integer(this.lastAcquisitionBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(9, (Object)new Integer(this.lastAcquisitionPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(10, (Object)this.postedDepreciationBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(11, (Object)new Integer(this.lastDepreciationBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(12, (Object)new Integer(this.lastDepreciationPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(13, (Object)this.currentBookvalueBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(14, (Object)this.previousBookvalueBalance, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(15, (Object)new Integer(this.depreciationMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(16, (Object)new Integer(this.interestCalculationMethod), mapping.getJDBCTypeFor("int"));
                if (this.interestTableId == null) {
                    prep.setNull(17, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(17, (Object)this.interestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(18, (Object)this.residualValue, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(19, (Object)this.residualPercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                if (this.yearPercentageTableId == null) {
                    prep.setNull(20, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(20, (Object)this.yearPercentageTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(21, (Object)new Integer(this.startPeriodHandlingMethod), mapping.getJDBCTypeFor("int"));
                prep.setObject(22, (Object)this.degressivePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(23, (Object)this.annuityPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                if (this.annuityInterestTableId == null) {
                    prep.setNull(24, mapping.getJDBCTypeFor("String"));
                } else {
                    prep.setObject(24, (Object)this.annuityInterestTableId, mapping.getJDBCTypeFor("String"));
                }
                prep.setObject(25, (Object)new Integer(this.startDepreciationBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(26, (Object)new Integer(this.startDepreciationPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(27, (Object)new Integer(this.numberOfDepreciatedPeriods), mapping.getJDBCTypeFor("int"));
                prep.setObject(28, (Object)new Integer(this.depreciatableLife), mapping.getJDBCTypeFor("int"));
                prep.setObject(29, (Object)new Boolean(this.depreciationPaused), mapping.getJDBCTypeFor("boolean"));
                prep.setObject(30, (Object)this.interestPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
                prep.setObject(31, (Object)new Integer(this.interestBookYear), mapping.getJDBCTypeFor("int"));
                prep.setObject(32, (Object)new Integer(this.interestPeriod), mapping.getJDBCTypeFor("int"));
                prep.setObject(33, (Object)this.correctionAmount445A, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(34, (Object)this.correctionAmount445B, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(35, (Object)this.beyondEconomicLifePercentage, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.setObject(36, (Object)this.postedDepreciationBalanceBeyondEconomicLife, mapping.getJDBCTypeFor("BigDecimal"), 2);
                prep.executeUpdate();
                this.updateDBImage();
                this.dirty = false;
                DBPersistenceManager.cache(this);
                if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                    ((AtomicDBTransaction)provider).addListener(this);
                    this.participatingInTransaction = true;
                }
            }
            catch (CreateException e) {
                this.stored = false;
                throw e;
            }
            catch (Exception e) {
                this.stored = false;
                Log.error((String)e.getMessage());
                throw e;
            }
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.cora = this.currentDBImage.cora;
            this.transactionImage.dbImage.assetId = this.currentDBImage.assetId;
            this.transactionImage.dbImage.accountingPrinciple = this.currentDBImage.accountingPrinciple;
            this.transactionImage.dbImage.documentNr1stTransaction = this.currentDBImage.documentNr1stTransaction;
            this.transactionImage.dbImage.seqNr1stTransaction = this.currentDBImage.seqNr1stTransaction;
            this.transactionImage.dbImage.postedAcquisitionBalance = this.currentDBImage.postedAcquisitionBalance;
            this.transactionImage.dbImage.lastAcquisitionBookYear = this.currentDBImage.lastAcquisitionBookYear;
            this.transactionImage.dbImage.lastAcquisitionPeriod = this.currentDBImage.lastAcquisitionPeriod;
            this.transactionImage.dbImage.postedDepreciationBalance = this.currentDBImage.postedDepreciationBalance;
            this.transactionImage.dbImage.lastDepreciationBookYear = this.currentDBImage.lastDepreciationBookYear;
            this.transactionImage.dbImage.lastDepreciationPeriod = this.currentDBImage.lastDepreciationPeriod;
            this.transactionImage.dbImage.currentBookvalueBalance = this.currentDBImage.currentBookvalueBalance;
            this.transactionImage.dbImage.previousBookvalueBalance = this.currentDBImage.previousBookvalueBalance;
            this.transactionImage.dbImage.depreciationMethod = this.currentDBImage.depreciationMethod;
            this.transactionImage.dbImage.interestCalculationMethod = this.currentDBImage.interestCalculationMethod;
            this.transactionImage.dbImage.interestTableId = this.currentDBImage.interestTableId;
            this.transactionImage.dbImage.residualValue = this.currentDBImage.residualValue;
            this.transactionImage.dbImage.residualPercentage = this.currentDBImage.residualPercentage;
            this.transactionImage.dbImage.yearPercentageTableId = this.currentDBImage.yearPercentageTableId;
            this.transactionImage.dbImage.startPeriodHandlingMethod = this.currentDBImage.startPeriodHandlingMethod;
            this.transactionImage.dbImage.degressivePercentage = this.currentDBImage.degressivePercentage;
            this.transactionImage.dbImage.annuityPercentage = this.currentDBImage.annuityPercentage;
            this.transactionImage.dbImage.annuityInterestTableId = this.currentDBImage.annuityInterestTableId;
            this.transactionImage.dbImage.startDepreciationBookYear = this.currentDBImage.startDepreciationBookYear;
            this.transactionImage.dbImage.startDepreciationPeriod = this.currentDBImage.startDepreciationPeriod;
            this.transactionImage.dbImage.numberOfDepreciatedPeriods = this.currentDBImage.numberOfDepreciatedPeriods;
            this.transactionImage.dbImage.depreciatableLife = this.currentDBImage.depreciatableLife;
            this.transactionImage.dbImage.depreciationPaused = this.currentDBImage.depreciationPaused;
            this.transactionImage.dbImage.interestPercentage = this.currentDBImage.interestPercentage;
            this.transactionImage.dbImage.interestBookYear = this.currentDBImage.interestBookYear;
            this.transactionImage.dbImage.interestPeriod = this.currentDBImage.interestPeriod;
            this.transactionImage.dbImage.correctionAmount445A = this.currentDBImage.correctionAmount445A;
            this.transactionImage.dbImage.correctionAmount445B = this.currentDBImage.correctionAmount445B;
            this.transactionImage.dbImage.beyondEconomicLifePercentage = this.currentDBImage.beyondEconomicLifePercentage;
            this.transactionImage.dbImage.postedDepreciationBalanceBeyondEconomicLife = this.currentDBImage.postedDepreciationBalanceBeyondEconomicLife;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.cora = this.transactionImage.dbImage.cora;
        this.currentDBImage.assetId = this.transactionImage.dbImage.assetId;
        this.currentDBImage.accountingPrinciple = this.transactionImage.dbImage.accountingPrinciple;
        this.currentDBImage.documentNr1stTransaction = this.transactionImage.dbImage.documentNr1stTransaction;
        this.currentDBImage.seqNr1stTransaction = this.transactionImage.dbImage.seqNr1stTransaction;
        this.currentDBImage.postedAcquisitionBalance = this.transactionImage.dbImage.postedAcquisitionBalance;
        this.currentDBImage.lastAcquisitionBookYear = this.transactionImage.dbImage.lastAcquisitionBookYear;
        this.currentDBImage.lastAcquisitionPeriod = this.transactionImage.dbImage.lastAcquisitionPeriod;
        this.currentDBImage.postedDepreciationBalance = this.transactionImage.dbImage.postedDepreciationBalance;
        this.currentDBImage.lastDepreciationBookYear = this.transactionImage.dbImage.lastDepreciationBookYear;
        this.currentDBImage.lastDepreciationPeriod = this.transactionImage.dbImage.lastDepreciationPeriod;
        this.currentDBImage.currentBookvalueBalance = this.transactionImage.dbImage.currentBookvalueBalance;
        this.currentDBImage.previousBookvalueBalance = this.transactionImage.dbImage.previousBookvalueBalance;
        this.currentDBImage.depreciationMethod = this.transactionImage.dbImage.depreciationMethod;
        this.currentDBImage.interestCalculationMethod = this.transactionImage.dbImage.interestCalculationMethod;
        this.currentDBImage.interestTableId = this.transactionImage.dbImage.interestTableId;
        this.currentDBImage.residualValue = this.transactionImage.dbImage.residualValue;
        this.currentDBImage.residualPercentage = this.transactionImage.dbImage.residualPercentage;
        this.currentDBImage.yearPercentageTableId = this.transactionImage.dbImage.yearPercentageTableId;
        this.currentDBImage.startPeriodHandlingMethod = this.transactionImage.dbImage.startPeriodHandlingMethod;
        this.currentDBImage.degressivePercentage = this.transactionImage.dbImage.degressivePercentage;
        this.currentDBImage.annuityPercentage = this.transactionImage.dbImage.annuityPercentage;
        this.currentDBImage.annuityInterestTableId = this.transactionImage.dbImage.annuityInterestTableId;
        this.currentDBImage.startDepreciationBookYear = this.transactionImage.dbImage.startDepreciationBookYear;
        this.currentDBImage.startDepreciationPeriod = this.transactionImage.dbImage.startDepreciationPeriod;
        this.currentDBImage.numberOfDepreciatedPeriods = this.transactionImage.dbImage.numberOfDepreciatedPeriods;
        this.currentDBImage.depreciatableLife = this.transactionImage.dbImage.depreciatableLife;
        this.currentDBImage.depreciationPaused = this.transactionImage.dbImage.depreciationPaused;
        this.currentDBImage.interestPercentage = this.transactionImage.dbImage.interestPercentage;
        this.currentDBImage.interestBookYear = this.transactionImage.dbImage.interestBookYear;
        this.currentDBImage.interestPeriod = this.transactionImage.dbImage.interestPeriod;
        this.currentDBImage.correctionAmount445A = this.transactionImage.dbImage.correctionAmount445A;
        this.currentDBImage.correctionAmount445B = this.transactionImage.dbImage.correctionAmount445B;
        this.currentDBImage.beyondEconomicLifePercentage = this.transactionImage.dbImage.beyondEconomicLifePercentage;
        this.currentDBImage.postedDepreciationBalanceBeyondEconomicLife = this.transactionImage.dbImage.postedDepreciationBalanceBeyondEconomicLife;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.cora = this.transactionImage.dbImage.cora;
            this.assetId = this.transactionImage.dbImage.assetId;
            this.accountingPrinciple = this.transactionImage.dbImage.accountingPrinciple;
            this.documentNr1stTransaction = this.transactionImage.dbImage.documentNr1stTransaction;
            this.seqNr1stTransaction = this.transactionImage.dbImage.seqNr1stTransaction;
            this.postedAcquisitionBalance = this.transactionImage.dbImage.postedAcquisitionBalance;
            this.lastAcquisitionBookYear = this.transactionImage.dbImage.lastAcquisitionBookYear;
            this.lastAcquisitionPeriod = this.transactionImage.dbImage.lastAcquisitionPeriod;
            this.postedDepreciationBalance = this.transactionImage.dbImage.postedDepreciationBalance;
            this.lastDepreciationBookYear = this.transactionImage.dbImage.lastDepreciationBookYear;
            this.lastDepreciationPeriod = this.transactionImage.dbImage.lastDepreciationPeriod;
            this.currentBookvalueBalance = this.transactionImage.dbImage.currentBookvalueBalance;
            this.previousBookvalueBalance = this.transactionImage.dbImage.previousBookvalueBalance;
            this.depreciationMethod = this.transactionImage.dbImage.depreciationMethod;
            this.interestCalculationMethod = this.transactionImage.dbImage.interestCalculationMethod;
            this.interestTableId = this.transactionImage.dbImage.interestTableId;
            this.residualValue = this.transactionImage.dbImage.residualValue;
            this.residualPercentage = this.transactionImage.dbImage.residualPercentage;
            this.yearPercentageTableId = this.transactionImage.dbImage.yearPercentageTableId;
            this.startPeriodHandlingMethod = this.transactionImage.dbImage.startPeriodHandlingMethod;
            this.degressivePercentage = this.transactionImage.dbImage.degressivePercentage;
            this.annuityPercentage = this.transactionImage.dbImage.annuityPercentage;
            this.annuityInterestTableId = this.transactionImage.dbImage.annuityInterestTableId;
            this.startDepreciationBookYear = this.transactionImage.dbImage.startDepreciationBookYear;
            this.startDepreciationPeriod = this.transactionImage.dbImage.startDepreciationPeriod;
            this.numberOfDepreciatedPeriods = this.transactionImage.dbImage.numberOfDepreciatedPeriods;
            this.depreciatableLife = this.transactionImage.dbImage.depreciatableLife;
            this.depreciationPaused = this.transactionImage.dbImage.depreciationPaused;
            this.interestPercentage = this.transactionImage.dbImage.interestPercentage;
            this.interestBookYear = this.transactionImage.dbImage.interestBookYear;
            this.interestPeriod = this.transactionImage.dbImage.interestPeriod;
            this.correctionAmount445A = this.transactionImage.dbImage.correctionAmount445A;
            this.correctionAmount445B = this.transactionImage.dbImage.correctionAmount445B;
            this.beyondEconomicLifePercentage = this.transactionImage.dbImage.beyondEconomicLifePercentage;
            this.postedDepreciationBalanceBeyondEconomicLife = this.transactionImage.dbImage.postedDepreciationBalanceBeyondEconomicLife;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            int x = 0;
            while (x < list.size()) {
                if (((BusinessObject_Impl)list.get(x)).isDeleted()) {
                    list.remove(x--);
                }
                ++x;
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private String cora;
        private String assetId;
        private int accountingPrinciple;
        private int documentNr1stTransaction;
        private int seqNr1stTransaction;
        private BigDecimal postedAcquisitionBalance;
        private int lastAcquisitionBookYear;
        private int lastAcquisitionPeriod;
        private BigDecimal postedDepreciationBalance;
        private int lastDepreciationBookYear;
        private int lastDepreciationPeriod;
        private BigDecimal currentBookvalueBalance;
        private BigDecimal previousBookvalueBalance;
        private int depreciationMethod;
        private int interestCalculationMethod;
        private String interestTableId;
        private BigDecimal residualValue;
        private BigDecimal residualPercentage;
        private String yearPercentageTableId;
        private int startPeriodHandlingMethod;
        private BigDecimal degressivePercentage;
        private BigDecimal annuityPercentage;
        private String annuityInterestTableId;
        private int startDepreciationBookYear;
        private int startDepreciationPeriod;
        private int numberOfDepreciatedPeriods;
        private int depreciatableLife;
        private boolean depreciationPaused;
        private BigDecimal interestPercentage;
        private int interestBookYear;
        private int interestPeriod;
        private BigDecimal correctionAmount445A;
        private BigDecimal correctionAmount445B;
        private BigDecimal beyondEconomicLifePercentage;
        private BigDecimal postedDepreciationBalanceBeyondEconomicLife;

        private DBImage() {
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }
}

