/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.fis;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.ibs.api.fis.Fagla1Adapter;
import nl.ibs.api.fis.FaglrekAdapter;
import nl.ibs.api.fis.FagversAdapter;
import nl.ibs.api.fis.FcalbkAdapter;
import nl.ibs.api.fis.FcaldcAdapter;
import nl.ibs.api.fis.FcaldimAdapter;
import nl.ibs.api.fis.Fcs100clAdapter;
import nl.ibs.api.fis.Fcs101clAdapter;
import nl.ibs.api.fis.FisLicenseChecker;
import nl.ibs.api.util.LicenseChecker;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.fis.FISBooking;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.util.AS400Enhanced;
import nl.ibs.util.NameValuePair;

public class FISHelper
implements Serializable {
    private static final long serialVersionUID = -4068322672840670705L;
    private String message = null;
    private LoginHelper loginHelper;
    private static final String VERSION = "0801000";
    private static final String LONGVERSION = "2008.01.003";
    public static final String CID = "companyId";
    public static final String BID = "branchId";
    private static final String DATATYPE_BV = "BV";
    private static final String DATATYPE_A1 = "A1";
    private static final String DATATYPE_J1 = "J1";
    private static final String DATATYPE_R1 = "R1";
    private static final String DATATYPE_P1 = "P1";
    private static final String DATATYPE_D1 = "D1";
    private static final String DATATYPE_S1 = "S1";
    private static final String DATATYPE_S2 = "S2";
    private static final String DATATYPE_S3 = "S3";
    private static final String DATATYPE_DEB = "DB";
    private static final String DATATYPE_CRED = "CR";
    private int daysUntilExpiration = 0;
    private int maxUsers = 0;

    public FISHelper(LoginHelper loginHelper) {
        this.loginHelper = loginHelper;
    }

    private AS400Enhanced getAS400() {
        return this.loginHelper.getAs400();
    }

    public void login(String dataLib, String programLib) throws Exception {
        Fcs101clAdapter fcs101clAdapter = new Fcs101clAdapter((AS400)this.getAS400());
        fcs101clAdapter.setPath(programLib);
        fcs101clAdapter.setPGMLIB(programLib);
        fcs101clAdapter.setDTALIB(dataLib);
        if (!fcs101clAdapter.execute()) {
            this.message = fcs101clAdapter.getFirstMessage();
            return;
        }
        this.message = fcs101clAdapter.getMSG();
        if (!"".equals(this.message)) {
            return;
        }
        FagversAdapter adapter = new FagversAdapter((AS400)this.getAS400());
        adapter.execute();
        if (adapter.getVERSLEV().compareTo(VERSION) < 0) {
            this.message = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "version_must_be_at_least")) + ": " + LONGVERSION;
        }
    }

    public void logout(String dataLib, String programLib) throws Exception {
        Fcs100clAdapter adapter = new Fcs100clAdapter((AS400)this.getAS400());
        adapter.setPGMLIB(programLib);
        adapter.setDTALIB(dataLib);
        adapter.execute();
        try {
            new CommandCall((AS400)this.getAS400()).run("RCLRSC LVL(*CALLER) OPTION(*NORMAL)");
        }
        catch (Exception e) {
            Log.error((Exception)e);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void checkActivated(boolean government) throws Exception {
        if (government) {
            this.message = "no_license_for_module";
            return;
        }
        FisLicenseChecker checker = new FisLicenseChecker(this.getAS400());
        LicenseChecker.Result result = checker.validateLicense("FAC", "BAS");
        this.message = result.getMessage();
        this.daysUntilExpiration = result.getDaysBeforeExpiration();
        Log.debug((String)("daysUntilExpiration: " + this.daysUntilExpiration));
        this.maxUsers = result.getMaxUsers();
        Log.debug((String)("maxUsers: " + this.maxUsers));
    }

    public int getDaysUntilExpiration() {
        return this.daysUntilExpiration;
    }

    public int getMaxUsers() {
        return this.maxUsers;
    }

    public List getBookYears(String adminId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Fagla1Adapter adapter = new Fagla1Adapter((AS400)this.getAS400());
        BigDecimal bdrNr = FISHelper.getCompany(adminId);
        BigDecimal vestNr = FISHelper.getBranche(adminId);
        adapter.setDSPAR1HP1BDR(bdrNr);
        adapter.setDSPAR1HP1VST(vestNr);
        adapter.setDSPAR1HP1BJR(new BigDecimal(-1));
        adapter.setDSPAR1HP1STK("V");
        while (adapter.execute() && adapter.getDSPAR1HP1RTC().trim().length() == 0) {
            if (adapter.getFASA1SABDR1().intValue() != bdrNr.intValue() || adapter.getFASA1SAVST1().intValue() != vestNr.intValue()) break;
            int bookYear = adapter.getFASA1SABJR1().intValue();
            bookYear = bookYear <= 75 ? (bookYear += 2000) : (bookYear += 1900);
            list.add("" + bookYear);
            adapter.setDSPAR1HP1BDR(adapter.getFASA1SABDR1());
            adapter.setDSPAR1HP1VST(adapter.getFASA1SAVST1());
            adapter.setDSPAR1HP1BJR(adapter.getFASA1SABJR1());
        }
        adapter.setDSPAR1HP1STK("C");
        adapter.execute();
        return list;
    }

    public String getAdministrationDescription(String adminId, int bookYear) throws Exception {
        String description = null;
        Fagla1Adapter adapter = new Fagla1Adapter((AS400)this.getAS400());
        adapter.setDSPAR1HP1BDR(FISHelper.getCompany(adminId));
        adapter.setDSPAR1HP1VST(FISHelper.getBranche(adminId));
        adapter.setDSPAR1HP1BJR(FISHelper.getBookYear("" + bookYear));
        if (adapter.execute() && adapter.getDSPAR1HP1RTC().trim().length() == 0) {
            description = adapter.getFASA1SAOMS();
        }
        adapter.setDSPAR1HP1STK("C");
        adapter.execute();
        return description;
    }

    public String checkAdministration(String adminId, int bookYear) throws Exception {
        String message = null;
        Fagla1Adapter adapter = new Fagla1Adapter((AS400)this.getAS400());
        adapter.setDSPAR1HP1BDR(FISHelper.getCompany(adminId));
        adapter.setDSPAR1HP1VST(FISHelper.getBranche(adminId));
        adapter.setDSPAR1HP1BJR(FISHelper.getBookYear("" + bookYear));
        if (adapter.execute()) {
            message = adapter.getDSPAR1HP1RTC();
            if ("A".equals(adapter.getDSPAR1HP1RTC())) {
                message = "no_authorization";
            }
            if ("N".equals(adapter.getDSPAR1HP1RTC())) {
                message = "key_not_found";
            }
        }
        adapter.setDSPAR1HP1STK("C");
        adapter.execute();
        return message;
    }

    public static String getCompanyId(String adminId) {
        int i = adminId.indexOf(47);
        if (i > 0) {
            String fid = "000" + adminId.substring(0, adminId.indexOf(47));
            return fid.substring(fid.length() - 3);
        }
        return adminId;
    }

    public static String getBrancheId(String adminId) {
        String fid = "000";
        int i = adminId.indexOf(47);
        if (i > 0) {
            fid = String.valueOf(fid) + adminId.substring(adminId.indexOf(47) + 1);
            return fid.substring(fid.length() - 3);
        }
        return fid;
    }

    private static BigDecimal getCompany(String adminId) {
        int i = adminId.indexOf(47);
        if (i > 0) {
            return new BigDecimal(adminId.substring(0, i));
        }
        return new BigDecimal(adminId);
    }

    private static BigDecimal getBranche(String adminId) {
        int i = adminId.indexOf(47);
        if (i > 0) {
            return new BigDecimal(adminId.substring(i + 1));
        }
        return new BigDecimal(0);
    }

    private static BigDecimal getBookYear(String bookYear) {
        return new BigDecimal(bookYear.substring(2));
    }

    public static String formatId(String id, int index) throws Exception {
        if (id == null || id.trim().length() == 0) {
            return id;
        }
        String format = "000000000";
        if (index == -3) {
            format = "000000";
        }
        if (index == -1) {
            format = "000";
        }
        if (index == 1) {
            format = "00000";
        }
        DecimalFormat formatter = new DecimalFormat(format);
        return formatter.format(Integer.parseInt(id.trim()));
    }

    public static String unFormatId(String id) throws Exception {
        if (id == null || id.trim().length() == 0) {
            return id;
        }
        return new BigDecimal(id).toString();
    }

    public Collection getNextCollection(Object previousObject, int max, String filter, String filterField, boolean position, String adminId, String bookYear, int index) throws Exception {
        FcaldimAdapter fcaldimAdapter;
        ArrayList<NameValuePair> result;
        block18: {
            NameValuePair pair2;
            result = new ArrayList<NameValuePair>(max);
            String function = previousObject == null ? "lees eerste" : "lees volgende";
            fcaldimAdapter = this.createAdapter(adminId, bookYear, index);
            fcaldimAdapter.setPI_PARMPI_STK(function);
            fcaldimAdapter.setPI_PARMPI_COUNT(new BigDecimal(max));
            fcaldimAdapter.setPI_PARMPI_STAMNR(new BigDecimal(0));
            fcaldimAdapter.setPI_PARMPI_ZOEK("");
            fcaldimAdapter.setPI_PARMPI_ZOEKACTIE("");
            if ("".equals(filter)) {
                filter = " ";
            }
            if ("description".equals(filterField)) {
                fcaldimAdapter.setPI_PARMPI_ZOEKACTIE("S");
                if (previousObject != null) {
                    pair2 = (NameValuePair)previousObject;
                    fcaldimAdapter.setPI_PARMPI_ZOEK(pair2.getValue());
                } else {
                    fcaldimAdapter.setPI_PARMPI_ZOEK(filter);
                }
            } else if (previousObject != null) {
                pair2 = (NameValuePair)previousObject;
                if (fcaldimAdapter.getPI_PARMPI_GEGSRT().equals(DATATYPE_BV)) {
                    fcaldimAdapter.setPI_PARMPI_BEDRIJF(FISHelper.getCompany(pair2.getName()));
                    fcaldimAdapter.setPI_PARMPI_VESTIG(FISHelper.getBranche(pair2.getName()));
                } else {
                    fcaldimAdapter.setPI_PARMPI_STAMNR(new BigDecimal(pair2.getName()));
                }
            } else if (!" ".equals(filter)) {
                try {
                    if (fcaldimAdapter.getPI_PARMPI_GEGSRT().equals(DATATYPE_BV)) {
                        fcaldimAdapter.setPI_PARMPI_BEDRIJF(FISHelper.getCompany(filter));
                        fcaldimAdapter.setPI_PARMPI_VESTIG(FISHelper.getBranche(filter));
                        break block18;
                    }
                    fcaldimAdapter.setPI_PARMPI_STAMNR(new BigDecimal(filter));
                }
                catch (Exception pair2) {}
            } else if (fcaldimAdapter.getPI_PARMPI_GEGSRT().equals(DATATYPE_BV)) {
                fcaldimAdapter.setPI_PARMPI_BEDRIJF(new BigDecimal(0));
                fcaldimAdapter.setPI_PARMPI_VESTIG(new BigDecimal(0));
            }
        }
        if (fcaldimAdapter.execute()) {
            int maxElem = fcaldimAdapter.getPF_PARMPF_AANTREC().intValue();
            int i = 0;
            while (i < maxElem) {
                String name = fcaldimAdapter.getPO_PARMPO_NR(i).toString();
                if (DATATYPE_BV.equals(fcaldimAdapter.getPI_PARMPI_GEGSRT())) {
                    name = FISHelper.formatId(name, -3);
                    int companyId = Integer.parseInt(name.substring(0, 3));
                    int brancheId = Integer.parseInt(name.substring(3));
                    name = brancheId == 0 ? "" + companyId : companyId + "/" + brancheId;
                }
                result.add(new NameValuePair(name, fcaldimAdapter.getPO_PARMPO_OMS(i)));
                ++i;
            }
            return result;
        }
        throw new Exception(fcaldimAdapter.getFirstMessage());
    }

    public String getDescription(String id, String adminId, String bookYear, int index) throws Exception {
        FcaldimAdapter fcaldimAdapter = this.createAdapter(adminId, bookYear, index);
        fcaldimAdapter.setPI_PARMPI_STK("lees sleutel");
        fcaldimAdapter.setPI_PARMPI_ZOEK("");
        fcaldimAdapter.setPI_PARMPI_ZOEKACTIE("");
        fcaldimAdapter.setPI_PARMPI_COUNT(new BigDecimal(0));
        if (fcaldimAdapter.getPI_PARMPI_GEGSRT().equals(DATATYPE_BV)) {
            fcaldimAdapter.setPI_PARMPI_BEDRIJF(FISHelper.getCompany(id));
            fcaldimAdapter.setPI_PARMPI_VESTIG(FISHelper.getBranche(id));
        } else {
            try {
                fcaldimAdapter.setPI_PARMPI_STAMNR(new BigDecimal(id));
            }
            catch (NumberFormatException e) {
                throw new UserMessageException("not_a_number");
            }
        }
        if (fcaldimAdapter.execute()) {
            if (fcaldimAdapter.getPF_PARMPF_AANTREC().intValue() == 0) {
                return null;
            }
            return fcaldimAdapter.getPO_PARMPO_OMS(0);
        }
        throw new Exception(fcaldimAdapter.getFirstMessage());
    }

    private FcaldimAdapter createAdapter(String adminId, String bookYear, int index) throws Exception {
        FcaldimAdapter fcaldimAdapter = new FcaldimAdapter((AS400)this.getAS400());
        fcaldimAdapter.setPI_PARMPI_BEDRIJF(FISHelper.getCompany(adminId));
        fcaldimAdapter.setPI_PARMPI_VESTIG(FISHelper.getBranche(adminId));
        fcaldimAdapter.setPI_PARMPI_BOEKJR(FISHelper.getBookYear(bookYear));
        fcaldimAdapter.setPI_PARMPI_GEGSRT(this.getDataType(index));
        fcaldimAdapter.setPI_PARMPI_SUBREK("N");
        fcaldimAdapter.setPI_PARMPI_TESTAUT("J");
        fcaldimAdapter.setPI_PARMPI_BLOK("H");
        return fcaldimAdapter;
    }

    public Collection getNextDCCollection(Object previousObject, int max, String filter, String filterField, boolean position, String adminId, int index) throws Exception {
        NameValuePair pair2;
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>(max);
        String function = previousObject == null ? "lees eerste" : "lees volgende";
        FcaldcAdapter fcaldcAdapter = this.createDCAdapter(adminId, index);
        fcaldcAdapter.setPI_STK(function);
        fcaldcAdapter.setPI_COUNT(new BigDecimal(max));
        fcaldcAdapter.setPI_STAMNR(new BigDecimal(0));
        fcaldcAdapter.setPI_ZOEK("");
        fcaldcAdapter.setPI_ZOEKACTIE("");
        if ("".equals(filter)) {
            filter = " ";
        }
        if ("description".equals(filterField)) {
            fcaldcAdapter.setPI_ZOEKACTIE("S");
            if (previousObject != null) {
                pair2 = (NameValuePair)previousObject;
                fcaldcAdapter.setPI_ZOEK(pair2.getValue());
            } else {
                fcaldcAdapter.setPI_ZOEK(filter);
            }
        } else if (previousObject != null) {
            pair2 = (NameValuePair)previousObject;
            fcaldcAdapter.setPI_STAMNR(new BigDecimal(pair2.getName()));
        } else if (!" ".equals(filter)) {
            try {
                fcaldcAdapter.setPI_STAMNR(new BigDecimal(filter));
            }
            catch (Exception pair2) {
                // empty catch block
            }
        }
        if (fcaldcAdapter.execute()) {
            int maxElem = fcaldcAdapter.getPF_AANTREC().intValue();
            int i = 0;
            while (i < maxElem) {
                String name = fcaldcAdapter.getPO_NR(i).toString();
                result.add(new NameValuePair(name, fcaldcAdapter.getPO_NAM(i)));
                ++i;
            }
            return result;
        }
        throw new Exception(fcaldcAdapter.getFirstMessage());
    }

    public String getDCDescription(String id, String adminId, int index) throws Exception {
        FcaldcAdapter fcaldcAdapter = this.createDCAdapter(adminId, index);
        fcaldcAdapter.setPI_STK("lees sleutel");
        fcaldcAdapter.setPI_ZOEK("");
        fcaldcAdapter.setPI_ZOEKACTIE("");
        fcaldcAdapter.setPI_COUNT(new BigDecimal(0));
        fcaldcAdapter.setPI_STAMNR(new BigDecimal(id));
        if (fcaldcAdapter.execute()) {
            if (fcaldcAdapter.getPF_AANTREC().intValue() == 0) {
                return null;
            }
            return fcaldcAdapter.getPO_NAM(0);
        }
        throw new Exception(fcaldcAdapter.getFirstMessage());
    }

    private FcaldcAdapter createDCAdapter(String adminId, int index) throws Exception {
        FcaldcAdapter fcaldcAdapter = new FcaldcAdapter((AS400)this.getAS400());
        fcaldcAdapter.setPI_BEDRIJF(FISHelper.getCompany(adminId));
        fcaldcAdapter.setPI_VESTIG(FISHelper.getBranche(adminId));
        fcaldcAdapter.setPI_GEGSRT(this.getDataType(index));
        fcaldcAdapter.setPI_TESTAUT("J");
        return fcaldcAdapter;
    }

    private String getDataType(int index) {
        String dataType = null;
        switch (index) {
            case -3: {
                dataType = DATATYPE_BV;
                break;
            }
            case -2: {
                dataType = DATATYPE_A1;
                break;
            }
            case -1: {
                dataType = DATATYPE_J1;
                break;
            }
            case 0: {
                dataType = DATATYPE_R1;
                break;
            }
            case 1: {
                dataType = DATATYPE_P1;
                break;
            }
            case 2: {
                dataType = DATATYPE_D1;
                break;
            }
            case 3: {
                dataType = DATATYPE_S1;
                break;
            }
            case 4: {
                dataType = DATATYPE_S2;
                break;
            }
            case 5: {
                dataType = DATATYPE_S3;
                break;
            }
            case 10: {
                dataType = DATATYPE_DEB;
                break;
            }
            case 11: {
                dataType = DATATYPE_CRED;
            }
        }
        return dataType;
    }

    public boolean[] getMainAccountAttributes(String adminId, String bookYear, String id) throws Exception {
        boolean[] result = new boolean[3];
        FaglrekAdapter faglrekAdapter = new FaglrekAdapter((AS400)this.getAS400());
        faglrekAdapter.setHP1BDR(FISHelper.getCompany(adminId));
        faglrekAdapter.setHP1VST(FISHelper.getBranche(adminId));
        faglrekAdapter.setHP1BJR(new BigDecimal(bookYear.substring(2)));
        faglrekAdapter.setHP1NR(new BigDecimal(id));
        faglrekAdapter.setHP1AUT("N");
        faglrekAdapter.execute();
        if (faglrekAdapter.getHP1RTC().trim().length() == 0) {
            result[0] = faglrekAdapter.getSRBIKP().equals("J");
            result[1] = faglrekAdapter.getSRBIKD().equals("J");
            result[2] = faglrekAdapter.getSRFACR().equals("J");
        }
        return result;
    }

    public Set getAdministrations() throws Exception {
        HashSet<String> result = new HashSet<String>();
        String name = null;
        FcaldimAdapter fcaldimAdapter = new FcaldimAdapter((AS400)this.getAS400());
        fcaldimAdapter.setPI_PARMPI_GEGSRT(DATATYPE_BV);
        fcaldimAdapter.setPI_PARMPI_TESTAUT("J");
        fcaldimAdapter.setPI_PARMPI_STK("lees eerste");
        fcaldimAdapter.execute();
        while (fcaldimAdapter.getPF_PARMPF_AANTREC().intValue() > 0) {
            int i = 0;
            while (i < fcaldimAdapter.getPF_PARMPF_AANTREC().intValue()) {
                name = fcaldimAdapter.getPO_PARMPO_NR(i).toString();
                name = FISHelper.formatId(name, -3);
                int companyId = Integer.parseInt(name.substring(0, 3));
                int brancheId = Integer.parseInt(name.substring(3));
                name = brancheId == 0 ? "" + companyId : companyId + "/" + brancheId;
                result.add(name);
                ++i;
            }
            fcaldimAdapter.setPI_PARMPI_BEDRIJF(FISHelper.getCompany(name));
            fcaldimAdapter.setPI_PARMPI_VESTIG(FISHelper.getBranche(name));
            fcaldimAdapter.setPI_PARMPI_STK("lees volgende");
            fcaldimAdapter.execute();
        }
        return result;
    }

    public Collection getNextBookingsCollection(Object previousObject, int max, String filter, String filterField, boolean position, String adminId, int bookYear, int batchId, String voucherId) throws Exception {
        ArrayList<FISBooking> result = new ArrayList<FISBooking>(max);
        FcalbkAdapter fcalbkAdapter = this.createBKAdapter(adminId, bookYear, batchId, voucherId);
        String function = previousObject == null ? "lees eerste" : "lees";
        fcalbkAdapter.setPI_STK(function);
        fcalbkAdapter.setPI_COUNT(new BigDecimal(max));
        if (fcalbkAdapter.execute()) {
            int maxElem = fcalbkAdapter.getPF_AANTREC().intValue();
            int i = 0;
            while (i < maxElem) {
                FISBooking fisBooking = new FISBooking();
                fisBooking.setPeriode(fcalbkAdapter.getPO_PERIODE(i));
                fisBooking.setBedrag(fcalbkAdapter.getPO_BEDRAG(i));
                fisBooking.setDagboek(fcalbkAdapter.getPO_DAGBOEK(i));
                fisBooking.setRekening(fcalbkAdapter.getPO_REKENING(i));
                fisBooking.setKostenpl(fcalbkAdapter.getPO_KOSTENPL(i));
                fisBooking.setKostendr(fcalbkAdapter.getPO_KOSTENDR(i));
                fisBooking.setStatnr1(fcalbkAdapter.getPO_STATNR1(i));
                fisBooking.setStatnr2(fcalbkAdapter.getPO_STATNR2(i));
                fisBooking.setStatnr3(fcalbkAdapter.getPO_STATNR3(i));
                fisBooking.setStuknr(fcalbkAdapter.getPO_STUKNR(i));
                fisBooking.setBoekdat(fcalbkAdapter.getPO_BOEKDAT(i));
                fisBooking.setOmschr(fcalbkAdapter.getPO_OMSCHR(i));
                fisBooking.setFactuur(fcalbkAdapter.getPO_FACTUUR(i));
                fisBooking.setDocumid(fcalbkAdapter.getPO_DOCUMID(i));
                fisBooking.setSystnr(fcalbkAdapter.getPO_SYSTNR(i));
                fisBooking.setSysvolg(fcalbkAdapter.getPO_SYSVOLG(i));
                result.add(fisBooking);
                ++i;
            }
            return result;
        }
        throw new Exception(fcalbkAdapter.getFirstMessage());
    }

    private FcalbkAdapter createBKAdapter(String adminId, int bookYear, int batchId, String voucherId) throws Exception {
        FcalbkAdapter fcalbkAdapter = new FcalbkAdapter((AS400)this.getAS400());
        fcalbkAdapter.setPI_BEDRIJF(FISHelper.getCompany(adminId));
        fcalbkAdapter.setPI_VESTIG(FISHelper.getBranche(adminId));
        fcalbkAdapter.setPI_BOEKJR(new BigDecimal(("" + bookYear).substring(2)));
        fcalbkAdapter.setPI_BATCHNR(new BigDecimal(batchId));
        fcalbkAdapter.setPI_STUKNR(new BigDecimal(voucherId));
        fcalbkAdapter.setPI_TESTAUT("J");
        return fcalbkAdapter;
    }
}

