/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.fms;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.ibs.api.fms.EkfcxfrAdapter;
import nl.ibs.api.fms.EkmwxfrAdapter;
import nl.ibs.api.fms.EkosxfrAdapter;
import nl.ibs.api.fms.FmsLicenseChecker;
import nl.ibs.api.util.LicenseChecker;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.fms.FMSBooking;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.fms.japi.EKIVXFRAdapter;
import nl.ibs.fms.japi.EKIXXFRAdapter;
import nl.ibs.fms.japi.EKLSXFRAdapter;
import nl.ibs.fms.japi.EKO9XFRAdapter;
import nl.ibs.fms.japi.EKQFXFRAdapter;
import nl.ibs.fms.japi.EKYPXFRAdapter;
import nl.ibs.fms.japi.EKYSXFRAdapter;
import nl.ibs.fms.japi.FMSOAINIT_Adapter;
import nl.ibs.jeelog.Log;
import nl.ibs.util.AS400Enhanced;
import nl.ibs.util.NameValuePair;

public class FMSHelper
implements Serializable {
    private static final long serialVersionUID = 6069867031220866032L;
    private String message = null;
    private LoginHelper loginHelper;
    private static final String VERSION = "R08M01016";
    public static final String ADMIN_ID = "adminId";
    private static final String DATATYPE_AD = "AD";
    private static final String DATATYPE_DB = "DB";
    private static final String DATATYPE_RK = "RK";
    private static final String DATATYPE_KP = "KP";
    private static final String DATATYPE_KD = "KD";
    private static final String DATATYPE_AK = "AK";
    private static final String DATATYPE_PR = "PR";
    private static final String DATATYPE_DEB = "D";
    private static final String DATATYPE_CRED = "C";
    private static final String DATATYPE_REL = "R";
    private static final String[] CODES = new String[]{"FMS0141", "FMS0196", "FMS0210", "FMS0178"};
    private int daysUntilExpiration = 0;
    private int maxUsers = 0;

    public FMSHelper(LoginHelper loginHelper) {
        this.loginHelper = loginHelper;
    }

    private AS400Enhanced getAS400() {
        return this.loginHelper.getAs400();
    }

    public void login(String operationArea, String administration, String bookYear) throws Exception {
        if (operationArea == null) {
            operationArea = "";
        }
        if (administration == null) {
            administration = "";
        }
        if (bookYear == null) {
            bookYear = "";
        }
        FMSOAINIT_Adapter initAdapter = new FMSOAINIT_Adapter(this.getAS400());
        this.message = initAdapter.aanmelden(operationArea, administration, bookYear);
        if (!"".equals(this.message.trim())) {
            this.message = this.investigate(this.message);
            return;
        }
        EKYSXFRAdapter adapter1 = new EKYSXFRAdapter(this.getAS400());
        adapter1.setAPIRtvAddChg("RTV");
        adapter1.setGebruikerAsRestrictor(this.loginHelper.getUser());
        adapter1.execute();
        EKYPXFRAdapter adapter2 = new EKYPXFRAdapter(this.getAS400());
        adapter2.setVersieIndicatieAsRestrictor(adapter1.getVersieIndicatie());
        adapter2.execute();
        if (adapter2.getVersieReleasenummer().compareTo(VERSION) < 0) {
            this.message = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "version_must_be_at_least")) + ": " + VERSION;
        }
    }

    public String investigate(String returnCode) {
        String message = "";
        if (returnCode.trim().length() == 0) {
            return message;
        }
        message = "FMSMessage";
        int i = 0;
        while (i < CODES.length) {
            if (returnCode.startsWith(CODES[i])) {
                message = CODES[i];
            }
            ++i;
        }
        TokenList tl = new TokenList();
        tl.addNonTranslatable(returnCode);
        message = LanguageHelper.getString("nl.ibs.fac.language", message, tl);
        return message;
    }

    public String getMessage() {
        return this.message;
    }

    public void logout(String operationArea, String administration, String bookYear) {
        if (operationArea == null) {
            operationArea = "";
        }
        if (administration == null) {
            administration = "";
        }
        if (bookYear == null) {
            bookYear = "";
        }
        FMSOAINIT_Adapter initAdapter = new FMSOAINIT_Adapter(this.getAS400());
        initAdapter.afmelden(operationArea, administration, bookYear);
        try {
            new CommandCall((AS400)this.getAS400()).run("RCLRSC LVL(*CALLER) OPTION(*NORMAL)");
        }
        catch (Exception e) {
            Log.error((Exception)e);
        }
    }

    public void checkActivated(boolean government) throws Exception {
        LicenseChecker.Result result = null;
        FmsLicenseChecker checker = new FmsLicenseChecker(this.getAS400());
        result = government ? checker.validateLicense("FAC", "GOV") : checker.validateLicense("FAC", "BAS");
        this.message = result.getMessage();
        this.daysUntilExpiration = result.getDaysBeforeExpiration();
        this.daysUntilExpiration = result.getDaysBeforeExpiration();
        Log.debug((String)("daysUntilExpiration: " + this.daysUntilExpiration));
        this.maxUsers = result.getMaxUsers();
        Log.debug((String)("maxUsers: " + this.maxUsers));
    }

    public int getDaysUntilExpiration() {
        return this.daysUntilExpiration;
    }

    public int getMaxUsers() {
        return this.maxUsers;
    }

    public List getOperationAreas() throws Exception {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        EKIVXFRAdapter ekivxfr = new EKIVXFRAdapter(this.getAS400());
        boolean ok = ekivxfr.execute();
        if (!ok) {
            this.message = ekivxfr.getAS400MessagesAsString();
        }
        while (ok && ekivxfr.getP0RTN().trim().length() == 0) {
            list.add(new NameValuePair(ekivxfr.getVerzorgingsgebied(), ekivxfr.getVerzorgingsgebiedNaam()));
            ok = ekivxfr.execute();
        }
        return list;
    }

    public String getAdministrationDescription(String adminId) throws Exception {
        return this.getDescription(adminId, -2);
    }

    public List getBookYears(String adminId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        EKIXXFRAdapter ekixxfr = new EKIXXFRAdapter(this.getAS400());
        ekixxfr.setAdministratieAsRestrictor(adminId);
        boolean ok = ekixxfr.execute();
        if (!ok) {
            this.message = ekixxfr.getAS400MessagesAsString();
        }
        while (ok && ekixxfr.getP0RTN().trim().length() == 0) {
            list.add(ekixxfr.getBoekjaar());
            ok = ekixxfr.execute();
        }
        return list;
    }

    public String formatId(String id, int index) throws Exception {
        if (id == null || id.trim().length() == 0) {
            return id;
        }
        String stamkode = "";
        switch (index) {
            case -1: {
                stamkode = DATATYPE_DB;
                break;
            }
            case 0: {
                stamkode = DATATYPE_RK;
                break;
            }
            case 1: {
                stamkode = DATATYPE_KP;
                break;
            }
            case 2: {
                stamkode = DATATYPE_KD;
                break;
            }
            case 3: {
                stamkode = DATATYPE_AK;
                break;
            }
            case 4: {
                stamkode = DATATYPE_PR;
            }
        }
        EKO9XFRAdapter adapterOpmaak = new EKO9XFRAdapter(this.getAS400());
        adapterOpmaak.setStamkodeAsRestrictor(stamkode);
        adapterOpmaak.setUPDimensieInvoer(id);
        adapterOpmaak.execute();
        return adapterOpmaak.getUPDimensieUitvoer();
    }

    public String unFormatId(String id, int index) {
        if (id == null || id.trim().length() == 0) {
            return id;
        }
        try {
            String[] dimensionAttributes = this.getDimensionAttributes(index);
            if (dimensionAttributes[0].equals("N")) {
                return "" + Integer.parseInt(id.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id.trim();
    }

    private boolean getBoolean(String value) {
        return "J".equals(value) || "O".equals(value) || "Y".equals(value) || "1".equals(value);
    }

    public String[] getDimensionAttributes(int index) throws Exception {
        String[] result = null;
        EKQFXFRAdapter stamKodeAdapter = new EKQFXFRAdapter(this.getAS400());
        stamKodeAdapter.setStamkodeAsRestrictor(this.getDataType(index));
        stamKodeAdapter.execute();
        String type = "A";
        if (this.getBoolean(stamKodeAdapter.getStamkodeNumeriek())) {
            type = "N";
        }
        result = new String[]{type, "" + stamKodeAdapter.getStamkodeLengte().intValue()};
        return result;
    }

    public Collection getNextCollection(Object previousObject, int max, String filter, String filterField, boolean position, int index) throws Exception {
        NameValuePair pair;
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>(max);
        EkmwxfrAdapter ekmwxfrAdapter = this.createAdapter(index);
        ekmwxfrAdapter.setP1SMNB(new BigDecimal(max));
        if (previousObject == null) {
            ekmwxfrAdapter.setP1MHTT("1");
        } else {
            ekmwxfrAdapter.setP1MHTT("");
        }
        if ("".equals(filter)) {
            filter = " ";
        }
        if ("description".equals(filterField)) {
            if (previousObject != null) {
                pair = (NameValuePair)previousObject;
                ekmwxfrAdapter.setP1FZCI(pair.getName());
            } else {
                ekmwxfrAdapter.setP1FZCI("");
            }
            ekmwxfrAdapter.setP1C3NZ(filter.toUpperCase());
            ekmwxfrAdapter.setP1MGTT("2");
        } else if (previousObject != null) {
            pair = (NameValuePair)previousObject;
            ekmwxfrAdapter.setP1FZCI(pair.getName());
        } else {
            ekmwxfrAdapter.setP1FZCI(filter.toUpperCase());
            ekmwxfrAdapter.setP1C3NZ("");
            if (position) {
                ekmwxfrAdapter.setP1MGTT("1");
            } else {
                ekmwxfrAdapter.setP1MGTT("");
            }
        }
        if (ekmwxfrAdapter.execute()) {
            int maxElem = ekmwxfrAdapter.getP1V3NO().intValue();
            int i = 0;
            while (i < maxElem) {
                result.add(new NameValuePair(ekmwxfrAdapter.getP2PARMWAFYCI(i), ekmwxfrAdapter.getP2PARMWAAZTM(i)));
                ++i;
            }
            return result;
        }
        throw new Exception(ekmwxfrAdapter.getFirstMessage());
    }

    public NameValuePair getNameValuePair(String id, int index) throws Exception {
        EkmwxfrAdapter ekmwxfrAdapter = this.createAdapter(index);
        ekmwxfrAdapter.setP1FZCI(id);
        ekmwxfrAdapter.setP1C3NZ("");
        ekmwxfrAdapter.setP1MGTT("1");
        ekmwxfrAdapter.setP1MHTT("2");
        ekmwxfrAdapter.setP1SMNB(new BigDecimal(1));
        if (ekmwxfrAdapter.execute()) {
            if (ekmwxfrAdapter.getP1V3NO().intValue() == 0) {
                return null;
            }
            NameValuePair pair = new NameValuePair(ekmwxfrAdapter.getP2PARMWAFYCI(0), ekmwxfrAdapter.getP2PARMWAAZTM(0));
            return pair;
        }
        throw new Exception(ekmwxfrAdapter.getFirstMessage());
    }

    public String getDescription(String id, int index) throws Exception {
        NameValuePair pair = this.getNameValuePair(id, index);
        if (pair == null) {
            return "";
        }
        return pair.getValue();
    }

    private EkmwxfrAdapter createAdapter(int index) throws Exception {
        EkmwxfrAdapter ekmwxfrAdapter = new EkmwxfrAdapter((AS400)this.getAS400());
        ekmwxfrAdapter.setP1O2TT(this.getDataType(index));
        ekmwxfrAdapter.setP1FZCI("");
        ekmwxfrAdapter.setP1SMNB(new BigDecimal(100));
        ekmwxfrAdapter.setP1V3NO(new BigDecimal(0));
        return ekmwxfrAdapter;
    }

    private String getDataType(int index) {
        String dataType = null;
        switch (index) {
            case -2: {
                dataType = DATATYPE_AD;
                break;
            }
            case -1: {
                dataType = DATATYPE_DB;
                break;
            }
            case 0: {
                dataType = DATATYPE_RK;
                break;
            }
            case 1: {
                dataType = DATATYPE_KP;
                break;
            }
            case 2: {
                dataType = DATATYPE_KD;
                break;
            }
            case 3: {
                dataType = DATATYPE_AK;
                break;
            }
            case 4: {
                dataType = DATATYPE_PR;
                break;
            }
            case 10: {
                dataType = DATATYPE_DEB;
                break;
            }
            case 11: {
                dataType = DATATYPE_CRED;
                break;
            }
            case 12: {
                dataType = DATATYPE_REL;
            }
        }
        return dataType;
    }

    public boolean[] getMainAccountAttributes(String bookYear, String id) throws Exception {
        boolean[] result = new boolean[5];
        EKLSXFRAdapter adapter = new EKLSXFRAdapter(this.getAS400());
        adapter.setBoekjaarAsRestrictor(bookYear);
        adapter.setRekeningAsRestrictor(this.formatId(id, 0));
        adapter.execute();
        if (adapter.getP0RTN().trim().length() == 0) {
            result[0] = this.getBoolean(adapter.getRekKdrGebonden());
            result[1] = this.getBoolean(adapter.getRekKplGebonden());
            result[2] = this.getBoolean(adapter.getRekAktGebonden());
            result[3] = this.getBoolean(adapter.getRekPrtGebonden());
            result[4] = this.getBoolean(adapter.getRekFACInvesteringsrek());
        }
        return result;
    }

    public Set getAdministrations() throws Exception {
        HashSet<String> result = new HashSet<String>();
        String name = null;
        EkmwxfrAdapter ekmwxfrAdapter = this.createAdapter(-2);
        ekmwxfrAdapter.setP1MHTT("1");
        ekmwxfrAdapter.execute();
        while (ekmwxfrAdapter.getP1V3NO().intValue() > 0) {
            int i = 0;
            while (i < ekmwxfrAdapter.getP1V3NO().intValue()) {
                name = ekmwxfrAdapter.getP2PARMWAFYCI(i);
                result.add(name);
                ++i;
            }
            ekmwxfrAdapter.setP1MHTT("");
            ekmwxfrAdapter.setP1FZCI(name);
            ekmwxfrAdapter.execute();
        }
        return result;
    }

    public Collection getNextBookingsCollection(Object previousObject, int max, String filter, String filterField, boolean position, String adminId, int bookYear, String daybookId, String voucherId) throws Exception {
        ArrayList<FMSBooking> result = new ArrayList<FMSBooking>(max);
        EkfcxfrAdapter ekfcxfrAdapter = this.createBKAdapter(adminId, bookYear, daybookId, voucherId);
        String function = previousObject == null ? "Read" : "Next";
        ekfcxfrAdapter.setSTUURCODE(function);
        ekfcxfrAdapter.setAANTALRECORDS(new BigDecimal(max));
        if (ekfcxfrAdapter.execute()) {
            int maxElem = ekfcxfrAdapter.getAANTALRECORDS().intValue();
            int i = 0;
            while (i < maxElem) {
                if (ekfcxfrAdapter.getA3ASDT(i).intValue() == 0) break;
                FMSBooking fmsBooking = new FMSBooking();
                fmsBooking.setPeriode(ekfcxfrAdapter.getA3ARNB(i));
                fmsBooking.setBedrag(ekfcxfrAdapter.getA3AHVA(i));
                fmsBooking.setDagboek(ekfcxfrAdapter.getCVXLCD(i));
                fmsBooking.setRekening(ekfcxfrAdapter.getCVXGCD(i));
                fmsBooking.setKostenpl(ekfcxfrAdapter.getCVXHCD(i));
                fmsBooking.setKostendr(ekfcxfrAdapter.getCVXICD(i));
                fmsBooking.setAktiviteit(ekfcxfrAdapter.getCVXJCD(i));
                fmsBooking.setPrestatie(ekfcxfrAdapter.getCVXKCD(i));
                fmsBooking.setStuknr(ekfcxfrAdapter.getA3HKTX(i));
                fmsBooking.setBoekdat(ekfcxfrAdapter.getA3ASDT(i));
                fmsBooking.setOmschr(ekfcxfrAdapter.getA3AMTX(i));
                fmsBooking.setFactuur(ekfcxfrAdapter.getK7L1NB(i));
                fmsBooking.setDocumid(ekfcxfrAdapter.getASYHTK(i));
                fmsBooking.setSystnr(ekfcxfrAdapter.getA3AQNB(i));
                result.add(fmsBooking);
                ++i;
            }
            return result;
        }
        throw new Exception(ekfcxfrAdapter.getFirstMessage());
    }

    private EkfcxfrAdapter createBKAdapter(String adminId, int bookYear, String daybookId, String voucherId) throws Exception {
        EkfcxfrAdapter ekfcxfrAdapter = new EkfcxfrAdapter((AS400)this.getAS400());
        ekfcxfrAdapter.setADMINISTRATIE(adminId);
        ekfcxfrAdapter.setBOEKJAAR("" + bookYear);
        ekfcxfrAdapter.setDAGBOEK(daybookId);
        ekfcxfrAdapter.setSTUKNUMMER(voucherId);
        return ekfcxfrAdapter;
    }

    public Collection getCostAccounts(String adminId, String bookYear) throws Exception {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>(50);
        EkosxfrAdapter ekosxfrAdapter = new EkosxfrAdapter((AS400)this.getAS400());
        ekosxfrAdapter.setADMINISTRATIE(adminId);
        ekosxfrAdapter.setBOEKJAAR(bookYear);
        ekosxfrAdapter.setFACTYPEREK("2");
        ekosxfrAdapter.setINCLGEBLOK("N");
        ekosxfrAdapter.setSTUURCODE("Read");
        if (ekosxfrAdapter.execute()) {
            int maxElem = ekosxfrAdapter.getAANTALRECORDS().intValue();
            int i = 0;
            while (i < maxElem) {
                result.add(new NameValuePair(ekosxfrAdapter.getRESULTSETAFACCD(i), ekosxfrAdapter.getRESULTSETAFAINA(i)));
                ++i;
            }
            while (maxElem == 50) {
                ekosxfrAdapter.setSTUURCODE("Next");
                if (ekosxfrAdapter.execute()) {
                    maxElem = ekosxfrAdapter.getAANTALRECORDS().intValue();
                    i = 0;
                    while (i < maxElem) {
                        result.add(new NameValuePair(ekosxfrAdapter.getRESULTSETAFACCD(i), ekosxfrAdapter.getRESULTSETAFAINA(i)));
                        ++i;
                    }
                    continue;
                }
                throw new Exception(ekosxfrAdapter.getFirstMessage());
            }
            ekosxfrAdapter.setSTUURCODE("Close");
            ekosxfrAdapter.execute();
            return result;
        }
        throw new Exception(ekosxfrAdapter.getFirstMessage());
    }
}

