/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov;

public abstract class GovernmentConstants {
    public static final String FMS_ASSET_INVESTMENT = "1";
    public static final String FMS_CREDIT_COST = "2";
    public static final String FMS_INITIAL_PROCESS_COSTS = "3";
    public static final String FMS_LOAN_OR_PAYOFF = "4";
    public static final int FAC_ASSET_INVESTMENT = 0;
    public static final int FAC_CREDIT_COST = 1;
    public static final int FAC_INITIAL_PROCESS_COSTS = 2;
    public static final int FAC_LOAN_OR_PAYOFF = 3;
    public static final int GOVCDE_NOT_APPLICABLE = 0;
    public static final int GOVCDE_SUBSEQUENT_CREDIT_TRANSACTION = 1;
    public static final int GOVCDE_INITIAL_PROCESS_COSTS = 2;
    public static final int GOVCDE_LOAN_OR_PAYOFF = 3;
    public static final int GOVCDE_DELETED_TRANSACTION = 999;
    public static final int CBD_TYPE_REALITY = 0;
    public static final int CBD_TYPE_ESTIMATION = 1;
    public static final int ET_TYPE_ORIGINAL_CREDIT_AMOUNT = 0;
    public static final int ET_TYPE_ADDITIONAL_CREDIT_AMOUNT = 1;
    public static final int ET_TYPE_BASIC_ASSET_TYPE = 100;
    public static final int ET_TYPE_ADDITIONAL_ASSET_TYPE = 102;
    public static final int ET_TYPE_ACTIVATION_SCHEME_DIFFERENCE = 104;
    public static final int BBV_TYPE_VERMEERDERING = 0;
    public static final int BBV_TYPE_VERMINDERING = 1;
    public static final int BBV_TYPE_BIJDRAGE_DERDE = 2;
    public static final int BBV_TYPE_AFWAARDERING = 4;
    public static final int BBV_TYPE_LENING = 3;
    public static final int BBV_TYPE_AFLOSSING = 4;

    public static String retrieveIFTTypeDescription(int iftType) {
        String description = "";
        switch (iftType) {
            case 0: {
                description = "Vaste activa";
                break;
            }
            case 1: {
                description = "Investeringskredieten";
                break;
            }
            case 2: {
                description = "Init. projectkosten";
                break;
            }
            case 3: {
                description = "Lening / Aflossing";
            }
        }
        return description;
    }

    public static String retrieveBBVCategoryDescription(int bbvCategory) {
        String description = "";
        switch (bbvCategory) {
            case 0: {
                description = "Vermeerdering";
                break;
            }
            case 1: {
                description = "Vermindering";
                break;
            }
            case 2: {
                description = "Bijdrage van derde";
                break;
            }
            case 3: {
                description = "Lening";
                break;
            }
            case 4: {
                description = "Aflossing";
            }
        }
        return description;
    }

    public static String retrieveIFTGovernmentCodeDescription(int iftGovernmentCode) {
        String description = "";
        switch (iftGovernmentCode) {
            case 0: {
                break;
            }
            case 1: {
                description = "Nagekomen (krediet) mutatie";
                break;
            }
            case 2: {
                description = "Init. projectkosten";
                break;
            }
            case 3: {
                description = "Lening / Aflossing";
            }
        }
        return description;
    }
}

