/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.language.UserContext;
import nl.ibs.util.NameValuePair;

public abstract class GovernmentEnumHelper
extends EnumHelper {
    private static Map[] maps = new Map[]{new HashMap(2), new HashMap(2), new HashMap(2), new HashMap(2), new HashMap(2), new HashMap(2)};
    public static final int ASSETTYPE_CATEGORY = 0;
    public static final int CREDIT_STATE = 1;
    public static final int CREDIT_BENEFIT = 2;
    public static final int CREDIT_BALANCE_TYPE = 3;
    public static final int ESTIMATION_TRANSACTION_TYPE = 4;
    public static final int BBV_CATEGORY = 5;
    public static final int N_A = 0;
    public static final int MAT_FA = 1;
    public static final int IMM_FA = 2;
    public static final int FIN_FA = 3;
    public static final int PRELIMINARY = 0;
    public static final int APPROVED = 2;
    public static final int CLOSED = 4;
    public static final int ECONOMIC = 1;
    public static final int SOCIAL = 2;
    public static final int ASSET_IN_PROGRESS = 1;
    public static final int WIP = 2;

    public static synchronized List<NameValuePair> getCollection(int enumSeqNr) {
        String locale = UserContext.getLocale().toString();
        ArrayList<NameValuePair> list = (ArrayList<NameValuePair>)maps[enumSeqNr].get(locale);
        if (list != null) {
            return list;
        }
        list = new ArrayList<NameValuePair>();
        switch (enumSeqNr) {
            case 0: {
                list.add(new NameValuePair("0", ""));
                list.add(new NameValuePair("1", "MAT_FA"));
                list.add(new NameValuePair("2", "IMM_FA"));
                list.add(new NameValuePair("3", "FIN_FA"));
                break;
            }
            case 1: {
                list.add(new NameValuePair("0", "PRELIMINARY"));
                list.add(new NameValuePair("2", "APPROVED"));
                list.add(new NameValuePair("4", "CLOSED"));
                break;
            }
            case 2: {
                list.add(new NameValuePair("0", ""));
                list.add(new NameValuePair("1", "ECONOMIC"));
                list.add(new NameValuePair("2", "SOCIAL"));
                break;
            }
            case 3: {
                list.add(new NameValuePair("0", ""));
                list.add(new NameValuePair("1", "ASSET_IN_PROGRESS"));
                list.add(new NameValuePair("2", "WIP"));
                break;
            }
            case 4: {
                list.add(new NameValuePair("0", "ET_TYPE_ORIGINAL_CREDIT_AMOUNT"));
                list.add(new NameValuePair("1", "ET_TYPE_ADDITIONAL_CREDIT_AMOUNT"));
                break;
            }
            case 5: {
                list.add(new NameValuePair("0", "BBV_TYPE_VERMEERDERING"));
                list.add(new NameValuePair("1", "BBV_TYPE_VERMINDERING"));
                list.add(new NameValuePair("2", "BBV_TYPE_BIJDRAGE_DERDE"));
                list.add(new NameValuePair("4", "BBV_TYPE_AFWAARDERING"));
            }
        }
        list = GovernmentEnumHelper.translate(list);
        maps[enumSeqNr].put(locale, list);
        return list;
    }

    public static String getValue(int enumSeqNr, int code) {
        for (NameValuePair pair : GovernmentEnumHelper.getCollection(enumSeqNr)) {
            if (!pair.getName().equals("" + code)) continue;
            return pair.getValue();
        }
        return null;
    }
}

