/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.MemoAdapter;
import nl.ibs.fac.adapters.MemoImageTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.IncomingFinancialTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.CreditPanels;
import nl.ibs.fac.gov.adapters.CreditProofDepreciationAdapter;
import nl.ibs.fac.gov.adapters.CreditStateTransformer;
import nl.ibs.fac.gov.adapters.IFTGovernmentCodeImageTransformer;
import nl.ibs.fac.gov.adapters.IPCReferenceCounterTransformer;
import nl.ibs.fac.gov.adapters.ValuationMainAccountAdapter;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.CreditBP;
import nl.ibs.fac.gov.bp.CreditBalanceBP;
import nl.ibs.fac.gov.bp.GenericGovernmentBP;
import nl.ibs.fac.gov.queries.CreditQuery;
import nl.ibs.fac.gov.queries.IncomingFinancialTransactionIPCQuery;

public class CreditAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3395032969744671332L;
    public static final String PAGE = CreditAdapter.class.getName();
    private Company company;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] TOOLTIPS = new String[]{"Label.State", "Label.Memo", "Label.IPC_short"};
    private static final String[] NAMES = new String[]{"id", "totalEstimationAmount", "totalCostAmount", "description", "proFormaTypeId", "startYear", "endYear", "preferedGLAccountId", "state", "hasMemo", "initialProjectCostsReferenceCounter"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.CreditAmount", "Label.BalanceAmount", "Label.Description", "Label.Type", "Label.From", "Label.To", "Label.GLAccount", "Label.State", "Label.Memo", "Label.IPC_short"};
    private static final String[] SEARCHNAMES = new String[]{"id", "description", "proFormaTypeId", "startYear", "endYear", "preferedGLAccountId", "state", "hasMemo", "initialProjectCostsReferenceCounter"};
    private static final String[] SEARCHLABELS = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.From", "Label.To", "Label.GLAccount", "Label.State", "Label.Memo", "Label.IPC_short"};
    private static final short[] SIZES = new short[]{80, 125, 125, 250, 80, 40, 40, 80, 20, 20, 20};
    private static final String[] TYPES = new String[11];
    private static final Transformer[] TRANSFORMERS;
    private static final boolean[] COLUMNNOWRAPS;
    private static final boolean[] SORTABLE;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private static final String REFRESH = "refresh";
    private static final String INITCREATEFORM = "initCreateForm";
    private static final String CREATECOMMONFORM = "createCommonForm";
    private static final String CREATEDIMENSIONFORM = "createDimensionForm";
    private static final String CREATE_AP_FORM = "createAccountingPrincipleForm";
    private static final String CREATEMAINACCOUNTFORM = "createMainAccountForm";
    private static final String CREATE = "create";
    private static final String EDITFORM = "initEditForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Credit credit;
    private Window deleteWindow;
    private ArrayList<Object> deleteList;
    private CreditPanels panels;
    private static final String EDIT2 = "editEstimation";
    private FloatBar fbEdit2 = new FloatBar();
    private Action memo;
    private Action detailIFT;
    private Action transactionDetails;
    private GenericGovernmentBP genericGovernmentBP;
    private CreditBalanceBP creditBalanceBP;
    private FieldGroup maFieldGroup = null;
    private Window ipcWindow;
    private ODBTable ipcTable;
    private CommonTable.SearchPanel ipcSearchPanel;
    private static final DecimalTransformer DECIMALTRANSFORMER;
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER;
    private static final BBVCategoryImageTransformer BBVTRANSFORMER;
    private static final IFTGovernmentCodeImageTransformer GOVCDETRANSFORMER;
    private static final String[] IPCTOOLTIPS;
    private static final String[] IPCNAMES;
    private static final String[] IPCLABELS;
    private static final short[] IPCSIZES;
    private static final Transformer[] IPCTRANSFORMERS;
    private static final String[] IPCSEARCHNAMES;
    private static final String[] IPCSEARCHLABELS;
    private Action[] ipcRowActions;

    static {
        Transformer[] transformerArray = new Transformer[11];
        transformerArray[1] = new DecimalTransformer();
        transformerArray[2] = new DecimalTransformer();
        transformerArray[9] = new MemoImageTransformer();
        TRANSFORMERS = transformerArray;
        COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true};
        boolean[] blArray = new boolean[11];
        blArray[0] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        SORTABLE = blArray;
        DECIMALTRANSFORMER = new DecimalTransformer();
        ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
        BBVTRANSFORMER = new BBVCategoryImageTransformer();
        GOVCDETRANSFORMER = new IFTGovernmentCodeImageTransformer();
        IPCTOOLTIPS = new String[]{"Label.BBVCategory", "Label.Remark"};
        IPCNAMES = new String[]{"bookYear", "period", "transactionValue", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
        IPCLABELS = new String[]{"Label.Year", "Label.Period.short", "Label.Amount", "Label.BBVCategory", "Label.Remark", "Label.Description", "Label.SystemItemNbr.Xshort", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
        IPCSIZES = new short[]{50, 30, 125, 20, 20, 210, 100, 80, 120};
        Transformer[] transformerArray2 = new Transformer[9];
        transformerArray2[2] = DECIMALTRANSFORMER;
        transformerArray2[3] = BBVTRANSFORMER;
        transformerArray2[4] = GOVCDETRANSFORMER;
        transformerArray2[8] = ZLTBTRANSFORMER;
        IPCTRANSFORMERS = transformerArray2;
        IPCSEARCHNAMES = new String[]{"bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
        IPCSEARCHLABELS = new String[]{"Label.Year", "Label.Period", "Label.Amount", "Label.Description", "Label.SystemItemNbr.short", "Label.VoucherId", "Label.InvoiceNbr.short"};
    }

    public CreditAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        CreditAdapter.TRANSFORMERS[8] = new CreditStateTransformer();
        CreditAdapter.TRANSFORMERS[10] = new IPCReferenceCounterTransformer();
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.genericGovernmentBP = new GenericGovernmentBP(this.company);
        this.creditBalanceBP = new CreditBalanceBP(this.company);
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(INITCREATEFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        this.memo = new Action("Label.Memo").setAdapter(this.getProcessAdapterPageName(MemoAdapter.PAGE)).setMethod("show");
        this.detailIFT = new Action("Label.Details").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        this.transactionDetails = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{edit, this.memo, confirmDelete};
        this.getProcess().setAttribute("MemoAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.headerActions = new Action[]{refresh, create};
        Action next = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEDIMENSIONFORM);
        next.setDefault(true);
        next.setValidationEnabled(true);
        this.fbCreate.addAction(next);
        this.fbCreate.addAction(this.cancel);
        this.fbCreate.addAction(this.finish);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action estimationOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT2);
        estimationOK.setValidationEnabled(true);
        estimationOK.setDefault(true);
        this.fbEdit2.addAction(estimationOK);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Credits", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        this.getProcess().setAttribute("Table", (Object)this.table);
        return object;
    }

    private void createTable() throws Exception {
        CreditQuery query = new CreditQuery(this.dbData, this.companyId, false, false);
        this.table = new ODBTable(Credit.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        if (CreditBO.isIdNumeric(this.company)) {
            CreditAdapter.TYPES[0] = "number";
            CreditAdapter.TRANSFORMERS[0] = this.numericIdTransformer;
        }
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setColumnSortable(SORTABLE);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        this.table.orderByColumn("id");
        this.searchPanel = this.table.createSearch(SEARCHNAMES, SEARCHLABELS);
        Action filterAction = this.table.createFilterAction(SEARCHNAMES, SEARCHLABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.searchPanel.setCSSClass("headerPanel");
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.panels = new CreditPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, null, false, null, null, null, null);
        this.panels.initializeValuationForm();
        this.maFieldGroup = null;
        return this.createCommonForm(object);
    }

    public DataObject createCommonForm(DataObject object) throws Exception {
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.description.setReadonly(false);
        this.panels.startYear.setValue("" + this.company.getCurrentBookYear());
        this.panels.type.setReadonly(false);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCredit", "screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.firstPanel);
        object.addUIObject((UIObject)this.panels.miscellaneousPanel);
        object.addUIObject((UIObject)this.panels.interestPanel);
        object.addUIObject((UIObject)this.fbCreate);
        object.getScreen().setHelpIdToNull();
        return object;
    }

    public DataObject createDimensionForm(DataObject object) throws Exception {
        String message = this.panels.validateCommonForm();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        if (!this.panels.resultAccountItem.getValueAsBoolean()) {
            this.panels.getAccountingPrincipleDefaultFromType(this.panels.type.getValue().trim());
            this.panels.depreciationMethodChangeAction.execute(null);
            this.panels.apInterestCalculationMethodChangeAction.execute(null);
        }
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCredit_Dimensions", "screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.financialPanel);
        object.addUIObject((UIObject)this.panels.dimensionPanel);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATECOMMONFORM));
        Action action = this.panels.resultAccountItem.getValueAsBoolean() ? new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEMAINACCOUNTFORM) : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE_AP_FORM);
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        object.getScreen().setHelpIdToNull();
        return object;
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCredit", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.ProFormaTypeId", "sub_screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        FieldGroup fg = new FieldGroup("");
        this.panels.type.setReadonly(true);
        fg.add((Field)this.panels.type);
        object.addUIObject((UIObject)fg);
        object.addUIObject((UIObject)this.panels.apPanel);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEDIMENSIONFORM));
        Action action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEMAINACCOUNTFORM);
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        object.getScreen().setHelpIdToNull();
        return object;
    }

    public DataObject createMainAccountForm(DataObject object) throws Exception {
        String message = this.panels.validateValuation();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCredit", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.MainAccounts", "sub_screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel);
        if (this.maFieldGroup == null) {
            this.maFieldGroup = this.genericGovernmentBP.getInitialMainAccountFieldGroup(this.loginHelper, null, 3, this.panels.startYear.getIntValue(), 1);
        }
        object.addUIObject((UIObject)this.maFieldGroup);
        FloatBar fb = new FloatBar();
        if (this.panels.resultAccountItem.getValueAsBoolean()) {
            fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEDIMENSIONFORM));
        } else {
            fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE_AP_FORM));
        }
        Action action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        object.getScreen().setHelpIdToNull();
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        this.panels.mainAccountIds = this.genericGovernmentBP.getFormattedMainAccountIds();
        this.credit = null;
        Object[] result = new CreditBP(this.panels).create();
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.credit = (Credit)result[0];
        TotalEstimationTransaction tet = TotalEstimationTransactionBO.getBaseActivationSchemeTransaction(this.credit);
        if (tet != null) {
            TotalEstimationTransactionBO.updateValuation(tet, Integer.parseInt(this.panels.depreciationMethod.getValue()), this.panels.yearPercentageTableId.getValue(), this.panels.degressivePercentage.getBigDecimal(), this.panels.annuityInterestTableId.getValue(), this.panels.annuityPercentage.getBigDecimal(), Integer.parseInt(this.panels.startPeriodHandlingMethod.getValue()), this.panels.depreciatableLife.getIntValue(), this.panels.residualPercentage.getBigDecimal(), this.panels.residualValue.getBigDecimal(), Integer.parseInt(this.panels.apInterestCalculationMethod.getValue()), this.panels.apInterestTableId.getValue(), this.numberOfPeriods, this.panels.apInterestPercentage.getBigDecimal());
        }
        this.panels.setCredit(this.credit);
        this.table.setPointer("id", (Object)this.credit.getId(), true);
        this.table.reload();
        if (this.credit.getStartYear() == this.credit.getEndYear()) {
            return this.show(object);
        }
        return this.showEstimations(object);
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.credit = (Credit)TableHelper.getSelectedItem((DataObject)object);
        if (this.credit.getAllocatedValue().doubleValue() != 0.0) {
            object.addUIObject((UIObject)new Message("Credit_is_being_closed_at_the_moment", "error"));
            return object;
        }
        Collection balances = CreditBalanceBO.retrieveCreditBalances(this.credit);
        if (balances != null && !balances.isEmpty()) {
            for (CreditBalance balance : balances) {
                this.creditBalanceBP.handleBalanceIsDirty(balance);
            }
        }
        this.panels = new CreditPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.credit, false, this.memo, this.detailIFT, this.transactionDetails, this.getProcess());
        this.panels.setValues();
        this.getProcess().setAttribute("credit", (Object)this.credit);
        this.panels.addCommonPanelAction(new Action("Label.MainAccountScheme").setAdapter(this.getProcessAdapterPageName(ValuationMainAccountAdapter.PAGE)).setMethod("show"));
        if (this.credit.getInitialProjectCostsReferenceCounter() > 0) {
            this.panels.addCommonPanelAction(new Action("Label.IPC_short").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showIPCWindow"));
        }
        this.panels.addEstimationPanelAction(new Action("Kapitaallasten").setAdapter(this.getProcessAdapterPageName(CreditProofDepreciationAdapter.PAGE)).setMethod("show"));
        if (this.credit.getCreditBalanceReferenceCounter() > 1 && this.credit.getEndYear() > this.credit.getStartYear()) {
            this.panels.addGeneralLedgerPanelAction(new Action("Uitsplitsing").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showGLYearWindow"));
        }
        return this.editForm(object);
    }

    public DataObject showGLYearWindow(DataObject object) throws Exception {
        return this.panels.showGLYearWindow(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditCredit", "screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel2);
        object.addUIObject((UIObject)this.panels.mainTabPanel);
        object.addUIObject((UIObject)this.fbEdit);
        object.getScreen().setHelpIdToNull();
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.panels.update();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.credit.getId(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject showEstimations(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCredit", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.Estimation", "sub_screen_name"));
        this.panels.id.setValue(this.credit.getId());
        this.panels.id.setReadonly(true);
        this.panels.description.setValue(this.credit.getDescription());
        this.panels.description.setReadonly(true);
        object.addUIObject((UIObject)this.panels.headerPanel);
        this.panels.firstPanel.setReadonly();
        object.addUIObject((UIObject)this.panels.firstPanel);
        this.panels.createEstimationTable();
        object.addUIObject((UIObject)this.panels.estimationYearsTable);
        object.addUIObject((UIObject)this.fbEdit2);
        object.getScreen().setHelpIdToNull();
        return object;
    }

    public DataObject editEstimation(DataObject object) throws Exception {
        this.panels.transactionAmount.setValue(this.credit.getOriginalInvestmentCreditAmount());
        this.panels.validateEstimations();
        this.panels.saveEstimations();
        return this.show(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.deleteWindow = new Window();
        this.deleteWindow.setLabel("Title.DeleteCredits");
        this.deleteWindow.add((Table)this.createConfirmationTable(object));
        this.deleteWindow.add(this.fbDelete);
        object.addUIObject((UIObject)this.deleteWindow);
        return object;
    }

    private CollectionTable createConfirmationTable(DataObject object) throws Exception {
        Object[] credits = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.deleteList = new ArrayList(credits.length);
        int i = 0;
        while (i < credits.length) {
            this.deleteList.add(credits[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(Credit.class, this.deleteList, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        if (CreditBO.isIdNumeric(this.company)) {
            CreditAdapter.TYPES[0] = "number";
            CreditAdapter.TRANSFORMERS[0] = this.numericIdTransformer;
        }
        table.setColumnTypes(TYPES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.setColumnNoWraps(COLUMNNOWRAPS);
        table.setSortable(true);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        Object[] credits = this.deleteList.toArray();
        int i = 0;
        while (i < credits.length) {
            Credit credit = (Credit)credits[i];
            if (credit != null && (message = CreditBP.delete(credit)) != null) {
                this.deleteWindow.add(new Message(message, "error"));
            }
            ++i;
        }
        if (message != null) {
            return object;
        }
        return this.refresh(object);
    }

    public DataObject showIPCWindow(DataObject object) throws Exception {
        if (this.ipcWindow != null) {
            this.ipcWindow.closeWindow(object);
        }
        this.ipcWindow = new Window();
        this.ipcWindow.setLabel("Label.IPC");
        this.createIPCTable();
        this.ipcWindow.add((Panel)this.ipcSearchPanel);
        this.ipcWindow.add((Table)this.ipcTable);
        object.addUIObject((UIObject)this.ipcWindow);
        object.getScreen().setHelpIdToNull();
        return object;
    }

    private void createIPCTable() throws Exception {
        IncomingFinancialTransactionIPCQuery query = new IncomingFinancialTransactionIPCQuery(this.dbData, this.credit.getCompanyId(), this.credit.getId());
        this.ipcTable = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.ipcTable.setName("CreditPanels.IncomingFinancialTransaction");
        this.ipcTable.setCounter((ODBCounter)query);
        this.ipcTable.setColumnNames(IPCNAMES);
        this.ipcTable.setColumnLabels(IPCLABELS);
        this.ipcTable.setColumnSizes(IPCSIZES);
        this.ipcTable.setDisplayTransformers(IPCTRANSFORMERS);
        this.ipcTable.setSortable(true);
        this.ipcSearchPanel = this.ipcTable.createSearch(IPCSEARCHNAMES, IPCSEARCHLABELS);
        Action ipcShow = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showIPCTransaction");
        Action ipcRemove = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("removeIPCTransaction");
        this.ipcRowActions = new Action[]{ipcShow, ipcRemove};
        TableHelper.createMenu((Table)this.ipcTable, null, (Action[])this.ipcRowActions);
        this.ipcTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.ipcTable, (String[])IPCTOOLTIPS);
    }

    public DataObject showIPCTransaction(DataObject object) throws Exception {
        IncomingFinancialTransaction incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
        this.getProcess().setAttribute("IncomingFinancialTransaction", (Object)incomingFinancialTransaction);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE), "showDetails", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject removeIPCTransaction(DataObject object) throws Exception {
        IncomingFinancialTransaction incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
        IncomingFinancialTransactionBP.deallocateInitialProjectCosts(incomingFinancialTransaction);
        this.credit.setInitialProjectCostsReferenceCounter(this.credit.getInitialProjectCostsReferenceCounter() - 1);
        this.panels.refreshAmountsTable();
        return this.showIPCWindow(object);
    }
}

