/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabActivateAction;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.adapters.AnalysisCodeReferenceField;
import nl.ibs.fac.adapters.AnalysisFieldHelper;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.BookYearField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.InterestTableReferenceField;
import nl.ibs.fac.adapters.MemoImageTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.TransactionStateImageTransformer;
import nl.ibs.fac.adapters.TransactionTypeTransformer;
import nl.ibs.fac.adapters.YearPercentageTableReferenceField;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.boadapters.AssetTypeAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.bp.IncomingFinancialTransactionBP;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetTypeAccountingPrincipleDefault;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.CreditBalanceManagerFactory;
import nl.ibs.fac.db.CreditBalancePK;
import nl.ibs.fac.db.DetailEstimationTransaction;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.gov.CreditBalanceWrapper;
import nl.ibs.fac.gov.GovernmentEnumHelper;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.BBVCategoryTransformer;
import nl.ibs.fac.gov.adapters.EstimationTransactionTypeImageTransformer;
import nl.ibs.fac.gov.adapters.IFTGovernmentCodeImageTransformer;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.CreditAdditionalDepreciationBP;
import nl.ibs.fac.gov.bp.CreditBP;
import nl.ibs.fac.gov.bp.CreditBalanceBP;
import nl.ibs.fac.gov.queries.CreditBalanceQuery;
import nl.ibs.fac.gov.queries.CreditQuery;
import nl.ibs.fac.gov.queries.IncomingFinancialTransactionForGLAccountQuery;
import nl.ibs.fac.gov.queries.TotalEstimationTransactionQuery;
import nl.ibs.fac.queries.TransactionQuery;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.util.NameValuePair;

public class CreditPanels
implements Serializable {
    private static final long serialVersionUID = 7655767722849364096L;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroBigDecimalToBlankTransformer ZBDTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    public LoginHelper loginHelper;
    private DBData dbData = null;
    private Environment env = null;
    public Company company = null;
    public String companyId;
    private Credit credit;
    private String bookYearMin = null;
    public int numberOfPeriods;
    public Panel headerPanel;
    public Field id = new Field("Label.Id", "upper");
    protected boolean idReadOnly = false;
    protected NumericIdTransformer numericIdTransformer = null;
    public Field description = new Field("Label.Description");
    protected FieldGroup firstPanel;
    public FACDecimalField creditAmount = new FACDecimalField("Label.OriginalInvestmentCreditAmount", 15, 2);
    public BookYearField startYear;
    public BookYearField endYear;
    protected FieldGroup financialPanel;
    private String[] finTexts = new String[4];
    public FinancialReferenceField[] financialDimension = new FinancialReferenceField[4];
    protected FieldGroup miscellaneousPanel;
    public ComboBox benefitType;
    public ComboBox balanceType;
    public CheckBox resultAccountItem;
    public AssetTypeReferenceField type;
    protected FieldGroup interestPanel;
    public ComboBox interestCalculationMethod;
    private InterestCalculationMethodChangeAction interestCalculationMethodChangeAction;
    public FACDecimalField interestPercentage;
    public ODBQueryReferenceField interestTableId;
    protected FieldGroup dimensionPanel;
    public AnalysisGroup[] analysisGroup = new AnalysisGroup[6];
    public AnalysisCodeReferenceField[] dimension = new AnalysisCodeReferenceField[6];
    public Field[] freeDimension;
    protected CollectionTable estimationYearsTable;
    private static final String[] NAMES2 = new String[]{"year", "detailTransactionAmount"};
    private static final String[] LABELS2 = new String[]{"Label.Year", "Label.Estimation"};
    private static final short[] SIZES2 = new short[]{80, 125};
    public Panel headerPanel2;
    protected FieldGroup firstPanel2;
    private ReferenceField idDesc = new ReferenceField("Label.Credit");
    protected ODBTable table0;
    private static final String[] NAMES0 = new String[]{"totalEstimationAmount", "totalCostAmount", "expenditureLeftAmount", "totalInterestAmount", "manualInterestAmount", "manualDepreciationAmount", "initialProjectCostAmount"};
    private String[] LABELS0 = new String[]{"Label.Estimation", "Label.Costs", "Label.ExpenditureLeftAmount", "Label.InterestCalculatedAmount", "Label.ManualInterestAmount", "Label.ManualDepreciationAmount", "Label.InitialProjectCostAmount"};
    private static final short[] SIZES0 = new short[]{96, 96, 96, 93, 93, 93, 93};
    private static final Transformer[] TRANSFORMERS0 = new Transformer[]{DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER};
    protected FieldGroup secondPanel;
    public ComboBox comboBoxState;
    public Field decisionId = new Field("Label.CouncilDecision");
    public DateSelectionField decisionDate = new DateSelectionField("Label.CouncilDecisionDate");
    protected ODBTable estimationTable;
    private static final String[] NAMES1 = new String[]{"bBVCategory", "description", "totalTransactionAmount", "estimationTransactionType", "hasMemo"};
    private static final String[] LABELS1 = new String[]{"Label.BBVCategory", "Label.Description", "Label.Amount", "Label.TransactionType", "Label.Memo"};
    private static final String[] TYPES1;
    private static final short[] SIZES1;
    private static final Transformer[] TRANSFORMERS1;
    private static final String[] TOOLTIPS1;
    protected ODBTable activationSchemeTable;
    private static final String[] NAMES3;
    private static final String[] LABELS3;
    private static final String[] TYPES3;
    private static final short[] SIZES3;
    private static final Transformer[] TRANSFORMERS3;
    private static final String[] TOOLTIPS3;
    private FieldGroup fg3;
    public Panel apPanel;
    private FieldGroup depreciationGroup;
    public ComboBox depreciationMethod;
    public FACDecimalField degressivePercentage;
    public ODBQueryReferenceField yearPercentageTableId;
    public ODBQueryReferenceField annuityInterestTableId;
    public FACDecimalField annuityPercentage;
    public ComboBox startPeriodHandlingMethod;
    private FieldGroup depreciationGroup2;
    public NumberField depreciatableLife;
    public FACDecimalField residualValue;
    public FACDecimalField residualPercentage;
    private FieldGroup interestGroup;
    public ComboBox apInterestCalculationMethod;
    public FACDecimalField apInterestPercentage;
    public ODBQueryReferenceField apInterestTableId;
    public DepreciationMethodChangeAction depreciationMethodChangeAction;
    public APInterestCalculationMethodChangeAction apInterestCalculationMethodChangeAction;
    protected Tab subPanelTabDeprInterest;
    protected ODBTable deprInterestTable;
    private static final String[] NAMES9;
    private static final String[] LABELS9;
    private static final String[] TOOLTIPS9;
    private static final short[] SIZES9;
    private static final String[] TYPES9;
    private static final Transformer[] TRANSFORMERS9;
    private static final boolean[] COLUMNNOWRAPS9;
    private static final boolean[] SORTABLE9;
    private FACDecimalField depreciation;
    private FACDecimalField interest;
    private BookYearPeriodGrid activationPeriod;
    private BookYearPeriodGrid financialBookPeriod;
    private Field adiDescription;
    protected ODBTable creditBalanceTable;
    private static final String[] NAMES4;
    private static final String[] LABELS4;
    private static final short[] SIZES4;
    private static final Transformer[] TRANSFORMERS4;
    protected ODBTable iftTable;
    private CommonTable.SearchPanel iftSearchPanel;
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER;
    private static final BBVCategoryImageTransformer BBVTRANSFORMER;
    private static final IFTGovernmentCodeImageTransformer GOVCDETRANSFORMER;
    private static final String[] TOOLTIPS5;
    private static final String[] NAMES5;
    private static final String[] LABELS5;
    private static final short[] SIZES5;
    private static final Transformer[] TRANSFORMERS5;
    private static final String[] SEARCHNAMES5;
    private static final String[] SEARCHLABELS5;
    protected CollectionTable glAccountSelectionTable;
    private CommonTable.SearchPanel glAccountSearchPanel;
    private static final String[] LABELS6;
    private static final short[] SIZES6;
    protected CollectionTable multipleAccountsMultipleYearsTable;
    private static final String[] NAMES8;
    private static final String[] LABELS8;
    private static final String[] TYPES8;
    private static final short[] SIZES8;
    protected CollectionTable singleAccountMultipleYearsTable;
    private static final String[] NAMES7;
    private static final String[] LABELS7;
    private static final String[] TYPES7;
    private static final short[] SIZES7;
    private TotalEstimationTransaction totalEstimationTransaction;
    private TotalEstimationTransaction newEstimationTransaction;
    private Field glAccountDescription = new Field("Label.Description");
    private FACDecimalField estimationAmount = new FACDecimalField("(Deel)raming", 15, 2);
    private Window window;
    private Field transactionDescription = new Field("Label.Description");
    protected FACDecimalField transactionAmount = new FACDecimalField("Label.Amount", 15, 2);
    public AssetTypeReferenceField assetTypeId;
    private CreditBalance creditBalance;
    private IncomingFinancialTransaction incomingFinancialTransaction;
    private static final String GRID_FILL_NONE;
    private static final String GRID_ANCHOR_WEST;
    private ComboBox oldBBVCategory;
    private ComboBox newBBVCategory;
    protected Action memoAction;
    protected Action detailIFT;
    protected Action transactionDetails;
    private ESPProcess process;
    private int mode = 0;
    private boolean readOnly;
    private static final int NEW = 0;
    private static final int UPDATE = 1;
    protected TabbedPanel mainTabPanel;
    private Tab commonTab;
    private FloatBar fbCommon = new FloatBar();
    private Tab dimmensionsTab;
    private Tab estimationsTab;
    private FloatBar fbEstimations = new FloatBar();
    private Tab activationsTab;
    private Tab generalLedgerTab;
    private FloatBar fbGeneralLedger;
    private FloatBar fbDepreciationInterest;
    public String[] mainAccountIds = null;

    static {
        String[] stringArray = new String[4];
        stringArray[0] = "text";
        TYPES1 = stringArray;
        SIZES1 = new short[]{210, 310, 140, 20, 20};
        Transformer[] transformerArray = new Transformer[5];
        transformerArray[0] = new BBVCategoryTransformer();
        transformerArray[2] = DECIMALTRANSFORMER;
        transformerArray[3] = new EstimationTransactionTypeImageTransformer();
        transformerArray[4] = new MemoImageTransformer();
        TRANSFORMERS1 = transformerArray;
        TOOLTIPS1 = new String[]{"Label.TransactionType", "Label.Memo"};
        NAMES3 = new String[]{"assetTypeId", "description", "totalTransactionAmount", "depreciatableLife", "depreciationMethod", "hasMemo"};
        LABELS3 = new String[]{"Label.Type", "Label.Description", "Label.Amount", "Label.DepreciationLife.short", "Label.DepreciationMethod.short", "Label.Memo"};
        String[] stringArray2 = new String[6];
        stringArray2[3] = "number";
        stringArray2[4] = "text";
        TYPES3 = stringArray2;
        SIZES3 = new short[]{100, 233, 115, 80, 150, 20};
        Transformer[] transformerArray2 = new Transformer[6];
        transformerArray2[2] = DECIMALTRANSFORMER;
        transformerArray2[3] = new ZeroIntegerToBlankTransformer();
        transformerArray2[5] = new MemoImageTransformer();
        TRANSFORMERS3 = transformerArray2;
        TOOLTIPS3 = new String[]{"Label.Memo"};
        NAMES9 = new String[]{"FACYearAndPeriod", "transactionType", "valueForAmount1", "valueForAmount2", "valueForAmount3", "bookingIndicator", "state", "documentAndSequenceNumber"};
        LABELS9 = new String[]{"Label.Period", "Label.TransactionType", "Label.Acquisition", "Label.Depreciation", "Label.Interest", "Label.BookingIndicator", "Label.State", "Label.TransNbrShort"};
        TOOLTIPS9 = new String[]{"Label.BookingIndicator", "Label.State"};
        SIZES9 = new short[]{80, 165, 100, 100, 100, 20, 20, 106};
        String[] stringArray3 = new String[8];
        stringArray3[1] = "text";
        TYPES9 = stringArray3;
        Transformer[] transformerArray3 = new Transformer[8];
        transformerArray3[1] = new TransactionTypeTransformer();
        transformerArray3[2] = ZBDTRANSFORMER;
        transformerArray3[3] = ZBDTRANSFORMER;
        transformerArray3[4] = ZBDTRANSFORMER;
        transformerArray3[5] = new BBVCategoryImageTransformer();
        transformerArray3[6] = new TransactionStateImageTransformer();
        TRANSFORMERS9 = transformerArray3;
        COLUMNNOWRAPS9 = new boolean[]{true, true, true, true, true, true, true, true};
        boolean[] blArray = new boolean[8];
        blArray[1] = true;
        blArray[5] = true;
        blArray[6] = true;
        SORTABLE9 = blArray;
        NAMES4 = new String[]{"gLAccountId", "description", "creditBalanceDetailAmount1", "creditBalanceDetailAmount2", "creditBalanceDetailAmount3"};
        LABELS4 = new String[]{"Label.GLAccount", "Label.Description", "Vermeerdering", "Vermindering", "Bijdr. derden"};
        SIZES4 = new short[]{100, 225, 124, 124, 124};
        Transformer[] transformerArray4 = new Transformer[5];
        transformerArray4[2] = DECIMALTRANSFORMER;
        transformerArray4[3] = DECIMALTRANSFORMER;
        transformerArray4[4] = DECIMALTRANSFORMER;
        TRANSFORMERS4 = transformerArray4;
        ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
        BBVTRANSFORMER = new BBVCategoryImageTransformer();
        GOVCDETRANSFORMER = new IFTGovernmentCodeImageTransformer();
        TOOLTIPS5 = new String[]{"Label.BBVCategory", "Label.Remark"};
        NAMES5 = new String[]{"bookYear", "period", "transactionValue", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
        LABELS5 = new String[]{"Label.Year", "Label.Period.short", "Label.Amount", "Label.BBVCategory", "Label.Remark", "Label.Description", "Label.SystemItemNbr.Xshort", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
        SIZES5 = new short[]{50, 30, 125, 20, 20, 210, 100, 80, 120};
        Transformer[] transformerArray5 = new Transformer[9];
        transformerArray5[2] = DECIMALTRANSFORMER;
        transformerArray5[3] = BBVTRANSFORMER;
        transformerArray5[4] = GOVCDETRANSFORMER;
        transformerArray5[8] = ZLTBTRANSFORMER;
        TRANSFORMERS5 = transformerArray5;
        SEARCHNAMES5 = new String[]{"bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
        SEARCHLABELS5 = new String[]{"Label.Year", "Label.Period", "Label.Amount", "Label.Description", "Label.SystemItemNbr.short", "Label.VoucherId", "Label.InvoiceNbr.short"};
        LABELS6 = new String[]{"Label.Id", "Label.Description"};
        SIZES6 = new short[]{80, 300};
        NAMES8 = new String[]{"dummy", "label", "amount1", "amount2", "percentage1", "amount3"};
        LABELS8 = new String[]{"", "Label.Description", "Label.Balance", "Cumulatief", "Perc.", "Label.Interest"};
        String[] stringArray4 = new String[6];
        stringArray4[2] = "number";
        stringArray4[3] = "number";
        stringArray4[4] = "number";
        stringArray4[5] = "number";
        TYPES8 = stringArray4;
        SIZES8 = new short[]{20, 225, 105, 105, 50, 105};
        NAMES7 = new String[]{"year", "amount1", "amount2", "percentage1", "amount3"};
        LABELS7 = new String[]{"Label.Year", "Label.Balance", "Cumulatief", "Perc.", "Label.Interest"};
        String[] stringArray5 = new String[5];
        stringArray5[1] = "number";
        stringArray5[2] = "number";
        stringArray5[3] = "number";
        stringArray5[4] = "number";
        TYPES7 = stringArray5;
        SIZES7 = new short[]{50, 115, 115, 50, 115};
        GRID_FILL_NONE = ESPGridLayoutConstraints.GRID_FILL_NONE;
        GRID_ANCHOR_WEST = ESPGridLayoutConstraints.GRID_ANCHOR_WEST;
    }

    public CreditPanels(LoginHelper loginHelper, DBData dbData, Environment env, Company company, String bookYearMin, String bookYearMax, int numberOfPeriods, Credit credit, boolean readOnly, Action memo, Action detailIFT, Action transactionDetails, ESPProcess process) throws Exception {
        this.loginHelper = loginHelper;
        this.dbData = dbData;
        this.env = env;
        this.bookYearMin = bookYearMin;
        this.numberOfPeriods = numberOfPeriods;
        this.company = company;
        this.credit = credit;
        this.readOnly = readOnly;
        this.memoAction = memo;
        this.detailIFT = detailIFT;
        this.transactionDetails = transactionDetails;
        this.process = process;
        this.companyId = company.getId();
        if (CreditBO.isIdNumeric(company)) {
            this.numericIdTransformer = new NumericIdTransformer();
        }
        this.mode = 0;
        if (credit != null) {
            this.mode = 1;
        }
        this.initialize();
    }

    public void setCredit(Credit credit) {
        this.credit = credit;
    }

    private void initialize() throws Exception {
        this.initializeCommonForm();
        this.dimensionPanel = new FieldGroup("Label.OtherDimensions");
        this.initializeFACDimensionPanel();
        if (this.mode == 1) {
            this.mainTabPanel = new TabbedPanel();
            this.mainTabPanel.setWidth(734);
            this.commonTab = new Tab("Label.Common");
            this.commonTab.add(this.firstPanel2);
            this.commonTab.add(this.secondPanel);
            this.commonTab.add(this.miscellaneousPanel);
            this.commonTab.add(this.interestPanel);
            this.fbCommon.alignment(1);
            this.commonTab.add(this.fbCommon);
            if (this.readOnly) {
                this.commonTab.setReadonly(true);
            }
            this.mainTabPanel.add(this.commonTab, (TabActivateAction)new MainTabActivateAction(this.commonTab, this.mainTabPanel));
            this.dimmensionsTab = new Tab("Label.Dimensions");
            this.dimmensionsTab.add(this.financialPanel);
            this.dimmensionsTab.add(this.dimensionPanel);
            if (this.readOnly) {
                this.dimmensionsTab.setReadonly(true);
            }
            this.mainTabPanel.add(this.dimmensionsTab, (TabActivateAction)new MainTabActivateAction(this.dimmensionsTab, this.mainTabPanel));
            this.estimationsTab = new Tab("Label.Estimation");
            this.createTotalEstimationTransactionTable();
            this.estimationsTab.add((Table)this.estimationTable);
            this.fbEstimations = new FloatBar();
            this.fbEstimations.alignment(1);
            if (!this.readOnly) {
                this.fbEstimations.addAction((Action)new CreateEstimationTransactionAction());
                this.estimationsTab.add(this.fbEstimations);
            }
            this.mainTabPanel.add(this.estimationsTab, (TabActivateAction)new MainTabActivateAction(this.estimationsTab, this.mainTabPanel));
            this.activationsTab = new Tab("Label.ActivationScheme");
            this.createActivationSchemeTable();
            this.activationsTab.add((Table)this.activationSchemeTable);
            if (!this.readOnly) {
                FloatBar fb = new FloatBar();
                fb.alignment(1);
                fb.addAction((Action)new CreateActivationSchemeTransactionAction());
                this.activationsTab.add(fb);
            }
            this.mainTabPanel.add(this.activationsTab, (TabActivateAction)new MainTabActivateAction(this.activationsTab, this.mainTabPanel));
            this.generalLedgerTab = new Tab("Label.Balances");
            TabbedPanel subTabPanel = new TabbedPanel();
            Tab subPanelTabMainAccounts = new Tab("Label.Costs");
            this.createCreditBalanceTable();
            subPanelTabMainAccounts.add((Table)this.creditBalanceTable);
            this.fbGeneralLedger = new FloatBar();
            this.fbGeneralLedger.alignment(1);
            subPanelTabMainAccounts.add(this.fbGeneralLedger);
            if (!this.readOnly) {
                this.fbGeneralLedger.addAction((Action)new CreateCreditBalanceAssignmentAction());
            }
            subTabPanel.add(subPanelTabMainAccounts);
            this.subPanelTabDeprInterest = new Tab("");
            this.createDepreciationInterestTable();
            this.subPanelTabDeprInterest.add((Table)this.deprInterestTable);
            this.fbDepreciationInterest = new FloatBar();
            this.fbDepreciationInterest.alignment(1);
            this.subPanelTabDeprInterest.add(this.fbDepreciationInterest);
            if (!this.readOnly) {
                this.fbDepreciationInterest.addAction((Action)new CreateDepreciationInterestTransactionAction());
            }
            subTabPanel.add(this.subPanelTabDeprInterest);
            this.generalLedgerTab.add(subTabPanel);
            this.mainTabPanel.add(this.generalLedgerTab, (TabActivateAction)new MainTabActivateAction(this.generalLedgerTab, this.mainTabPanel));
        }
    }

    protected void setValues() throws Exception {
        this.setCommonValues();
    }

    protected String update() throws Exception {
        String message = this.validateAll();
        if (message != null) {
            return message;
        }
        return new CreditBP(this).update(this.credit);
    }

    private String validateAll() throws Exception {
        String message = this.validateCommonForm();
        if (message != null) {
            return message;
        }
        return null;
    }

    protected void addCommonPanelAction(Action action) {
        this.fbCommon.addAction(action);
    }

    protected void addEstimationPanelAction(Action action) {
        this.fbEstimations.addAction(action);
        if (this.readOnly) {
            this.estimationsTab.add(this.fbEstimations);
        }
    }

    protected void addGeneralLedgerPanelAction(Action action) {
        this.fbGeneralLedger.addAction(action);
    }

    private void initializeCommonForm() throws Exception {
        CompanyAccountingPrincipleDefault capd;
        this.id.setLength(10);
        this.id.setMaxLength(10);
        this.id.setHelpId("Label.CreditId");
        if (this.company.getCreditIdAuto()) {
            this.id.setMandatory(false);
            this.id.setHidden(true);
        } else {
            this.id.setReadonly(false);
            this.id.setMandatory(true);
            this.id.setHidden(false);
            this.id.setLength(this.company.getCreditIdLength());
            this.id.setMaxLength(this.company.getCreditIdLength());
        }
        if (CreditBO.isIdNumeric(this.company)) {
            this.id.setType("number");
        }
        this.idReadOnly = this.id.getReadonly();
        this.description.setLength(50);
        this.description.setMaxLength(50);
        this.headerPanel = new HeaderPanel();
        this.headerPanel.addUIObject((UIObject)this.id);
        this.headerPanel.addUIObject((UIObject)this.description);
        this.headerPanel2 = new HeaderPanel();
        this.idDesc.setReadonly(true);
        this.idDesc.setLength(10);
        this.idDesc.setDescriptionLength(50);
        this.headerPanel2.addUIObject((UIObject)this.idDesc);
        this.firstPanel = new FieldGroup("Label.Common");
        this.creditAmount.setMandatory(true);
        this.firstPanel.add((Field)this.creditAmount);
        this.startYear = new BookYearField("Label.StartYear", "", this.bookYearMin, null);
        if (this.mode == 1) {
            this.startYear.setMandatory(false);
            this.startYear.setReadonly(true);
        }
        this.firstPanel.add((Field)this.startYear);
        this.endYear = new BookYearField("Label.EndYear", "", this.bookYearMin, null);
        this.endYear.setMandatory(false);
        this.firstPanel.add((Field)this.endYear);
        this.firstPanel2 = new FieldGroup();
        this.firstPanel2.add(this.description);
        this.firstPanel2.add((Field)this.startYear);
        this.firstPanel2.add((Field)this.endYear);
        this.secondPanel = new FieldGroup();
        this.decisionId.setLength(15);
        this.decisionId.setMaxLength(15);
        this.secondPanel.add(this.decisionId);
        this.secondPanel.add((Field)this.decisionDate);
        this.comboBoxState = GovernmentEnumHelper.createComboBox("Label.State", GovernmentEnumHelper.getCollection(1), false);
        if (!this.readOnly) {
            this.comboBoxState.removeOption(this.comboBoxState.getOptionByValue("4"));
        }
        this.secondPanel.add(this.comboBoxState);
        this.financialPanel = new FieldGroup("Label.FinancialDimensions");
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        int i = 0;
        while (i < this.finTexts.length) {
            this.financialDimension[i] = new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company);
            this.financialPanel.add((Field)this.financialDimension[i]);
            ++i;
        }
        this.miscellaneousPanel = new FieldGroup("Label.Miscellaneous");
        this.benefitType = GovernmentEnumHelper.createComboBox("Label.Benefit", GovernmentEnumHelper.getCollection(2), false);
        this.benefitType.setHidden(true);
        this.miscellaneousPanel.add(this.benefitType);
        this.balanceType = GovernmentEnumHelper.createComboBox("Label.BalanceType", GovernmentEnumHelper.getCollection(3), false);
        this.balanceType.setHidden(true);
        this.miscellaneousPanel.add(this.balanceType);
        this.resultAccountItem = new CheckBox("Label.ResultAccountItem");
        this.resultAccountItem.addOnChangeListener((EventListener)new ResultAccountItemListener());
        this.miscellaneousPanel.add(this.resultAccountItem);
        this.type = new AssetTypeReferenceField(this.dbData, this.companyId, true);
        this.type.setDescriptionLength(35);
        this.type.setLabel("Label.ProFormaTypeId");
        this.type.addOnChangeListener(new TypeListener());
        this.type.setMandatory(true);
        this.miscellaneousPanel.add((Field)this.type);
        this.assetTypeId = new AssetTypeReferenceField(this.dbData, this.companyId, true);
        this.assetTypeId.setDescriptionLength(35);
        this.assetTypeId.setLabel("Label.AssetType");
        this.assetTypeId.addOnChangeListener(new TypeListener());
        this.interestPanel = new FieldGroup("Label.Interest");
        this.interestCalculationMethod = EnumHelper.createComboBox("Label.InterestCalculationMethod", InterestCalculationMethodEnum.getCollection(), false);
        this.interestCalculationMethod.removeOption(this.interestCalculationMethod.getOptionByValue("2"));
        this.interestCalculationMethodChangeAction = new InterestCalculationMethodChangeAction();
        this.interestCalculationMethod.add((Action)this.interestCalculationMethodChangeAction);
        this.interestPanel.add(this.interestCalculationMethod);
        this.interestTableId = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.interestPanel.add((Field)this.interestTableId);
        this.interestPercentage = new FACDecimalField("Label.Percentage", 6, 3);
        this.interestPanel.add((Field)this.interestPercentage);
        if (this.mode == 0 && (capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.company.getId(), 3)[0]) != null) {
            this.interestCalculationMethod.setSelectedOptionValue("" + capd.getInterestCalculationMethod());
            this.interestTableId.setValue(capd.getInterestTableId());
            this.interestPercentage.setValue(capd.getInterestPercentage());
        }
        this.interestCalculationMethodChangeAction.execute(null);
    }

    private void setCommonValues() throws Exception {
        String creditId = this.credit.getId();
        if (this.numericIdTransformer != null) {
            creditId = (String)this.numericIdTransformer.transform(creditId);
        }
        this.id.setValue(creditId);
        this.id.setHidden(false);
        this.id.setReadonly(true);
        this.description.setValue(this.credit.getDescription().trim());
        this.idDesc.setValue(creditId);
        this.idDesc.setDescription(this.credit.getDescription().trim());
        this.startYear.setValue(this.credit.getStartYear());
        this.endYear.setValue(this.credit.getEndYear());
        int i = 0;
        while (i < this.finTexts.length) {
            String value = null;
            switch (i) {
                case 0: {
                    value = this.credit.getFinDimId1();
                    break;
                }
                case 1: {
                    value = this.credit.getFinDimId2();
                    break;
                }
                case 2: {
                    value = this.credit.getFinDimId3();
                    break;
                }
                case 3: {
                    value = this.credit.getFinDimId4();
                }
            }
            this.financialDimension[i].setValue(value);
            ++i;
        }
        this.benefitType.setSelectedOptionValue("" + this.credit.getBenefitType());
        this.balanceType.setSelectedOptionValue("" + this.credit.getGLBalanceType());
        this.resultAccountItem.setValue(this.credit.getIsResultAccountItem());
        this.type.setValue(this.credit.getProFormaTypeId());
        this.interestCalculationMethod.setSelectedOptionValue("" + this.credit.getInterestCalculationMethod());
        this.interestTableId.setValue(this.credit.getInterestTableId());
        InterestTable interestTable = this.credit.getInterestTable();
        if (interestTable != null) {
            this.interestTableId.setDescription(interestTable.getDescription());
        }
        this.interestPercentage.setValue(this.credit.getInterestPercentage());
        this.interestCalculationMethodChangeAction.execute(null);
        this.decisionId.setValue(this.credit.getDecisionId());
        this.decisionDate.setValue(this.credit.getDecisionDate());
        this.comboBoxState.setSelectedOptionValue("" + this.credit.getState());
        if (this.credit.getState() != 4) {
            this.subPanelTabDeprInterest.setLabel("Button.Valuation");
            this.LABELS0[2] = "Label.ExpenditureLeftAmount";
        } else {
            this.subPanelTabDeprInterest.setLabel("Label.Other");
            this.LABELS0[2] = "Label.Result";
        }
        this.createAmountsTable();
        this.headerPanel2.addUIObject((UIObject)this.table0);
    }

    protected void createAmountsTable() throws Exception {
        CreditQuery query = new CreditQuery(this.dbData, this.company.getId(), this.credit.getId());
        this.table0 = new ODBTable(Credit.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table0.setName("CreditPanels.CreditHeader");
        this.table0.setCounter((ODBCounter)query);
        this.table0.setColumnNames(NAMES0);
        this.table0.setColumnLabels(this.LABELS0);
        this.table0.setColumnSizes(SIZES0);
        this.table0.setDisplayTransformers(TRANSFORMERS0);
        this.table0.reload();
    }

    protected void refreshAmountsTable() throws Exception {
        ODBTable oldTable = this.table0;
        this.createAmountsTable();
        this.headerPanel2.replaceUIObject((UIObject)oldTable, (UIObject)this.table0);
    }

    protected String validateCommonForm() throws Exception {
        this.endYear.removeInvalidTag();
        int year = this.endYear.getIntValue();
        if (year == 0) {
            this.endYear.setValue(this.startYear.getInteger());
        } else if (this.endYear.getIntValue() < this.startYear.getIntValue()) {
            this.endYear.setInvalidTag();
            String message = TranslationHelperImpl.getInstance().translate("endYear_cannot_be_less_than_startYear");
            return message;
        }
        if (this.mode == 1 && this.endYear.getIntValue() < this.credit.getEndYear()) {
            Collection<TotalEstimationTransaction> transactions = TotalEstimationTransactionBO.getEstimationTransactions(this.credit, true);
            for (TotalEstimationTransaction totalTransaction : transactions) {
                Collection detailTransactions = totalTransaction.getDetailEstimationTransactionsCollection(null);
                for (DetailEstimationTransaction detailTransaction : detailTransactions) {
                    if (detailTransaction.getYear() <= this.endYear.getIntValue() || detailTransaction.getDetailTransactionAmount().doubleValue() == 0.0) continue;
                    this.endYear.setInvalidTag();
                    String message = TranslationHelperImpl.getInstance().translate("estimation_transactions_out_of_boundaries");
                    return message;
                }
            }
        }
        this.interestTableId.removeInvalidTag();
        this.interestPercentage.removeInvalidTag();
        if (!"0".equals(this.interestCalculationMethod.getValue())) {
            Object[] result;
            String message;
            boolean precentageFilled;
            String id = this.interestTableId.getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.interestPercentage.getDoubleValue() > 0.0;
            if (!idFilled && !precentageFilled) {
                this.interestTableId.setInvalidTag();
                this.interestPercentage.setInvalidTag();
                return "provide_one_value";
            }
            if (idFilled && precentageFilled) {
                this.interestTableId.setInvalidTag();
                this.interestPercentage.setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.interestTableId.setInvalidTag();
                return message;
            }
        }
        return null;
    }

    protected void validateDimensionForm() throws Exception {
        this.financialPanel.removeInvalidTags();
        this.financialPanel.validateAll();
        int i = 0;
        while (i < 6) {
            if (this.dimension[i] != null) {
                this.dimension[i].validate();
            }
            ++i;
        }
    }

    protected FieldGroup initializeFACDimensionPanel() throws Exception {
        this.dimensionPanel.removeAllChildUIObjects();
        this.freeDimension = new Field[6];
        boolean mandatory = false;
        int i = 0;
        while (i < 6) {
            String value = "";
            switch (i) {
                case 0: {
                    this.analysisGroup[i] = this.company.getAnalysisGroup1();
                    mandatory = this.company.getSeqNr1Mandatory();
                    if (this.credit == null) break;
                    value = this.credit.getDimValue1();
                    break;
                }
                case 1: {
                    this.analysisGroup[i] = this.company.getAnalysisGroup2();
                    mandatory = this.company.getSeqNr2Mandatory();
                    if (this.credit == null) break;
                    value = this.credit.getDimValue2();
                    break;
                }
                case 2: {
                    this.analysisGroup[i] = this.company.getAnalysisGroup3();
                    mandatory = this.company.getSeqNr3Mandatory();
                    if (this.credit == null) break;
                    value = this.credit.getDimValue3();
                    break;
                }
                case 3: {
                    this.analysisGroup[i] = this.company.getAnalysisGroup4();
                    mandatory = this.company.getSeqNr4Mandatory();
                    if (this.credit == null) break;
                    value = this.credit.getDimValue4();
                    break;
                }
                case 4: {
                    this.analysisGroup[i] = this.company.getAnalysisGroup5();
                    mandatory = this.company.getSeqNr5Mandatory();
                    if (this.credit == null) break;
                    value = this.credit.getDimValue5();
                    break;
                }
                case 5: {
                    this.analysisGroup[i] = this.company.getAnalysisGroup6();
                    mandatory = this.company.getSeqNr6Mandatory();
                    if (this.credit == null) break;
                    value = this.credit.getDimValue6();
                }
            }
            if (this.analysisGroup[i] != null) {
                Object field;
                if (this.analysisGroup[i].getUsage() == 1) {
                    this.dimension[i] = new AnalysisCodeReferenceField(this.dbData, this.analysisGroup[i]);
                    if (this.credit == null) {
                        value = this.getDefaultAnalysisCodeValue(i);
                    }
                    this.dimension[i].setValue(value);
                    field = this.dimension[i];
                } else {
                    this.freeDimension[i] = AnalysisFieldHelper.create(this.analysisGroup[i]);
                    this.freeDimension[i].setValue(value);
                    field = this.freeDimension[i];
                    field.setMaxLength(10);
                }
                field.setMandatory(mandatory);
                this.dimensionPanel.add(field);
            }
            ++i;
        }
        this.dimensionPanel.setHidden(!this.dimensionPanel.hasUIObjects());
        return this.dimensionPanel;
    }

    private String getDefaultAnalysisCodeValue(int index) throws Exception {
        String value = "";
        switch (index) {
            case 0: {
                value = this.company.getDefaultAnalysisCode1();
                break;
            }
            case 1: {
                value = this.company.getDefaultAnalysisCode2();
                break;
            }
            case 2: {
                value = this.company.getDefaultAnalysisCode3();
                break;
            }
            case 3: {
                value = this.company.getDefaultAnalysisCode4();
                break;
            }
            case 4: {
                value = this.company.getDefaultAnalysisCode5();
                break;
            }
            case 5: {
                value = this.company.getDefaultAnalysisCode6();
            }
        }
        return value;
    }

    protected void createTotalEstimationTransactionTable() throws Exception {
        TotalEstimationTransactionQuery query = new TotalEstimationTransactionQuery(this.dbData, this.credit.getCompanyId(), this.credit.getId(), true, false);
        this.estimationTable = new ODBTable(TotalEstimationTransaction.class, (ODBQuery)query, new String[]{"internalNumber"}, 12);
        this.estimationTable.setName("CreditPanels.TotalEstimationTransaction");
        this.estimationTable.setCounter((ODBCounter)query);
        this.estimationTable.setColumnNames(NAMES1);
        this.estimationTable.setColumnLabels(LABELS1);
        this.estimationTable.setColumnSizes(SIZES1);
        this.estimationTable.setDisplayTransformers(TRANSFORMERS1);
        this.estimationTable.setColumnTypes(TYPES1);
        ContextMenu menu = new ContextMenu();
        menu.addContextMenuItem((ContextAction)new EstimationTransactionRowAction());
        menu.addContextMenuItem((ContextAction)new EstimationTransactionMemoAction());
        this.estimationTable.setContextMenu(menu);
        this.estimationTable.setRowAction((Action)new EstimationTransactionRowAction());
        this.estimationTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.estimationTable, (String[])TOOLTIPS1);
    }

    protected void refreshTotalEstimationTransactionTable() throws Exception {
        ODBTable oldTable = this.estimationTable;
        this.createTotalEstimationTransactionTable();
        this.estimationsTab.replaceUIObject((UIObject)oldTable, (UIObject)this.estimationTable);
    }

    protected void createEstimationTable() throws Exception {
        if (this.totalEstimationTransaction == null) {
            this.totalEstimationTransaction = TotalEstimationTransactionBO.getEstimationTransaction(this.credit);
        }
        Collection estimations = this.totalEstimationTransaction.getDetailEstimationTransactionsCollection(QueryFactory.create("", "year"));
        this.estimationYearsTable = new EstimationCollectionTable(DetailEstimationTransaction.class, estimations, 12);
        this.estimationYearsTable.setName("CreditPanels.DetailEstimationTransaction");
        this.estimationYearsTable.setColumnNames(NAMES2);
        this.estimationYearsTable.setColumnLabels(LABELS2);
        this.estimationYearsTable.setColumnSizes(SIZES2);
        this.estimationYearsTable.reload();
    }

    protected void validateEstimations() throws Exception {
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (TableRow row : this.estimationYearsTable.getRows()) {
            FACDecimalField field = (FACDecimalField)((Object)row.getUIObjects().get(1));
            totalAmount = totalAmount.add(field.getBigDecimal());
        }
        if (totalAmount.doubleValue() != this.transactionAmount.getBigDecimal().doubleValue()) {
            throw new UserErrorMessage(String.valueOf(TranslationHelperImpl.getInstance().translate("Error.The_sum_of_the_amounts_is_not_equal_the_total_credit_amount_the_difference_is")) + ": " + totalAmount.subtract(this.transactionAmount.getBigDecimal()));
        }
    }

    protected void saveEstimations() throws Exception {
        for (TableRow row : this.estimationYearsTable.getRows()) {
            FACDecimalField field = (FACDecimalField)((Object)row.getUIObjects().get(1));
            DetailEstimationTransaction detailEstimationTransaction = (DetailEstimationTransaction)row.getObject();
            detailEstimationTransaction.setDetailTransactionAmount(field.getBigDecimal());
        }
    }

    protected void addWarningOnBehalfOfActivationScheme(DataObject object) throws Exception {
        if (this.type.getAssetType() != null && this.type.getValue().trim().length() > 0) {
            object.addUIObject((UIObject)new Message("Let op, wijzigingen in ramingsgegevens zijn (mogelijk) van invloed op het activeringsschema !", "alert"));
        }
    }

    protected void createDepreciationInterestTable() throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.credit, false);
        this.deprInterestTable = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"documentNr", "seqNr"}, 12);
        this.deprInterestTable.setName("CreditPanels.DeprInterest");
        this.deprInterestTable.setCounter((ODBCounter)query);
        this.deprInterestTable.setColumnNames(NAMES9);
        this.deprInterestTable.setColumnLabels(LABELS9);
        this.deprInterestTable.setColumnSizes(SIZES9);
        this.deprInterestTable.setColumnTypes(TYPES9);
        this.deprInterestTable.setDisplayTransformers(TRANSFORMERS9);
        this.deprInterestTable.setColumnNoWraps(COLUMNNOWRAPS9);
        this.deprInterestTable.setColumnSortable(SORTABLE9);
        ContextMenu menu = new ContextMenu();
        menu.addContextMenuItem((ContextAction)new TransactionDetailAction());
        this.deprInterestTable.setRowAction((Action)new TransactionDetailAction());
        this.deprInterestTable.setContextMenu(menu);
        this.deprInterestTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.deprInterestTable, (String[])TOOLTIPS9);
    }

    protected void refreshDepreciationInterestTable() throws Exception {
        ODBTable oldTable = this.creditBalanceTable;
        this.createCreditBalanceTable();
        this.generalLedgerTab.replaceUIObject((UIObject)oldTable, (UIObject)this.creditBalanceTable);
    }

    protected void createCreditBalanceTable() throws Exception {
        CreditBalanceQuery query = new CreditBalanceQuery(this.dbData, this.credit.getCompanyId(), this.credit.getId());
        for (CreditBalance creditBalance : query.fetchData(null, null, null, 0)) {
            new CreditBalanceBP(this.company).handleBalanceIsDirty(creditBalance);
        }
        this.creditBalanceTable = new ODBTable(CreditBalance.class, (ODBQuery)query, new String[]{"gLAccountId"}, 12);
        this.creditBalanceTable.setName("CreditPanels.CreditBalance");
        this.creditBalanceTable.setCounter((ODBCounter)query);
        this.creditBalanceTable.setColumnNames(NAMES4);
        this.creditBalanceTable.setColumnLabels(LABELS4);
        this.creditBalanceTable.setColumnSizes(SIZES4);
        this.creditBalanceTable.setDisplayTransformers(TRANSFORMERS4);
        ContextMenu menu = new ContextMenu();
        menu.addContextMenuItem((ContextAction)new IFTTableAction());
        menu.addContextMenuItem((ContextAction)new SingleAccountMultipleYearsAction());
        if (!this.readOnly) {
            menu.addContextMenuItem((ContextAction)new CreditBalanceAction());
        }
        this.creditBalanceTable.setRowAction((Action)new IFTTableAction());
        this.creditBalanceTable.setContextMenu(menu);
        this.creditBalanceTable.reload();
    }

    protected void refreshCreditBalanceTable() throws Exception {
        ODBTable oldTable = this.creditBalanceTable;
        this.createCreditBalanceTable();
        this.generalLedgerTab.replaceUIObject((UIObject)oldTable, (UIObject)this.creditBalanceTable);
    }

    protected void createCostAccountTable(String bookYear) throws Exception {
        this.glAccountSelectionTable = new CollectionTable(NameValuePair.class, CreditBalanceBP.getCostAccounts(this.company, bookYear, this.loginHelper), 12);
        this.glAccountSelectionTable.setName("CreditPanels.CostAccount");
        this.glAccountSelectionTable.setColumnNames(NameValuePair.NAMES);
        this.glAccountSelectionTable.setColumnLabels(LABELS6);
        this.glAccountSelectionTable.setColumnSizes(SIZES6);
        ContextMenu menu = new ContextMenu();
        menu.addContextMenuItem((ContextAction)new AssignCreditBalanceAction());
        this.glAccountSelectionTable.setRowAction((Action)new AssignCreditBalanceAction());
        this.glAccountSelectionTable.setContextMenu(menu);
        this.glAccountSearchPanel = this.glAccountSelectionTable.createSearch(NameValuePair.NAMES, LABELS6);
        this.glAccountSelectionTable.reload();
    }

    protected void createIncomingFinancialTransactionTable() throws Exception {
        IncomingFinancialTransactionForGLAccountQuery query = new IncomingFinancialTransactionForGLAccountQuery(this.dbData, this.creditBalance.getCompanyId(), this.creditBalance.getGLAccountId());
        this.iftTable = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.iftTable.setName("CreditPanels.IncomingFinancialTransaction");
        this.iftTable.setColumnNames(NAMES5);
        this.iftTable.setCounter((ODBCounter)query);
        this.iftTable.setColumnLabels(LABELS5);
        this.iftTable.setColumnSizes(SIZES5);
        this.iftTable.setDisplayTransformers(TRANSFORMERS5);
        this.iftTable.setSortable(true);
        ContextMenu menu = new ContextMenu();
        menu.addContextMenuItem((ContextAction)new DetailIFTAction());
        menu.addContextMenuItem((ContextAction)new IFTAction());
        this.iftTable.setRowAction((Action)new DetailIFTAction());
        this.iftTable.setContextMenu(menu);
        this.iftSearchPanel = this.iftTable.createSearch(SEARCHNAMES5, SEARCHLABELS5);
        this.iftTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.iftTable, (String[])TOOLTIPS5);
    }

    protected void createRow4ZoomTable(CreditBalance creditBalance) throws Exception {
        this.singleAccountMultipleYearsTable = new CollectionTable(CreditBalanceWrapper.class, CreditBalanceBO.retrieveCreditBalanceWrapperCollection(this.credit, creditBalance), 12);
        this.singleAccountMultipleYearsTable.setName("CreditPanels.Row4ZoomTable");
        this.singleAccountMultipleYearsTable.setColumnNames(NAMES7);
        this.singleAccountMultipleYearsTable.setColumnLabels(LABELS7);
        this.singleAccountMultipleYearsTable.setColumnTypes(TYPES7);
        this.singleAccountMultipleYearsTable.setColumnSizes(SIZES7);
        this.singleAccountMultipleYearsTable.reload();
    }

    protected DataObject showGLYearWindow(DataObject object) throws Exception {
        if (this.credit.getEndYear() <= this.credit.getStartYear()) {
            object.addUIObject((UIObject)new Message("Uitsplitsing alleen mogelijk indien de looptijd van het krediet > 1 jaar", "error"));
            return object;
        }
        if (this.credit.getCreditBalanceReferenceCounter() < 2) {
            object.addUIObject((UIObject)new Message("Uitsplitsing alleen mogelijk bij meerdere rekeningen", "error"));
            return object;
        }
        this.window = new Window();
        this.window.setLabel("Uitsplitsing boekjaar / rekening");
        this.multipleAccountsMultipleYearsTable = new CollectionTable(CreditBalanceWrapper.class, CreditBalanceBO.retrieveCreditBalanceWrapperCollection(this.credit), 12);
        this.multipleAccountsMultipleYearsTable.setName("CreditPanels.GLYearTable");
        this.multipleAccountsMultipleYearsTable.setColumnNames(NAMES8);
        this.multipleAccountsMultipleYearsTable.setColumnLabels(LABELS8);
        this.multipleAccountsMultipleYearsTable.setColumnTypes(TYPES8);
        this.multipleAccountsMultipleYearsTable.setColumnSizes(SIZES8);
        this.multipleAccountsMultipleYearsTable.reload();
        this.window.add((Table)this.multipleAccountsMultipleYearsTable);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    protected void createActivationSchemeTable() throws Exception {
        TotalEstimationTransactionQuery query = new TotalEstimationTransactionQuery(this.dbData, this.credit.getCompanyId(), this.credit.getId(), false, false);
        this.activationSchemeTable = new ODBTable(TotalEstimationTransaction.class, (ODBQuery)query, new String[]{"estimationTransactionType", "internalNumber"}, 12);
        this.activationSchemeTable.setName("CreditPanels.ActivationScheme");
        this.activationSchemeTable.setCounter((ODBCounter)query);
        this.activationSchemeTable.setColumnNames(NAMES3);
        this.activationSchemeTable.setColumnLabels(LABELS3);
        this.activationSchemeTable.setColumnSizes(SIZES3);
        CreditPanels.TRANSFORMERS3[4] = new DepreciationMethodTransformer();
        this.activationSchemeTable.setDisplayTransformers(TRANSFORMERS3);
        this.activationSchemeTable.setColumnTypes(TYPES3);
        ContextMenu menu = new ContextMenu();
        menu.addContextMenuItem((ContextAction)new ActivationSchemeTransactionAction());
        menu.addContextMenuItem((ContextAction)new ActivationSchemeTransactionMemoAction());
        this.activationSchemeTable.setRowAction((Action)new ActivationSchemeTransactionAction());
        this.activationSchemeTable.setContextMenu(menu);
        this.activationSchemeTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.activationSchemeTable, (String[])TOOLTIPS3);
    }

    protected void refreshActivationSchemeTable() throws Exception {
        TotalEstimationTransactionBO.createActivationSchemeTransactions(this.credit);
        ODBTable oldTable = this.activationSchemeTable;
        this.createActivationSchemeTable();
        this.activationsTab.replaceUIObject((UIObject)oldTable, (UIObject)this.activationSchemeTable);
    }

    public void initializeValuationForm() throws Exception {
        this.apPanel = new Panel();
        this.depreciationGroup = new FieldGroup("Label.Depreciations");
        this.depreciationMethod = EnumHelper.createComboBox("Label.DepreciationMethod", DepreciationMethodEnum.getCollection(), false);
        this.depreciationMethod.setWidth("225");
        this.depreciationMethodChangeAction = new DepreciationMethodChangeAction();
        this.depreciationMethod.add((Action)this.depreciationMethodChangeAction);
        this.depreciationGroup.add(this.depreciationMethod);
        this.yearPercentageTableId = new YearPercentageTableReferenceField(this.dbData);
        this.depreciationGroup.add((Field)this.yearPercentageTableId);
        this.degressivePercentage = new FACDecimalField("Label.Percentage", 5, 2);
        this.degressivePercentage.setMinValue(new BigDecimal(0), true);
        this.degressivePercentage.setMaxValue(new BigDecimal(100), true);
        this.depreciationGroup.add((Field)this.degressivePercentage);
        this.annuityInterestTableId = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.depreciationGroup.add((Field)this.annuityInterestTableId);
        this.annuityPercentage = new FACDecimalField("Label.Percentage", 6, 3);
        this.annuityPercentage.setMinValue(new BigDecimal(0), true);
        this.annuityPercentage.setMaxValue(new BigDecimal(100), true);
        this.depreciationGroup.add((Field)this.annuityPercentage);
        this.startPeriodHandlingMethod = EnumHelper.createComboBox("Label.StartPeriodHandlingPolicy", StartPeriodHandlingEnum.getCollection(), false);
        this.startPeriodHandlingMethod.setWidth("225");
        this.depreciationGroup.add(this.startPeriodHandlingMethod);
        this.apPanel.addUIObject((UIObject)this.depreciationGroup);
        this.depreciationGroup2 = new FieldGroup("");
        this.depreciatableLife = new NumberField("Label.DepreciationLife", 4, true);
        this.depreciatableLife.setMinValue(new BigInteger("0"), true);
        this.depreciatableLife.setMandatory(true);
        this.depreciationGroup2.add((Field)this.depreciatableLife);
        this.residualPercentage = new FACDecimalField("Label.ResidualValuePercentage", 5, 2);
        this.residualPercentage.setMinValue(new BigDecimal(0), true);
        this.residualPercentage.setMaxValue(new BigDecimal(100), true);
        this.depreciationGroup2.add((Field)this.residualPercentage);
        this.residualValue = new FACDecimalField("Label.ResidualValueAmount", 15, 2);
        this.depreciationGroup2.add((Field)this.residualValue);
        this.apPanel.addUIObject((UIObject)this.depreciationGroup2);
        this.interestGroup = new FieldGroup("Label.Interest");
        this.apInterestCalculationMethod = EnumHelper.createComboBox("Label.InterestCalculationMethod", InterestCalculationMethodEnum.getCollection(), false);
        this.apInterestCalculationMethod.removeOption(this.apInterestCalculationMethod.getOptionByValue("2"));
        this.apInterestCalculationMethod.setWidth("225");
        this.apInterestCalculationMethodChangeAction = new APInterestCalculationMethodChangeAction();
        this.apInterestCalculationMethod.add((Action)this.apInterestCalculationMethodChangeAction);
        this.interestGroup.add(this.apInterestCalculationMethod);
        this.apInterestTableId = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.apInterestTableId.setDescriptionLength(35);
        this.interestGroup.add((Field)this.apInterestTableId);
        this.apInterestPercentage = new FACDecimalField("Label.Percentage", 6, 3);
        this.apInterestPercentage.setMinValue(new BigDecimal(0), true);
        this.apInterestPercentage.setMaxValue(new BigDecimal(100), true);
        this.interestGroup.add((Field)this.apInterestPercentage);
        this.apPanel.addUIObject((UIObject)this.interestGroup);
    }

    public void getAccountingPrincipleDefaultFromType(String id) throws Exception {
        AssetTypeAccountingPrincipleDefault assetTypeAccountingPrincipleDefault = (AssetTypeAccountingPrincipleDefault)AssetTypeAccountingPrincipleDefaultBO.get(this.dbData, this.companyId, id, 1)[0];
        if (assetTypeAccountingPrincipleDefault != null) {
            this.depreciationMethod.setSelectedOptionValue("" + assetTypeAccountingPrincipleDefault.getDepreciationMethod());
            this.degressivePercentage.setValue(assetTypeAccountingPrincipleDefault.getDegressivePercentage());
            this.annuityPercentage.setValue(assetTypeAccountingPrincipleDefault.getAnnuityPercentage());
            this.annuityInterestTableId.setValue(assetTypeAccountingPrincipleDefault.getAnnuityInterestTableId());
            InterestTable interestTable = assetTypeAccountingPrincipleDefault.getAnnuityInterestTable();
            if (interestTable != null) {
                this.annuityInterestTableId.setDescription(interestTable.getDescription());
            }
            this.yearPercentageTableId.setValue(assetTypeAccountingPrincipleDefault.getYearPercentageTableId());
            YearPercentageTable yearPercentageTable = assetTypeAccountingPrincipleDefault.getYearPercentageTable();
            if (yearPercentageTable != null) {
                this.yearPercentageTableId.setDescription(yearPercentageTable.getDescription());
            }
            this.startPeriodHandlingMethod.setSelectedOptionValue("" + assetTypeAccountingPrincipleDefault.getStartPeriodHandlingMethod());
            this.depreciatableLife.setValue((long)assetTypeAccountingPrincipleDefault.getDepreciatableLife());
            this.residualValue.setValue(assetTypeAccountingPrincipleDefault.getResidualValue());
            this.residualPercentage.setValue(assetTypeAccountingPrincipleDefault.getResidualPercentage());
            this.apInterestCalculationMethod.setSelectedOptionValue("" + assetTypeAccountingPrincipleDefault.getInterestCalculationMethod());
            this.apInterestTableId.setValue(assetTypeAccountingPrincipleDefault.getInterestTableId());
            interestTable = assetTypeAccountingPrincipleDefault.getInterestTable();
            if (interestTable != null) {
                this.apInterestTableId.setDescription(interestTable.getDescription());
            }
            this.apInterestPercentage.setValue(assetTypeAccountingPrincipleDefault.getInterestPercentage());
        }
    }

    private void setValuationValues() throws Exception {
        if (this.totalEstimationTransaction.getDepreciationMethod() == 0) {
            this.getAccountingPrincipleDefaultFromType(this.assetTypeId.getValue().trim());
            return;
        }
        this.depreciationMethod.setSelectedOptionValue("" + this.totalEstimationTransaction.getDepreciationMethod());
        this.degressivePercentage.setValue(this.totalEstimationTransaction.getDegressivePercentage());
        this.annuityPercentage.setValue(this.totalEstimationTransaction.getAnnuityPercentage());
        this.annuityInterestTableId.setValue(this.totalEstimationTransaction.getAnnuityInterestTableId());
        InterestTable interestTable = this.totalEstimationTransaction.getAnnuityInterestTable();
        if (interestTable != null) {
            this.annuityInterestTableId.setDescription(interestTable.getDescription());
        }
        this.yearPercentageTableId.setValue(this.totalEstimationTransaction.getYearPercentageTableId());
        YearPercentageTable yearPercentageTable = this.totalEstimationTransaction.getYearPercentageTable();
        if (yearPercentageTable != null) {
            this.yearPercentageTableId.setDescription(yearPercentageTable.getDescription());
        }
        this.startPeriodHandlingMethod.setSelectedOptionValue("" + this.totalEstimationTransaction.getStartPeriodHandlingMethod());
        this.depreciatableLife.setValue((long)this.totalEstimationTransaction.getDepreciatableLife());
        this.residualValue.setValue(this.totalEstimationTransaction.getResidualValue());
        this.residualPercentage.setValue(this.totalEstimationTransaction.getResidualPercentage());
        this.apInterestCalculationMethod.setSelectedOptionValue("" + this.totalEstimationTransaction.getInterestCalculationMethod());
        this.apInterestTableId.setValue(this.totalEstimationTransaction.getInterestTableId());
        interestTable = this.totalEstimationTransaction.getInterestTable();
        if (interestTable != null) {
            this.apInterestTableId.setDescription(interestTable.getDescription());
        }
        this.apInterestPercentage.setValue(this.totalEstimationTransaction.getInterestPercentage());
    }

    protected String validateValuation() throws Exception {
        Object[] result;
        this.yearPercentageTableId.removeInvalidTag();
        this.depreciatableLife.removeInvalidTag();
        this.apInterestTableId.removeInvalidTag();
        this.apInterestPercentage.removeInvalidTag();
        this.residualValue.removeInvalidTag();
        this.residualPercentage.removeInvalidTag();
        String id = this.yearPercentageTableId.getValue().trim();
        if (id.length() > 0) {
            Object[] result2 = YearPercentageTableBO.get(this.dbData, id);
            String message = (String)result2[1];
            if (message != null) {
                this.yearPercentageTableId.setInvalidTag();
                return message;
            }
            YearPercentageTable table = (YearPercentageTable)result2[0];
            int maxPeriodsAllowed = table.getActualYears() * this.numberOfPeriods;
            if (this.depreciatableLife.getIntValue() > maxPeriodsAllowed) {
                message = String.valueOf(TranslationHelperImpl.getInstance().translate("depr_life_greater_than_table_periods")) + " (" + maxPeriodsAllowed + ")";
                this.yearPercentageTableId.setInvalidTag();
                this.depreciatableLife.setInvalidTag();
                return message;
            }
            int minPeriodsAllowed = (table.getActualYears() - 1) * this.numberOfPeriods + 1;
            if (this.depreciatableLife.getIntValue() < minPeriodsAllowed) {
                message = String.valueOf(TranslationHelperImpl.getInstance().translate("depr_life_less_than_table_periods")) + " (" + minPeriodsAllowed + ")";
                this.yearPercentageTableId.setInvalidTag();
                this.depreciatableLife.setInvalidTag();
                return message;
            }
        }
        if (!"0".equals(this.apInterestCalculationMethod.getValue())) {
            String message;
            boolean precentageFilled;
            id = this.apInterestTableId.getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.apInterestPercentage.getDoubleValue() > 0.0;
            if (!idFilled && !precentageFilled) {
                this.apInterestTableId.setInvalidTag();
                this.apInterestPercentage.setInvalidTag();
                return "provide_one_value";
            }
            if (idFilled && precentageFilled) {
                this.apInterestTableId.setInvalidTag();
                this.apInterestPercentage.setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.apInterestTableId.setInvalidTag();
                return message;
            }
        }
        if ("12".equals(this.depreciationMethod.getValue()) || "11".equals(this.depreciationMethod.getValue())) {
            String message;
            boolean precentageFilled;
            id = this.annuityInterestTableId.getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.annuityPercentage.getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.annuityInterestTableId.setInvalidTag();
                this.annuityPercentage.setInvalidTag();
                return "provide_only_one_value";
            }
            if (!idFilled && !precentageFilled) {
                this.annuityInterestTableId.setInvalidTag();
                this.annuityPercentage.setInvalidTag();
                return "provide_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.annuityInterestTableId.setInvalidTag();
                return message;
            }
            if (this.depreciatableLife.getIntValue() % this.company.getNumberOfPeriods() != 0) {
                this.depreciatableLife.setInvalidTag();
                String message2 = TranslationHelperImpl.getInstance().translate("depreciatableLife_in_complete_years");
                return String.valueOf(message2) + " " + this.numberOfPeriods;
            }
        }
        if (this.residualValue.getDoubleValue() != 0.0 && this.residualPercentage.getDoubleValue() > 0.0) {
            this.residualValue.setInvalidTag();
            this.residualPercentage.setInvalidTag();
            return "provide_only_one_value";
        }
        return null;
    }

    private HeaderPanel getIFTHeader() throws Exception {
        HeaderPanel header = new HeaderPanel();
        ESPGridLayout grid = new ESPGridLayout();
        short[] sArray = new short[2];
        sArray[0] = 200;
        grid.setColumnWidths(sArray);
        Field systemItemNumber = new Field();
        systemItemNumber.setDiscardLabel(true);
        systemItemNumber.setLength(15);
        systemItemNumber.setReadonly(true);
        grid.add((UIObject)new Label("Label.SystemItemNbr"), 0, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)systemItemNumber, 0, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        BookYearPeriodGrid iftYearPeriod = new BookYearPeriodGrid(null, true);
        grid.add((UIObject)new Label("Label.GLPeriod"), 1, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)iftYearPeriod, 1, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        Field iftTransactionValue = new Field("", "decimal", null, "", 15);
        iftTransactionValue.setDiscardLabel(true);
        iftTransactionValue.setReadonly(true);
        grid.add((UIObject)new Label("Label.TransactionValue"), 2, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)iftTransactionValue, 2, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        header.addUIObject((UIObject)grid);
        String sSystemItemNumber = this.incomingFinancialTransaction.getSystemItemSequencenumber() != 0 ? this.incomingFinancialTransaction.getSystemItemNumber() + "/" + this.incomingFinancialTransaction.getSystemItemSequencenumber() : "" + this.incomingFinancialTransaction.getSystemItemNumber();
        systemItemNumber.setValue(sSystemItemNumber);
        iftYearPeriod.setValues("" + this.incomingFinancialTransaction.getBookYear(), "" + this.incomingFinancialTransaction.getPeriod());
        iftTransactionValue.setValue((String)DECIMALTRANSFORMER.transform(this.incomingFinancialTransaction.getTransactionValue()));
        return header;
    }

    public class APInterestCalculationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(CreditPanels.this.apInterestCalculationMethod.getValue())) {
                CreditPanels.this.apInterestTableId.setHidden(true);
                CreditPanels.this.apInterestTableId.setValue();
                CreditPanels.this.apInterestPercentage.setHidden(true);
                CreditPanels.this.apInterestPercentage.setValue();
                return true;
            }
            CreditPanels.this.apInterestTableId.setHidden(false);
            CreditPanels.this.apInterestPercentage.setHidden(false);
            return true;
        }
    }

    private class ActivationSchemeTransactionAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private ActivationSchemeTransactionAction() throws Exception {
            super("Button.Edit");
            if (CreditPanels.this.readOnly) {
                this.setLabel("Button.Details");
            }
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.totalEstimationTransaction = (TotalEstimationTransaction)TableHelper.getSelectedItem((DataObject)object);
            if (CreditPanels.this.totalEstimationTransaction.getEstimationTransactionType() == 104) {
                throw new UserErrorMessage("Error.Edit_not_allowed");
            }
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setLabel("Title.EditActivationSchemeTransaction");
            FieldGroup fg = new FieldGroup("Label.Common");
            CreditPanels.this.assetTypeId.setValue(CreditPanels.this.totalEstimationTransaction.getAssetTypeId());
            CreditPanels.this.assetTypeId.setMandatory(true);
            fg.add((Field)CreditPanels.this.assetTypeId);
            CreditPanels.this.transactionAmount.setValue(CreditPanels.this.totalEstimationTransaction.getTotalTransactionAmount());
            CreditPanels.this.transactionAmount.setMandatory(true);
            CreditPanels.this.transactionAmount.removeInvalidTag();
            CreditPanels.this.transactionAmount.setReadonly(false);
            fg.add((Field)CreditPanels.this.transactionAmount);
            CreditPanels.this.transactionDescription.setValue(CreditPanels.this.totalEstimationTransaction.getDescription());
            CreditPanels.this.transactionDescription.setLength(50);
            CreditPanels.this.transactionDescription.setMaxLength(50);
            CreditPanels.this.transactionDescription.setReadonly(false);
            fg.add(CreditPanels.this.transactionDescription);
            CreditPanels.this.window.add(fg);
            CreditPanels.this.initializeValuationForm();
            CreditPanels.this.setValuationValues();
            CreditPanels.this.depreciationMethodChangeAction.execute(object);
            CreditPanels.this.apInterestCalculationMethodChangeAction.execute(object);
            CreditPanels.this.window.add(CreditPanels.this.apPanel);
            if (!CreditPanels.this.readOnly) {
                CreditPanels.this.assetTypeId.setReadonly(true);
                FloatBar fb = new FloatBar();
                fb.addAction((Action)new ActivationSchemeTransactionOKAction());
                if (CreditPanels.this.totalEstimationTransaction.getEstimationTransactionType() == 102) {
                    fb.addAction((Action)new ActivationSchemeTransactionDeleteAction());
                }
                CreditPanels.this.window.add(fb);
            } else {
                CreditPanels.this.window.setLabel("Title.ShowActivationSchemeTransaction");
                fg.setReadonly(true);
                CreditPanels.this.depreciationGroup.setReadonly(true);
                CreditPanels.this.depreciationGroup2.setReadonly(true);
                CreditPanels.this.interestGroup.setReadonly(true);
            }
            object.addUIObject((UIObject)CreditPanels.this.window);
            object.getScreen().setHelpIdToNull();
            return true;
        }
    }

    private class ActivationSchemeTransactionDeleteAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private ActivationSchemeTransactionDeleteAction() {
            super("Button.Delete");
        }

        public boolean execute(DataObject object) throws Exception {
            TotalEstimationTransactionBO.delete(CreditPanels.this.totalEstimationTransaction);
            CreditPanels.this.refreshActivationSchemeTable();
            CreditPanels.this.window.closeWindow(object);
            return true;
        }
    }

    private class ActivationSchemeTransactionMemoAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private ActivationSchemeTransactionMemoAction() throws Exception {
            super(CreditPanels.this.memoAction.getLanguageCode());
            this.setAdapter(CreditPanels.this.memoAction.getPageid());
            this.setMethod(CreditPanels.this.memoAction.getMethod());
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.process.setAttribute("Table", (Object)CreditPanels.this.activationSchemeTable);
            return false;
        }
    }

    private class ActivationSchemeTransactionOKAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private ActivationSchemeTransactionOKAction() {
            super("Button.OK");
            this.setDefault(true);
            this.setValidationEnabled(true);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            String message = CreditPanels.this.validateValuation();
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return true;
            }
            TotalEstimationTransactionBO.changeActivationTransaction(CreditPanels.this.credit, CreditPanels.this.totalEstimationTransaction, CreditPanels.this.assetTypeId.getValue(), CreditPanels.this.transactionAmount.getBigDecimal(), CreditPanels.this.transactionDescription.getValue());
            if (CreditPanels.this.totalEstimationTransaction.getEstimationTransactionType() == 100) {
                CreditPanels.this.type.setValue(CreditPanels.this.assetTypeId.getValue());
            }
            TotalEstimationTransactionBO.updateValuation(CreditPanels.this.totalEstimationTransaction, Integer.parseInt(CreditPanels.this.depreciationMethod.getValue()), CreditPanels.this.yearPercentageTableId.getValue(), CreditPanels.this.degressivePercentage.getBigDecimal(), CreditPanels.this.annuityInterestTableId.getValue(), CreditPanels.this.annuityPercentage.getBigDecimal(), Integer.parseInt(CreditPanels.this.startPeriodHandlingMethod.getValue()), CreditPanels.this.depreciatableLife.getIntValue(), CreditPanels.this.residualPercentage.getBigDecimal(), CreditPanels.this.residualValue.getBigDecimal(), Integer.parseInt(CreditPanels.this.apInterestCalculationMethod.getValue()), CreditPanels.this.apInterestTableId.getValue(), CreditPanels.this.numberOfPeriods, CreditPanels.this.apInterestPercentage.getBigDecimal());
            CreditPanels.this.refreshActivationSchemeTable();
            CreditPanels.this.window.closeWindow(object);
            return true;
        }
    }

    private class AssignCreditBalanceAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private AssignCreditBalanceAction() throws Exception {
            super("Button.Assign");
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.window.closeWindow(object);
            NameValuePair pair = (NameValuePair)TableHelper.getSelectedItem((DataObject)object);
            CreditBalancePK key = new CreditBalancePK();
            key.setCompanyId(CreditPanels.this.company.getId());
            key.setGLAccountId(pair.getName());
            CreditBalance creditBalance = CreditBalanceManagerFactory.getInstance(CreditPanels.this.dbData).findOrCreate(key);
            if (creditBalance.getDescription().trim().length() == 0) {
                creditBalance.setDescription(pair.getValue().trim());
            }
            new CreditBalanceBP(CreditPanels.this.company).handleBalanceIsDirty(creditBalance);
            String message = CreditBalanceBO.assign(creditBalance, CreditPanels.this.credit);
            if (message != null) {
                throw new UserMessageException(message);
            }
            CreditPanels.this.comboBoxState.setSelectedOptionValue("2");
            CreditPanels.this.refreshAmountsTable();
            CreditPanels.this.refreshCreditBalanceTable();
            return true;
        }
    }

    private class CreateActivationSchemeTransactionAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateActivationSchemeTransactionAction() {
            super("Button.Add");
            this.setDefault(true);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setTop("30");
            CreditPanels.this.window.setLabel("Title.CreateActivationSchemeTransaction");
            CreditPanels.this.fg3 = new FieldGroup("Label.Common");
            CreditPanels.this.assetTypeId.setValue();
            CreditPanels.this.assetTypeId.setMandatory(true);
            CreditPanels.this.fg3.add((Field)CreditPanels.this.assetTypeId);
            CreditPanels.this.transactionAmount.removeInvalidTag();
            CreditPanels.this.transactionAmount.setValue();
            CreditPanels.this.transactionAmount.setMandatory(true);
            CreditPanels.this.fg3.add((Field)CreditPanels.this.transactionAmount);
            CreditPanels.this.transactionDescription.setValue();
            CreditPanels.this.transactionDescription.setLength(50);
            CreditPanels.this.transactionDescription.setMaxLength(50);
            CreditPanels.this.fg3.setReadonly(false);
            CreditPanels.this.window.add(CreditPanels.this.fg3);
            CreditPanels.this.window.add((Action)new CreateActivationSchemeTransactionOKAction());
            object.addUIObject((UIObject)CreditPanels.this.window);
            object.getScreen().setHelpIdToNull();
            return true;
        }
    }

    private class CreateActivationSchemeTransactionContinuedOKAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateActivationSchemeTransactionContinuedOKAction() {
            super("Button.OK");
            this.setDefault(true);
            this.setValidationEnabled(true);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            String message = CreditPanels.this.validateValuation();
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return true;
            }
            CreditPanels.this.transactionDescription.setValue();
            AssetType assetType = (AssetType)AssetTypeBO.get(CreditPanels.this.credit.getDBData(), CreditPanels.this.credit.getCompanyId(), CreditPanels.this.assetTypeId.getValue())[0];
            if (assetType != null) {
                CreditPanels.this.transactionDescription.setValue(assetType.getDescription());
            }
            CreditPanels.this.totalEstimationTransaction = TotalEstimationTransactionBO.createTransaction(CreditPanels.this.credit, 102, CreditPanels.this.transactionDescription.getValue(), CreditPanels.this.transactionAmount.getBigDecimal(), CreditPanels.this.assetTypeId.getValue());
            TotalEstimationTransactionBO.createDetailTransaction(CreditPanels.this.totalEstimationTransaction, CreditPanels.this.credit);
            TotalEstimationTransactionBO.updateValuation(CreditPanels.this.totalEstimationTransaction, Integer.parseInt(CreditPanels.this.depreciationMethod.getValue()), CreditPanels.this.yearPercentageTableId.getValue(), CreditPanels.this.degressivePercentage.getBigDecimal(), CreditPanels.this.annuityInterestTableId.getValue(), CreditPanels.this.annuityPercentage.getBigDecimal(), Integer.parseInt(CreditPanels.this.startPeriodHandlingMethod.getValue()), CreditPanels.this.depreciatableLife.getIntValue(), CreditPanels.this.residualPercentage.getBigDecimal(), CreditPanels.this.residualValue.getBigDecimal(), Integer.parseInt(CreditPanels.this.apInterestCalculationMethod.getValue()), CreditPanels.this.apInterestTableId.getValue(), CreditPanels.this.numberOfPeriods, CreditPanels.this.apInterestPercentage.getBigDecimal());
            CreditPanels.this.window.closeWindow(object);
            CreditPanels.this.refreshActivationSchemeTable();
            return true;
        }
    }

    private class CreateActivationSchemeTransactionOKAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateActivationSchemeTransactionOKAction() {
            super("Button.Next");
            this.setDefault(true);
            this.setValidationEnabled(true);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.window.closeWindow(object);
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setTop("30");
            CreditPanels.this.window.setLabel("Title.CreateActivationSchemeTransaction_Valuation");
            CreditPanels.this.fg3.setReadonly();
            CreditPanels.this.window.add(CreditPanels.this.fg3);
            CreditPanels.this.initializeValuationForm();
            CreditPanels.this.getAccountingPrincipleDefaultFromType(CreditPanels.this.assetTypeId.getValue().trim());
            CreditPanels.this.depreciationMethodChangeAction.execute(object);
            CreditPanels.this.apInterestCalculationMethodChangeAction.execute(object);
            CreditPanels.this.window.add(CreditPanels.this.apPanel);
            FloatBar fb = new FloatBar();
            fb.addAction((Action)new CreateActivationSchemeTransactionContinuedOKAction());
            fb.addAction((Action)new CreateActivationSchemeTransactionPreviousAction());
            CreditPanels.this.window.add(fb);
            object.addUIObject((UIObject)CreditPanels.this.window);
            object.getScreen().setHelpIdToNull();
            return true;
        }
    }

    private class CreateActivationSchemeTransactionPreviousAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateActivationSchemeTransactionPreviousAction() {
            super("Button.Back");
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.window.closeWindow(object);
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setTop("30");
            CreditPanels.this.window.setLabel("Title.CreateActivationSchemeTransaction");
            CreditPanels.this.fg3.setReadonly(false);
            CreditPanels.this.window.add(CreditPanels.this.fg3);
            CreditPanels.this.window.add((Action)new CreateActivationSchemeTransactionOKAction());
            object.addUIObject((UIObject)CreditPanels.this.window);
            object.getScreen().setHelpIdToNull();
            return true;
        }
    }

    private class CreateCreditBalanceAssignmentAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateCreditBalanceAssignmentAction() {
            super("Button.Add");
            this.setDefault(true);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setLabel("Title.AssignToCostAccount");
            String bookYear = (String)object.getSessionAttribute("ActiveBookYear");
            CreditPanels.this.createCostAccountTable(bookYear);
            CreditPanels.this.window.add((Panel)CreditPanels.this.glAccountSearchPanel);
            CreditPanels.this.window.add((Table)CreditPanels.this.glAccountSelectionTable);
            object.addUIObject((UIObject)CreditPanels.this.window);
            return true;
        }
    }

    private class CreateDepreciationInterestTransactionAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateDepreciationInterestTransactionAction() {
            super("Button.AdditionalDepreciation");
            this.setDefault(true);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setLabel("Title.AdditionalDepreciationAndInterest");
            FieldGroup fg = new FieldGroup("");
            fg.forceBorder(true);
            CreditPanels.this.depreciation = new FACDecimalField("Label.AdditionalDepreciation", 15, 2);
            fg.add((Field)CreditPanels.this.depreciation);
            CreditPanels.this.interest = new FACDecimalField("Label.AdditionalInterest", 15, 2);
            fg.add((Field)CreditPanels.this.interest);
            CreditPanels.this.activationPeriod = new BookYearPeriodGrid("Label.FACStartPeriod", "" + CreditPanels.this.credit.getStartYear(), "" + CreditPanels.this.credit.getStartYear(), "" + CreditPanels.this.credit.getEndYear(), CreditPanels.this.numberOfPeriods);
            fg.add((ESPGridLayout)CreditPanels.this.activationPeriod);
            CreditPanels.this.financialBookPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
            fg.add((ESPGridLayout)CreditPanels.this.financialBookPeriod);
            CreditPanels.this.window.add(fg);
            fg = new FieldGroup("Label.Description");
            CreditPanels.this.adiDescription = new Field();
            CreditPanels.this.adiDescription.setDiscardLabel(true);
            CreditPanels.this.adiDescription.setLength(50);
            CreditPanels.this.adiDescription.setMaxLength(30);
            fg.add(CreditPanels.this.adiDescription);
            CreditPanels.this.window.add(fg);
            CreditPanels.this.window.add((Action)new CreateDepreciationInterestTransactionOKAction());
            object.addUIObject((UIObject)CreditPanels.this.window);
            object.getScreen().setHelpIdToNull();
            return true;
        }
    }

    private class CreateDepreciationInterestTransactionOKAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateDepreciationInterestTransactionOKAction() {
            super("Button.OK");
            this.setDefault(true);
            this.setValidationEnabled(true);
        }

        public boolean execute(DataObject object) throws Exception {
            String[] messages = null;
            boolean error = false;
            CreditPanels.this.activationPeriod.removeInvalidTags();
            CreditPanels.this.financialBookPeriod.removeInvalidTags();
            CreditPanels.this.depreciation.removeInvalidTag();
            CreditPanels.this.interest.removeInvalidTag();
            int facYear = CreditPanels.this.activationPeriod.getBookYear().getIntValue();
            int facPeriod = CreditPanels.this.activationPeriod.getPeriod().getIntValue();
            int finYear = CreditPanels.this.financialBookPeriod.getBookYear().getIntValue();
            int finPeriod = CreditPanels.this.financialBookPeriod.getPeriod().getIntValue();
            CreditAdditionalDepreciationBP businessProcess = new CreditAdditionalDepreciationBP(CreditPanels.this.company, CreditPanels.this.numberOfPeriods);
            messages = businessProcess.validateFACYearAndPeriod(CreditPanels.this.credit, facYear, facPeriod);
            if (messages != null) {
                error = true;
                this.addErrors(messages);
                CreditPanels.this.activationPeriod.setInvalidTag();
            }
            if ((messages = businessProcess.validateFINYearAndPeriod(finYear, finPeriod, CreditPanels.this.credit.getStartYear(), CreditPanels.this.credit.getEndYear())) != null) {
                error = true;
                this.addErrors(messages);
                CreditPanels.this.financialBookPeriod.setInvalidTag();
            }
            if ((messages = businessProcess.validateAmounts(CreditPanels.this.depreciation.getBigDecimal(), CreditPanels.this.interest.getBigDecimal())) != null) {
                error = true;
                this.addErrors(messages);
                CreditPanels.this.depreciation.setInvalidTag();
                CreditPanels.this.interest.setInvalidTag();
            }
            if (!error) {
                String message = businessProcess.createAdditionalDepreciation(CreditPanels.this.credit, facYear, facPeriod, finYear, finPeriod, CreditPanels.this.depreciation.getBigDecimal(), CreditPanels.this.interest.getBigDecimal(), CreditPanels.this.adiDescription.getValue(), CreditPanels.this.loginHelper.getUser());
                if (message != null) {
                    CreditPanels.this.window.add(new Message(message, "error"));
                    return true;
                }
                ODBTable oldTable = CreditPanels.this.deprInterestTable;
                CreditPanels.this.createDepreciationInterestTable();
                CreditPanels.this.subPanelTabDeprInterest.replaceUIObject((UIObject)oldTable, (UIObject)CreditPanels.this.deprInterestTable);
                CreditPanels.this.refreshAmountsTable();
                CreditPanels.this.window.closeWindow(object);
            }
            return true;
        }

        private void addErrors(String[] errors) throws Exception {
            int i = 0;
            while (i < errors.length) {
                if (errors[i] != null && errors[i].trim().length() > 0) {
                    CreditPanels.this.window.add(new Message(errors[i], "error"));
                }
                ++i;
            }
        }
    }

    private class CreateEstimationTransactionAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateEstimationTransactionAction() {
            super("Button.Add");
            this.setDefault(true);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setLabel("Title.CreateEstimationTransaction");
            FieldGroup fg = new FieldGroup("Label.Transaction");
            Field type = new Field("Label.Type");
            type.setValue(GovernmentEnumHelper.getValue(4, 1));
            type.setReadonly(true);
            fg.add(type);
            CreditPanels.this.newBBVCategory = EnumHelper.createComboBox("Label.BBVCategory", GovernmentEnumHelper.getCollection(5), false);
            fg.add(CreditPanels.this.newBBVCategory);
            CreditPanels.this.transactionDescription.setLength(50);
            CreditPanels.this.transactionDescription.setMaxLength(50);
            CreditPanels.this.transactionDescription.setReadonly(false);
            CreditPanels.this.transactionDescription.setValue();
            fg.add(CreditPanels.this.transactionDescription);
            CreditPanels.this.transactionAmount.removeInvalidTag();
            CreditPanels.this.transactionAmount.setMandatory(true);
            CreditPanels.this.transactionAmount.setReadonly(false);
            CreditPanels.this.transactionAmount.setValue();
            fg.add((Field)CreditPanels.this.transactionAmount);
            CreditPanels.this.window.add(fg);
            CreditPanels.this.window.add((Action)new CreateEstimationTransactionOKAction());
            object.addUIObject((UIObject)CreditPanels.this.window);
            object.getScreen().setHelpIdToNull();
            return true;
        }
    }

    private class CreateEstimationTransactionOKAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreateEstimationTransactionOKAction() {
            super("Button.OK");
            this.setDefault(true);
            this.setValidationEnabled(true);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.newEstimationTransaction = TotalEstimationTransactionBO.createTransaction(CreditPanels.this.credit, 1, CreditPanels.this.transactionDescription.getValue().trim(), CreditPanels.this.transactionAmount.getBigDecimal(), "");
            CreditPanels.this.newEstimationTransaction.setBBVCategory(Integer.parseInt(CreditPanels.this.newBBVCategory.getSelectedOptionValue()));
            TotalEstimationTransactionBO.createEstimationTransactions(CreditPanels.this.credit);
            CreditPanels.this.window.closeWindow(object);
            CreditPanels.this.refreshTotalEstimationTransactionTable();
            CreditPanels.this.refreshActivationSchemeTable();
            CreditPanels.this.refreshAmountsTable();
            if (CreditPanels.this.credit.getStartYear() != CreditPanels.this.credit.getEndYear()) {
                new EstimationTransactionRowAction().execute(object);
            }
            CreditPanels.this.newEstimationTransaction = null;
            CreditPanels.this.addWarningOnBehalfOfActivationScheme(object);
            return true;
        }
    }

    private class CreditBalanceAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private CreditBalanceAction() throws Exception {
            super("Button.Edit");
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.creditBalance = (CreditBalance)TableHelper.getSelectedItem((DataObject)object);
            new CreditBalanceBP(CreditPanels.this.company).handleBalanceIsDirty(CreditPanels.this.creditBalance);
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setLabel("Wijzigen rekeninggegevens");
            HeaderPanel panel = new HeaderPanel();
            ReferenceField mainAccount = new ReferenceField("Label.GLAccount");
            mainAccount.setReadonly(true);
            mainAccount.setLength(10);
            mainAccount.setDescriptionLength(50);
            mainAccount.setValue(CreditPanels.this.creditBalance.getGLAccountId());
            mainAccount.setDescription(CreditPanels.this.creditBalance.getDescription());
            panel.addUIObject((UIObject)mainAccount);
            FACDecimalField balance = new FACDecimalField("Label.Balance", 15, 2);
            balance.setNullable(false);
            balance.setValue(CreditPanels.this.creditBalance.getTotalBalanceAmount());
            balance.setReadonly(true);
            panel.addUIObject((UIObject)balance);
            FACDecimalField estOld = new FACDecimalField("(Deel)raming", 15, 2);
            estOld.setNullable(false);
            estOld.setValue(CreditPanels.this.creditBalance.getTotalEstimationAmount());
            estOld.setReadonly(true);
            panel.addUIObject((UIObject)estOld);
            FACDecimalField interest = new FACDecimalField("Label.Interest", 15, 2);
            interest.setNullable(false);
            interest.setValue(CreditPanels.this.creditBalance.getTotalInterestAmount());
            interest.setReadonly(true);
            panel.addUIObject((UIObject)interest);
            CreditPanels.this.window.add(panel);
            FieldGroup fg = new FieldGroup("");
            fg.forceBorder(true);
            CreditPanels.this.glAccountDescription.setLength(50);
            CreditPanels.this.glAccountDescription.setValue(CreditPanels.this.creditBalance.getDescription());
            CreditPanels.this.glAccountDescription.setReadonly(false);
            fg.add(CreditPanels.this.glAccountDescription);
            CreditPanels.this.estimationAmount.setValue(CreditPanels.this.creditBalance.getTotalEstimationAmount());
            CreditPanels.this.estimationAmount.setMandatory(true);
            CreditPanels.this.estimationAmount.setReadonly(false);
            CreditPanels.this.estimationAmount.removeInvalidTag();
            fg.add((Field)CreditPanels.this.estimationAmount);
            CreditPanels.this.window.add(fg);
            FloatBar fb = new FloatBar();
            fb.addAction((Action)new CreditBalanceOKAction());
            fb.addAction((Action)new CreditBalanceDeassignAction());
            CreditPanels.this.window.add(fb);
            object.addUIObject((UIObject)CreditPanels.this.window);
            return true;
        }
    }

    private class CreditBalanceDeassignAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreditBalanceDeassignAction() {
            super("Button.Delete");
        }

        public boolean execute(DataObject object) throws Exception {
            String message = CreditBalanceBO.deassign(CreditPanels.this.creditBalance, CreditPanels.this.credit);
            if (message != null) {
                throw new UserMessageException(message);
            }
            CreditPanels.this.refreshAmountsTable();
            CreditPanels.this.refreshCreditBalanceTable();
            CreditPanels.this.window.closeWindow(object);
            return true;
        }
    }

    private class CreditBalanceOKAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private CreditBalanceOKAction() {
            super("Button.OK");
            this.setDefault(true);
            this.setValidationEnabled(true);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.creditBalance.setDescription(CreditPanels.this.glAccountDescription.getValue());
            CreditPanels.this.creditBalance.setTotalEstimationAmount(CreditPanels.this.estimationAmount.getBigDecimal());
            CreditPanels.this.creditBalanceTable.reload();
            CreditPanels.this.window.closeWindow(object);
            return true;
        }
    }

    public class DepreciationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public boolean execute(DataObject dataObject) throws Exception {
            if (!CreditPanels.this.readOnly) {
                CreditPanels.this.startPeriodHandlingMethod.setReadonly(false);
                CreditPanels.this.apInterestCalculationMethod.setReadonly(false);
            }
            if ("99".equals(CreditPanels.this.depreciationMethod.getValue())) {
                CreditPanels.this.depreciatableLife.setMandatory(false);
            } else {
                CreditPanels.this.depreciatableLife.setMandatory(true);
            }
            if ("3".equals(CreditPanels.this.depreciationMethod.getValue())) {
                CreditPanels.this.yearPercentageTableId.setMandatory(true);
                CreditPanels.this.yearPercentageTableId.setHidden(false);
                CreditPanels.this.degressivePercentage.setMandatory(false);
                CreditPanels.this.degressivePercentage.setHidden(true);
                CreditPanels.this.degressivePercentage.setValue();
                CreditPanels.this.annuityPercentage.setMandatory(false);
                CreditPanels.this.annuityPercentage.setHidden(true);
                CreditPanels.this.annuityPercentage.setValue();
                CreditPanels.this.annuityInterestTableId.setHidden(true);
                CreditPanels.this.annuityInterestTableId.setValue();
                return true;
            }
            if ("12".equals(CreditPanels.this.depreciationMethod.getValue()) || "11".equals(CreditPanels.this.depreciationMethod.getValue())) {
                if (!CreditPanels.this.readOnly) {
                    CreditPanels.this.startPeriodHandlingMethod.setSelectedOptionValue("1");
                    CreditPanels.this.startPeriodHandlingMethod.setReadonly(true);
                    CreditPanels.this.apInterestCalculationMethod.setSelectedOptionValue("0");
                    CreditPanels.this.apInterestCalculationMethod.setReadonly(true);
                    CreditPanels.this.apInterestCalculationMethodChangeAction.execute(null);
                }
                CreditPanels.this.yearPercentageTableId.setMandatory(false);
                CreditPanels.this.yearPercentageTableId.setHidden(true);
                CreditPanels.this.yearPercentageTableId.setValue();
                CreditPanels.this.degressivePercentage.setMandatory(false);
                CreditPanels.this.degressivePercentage.setHidden(true);
                CreditPanels.this.degressivePercentage.setValue();
                CreditPanels.this.annuityPercentage.setHidden(false);
                CreditPanels.this.annuityInterestTableId.setHidden(false);
                return true;
            }
            if ("2".equals(CreditPanels.this.depreciationMethod.getValue())) {
                CreditPanels.this.yearPercentageTableId.setMandatory(false);
                CreditPanels.this.yearPercentageTableId.setHidden(true);
                CreditPanels.this.yearPercentageTableId.setValue();
                CreditPanels.this.degressivePercentage.setMandatory(true);
                CreditPanels.this.degressivePercentage.setHidden(false);
                CreditPanels.this.annuityPercentage.setMandatory(false);
                CreditPanels.this.annuityPercentage.setHidden(true);
                CreditPanels.this.annuityPercentage.setValue();
                CreditPanels.this.annuityInterestTableId.setHidden(true);
                CreditPanels.this.annuityInterestTableId.setValue();
                return true;
            }
            CreditPanels.this.yearPercentageTableId.setMandatory(false);
            CreditPanels.this.yearPercentageTableId.setHidden(true);
            CreditPanels.this.yearPercentageTableId.setValue();
            CreditPanels.this.degressivePercentage.setMandatory(false);
            CreditPanels.this.degressivePercentage.setHidden(true);
            CreditPanels.this.degressivePercentage.setValue();
            CreditPanels.this.annuityPercentage.setMandatory(false);
            CreditPanels.this.annuityPercentage.setHidden(true);
            CreditPanels.this.annuityPercentage.setValue();
            CreditPanels.this.annuityInterestTableId.setHidden(true);
            CreditPanels.this.annuityInterestTableId.setValue();
            return true;
        }
    }

    private class DepreciationMethodTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;

        private DepreciationMethodTransformer() {
        }

        public Object transform(Object object) {
            return DepreciationMethodEnum.getValue((Integer)object);
        }
    }

    private class DetailIFTAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private DetailIFTAction() throws Exception {
            super(CreditPanels.this.detailIFT.getLanguageCode());
            this.setAdapter(CreditPanels.this.detailIFT.getPageid());
            this.setMethod(CreditPanels.this.detailIFT.getMethod());
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
            CreditPanels.this.process.setAttribute("IncomingFinancialTransaction", (Object)CreditPanels.this.incomingFinancialTransaction);
            return false;
        }
    }

    private class EstimationCollectionTable
    extends CollectionTable {
        private static final long serialVersionUID = 1L;

        public EstimationCollectionTable(Class<DetailEstimationTransaction> clss, Collection<?> collection, int size) throws Exception {
            super(clss, collection, size);
        }

        protected void postprocesCreatedRow(TableRow row) throws Exception {
            if (!CreditPanels.this.readOnly) {
                Field field = (Field)row.getUIObjects().get(1);
                FACDecimalField newField = new FACDecimalField(null, 15, 2);
                newField.setValue(new BigDecimal(field.getValue()));
                row.replaceUIObject((UIObject)field, (UIObject)newField);
            }
        }
    }

    private class EstimationDeleteAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private EstimationDeleteAction() {
            super("Button.Delete");
        }

        public boolean execute(DataObject object) throws Exception {
            TotalEstimationTransactionBO.delete(CreditPanels.this.totalEstimationTransaction);
            CreditPanels.this.refreshTotalEstimationTransactionTable();
            CreditPanels.this.refreshActivationSchemeTable();
            CreditPanels.this.refreshAmountsTable();
            CreditPanels.this.window.closeWindow(object);
            CreditPanels.this.addWarningOnBehalfOfActivationScheme(object);
            return true;
        }
    }

    private class EstimationOKAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private EstimationOKAction() {
            super("Button.OK");
            this.setDefault(true);
            this.setValidationEnabled(true);
        }

        public boolean execute(DataObject object) throws Exception {
            if (CreditPanels.this.credit.getStartYear() != CreditPanels.this.credit.getEndYear()) {
                CreditPanels.this.validateEstimations();
                CreditPanels.this.saveEstimations();
            }
            TotalEstimationTransactionBO.changeEstimationTransaction(CreditPanels.this.credit, CreditPanels.this.totalEstimationTransaction, CreditPanels.this.transactionAmount.getBigDecimal(), CreditPanels.this.transactionDescription.getValue().trim(), Integer.parseInt(CreditPanels.this.newBBVCategory.getSelectedOptionValue()));
            CreditPanels.this.refreshAmountsTable();
            CreditPanels.this.estimationTable.reload();
            CreditPanels.this.refreshActivationSchemeTable();
            CreditPanels.this.window.closeWindow(object);
            CreditPanels.this.addWarningOnBehalfOfActivationScheme(object);
            return true;
        }
    }

    private class EstimationTransactionMemoAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private EstimationTransactionMemoAction() throws Exception {
            super(CreditPanels.this.memoAction.getLanguageCode());
            this.setAdapter(CreditPanels.this.memoAction.getPageid());
            this.setMethod(CreditPanels.this.memoAction.getMethod());
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.process.setAttribute("Table", (Object)CreditPanels.this.estimationTable);
            return false;
        }
    }

    private class EstimationTransactionRowAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private EstimationTransactionRowAction() throws Exception {
            super("Button.Edit");
            if (CreditPanels.this.readOnly) {
                this.setLabel("Button.Details");
            }
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            if (CreditPanels.this.newEstimationTransaction != null) {
                CreditPanels.this.totalEstimationTransaction = CreditPanels.this.newEstimationTransaction;
                CreditPanels.this.newEstimationTransaction = null;
            } else {
                CreditPanels.this.totalEstimationTransaction = (TotalEstimationTransaction)TableHelper.getSelectedItem((DataObject)object);
            }
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setLabel("Title.EditEstimationTransaction");
            if (CreditPanels.this.readOnly) {
                CreditPanels.this.window.setLabel("Title.ShowEstimationTransaction");
            }
            FieldGroup fg = new FieldGroup("Label.Transaction");
            Field type = new Field("Label.Type");
            type.setValue(GovernmentEnumHelper.getValue(4, CreditPanels.this.totalEstimationTransaction.getEstimationTransactionType()));
            type.setReadonly(true);
            fg.add(type);
            CreditPanels.this.newBBVCategory = EnumHelper.createComboBox("Label.BBVCategory", GovernmentEnumHelper.getCollection(5), false);
            CreditPanels.this.newBBVCategory.setValueAsString("" + CreditPanels.this.totalEstimationTransaction.getBBVCategory());
            CreditPanels.this.newBBVCategory.setReadonly(CreditPanels.this.totalEstimationTransaction.getEstimationTransactionType() == 0);
            fg.add(CreditPanels.this.newBBVCategory);
            CreditPanels.this.transactionDescription.setValue(CreditPanels.this.totalEstimationTransaction.getDescription());
            CreditPanels.this.transactionDescription.setLength(50);
            CreditPanels.this.transactionDescription.setMaxLength(50);
            CreditPanels.this.transactionDescription.setReadonly(false);
            fg.add(CreditPanels.this.transactionDescription);
            CreditPanels.this.transactionAmount.setValue(CreditPanels.this.totalEstimationTransaction.getTotalTransactionAmount());
            CreditPanels.this.transactionAmount.removeInvalidTag();
            CreditPanels.this.transactionAmount.setMandatory(true);
            CreditPanels.this.transactionAmount.setReadonly(false);
            fg.add((Field)CreditPanels.this.transactionAmount);
            CreditPanels.this.window.add(fg);
            if (CreditPanels.this.credit.getStartYear() != CreditPanels.this.credit.getEndYear()) {
                CreditPanels.this.createEstimationTable();
                CreditPanels.this.window.add((Table)CreditPanels.this.estimationYearsTable);
            }
            if (CreditPanels.this.readOnly) {
                CreditPanels.this.window.setReadonly(true);
            } else {
                FloatBar fb = new FloatBar();
                fb.addAction((Action)new EstimationOKAction());
                if (CreditPanels.this.totalEstimationTransaction.getEstimationTransactionType() != 0) {
                    fb.addAction((Action)new EstimationDeleteAction());
                }
                CreditPanels.this.window.add(fb);
            }
            object.addUIObject((UIObject)CreditPanels.this.window);
            object.getScreen().setHelpIdToNull();
            return true;
        }
    }

    private class IFTAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private IFTAction() throws Exception {
            super("Button.Edit");
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setTop("10%");
            CreditPanels.this.window.setRight("15%");
            CreditPanels.this.window.setLabel("Title.ChangeBBVCategory");
            CreditPanels.this.window.add(CreditPanels.this.getIFTHeader());
            FieldGroup fg = new FieldGroup("Label.BBVCategory");
            CreditPanels.this.oldBBVCategory = EnumHelper.createComboBox("Label.Current", GovernmentEnumHelper.getCollection(5), false);
            CreditPanels.this.oldBBVCategory.setSelectedOptionValue("" + CreditPanels.this.incomingFinancialTransaction.getBBVCategory());
            CreditPanels.this.oldBBVCategory.setReadonly(true);
            fg.add(CreditPanels.this.oldBBVCategory);
            CreditPanels.this.newBBVCategory = EnumHelper.createComboBox("Label.New", GovernmentEnumHelper.getCollection(5), false);
            fg.add(CreditPanels.this.newBBVCategory);
            CreditPanels.this.window.add(fg);
            FloatBar fb = new FloatBar();
            fb.addAction((Action)new IFTOKAction());
            CreditPanels.this.window.add(fb);
            object.addUIObject((UIObject)CreditPanels.this.window);
            object.getScreen().setHelpIdToNull();
            return true;
        }
    }

    private class IFTOKAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private IFTOKAction() throws Exception {
            super("Button.OK");
        }

        public boolean execute(DataObject object) throws Exception {
            if (CreditPanels.this.oldBBVCategory.getSelectedOptionValue().equals(CreditPanels.this.newBBVCategory.getSelectedOptionValue())) {
                CreditPanels.this.window.closeWindow(object);
                return true;
            }
            String message = IncomingFinancialTransactionBP.changeBBVCategory(CreditPanels.this.incomingFinancialTransaction, Integer.parseInt(CreditPanels.this.newBBVCategory.getSelectedOptionValue()));
            if (message != null) {
                CreditPanels.this.window.add(new Message(message, "error"));
            } else {
                CreditPanels.this.iftTable.reloadPage();
                CreditPanels.this.window.closeWindow(object);
            }
            return true;
        }
    }

    private class IFTTableAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private IFTTableAction() throws Exception {
            super("Button.Transactions");
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            CreditPanels.this.creditBalance = (CreditBalance)TableHelper.getSelectedItem((DataObject)object);
            new CreditBalanceBP(CreditPanels.this.company).handleBalanceIsDirty(CreditPanels.this.creditBalance);
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setLabel("Label.FinancialTransactions");
            HeaderPanel panel = new HeaderPanel();
            ReferenceField mainAccount = new ReferenceField("Label.GLAccount");
            mainAccount.setReadonly(true);
            mainAccount.setLength(10);
            mainAccount.setDescriptionLength(50);
            mainAccount.setValue(CreditPanels.this.creditBalance.getGLAccountId());
            mainAccount.setDescription(CreditPanels.this.creditBalance.getDescription());
            panel.addUIObject((UIObject)mainAccount);
            CreditPanels.this.window.add(panel);
            CreditPanels.this.createIncomingFinancialTransactionTable();
            CreditPanels.this.window.add((Panel)CreditPanels.this.iftSearchPanel);
            CreditPanels.this.window.add((Table)CreditPanels.this.iftTable);
            object.addUIObject((UIObject)CreditPanels.this.window);
            return true;
        }
    }

    private class InterestCalculationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        private InterestCalculationMethodChangeAction() {
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(CreditPanels.this.interestCalculationMethod.getValue())) {
                CreditPanels.this.interestTableId.setHidden(true);
                CreditPanels.this.interestTableId.setValue();
                CreditPanels.this.interestPercentage.setHidden(true);
                CreditPanels.this.interestPercentage.setValue();
                return true;
            }
            CreditPanels.this.interestTableId.setHidden(false);
            CreditPanels.this.interestPercentage.setHidden(false);
            return true;
        }
    }

    private class MainTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 1L;

        private MainTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            String message;
            if (CreditPanels.this.readOnly) {
                return super.execute(object);
            }
            object.removeMessages();
            if ("Label.Common".equals(CreditPanels.this.mainTabPanel.getActiveTabName()) && (message = CreditPanels.this.validateCommonForm()) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                CreditPanels.this.mainTabPanel.setActiveTabByName("Label.Common");
                return true;
            }
            if ("Label.Dimensions".equals(CreditPanels.this.mainTabPanel.getActiveTabName())) {
                CreditPanels.this.validateDimensionForm();
            }
            return super.execute(object);
        }
    }

    private class ResultAccountItemListener
    implements EventListener {
        private static final long serialVersionUID = 1L;

        private ResultAccountItemListener() {
        }

        public void event(UIObject object, String eventType) throws Exception {
            if (((CheckBox)object).isChecked()) {
                CreditPanels.this.type.setValue();
                CreditPanels.this.type.setHidden(true);
                CreditPanels.this.type.setMandatory(false);
                if (CreditPanels.this.activationsTab != null) {
                    CreditPanels.this.activationsTab.setHidden(true);
                }
            } else {
                CreditPanels.this.type.setHidden(false);
                CreditPanels.this.type.setMandatory(true);
                if (CreditPanels.this.activationsTab != null) {
                    CreditPanels.this.activationsTab.setHidden(false);
                }
            }
        }
    }

    private class SingleAccountMultipleYearsAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private SingleAccountMultipleYearsAction() throws Exception {
            super("Uitsplitsing op boekjaar");
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            if (CreditPanels.this.credit.getEndYear() <= CreditPanels.this.credit.getStartYear()) {
                object.addUIObject((UIObject)new Message("Uitsplitsing alleen mogelijk indien de looptijd van het krediet > 1 jaar", "error"));
                return true;
            }
            CreditPanels.this.creditBalance = (CreditBalance)TableHelper.getSelectedItem((DataObject)object);
            new CreditBalanceBP(CreditPanels.this.company).handleBalanceIsDirty(CreditPanels.this.creditBalance);
            CreditPanels.this.window = new Window();
            CreditPanels.this.window.setLabel("Uitsplitsing op boekjaar");
            HeaderPanel panel = new HeaderPanel();
            ReferenceField mainAccount = new ReferenceField("Label.GLAccount");
            mainAccount.setReadonly(true);
            mainAccount.setLength(10);
            mainAccount.setDescriptionLength(50);
            mainAccount.setValue(CreditPanels.this.creditBalance.getGLAccountId());
            mainAccount.setDescription(CreditPanels.this.creditBalance.getDescription());
            panel.addUIObject((UIObject)mainAccount);
            FACDecimalField balance = new FACDecimalField("Label.Balance", 15, 2);
            balance.setNullable(false);
            balance.setValue(CreditPanels.this.creditBalance.getTotalBalanceAmount());
            balance.setReadonly(true);
            panel.addUIObject((UIObject)balance);
            FACDecimalField estOld = new FACDecimalField("(Deel)raming", 15, 2);
            estOld.setNullable(false);
            estOld.setValue(CreditPanels.this.creditBalance.getTotalEstimationAmount());
            estOld.setReadonly(true);
            panel.addUIObject((UIObject)estOld);
            FACDecimalField interest = new FACDecimalField("Label.Interest", 15, 2);
            interest.setNullable(false);
            interest.setValue(CreditPanels.this.creditBalance.getTotalInterestAmount());
            interest.setReadonly(true);
            panel.addUIObject((UIObject)interest);
            CreditPanels.this.window.add(panel);
            CreditPanels.this.createRow4ZoomTable(CreditPanels.this.creditBalance);
            CreditPanels.this.window.add((Table)CreditPanels.this.singleAccountMultipleYearsTable);
            object.addUIObject((UIObject)CreditPanels.this.window);
            return true;
        }
    }

    private class TransactionDetailAction
    extends ContextAction {
        private static final long serialVersionUID = 1L;

        private TransactionDetailAction() throws Exception {
            super(CreditPanels.this.transactionDetails.getLanguageCode());
            this.setAdapter(CreditPanels.this.transactionDetails.getPageid());
            this.setMethod(CreditPanels.this.transactionDetails.getMethod());
            this.setContextTarget(1);
        }

        public boolean execute(DataObject object) throws Exception {
            return super.execute(object);
        }
    }

    private class TypeListener
    implements EventListener {
        private static final long serialVersionUID = 1L;

        private TypeListener() {
        }

        public void event(UIObject object, String eventType) throws Exception {
            Object[] result = AssetTypeBO.get(CreditPanels.this.dbData, CreditPanels.this.companyId, ((ReferenceField)object).getValue().trim());
            AssetType assetType = (AssetType)result[0];
            if (assetType == null) {
                ((ReferenceField)object).setDescription("");
                return;
            }
            ((ReferenceField)object).setDescription(assetType.getDescription());
        }
    }
}

