/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.adapters.BookYearField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ReasonCodeImageTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.gov.bp.CreditDepreciationBP;

public class CreditProofDepreciationAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 1208415112128662271L;
    public static final String PAGE = CreditProofDepreciationAdapter.class.getName();
    public static final String CREDIT = "credit";
    private Company company;
    private Credit credit;
    private CreditDepreciationBP creditDepreciationBP;
    private Window window = new Window();
    private ReferenceField field;
    private BookYearField startYear;
    private BookYearField endYear;
    private BookYearField calcYear;
    private Action ok;
    private static final String[] NAMES = new String[]{"year", "bookValue", "previousBookvalueBalance", "depreciationAmount", "bookValueAfterDepreciation", "totalDepreciationAmount", "interestAmount", "reasonCode", "assetTypeId"};
    private static final String[] LABELS = new String[]{"Label.Year", "Label.BookValueBegin", "Mutaties", "Label.DepreciationAmount.short", "Label.BookValueEnd", "Label.TotalDepreciationAmount.short", "Label.InterestAmount", "Label.ReasonCode", "Label.AssetType"};
    private static final String[] TOOLTIPS = new String[]{"Label.ReasonCode"};
    private static final short[] SIZES = new short[]{50, 100, 100, 100, 100, 100, 100, 20, 90};
    private static final ZeroIntegerToBlankTransformer INTEGERTRANSFORMER = new ZeroIntegerToBlankTransformer();
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private Transformer[] transformers;
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true};
    private CollectionTable table;
    private FieldGroup tableFG;

    public CreditProofDepreciationAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        Transformer[] transformerArray = new Transformer[9];
        transformerArray[0] = INTEGERTRANSFORMER;
        transformerArray[1] = DECIMALTRANSFORMER;
        transformerArray[2] = DECIMALTRANSFORMER;
        transformerArray[3] = DECIMALTRANSFORMER;
        transformerArray[4] = DECIMALTRANSFORMER;
        transformerArray[5] = DECIMALTRANSFORMER;
        transformerArray[6] = DECIMALTRANSFORMER;
        transformerArray[7] = new ReasonCodeImageTransformer();
        this.transformers = transformerArray;
        this.table = null;
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.creditDepreciationBP = new CreditDepreciationBP(this.company, this.numberOfPeriods);
        this.window.setWidth(800);
        this.window.setTop("8%");
        this.window.setRight("15%");
        FieldGroup fieldGroup = new FieldGroup();
        fieldGroup.forceBorder(true);
        this.field = new ReferenceField("Label.Credit");
        this.field.setLength(10);
        this.field.setDescriptionLength(50);
        this.field.setReadonly(true);
        fieldGroup.add((Field)this.field);
        this.startYear = new BookYearField("Label.StartYear", "", null, null);
        this.startYear.setReadonly(true);
        fieldGroup.add((Field)this.startYear);
        this.endYear = new BookYearField("Label.EndYear", "", null, null);
        this.endYear.setReadonly(true);
        fieldGroup.add((Field)this.endYear);
        this.calcYear = new BookYearField("Label.CalculateUntilIncluding", "", null, null);
        this.calcYear.setReadonly(true);
        fieldGroup.add((Field)this.calcYear);
        this.window.add(fieldGroup);
        this.ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("calculate");
        this.ok.setValidationEnabled(true);
        this.ok.setDefault(true);
        this.window.add(this.ok);
    }

    public DataObject show(DataObject object) throws Exception {
        this.credit = (Credit)this.getProcess().getAttribute(CREDIT);
        this.window.setLabel(object.translate("Kapitaallasten", object.getLocale()));
        this.field.setValue(this.credit.getId());
        this.field.setDescription(this.credit.getDescription());
        this.startYear.setValue(this.credit.getStartYear());
        this.endYear.setValue(this.credit.getEndYear());
        if (this.credit.getIsResultAccountItem()) {
            this.calcYear.setValue(this.credit.getEndYear());
            this.calcYear.setMandatory(false);
            this.calcYear.setReadonly(true);
        } else {
            this.calcYear.setValue(this.credit.getEndYear() + 1);
            this.calcYear.setMinValue(this.calcYear.getLongValue(), true);
            this.calcYear.setMaxValue(this.calcYear.getLongValue() + 9L, true);
            this.calcYear.setMandatory(true);
            this.calcYear.setReadonly(false);
        }
        if (this.table != null) {
            this.window.removeUIObject((UIObject)this.tableFG, false);
            this.table = null;
        }
        object.addUIObject((UIObject)this.window);
        this.window.removeUIObjects(Message.class, false);
        return object;
    }

    public DataObject calculate(DataObject object) throws Exception {
        String message;
        if (this.table != null) {
            this.window.removeUIObject((UIObject)this.tableFG, false);
        }
        if ((message = this.creditDepreciationBP.proofDepreciate(this.credit, Integer.parseInt(this.calcYear.getValue()), true)) != null) {
            this.window.add(new Message(message, "error"));
            return object;
        }
        this.createTable();
        this.tableFG = new FieldGroup("");
        this.tableFG.add((Table)this.table);
        this.window.add(this.tableFG);
        return object;
    }

    private void createTable() throws Exception {
        ArrayList collection = (ArrayList)this.creditDepreciationBP.getAllCalculationValues();
        this.table = new CollectionTable(CalculationValue.class, (Collection)collection, this.numberOfPeriods);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(this.transformers);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setSortable(false);
        this.table.setSelectable(false);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }
}

