/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.AdditionalJournalingDataBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.AdditionalJournalingData;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.util.NameValuePair;

public class ExtendedAdditionalJournalingDataAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -7950678473766631945L;
    public static final String PAGE = ExtendedAdditionalJournalingDataAdapter.class.getName();
    private Company company;
    private AssetType assetType;
    private FieldGroup theFieldGroup;
    private Action backAction;
    private Action editOKAction;
    private FinancialReferenceField[] theMainAccounts = new FinancialReferenceField[9];
    private FinancialReferenceField[] mainAccounts = new FinancialReferenceField[9];
    private FinancialReferenceField[] costCentres = new FinancialReferenceField[9];
    private FinancialReferenceField[] costUnits = new FinancialReferenceField[9];
    private FinancialReferenceField[] activities = new FinancialReferenceField[9];
    private FinancialReferenceField[] achievements = new FinancialReferenceField[9];
    private int jteLength = 0;
    private Window window;
    private int accountingPrinciple = 1;
    private boolean info = false;

    public ExtendedAdditionalJournalingDataAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        if (!this.governmentActivated) {
            return;
        }
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.theFieldGroup = new FieldGroup("");
        this.theFieldGroup.forceBorder(true);
        ESPGridLayout grid = new ESPGridLayout();
        this.theFieldGroup.add(grid);
        grid.setColumnWidths(new short[]{200, 300, 100, 100, 100, 100});
        grid.add((UIObject)new Label("Label.MainAccount"), 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        grid.add((UIObject)new Label(this.env.getShortName1()), 0, 2, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        grid.add((UIObject)new Label(this.env.getShortName2()), 0, 3, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        grid.add((UIObject)new Label(this.env.getShortName3()), 0, 4, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        grid.add((UIObject)new Label(this.env.getShortName4()), 0, 5, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        Object[] jte = JournalingsTermEnum.getCollection().toArray();
        if (this.env.getOperationArea().length() > 0) {
            this.jteLength = jte.length;
            int j = 0;
            while (j < this.jteLength - 1) {
                if (j != 9 && j != 10) {
                    NameValuePair pair = (NameValuePair)jte[j];
                    this.mainAccounts[j] = new FMSReferenceField(this.loginHelper, pair.getValue(), 0, true);
                    this.mainAccounts[j].setDiscardLabel(true);
                    this.mainAccounts[j].setReadonly(true);
                    this.costCentres[j] = new FMSReferenceField(this.loginHelper, pair.getValue(), 1, true);
                    this.costCentres[j].setDiscardLabel(true);
                    this.costCentres[j].showDescription(false);
                    this.costCentres[j].setReadonly(false);
                    this.costUnits[j] = new FMSReferenceField(this.loginHelper, pair.getValue(), 2, true);
                    this.costUnits[j].setDiscardLabel(true);
                    this.costUnits[j].showDescription(false);
                    this.costUnits[j].setReadonly(false);
                    this.activities[j] = new FMSReferenceField(this.loginHelper, pair.getValue(), 3, true);
                    this.activities[j].setDiscardLabel(true);
                    this.activities[j].showDescription(false);
                    this.activities[j].setReadonly(false);
                    this.achievements[j] = new FMSReferenceField(this.loginHelper, pair.getValue(), 4, true);
                    this.achievements[j].setDiscardLabel(true);
                    this.achievements[j].showDescription(false);
                    this.achievements[j].setReadonly(false);
                    grid.add((UIObject)new Label(pair.getValue()), j + 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                    grid.add((UIObject)this.mainAccounts[j], j + 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                    grid.add((UIObject)this.costCentres[j], j + 1, 2, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                    grid.add((UIObject)this.costUnits[j], j + 1, 3, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                    grid.add((UIObject)this.activities[j], j + 1, 4, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                    grid.add((UIObject)this.achievements[j], j + 1, 5, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                }
                ++j;
            }
        }
        this.backAction = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close");
        this.backAction.setDefault(true);
        this.editOKAction = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
    }

    public DataObject showInfoWindow(DataObject object) throws Exception {
        this.info = true;
        int j = 0;
        while (j < this.jteLength - 1) {
            if (j != 9 && j != 10) {
                this.costCentres[j].setReadonly(true);
                this.costUnits[j].setReadonly(true);
                this.activities[j].setReadonly(true);
                this.achievements[j].setReadonly(true);
            }
            ++j;
        }
        object = this.show(object);
        return object;
    }

    public DataObject show(DataObject object) throws Exception {
        this.assetType = (AssetType)this.getProcess().getAttribute("assetType");
        this.accountingPrinciple = Integer.parseInt((String)this.getProcess().getAttribute("accountingPrinciple"));
        this.theMainAccounts = (FinancialReferenceField[])this.getProcess().getAttribute("mainAccounts");
        this.setValues();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setWidth(920);
        this.window.setTop("20%");
        this.window.setRight("25%");
        this.window.setLabel("Title.AdditionalJournalingData");
        this.window.add(this.theFieldGroup);
        if (!this.info) {
            FloatBar floatBar = new FloatBar();
            floatBar.addAction(this.backAction);
            floatBar.addAction(this.editOKAction);
            this.window.add(floatBar);
        }
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = AdditionalJournalingDataBO.handleMassUpdate(this.dbData, this.company, this.assetType.getId(), this.accountingPrinciple, this.costCentres, this.costUnits, this.activities, this.achievements);
        if (message != null) {
            this.window.add(new Message(message, "error"));
            return object;
        }
        return this.close(object);
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        return object;
    }

    private void setValues() throws Exception {
        int processCode = 0;
        int index = 0;
        while (index < 8) {
            this.mainAccounts[index].setValue();
            this.costCentres[index].setValue();
            this.costUnits[index].setValue();
            this.activities[index].setValue();
            this.achievements[index].setValue();
            int journalingTerm = (index + 1) * 10;
            String value = this.theMainAccounts[index].getValue();
            if (value != null && value.length() > 0) {
                this.theMainAccounts[index].validate();
                value = this.theMainAccounts[index].getFormattedId();
                this.mainAccounts[index].setValue(value);
            } else {
                this.mainAccounts[index].setValue();
            }
            Object[] objects = AdditionalJournalingDataBO.get(this.dbData, this.companyId, this.assetType.getId(), this.accountingPrinciple, journalingTerm, processCode);
            if (objects[0] != null) {
                AdditionalJournalingData ajd = (AdditionalJournalingData)objects[0];
                this.costCentres[index].setValue(ajd.getFixedDimension1());
                this.costUnits[index].setValue(ajd.getFixedDimension2());
                this.activities[index].setValue(ajd.getFixedDimension3());
                this.achievements[index].setValue(ajd.getFixedDimension4());
            }
            ++index;
        }
    }
}

