/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import java.util.Collection;
import java.util.Iterator;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Option;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.AdditionalJournalingDataBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.gov.adapters.ExtendedAdditionalJournalingDataAdapter;
import nl.ibs.fac.queries.ValuationMainAccountQuery;
import nl.ibs.util.NameValuePair;

public class ValuationMainAccountAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 7773334108239665281L;
    public static final String PAGE = ValuationMainAccountAdapter.class.getName();
    public static final String RETURNPAGE = "ValuationMainAccountAdapterReturnPage";
    public static final String RETURNMETHOD = "ValuationMainAccountAdapterReturnMethod";
    private Company company;
    private FieldGroup mainPanel;
    private FloatBar fbMain = new FloatBar();
    private Action backAction;
    private Action addAction;
    private Action editAction;
    private Action deleteAction;
    private Action backToMainAction;
    private Action addOKAction;
    private Action editOKAction;
    private Action deleteOKAction;
    private FieldGroup fgMainAccounts;
    private ComboBox schemes;
    private BookYearPeriodGrid validFrom;
    private FinancialReferenceField[] mainAccounts = new FinancialReferenceField[9];
    private int jteLength = 0;
    private ValuationMainAccount vmas;
    private Window window;
    private int accountingPrinciple = 1;
    private String cora;
    private String typeId;
    private Credit credit;
    private Asset asset;
    private String id;
    private boolean info;
    private Object[] jte;

    public ValuationMainAccountAdapter(ESPProcess process, DataObject object, String cora) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.cora = cora;
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.mainPanel = new FieldGroup("Label.Common");
        this.schemes = new ComboBox("Label.ValidFrom");
        this.schemes.add((Action)new ComboBoxChangeAction());
        this.schemes.setWidth("100");
        this.mainPanel.add(this.schemes);
        this.validFrom = new BookYearPeriodGrid("Label.ValidFrom", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.mainPanel.add((ESPGridLayout)this.validFrom);
        if (this.env.getOperationArea().length() > 0) {
            this.initializeJournalingTermForm();
        }
        this.backAction = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeWindow");
        this.backAction.setDefault(true);
        this.addAction = new Action("Button.Add").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm");
        this.editAction = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("editForm");
        this.deleteAction = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("deleteForm");
        this.addOKAction = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
        this.editOKAction = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        this.deleteOKAction = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete");
        this.backToMainAction = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showForm");
    }

    private void initializeJournalingTermForm() throws Exception {
        this.fgMainAccounts = new FieldGroup("Label.MainAccounts");
        this.jte = JournalingsTermEnum.getCollection().toArray();
        this.jteLength = this.jte.length;
        int j = 0;
        while (j < this.jteLength) {
            if (j != 9 && j != 10) {
                NameValuePair pair = (NameValuePair)this.jte[j];
                this.mainAccounts[j] = new FMSReferenceField(this.loginHelper, pair.getValue(), 0, true);
                this.fgMainAccounts.add((Field)this.mainAccounts[j]);
            }
            ++j;
        }
    }

    public DataObject showInfoWindow(DataObject object) throws Exception {
        this.info = true;
        object = this.show(object);
        return object;
    }

    public DataObject show(DataObject object) throws Exception {
        if ("C".equals(this.cora)) {
            this.credit = (Credit)this.getProcess().getAttribute("credit");
            this.id = this.credit.getId();
            this.accountingPrinciple = 3;
            this.asset = null;
            this.mainAccounts[0].setHidden(true);
            this.mainAccounts[4].setHidden(true);
            this.mainAccounts[5].setHidden(true);
            this.mainAccounts[8].setHidden(true);
            NameValuePair pair = (NameValuePair)this.jte[0];
            this.mainAccounts[0].setLabel(pair.getValue());
            pair = (NameValuePair)this.jte[1];
            this.mainAccounts[1].setLabel(pair.getValue());
            this.mainAccounts[2].setHidden(false);
        } else {
            this.asset = (Asset)this.getProcess().getAttribute("asset");
            this.id = this.asset.getId();
            this.accountingPrinciple = 1;
            this.credit = null;
            this.mainAccounts[0].setHidden(false);
            this.mainAccounts[4].setHidden(false);
            this.mainAccounts[5].setHidden(false);
            this.mainAccounts[8].setHidden(true);
            if (this.asset.getLoan()) {
                this.mainAccounts[0].setLabel("Label.LoanAmount");
                this.mainAccounts[1].setLabel("Label.PayOffs");
                this.mainAccounts[2].setHidden(true);
            } else {
                NameValuePair pair = (NameValuePair)this.jte[0];
                this.mainAccounts[0].setLabel(pair.getValue());
                pair = (NameValuePair)this.jte[1];
                this.mainAccounts[1].setLabel(pair.getValue());
                this.mainAccounts[2].setHidden(false);
            }
        }
        return this.showPanel(object);
    }

    public DataObject showPanel(DataObject object) throws Exception {
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "closeWindow");
        this.window.setWidth(600);
        this.window.setLabel("Label.MainAccountSchemeData");
        this.window.add(this.mainPanel);
        this.window.add(this.fgMainAccounts);
        if (!this.info) {
            this.window.add(this.fbMain);
        } else {
            this.typeId = this.asset == null ? this.credit.getProFormaTypeId() : this.asset.getTypeId();
            if (this.typeId != null && this.typeId.trim().length() > 0) {
                Collection typeIds = AdditionalJournalingDataBO.retrieveAdditionalJournalingDataTypes(this.company, 1);
                Iterator ti = typeIds.iterator();
                boolean found = false;
                while (ti.hasNext()) {
                    String sTypeId = (String)ti.next();
                    if (!this.typeId.equals(sTypeId)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    FloatBar fbInfo = new FloatBar();
                    fbInfo.addAction(this.backAction);
                    fbInfo.addAction(new Action("Button.AdditionalData_short").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("handleAdditionalJournalingData"));
                    this.window.add(fbInfo);
                }
            }
        }
        object.addUIObject((UIObject)this.window);
        return this.showForm(object);
    }

    public DataObject handleAdditionalJournalingData(DataObject object) throws Exception {
        this.getProcess().setAttribute("assetType", (Object)((AssetType)AssetTypeBO.get(this.dbData, this.companyId, this.typeId)[0]));
        this.getProcess().setAttribute("accountingPrinciple", (Object)"1");
        FinancialReferenceField[] newMainAccounts = new FinancialReferenceField[9];
        System.arraycopy(this.mainAccounts, 0, newMainAccounts, 0, this.mainAccounts.length);
        this.getProcess().setAttribute("mainAccounts", (Object)newMainAccounts);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(ExtendedAdditionalJournalingDataAdapter.PAGE), "showInfoWindow", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject showForm(DataObject object) throws Exception {
        this.schemes.setHidden(false);
        this.schemes.setReadonly(false);
        this.validFrom.setMandatory(false);
        this.validFrom.setHidden(true);
        this.fillComboBox();
        this.setValues();
        this.removeActions();
        this.fbMain.addAction(this.backAction);
        this.fbMain.addAction(this.addAction);
        this.fbMain.addAction(this.editAction);
        this.fbMain.addAction(this.deleteAction);
        if (this.schemes.getUIObjects(Option.class, false).size() == 0) {
            this.editAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
        } else {
            this.editAction.setEnabled(true);
            this.deleteAction.setEnabled(true);
        }
        int i = 0;
        while (i < this.jteLength) {
            if (i != 9 && i != 10) {
                this.mainAccounts[i].setReadonly(true);
            }
            ++i;
        }
        return object;
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.schemes.setHidden(true);
        this.validFrom.setMandatory(true);
        this.validFrom.setHidden(false);
        this.validFrom.getPeriod().requestFocus(true);
        this.removeActions();
        this.fbMain.addAction(this.addOKAction);
        this.fbMain.addAction(this.backToMainAction);
        this.addOKAction.setDefault(true);
        this.addOKAction.setValidationEnabled(true);
        int i = 0;
        while (i < this.jteLength) {
            if (i != 9 && i != 10) {
                this.mainAccounts[i].setReadonly(false);
            }
            ++i;
        }
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        int year = this.validFrom.getBookYear().getIntValue();
        int period = this.validFrom.getPeriod().getIntValue();
        Object[] result = null;
        result = ValuationMainAccountBO.create(this.dbData, this.companyId, this.cora, this.id, this.accountingPrinciple, year, period, this.mainAccounts[0].getFormattedId(), this.mainAccounts[1].getFormattedId(), this.mainAccounts[2].getFormattedId(), this.mainAccounts[3].getFormattedId(), this.mainAccounts[4].getFormattedId(), this.mainAccounts[5].getFormattedId(), this.mainAccounts[6].getFormattedId(), this.mainAccounts[7].getFormattedId(), this.mainAccounts[8].getFormattedId());
        if (result[1] != null) {
            String messageText = (String)result[1];
            object.addUIObject((UIObject)new Message(messageText, "error"));
            return object;
        }
        this.vmas = (ValuationMainAccount)result[0];
        this.fillComboBox();
        return this.showForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.schemes.setHidden(false);
        this.schemes.setReadonly(true);
        this.validFrom.setMandatory(false);
        this.validFrom.setHidden(true);
        this.removeActions();
        this.fbMain.addAction(this.editOKAction);
        this.fbMain.addAction(this.backToMainAction);
        this.editOKAction.setDefault(true);
        this.editOKAction.setValidationEnabled(true);
        int i = 0;
        while (i < this.jteLength) {
            if (i != 9 && i != 10) {
                this.mainAccounts[i].setReadonly(false);
            }
            ++i;
        }
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String messageText = ValuationMainAccountBO.update(this.vmas, this.mainAccounts[0].getFormattedId(), this.mainAccounts[1].getFormattedId(), this.mainAccounts[2].getFormattedId(), this.mainAccounts[3].getFormattedId(), this.mainAccounts[4].getFormattedId(), this.mainAccounts[5].getFormattedId(), this.mainAccounts[6].getFormattedId(), this.mainAccounts[7].getFormattedId(), this.mainAccounts[8].getFormattedId());
        if (messageText != null) {
            object.addUIObject((UIObject)new Message(messageText, "error"));
            return object;
        }
        return this.showForm(object);
    }

    public DataObject deleteForm(DataObject object) throws Exception {
        this.schemes.setHidden(false);
        this.schemes.setReadonly(true);
        this.validFrom.setMandatory(false);
        this.validFrom.setHidden(true);
        this.removeActions();
        this.fbMain.addAction(this.deleteOKAction);
        this.fbMain.addAction(this.backToMainAction);
        this.deleteOKAction.setDefault(true);
        this.deleteOKAction.setValidationEnabled(true);
        int i = 0;
        while (i < this.jteLength) {
            this.mainAccounts[i].setReadonly(true);
            ++i;
        }
        return object;
    }

    public DataObject delete(DataObject object) throws Exception {
        String messageText = ValuationMainAccountBO.delete(this.vmas);
        if (messageText != null) {
            object.addUIObject((UIObject)new Message(messageText, "error"));
            return object;
        }
        this.fillComboBox();
        new ComboBoxChangeAction().execute(this.dataObject);
        return this.showForm(object);
    }

    public DataObject closeWindow(DataObject object) throws Exception {
        this.window.closeWindow(object);
        return object;
    }

    public void removeActions() throws Exception {
        this.fbMain.removeAction("Button.OK");
        this.fbMain.removeAction("Button.Back");
        this.fbMain.removeAction("Button.Add");
        this.fbMain.removeAction("Button.Edit");
        this.fbMain.removeAction("Button.Delete");
    }

    protected void setValues() throws Exception {
        String value = this.schemes.getSelectedOptionValue();
        if (value == null) {
            return;
        }
        int year = Integer.parseInt(value.substring(0, 4));
        int period = Integer.parseInt(value.substring(5));
        Object[] objects = ValuationMainAccountBO.get(this.dbData, this.companyId, this.cora, this.id, this.accountingPrinciple, year, period);
        this.vmas = (ValuationMainAccount)objects[0];
        if (this.vmas != null) {
            this.mainAccounts[0].setValue(this.vmas.getMainAccountId1());
            this.mainAccounts[1].setValue(this.vmas.getMainAccountId2());
            this.mainAccounts[2].setValue(this.vmas.getMainAccountId3());
            this.mainAccounts[3].setValue(this.vmas.getMainAccountId4());
            this.mainAccounts[4].setValue(this.vmas.getMainAccountId5());
            this.mainAccounts[5].setValue(this.vmas.getMainAccountId6());
            this.mainAccounts[6].setValue(this.vmas.getMainAccountId7());
            this.mainAccounts[7].setValue(this.vmas.getMainAccountId8());
            this.mainAccounts[8].setValue(this.vmas.getMainAccountId9());
        } else {
            this.mainAccounts[0].setValue();
            this.mainAccounts[1].setValue();
            this.mainAccounts[2].setValue();
            this.mainAccounts[3].setValue();
            this.mainAccounts[4].setValue();
            this.mainAccounts[5].setValue();
            this.mainAccounts[6].setValue();
            this.mainAccounts[7].setValue();
            this.mainAccounts[8].setValue();
        }
    }

    private void fillComboBox() throws Exception {
        this.schemes.removeUIObjects(Option.class, false);
        ValuationMainAccountQuery query = new ValuationMainAccountQuery(this.dbData, this.companyId, this.cora, this.id, "" + this.accountingPrinciple);
        Collection maSchemes = query.fetchData(null, "bookYearFrom, periodFrom", null, 0);
        Object[] maSchemesArray = maSchemes.toArray();
        boolean selected = true;
        int i = maSchemesArray.length - 1;
        while (i >= 0) {
            ValuationMainAccount maScheme = (ValuationMainAccount)maSchemesArray[i];
            String labval = maScheme.getBookYearFrom() + "-" + maScheme.getPeriodFrom();
            this.schemes.addOption(labval, labval, selected);
            selected = false;
            --i;
        }
    }

    private class ComboBoxChangeAction
    extends Action {
        private static final long serialVersionUID = 3064534779286620621L;

        public boolean execute(DataObject dataObject) throws Exception {
            ValuationMainAccountAdapter.this.setValues();
            return true;
        }
    }
}

