/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.boadapters;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.MemoBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditDataBean;
import nl.ibs.fac.db.CreditManager;
import nl.ibs.fac.db.CreditManagerFactory;
import nl.ibs.fac.db.CreditPK;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.Memo;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.queries.ValuationMainAccountQuery;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class CreditBO
extends BOAdapter {
    public static Object[] get(Company company, String id) throws Exception {
        Object[] result = new Object[2];
        CreditPK key = new CreditPK();
        key.setCompanyId(company.getId());
        key.setId(CreditBO.formatId(company, id));
        try {
            result[0] = CreditManagerFactory.getInstance(company.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static boolean hasCredits(Company company) throws Exception {
        if (company == null) {
            return false;
        }
        ExecutableQuery query = QueryFactory.create(Credit.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = CreditBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", company.getId());
        query.setFilter(filter);
        query.setParameters(parameters);
        CreditManager manager = CreditManagerFactory.getInstance(company.getDBData());
        return manager.getFirstObject(query) != null;
    }

    public static Object[] create(DBData dbData, String companyId, String id, String description, int state, BigDecimal creditValue, int startYear, int endYear, String finDimId1, String finDimId2, String finDimId3, String finDimId4, int benefitType, int balanceType, boolean resultAccountItem, String typeId, int interestCalculationMethod, String interestTableId, BigDecimal interestPercentage) throws Exception {
        Object[] result = new Object[2];
        CreditManager manager = CreditManagerFactory.getInstance(dbData);
        CreditDataBean bean = new CreditDataBean();
        bean.setCompanyId(companyId);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        Object[] idResult = CreditBO.getId(company, id);
        if (idResult[1] != null) {
            result[1] = idResult[1];
            return result;
        }
        bean.setId(CreditBO.formatId(company, (String)idResult[0]));
        bean.setDescription(description);
        bean.setState(state);
        bean.setOriginalInvestmentCreditAmount(creditValue);
        bean.setStartYear(startYear);
        bean.setEndYear(endYear);
        bean.setFinDimId1(finDimId1);
        bean.setFinDimId2(finDimId2);
        bean.setFinDimId3(finDimId3);
        bean.setFinDimId4(finDimId4);
        bean.setBenefitType(benefitType);
        bean.setGLBalanceType(balanceType);
        bean.setIsResultAccountItem(resultAccountItem);
        bean.setProFormaTypeId(typeId);
        bean.setInterestCalculationMethod(interestCalculationMethod);
        if (interestTableId.trim().length() > 0) {
            bean.setInterestTableId(interestTableId);
        }
        bean.setInterestPercentage(interestPercentage);
        boolean alreadyActive = CreditBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        boolean created = false;
        while (!created) {
            try {
                result[0] = manager.create(bean);
                CreditBO.commitTransaction(alreadyActive);
                created = true;
            }
            catch (Exception e) {
                if (id.trim().length() == 0 && e.getMessage().startsWith("[SQL0803]")) {
                    idResult = CreditBO.getId(company, id);
                    if (idResult[1] != null) {
                        result[1] = idResult[1];
                        CreditBO.investigate(null, dbTransaction);
                        return result;
                    }
                    bean.setId(CreditBO.formatId(company, (String)idResult[0]));
                    continue;
                }
                result[1] = CreditBO.investigate(e, dbTransaction);
                return result;
            }
        }
        return result;
    }

    private static Object[] getId(Company company, String id) throws Exception {
        Object[] result = new Object[2];
        CreditManager manager = CreditManagerFactory.getInstance(company.getDBData());
        if (id.trim().length() == 0) {
            id = manager.getCreditIdMax(company.getId());
            int startValue = 0;
            if (id != null) {
                try {
                    startValue = Integer.parseInt(id);
                }
                catch (NumberFormatException e) {
                    result[1] = "autoNumber_value_not_numeric";
                    return result;
                }
            }
            id = id == null || startValue < company.getCreditIdStartValue() ? "" + company.getCreditIdStartValue() : "" + (Integer.parseInt(id) + 1);
        }
        result[0] = id;
        return result;
    }

    public static String formatId(Company company, String id) throws Exception {
        if (id == null) {
            return id;
        }
        if (CreditBO.isIdNumeric(company)) {
            DecimalFormat formatter = new DecimalFormat("0000000000");
            try {
                id = formatter.format(Integer.parseInt(id.trim()));
                id = id.substring(10 - company.getCreditIdLength());
            }
            catch (RuntimeException e) {
                return id;
            }
        }
        return id;
    }

    public static String unFormatId(Company company, String id) throws Exception {
        if (CreditBO.isIdNumeric(company)) {
            return (String)new NumericIdTransformer().transform(id);
        }
        return id;
    }

    public static boolean isIdNumeric(Company company) throws Exception {
        return company.getCreditIdType().equals("N");
    }

    public static String update(Credit credit, String description, int startYear, int endYear, String finDimId1, String finDimId2, String finDimId3, String finDimId4, int benefitType, int balanceType, boolean resultAccountItem, String typeId, int interestCalculationMethod, InterestTable interestTable, BigDecimal interestPercentage, String decisionId, Date decisionDate, int state) throws Exception {
        boolean alreadyActive = CreditBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            credit.setDescription(description);
            credit.setStartYear(startYear);
            credit.setEndYear(endYear);
            credit.setFinDimId1(finDimId1);
            credit.setFinDimId2(finDimId2);
            credit.setFinDimId3(finDimId3);
            credit.setFinDimId4(finDimId4);
            credit.setBenefitType(benefitType);
            credit.setGLBalanceType(balanceType);
            credit.setIsResultAccountItem(resultAccountItem);
            credit.setProFormaTypeId(typeId);
            credit.setInterestCalculationMethod(interestCalculationMethod);
            credit.setInterestTable(interestTable);
            credit.setInterestPercentage(interestPercentage);
            credit.setDecisionId(decisionId);
            credit.setDecisionDate(decisionDate);
            credit.setState(state);
            CreditBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return CreditBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(Credit credit) throws Exception {
        boolean alreadyActive = CreditBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message = null;
            ValuationMainAccountQuery query = new ValuationMainAccountQuery(credit.getDBData(), credit.getCompanyId(), "C", credit.getId(), "3");
            Collection maSchemes = query.fetchData(null, null, null, 0);
            for (ValuationMainAccount maScheme : maSchemes) {
                message = ValuationMainAccountBO.delete(maScheme);
                if (message == null) continue;
                return message;
            }
            if (credit.getHasMemo()) {
                Object[] oa = MemoBO.get(credit);
                message = oa[0] == null ? (String)oa[1] : MemoBO.delete(credit, (Memo)oa[0]);
            }
            if (message != null) {
                return message;
            }
            credit.delete();
            CreditBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return CreditBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static boolean dimensionInUse(Company company, int dimension) throws Exception {
        ExecutableQuery qry = QueryFactory.create(Credit.class);
        String filter = "companyId = '" + company.getId() + "' AND ";
        switch (dimension) {
            case 1: {
                filter = String.valueOf(filter) + "dimValue1";
                break;
            }
            case 2: {
                filter = String.valueOf(filter) + "dimValue2";
                break;
            }
            case 3: {
                filter = String.valueOf(filter) + "dimValue3";
                break;
            }
            case 4: {
                filter = String.valueOf(filter) + "dimValue4";
                break;
            }
            case 5: {
                filter = String.valueOf(filter) + "dimValue5";
                break;
            }
            case 6: {
                filter = String.valueOf(filter) + "dimValue6";
            }
        }
        filter = String.valueOf(filter) + " <> ''";
        qry.setFilter(filter);
        Credit result = CreditManagerFactory.getInstance(company.getDBData()).getFirstObject(qry);
        return result != null;
    }

    public static Collection getCredits(Map map) throws Exception {
        String to;
        ExecutableQuery query = QueryFactory.create(Credit.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String companyId = (String)map.get("Company");
        String filter = CreditBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        String from = (String)map.get("FromFinDimId1");
        if (from != null && from.length() > 0) {
            filter = CreditBO.addFilterTerm(filter, "finDimId1 >= ?_fromFinDimId1");
            parameters.put("_fromFinDimId1", from);
        }
        if ((to = (String)map.get("ToFinDimId1")) != null && to.length() > 0) {
            filter = CreditBO.addFilterTerm(filter, "finDimId1 <= ?_toFinDimId1");
            parameters.put("_toFinDimId1", to);
        }
        if ((from = (String)map.get("FromFinDimId2")) != null && from.length() > 0) {
            filter = CreditBO.addFilterTerm(filter, "finDimId2 >= ?_fromFinDimId2");
            parameters.put("_fromFinDimId2", from);
        }
        if ((to = (String)map.get("ToFinDimId2")) != null && to.length() > 0) {
            filter = CreditBO.addFilterTerm(filter, "finDimId2 <= ?_toFinDimId2");
            parameters.put("_toFinDimId2", to);
        }
        if ((from = (String)map.get("FromFinDimId3")) != null && from.length() > 0) {
            filter = CreditBO.addFilterTerm(filter, "finDimId3 >= ?_fromFinDimId3");
            parameters.put("_fromFinDimId3", from);
        }
        if ((to = (String)map.get("ToFinDimId3")) != null && to.length() > 0) {
            filter = CreditBO.addFilterTerm(filter, "finDimId3 <= ?_toFinDimId3");
            parameters.put("_toFinDimId3", to);
        }
        if ((from = (String)map.get("FromFinDimId4")) != null && from.length() > 0) {
            filter = CreditBO.addFilterTerm(filter, "finDimId4 >= ?_fromFinDimId4");
            parameters.put("_fromFinDimId4", from);
        }
        if ((to = (String)map.get("ToFinDimId4")) != null && to.length() > 0) {
            filter = CreditBO.addFilterTerm(filter, "finDimId4 <= ?_toFinDimId4");
            parameters.put("_toFinDimId4", to);
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        CreditBO.addOrdering(query, map, "id");
        CreditManager manager = CreditManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }
}

