/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.boadapters;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.CreditBalanceDetail;
import nl.ibs.fac.db.CreditBalanceManagerFactory;
import nl.ibs.fac.db.CreditBalancePK;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.gov.CreditBalanceWrapper;
import nl.ibs.fac.gov.boadapters.CreditBalanceDetailBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.CreditBalanceBP;
import nl.ibs.fac.gov.queries.CreditBalanceQuery;
import nl.ibs.fac.gov.queries.IncomingFinancialTransactionForGLAccountQuery;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class CreditBalanceBO
extends BOAdapter {
    public static Object[] get(Company company, String id) throws Exception {
        Object[] result = new Object[2];
        CreditBalancePK key = new CreditBalancePK();
        key.setCompanyId(company.getId());
        key.setGLAccountId(id);
        try {
            result[0] = CreditBalanceManagerFactory.getInstance(company.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection retrieveCreditBalances(Credit credit) throws Exception {
        String sql = "companyId = '" + credit.getCompanyId() + "' AND " + "creditId" + " = '" + credit.getId() + "'";
        ExecutableQuery query = QueryFactory.create(CreditBalance.class, sql, "gLAccountId");
        return CreditBalanceManagerFactory.getInstance(credit.getDBData()).getCollection(query);
    }

    public static BigDecimal retrieveCreditBalanceDetailAmount1(CreditBalance balance) throws Exception {
        return CreditBalanceBO.retrieveCreditBalanceDetailAmounts(balance)[0];
    }

    public static BigDecimal retrieveCreditBalanceDetailAmount2(CreditBalance balance) throws Exception {
        return CreditBalanceBO.retrieveCreditBalanceDetailAmounts(balance)[1];
    }

    public static BigDecimal retrieveCreditBalanceDetailAmount3(CreditBalance balance) throws Exception {
        return CreditBalanceBO.retrieveCreditBalanceDetailAmounts(balance)[2];
    }

    public static BigDecimal[] retrieveCreditBalanceDetailAmounts(CreditBalance balance) throws Exception {
        BigDecimal[] amounts = new BigDecimal[]{new BigDecimal("0.00"), new BigDecimal("0.00"), new BigDecimal("0.00"), new BigDecimal("0.00"), new BigDecimal("0.00")};
        Collection details = balance.getCreditBalanceDetailsCollection(null);
        for (CreditBalanceDetail detail : details) {
            amounts[0] = amounts[0].add(detail.getBalanceAmount1());
            amounts[1] = amounts[1].add(detail.getBalanceAmount2());
            amounts[2] = amounts[2].add(detail.getBalanceAmount3());
            amounts[3] = amounts[3].add(detail.getBalanceAmount4());
            amounts[4] = amounts[4].add(detail.getBalanceAmount5());
        }
        return amounts;
    }

    public static BigDecimal[] getBalanceAmounts(Credit credit) throws Exception {
        BigDecimal[] result = new BigDecimal[]{new BigDecimal("0.00"), new BigDecimal("0.00"), new BigDecimal("0.00")};
        String sql = "companyId = '" + credit.getCompanyId() + "' AND " + "creditId" + " = '" + credit.getId() + "'";
        ExecutableQuery query = QueryFactory.create(CreditBalance.class, sql, "gLAccountId");
        for (CreditBalance creditBalance : CreditBalanceManagerFactory.getInstance(credit.getDBData()).getCollection(query)) {
            result[0] = result[0].add(creditBalance.getTotalBalanceAmount());
            result[1] = result[1].add(creditBalance.getTotalEstimationAmount());
            result[2] = result[2].add(creditBalance.getTotalInterestAmount());
        }
        return result;
    }

    public static String assign(CreditBalance creditBalance, Credit credit) throws Exception {
        if (creditBalance.getCreditId() != null) {
            return "Error.Assigned_to_credit";
        }
        boolean alreadyActive = CreditBalanceBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            if (credit.getPreferedGLAccountId() == null) {
                creditBalance.setTotalEstimationAmount(TotalEstimationTransactionBO.getTotalCreditAmount(credit));
                credit.setPreferedGLAccountId(creditBalance.getGLAccountId());
            }
            credit.setCreditBalanceReferenceCounter(credit.getCreditBalanceReferenceCounter() + 1);
            credit.setState(2);
            creditBalance.setCreditId(credit.getId());
            for (CreditBalanceDetail creditBalanceDetail : creditBalance.getCreditBalanceDetailsCollection(QueryFactory.create())) {
                creditBalanceDetail.setCreditId(credit.getId());
            }
            CreditBalanceBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return CreditBalanceBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String deassign(CreditBalance creditBalance, Credit credit) throws Exception {
        if (creditBalance.getTotalInterestAmount().doubleValue() != 0.0) {
            return "Actie niet toegestaan : er is al rente berekend over het rekeningsaldo.";
        }
        boolean alreadyActive = CreditBalanceBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            creditBalance.setTotalEstimationAmount(new BigDecimal("0.00"));
            int cbrc = credit.getCreditBalanceReferenceCounter();
            if (cbrc > 0) {
                credit.setCreditBalanceReferenceCounter(cbrc - 1);
            }
            if (creditBalance.getGLAccountId().equals(credit.getPreferedGLAccountId())) {
                credit.setPreferedGLAccountId(null);
                if (cbrc > 1) {
                    CreditBalanceQuery query = new CreditBalanceQuery(creditBalance.getDBData(), credit.getCompanyId(), credit.getId());
                    Collection balances = query.fetchData(null, null, null, 999);
                    for (CreditBalance balance : balances) {
                        if (balance.getGLAccountId().trim().equals(creditBalance.getGLAccountId().trim())) continue;
                        credit.setPreferedGLAccountId(balance.getGLAccountId());
                        break;
                    }
                }
            }
            creditBalance.setCreditId(null);
            creditBalance.setTotalEstimationAmount(new BigDecimal("0.00"));
            Collection details = creditBalance.getCreditBalanceDetailsCollection(QueryFactory.create());
            for (CreditBalanceDetail creditBalanceDetail : details) {
                creditBalanceDetail.setCreditId(null);
            }
            CreditBalanceBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return CreditBalanceBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(CreditBalance creditBalance) throws Exception {
        CreditBalancePK key = new CreditBalancePK();
        key.setCompanyId(creditBalance.getCompanyId());
        key.setGLAccountId(creditBalance.getGLAccountId());
        try {
            creditBalance = CreditBalanceManagerFactory.getInstance(creditBalance.getDBData()).findByPrimaryKey(key);
        }
        catch (Exception e1) {
            return null;
        }
        if (creditBalance.getCreditId() != null) {
            return String.valueOf(TranslationHelperImpl.getInstance().translate("Error.Deletion_not_allowed")) + ". " + TranslationHelperImpl.getInstance().translate("Error.Assigned_to_credit") + " " + creditBalance.getCreditId();
        }
        if (!creditBalance.getIsDeletable() && creditBalance.getTotalBalanceAmount().doubleValue() != 0.0) {
            return String.valueOf(TranslationHelperImpl.getInstance().translate("Error.Deletion_not_allowed")) + ". " + TranslationHelperImpl.getInstance().translate("Error.TotalAmount_is_not_zero");
        }
        boolean alreadyActive = CreditBalanceBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            IncomingFinancialTransactionForGLAccountQuery query = new IncomingFinancialTransactionForGLAccountQuery(creditBalance.getDBData(), creditBalance.getCompanyId(), creditBalance.getGLAccountId());
            for (IncomingFinancialTransaction ift : query.fetchData(null, null, null, 0)) {
                ift.setGovernmentCode(999);
            }
            creditBalance.delete();
            CreditBalanceBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return CreditBalanceBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static Collection retrieveCreditBalanceWrapperCollection(Credit credit, CreditBalance creditBalance) throws Exception {
        ArrayList<CreditBalanceWrapper> wrappers = new ArrayList<CreditBalanceWrapper>();
        BigDecimal zeroAmount = new BigDecimal("0.00");
        BigDecimal zeroPercentage = new BigDecimal("0.0");
        BigDecimal previousCumBalance = new BigDecimal("0.00");
        int year = credit.getStartYear();
        while (year <= credit.getEndYear()) {
            CreditBalanceWrapper wrapper = new CreditBalanceWrapper();
            CreditBalanceDetail cbd = (CreditBalanceDetail)CreditBalanceDetailBO.get(credit.getOwnedByCompanyAsCredits(), creditBalance.getGLAccountId(), year, 0)[0];
            wrapper.setYear(year);
            wrapper.setLabelText(creditBalance.getGLAccountId() + " : " + creditBalance.getDescription(), null);
            if (cbd == null) {
                wrapper.setAmount1(zeroAmount);
                wrapper.setAmount2(previousCumBalance);
                wrapper.setAmount3(zeroAmount);
            } else {
                BigDecimal totalBalanceAmount = CreditBalanceBO.getTotalBalanceAmount(cbd);
                wrapper.setAmount1(totalBalanceAmount);
                previousCumBalance = previousCumBalance.add(totalBalanceAmount);
                wrapper.setAmount2(previousCumBalance);
                wrapper.setAmount3(cbd.getBalanceAmount5());
            }
            if (creditBalance.getTotalEstimationAmount().doubleValue() == 0.0 || previousCumBalance.doubleValue() == 0.0) {
                wrapper.setPercentage1(zeroPercentage);
            } else {
                BigDecimal thePercentage = previousCumBalance.multiply(new BigDecimal("100.00")).divide(creditBalance.getTotalEstimationAmount(), 4);
                if (thePercentage.doubleValue() > 999.9) {
                    wrapper.setPercentage1(new BigDecimal("999.9"));
                } else {
                    wrapper.setPercentage1(thePercentage);
                }
            }
            wrappers.add(wrapper);
            ++year;
        }
        return wrappers;
    }

    public static Collection retrieveCreditBalanceWrapperCollection(Credit credit) throws Exception {
        BigDecimal zeroPercentage = new BigDecimal("0.0");
        ArrayList<CreditBalanceWrapper> wrappers = new ArrayList<CreditBalanceWrapper>();
        ArrayList allDetailWrappers = new ArrayList();
        Collection cbs = CreditBalanceBO.retrieveCreditBalances(credit);
        Iterator cbsi = cbs.iterator();
        CreditBalanceBP cbBP = new CreditBalanceBP(credit.getOwnedByCompanyAsCredits());
        BigDecimal totalCreditAmount = TotalEstimationTransactionBO.getTotalCreditAmount(credit);
        while (cbsi.hasNext()) {
            CreditBalance cb = (CreditBalance)cbsi.next();
            cbBP.handleBalanceIsDirty(cb);
            Collection detailWrappers = CreditBalanceBO.retrieveCreditBalanceWrapperCollection(credit, cb);
            allDetailWrappers.addAll(detailWrappers);
        }
        int year = credit.getStartYear();
        while (year <= credit.getEndYear()) {
            BigDecimal thePercentage;
            CreditBalanceWrapper wrapper;
            Iterator adwi = allDetailWrappers.iterator();
            BigDecimal amount1 = new BigDecimal("0.00");
            BigDecimal amount2 = new BigDecimal("0.00");
            BigDecimal amount3 = new BigDecimal("0.00");
            while (adwi.hasNext()) {
                wrapper = (CreditBalanceWrapper)adwi.next();
                if (year != wrapper.getYear()) continue;
                amount1 = amount1.add(wrapper.getAmount1().getBigDecimal());
                amount2 = amount2.add(wrapper.getAmount2().getBigDecimal());
                amount3 = amount3.add(wrapper.getAmount3().getBigDecimal());
                if (totalCreditAmount.doubleValue() == 0.0 || wrapper.getAmount2().getBigDecimal().doubleValue() == 0.0) {
                    wrapper.setPercentage1(zeroPercentage);
                } else {
                    thePercentage = wrapper.getAmount2().getBigDecimal().multiply(new BigDecimal("100.00")).divide(totalCreditAmount, 4);
                    if (thePercentage.doubleValue() > 999.9) {
                        wrapper.setPercentage1(new BigDecimal("999.9"));
                    } else {
                        wrapper.setPercentage1(thePercentage);
                    }
                }
                wrappers.add(wrapper);
            }
            wrapper = new CreditBalanceWrapper();
            wrapper.setYear(year);
            wrapper.setLabelText("** Totaal " + year + " **", "blue");
            wrapper.getAmount1().setColor("blue");
            wrapper.getAmount2().setColor("blue");
            wrapper.getAmount3().setColor("blue");
            wrapper.getPercentage1().setColor("blue");
            wrapper.setAmount1(amount1);
            wrapper.setAmount2(amount2);
            wrapper.setAmount3(amount3);
            if (totalCreditAmount.doubleValue() == 0.0 || amount2.doubleValue() == 0.0) {
                wrapper.setPercentage1(zeroPercentage);
            } else {
                thePercentage = amount2.multiply(new BigDecimal("100.00")).divide(totalCreditAmount, 4);
                if (thePercentage.doubleValue() > 999.9) {
                    wrapper.setPercentage1(new BigDecimal("999.9"));
                } else {
                    wrapper.setPercentage1(thePercentage);
                }
            }
            wrappers.add(wrapper);
            ++year;
        }
        return wrappers;
    }

    private static BigDecimal getTotalBalanceAmount(CreditBalanceDetail cbd) throws Exception {
        return cbd.getBalanceAmount1().add(cbd.getBalanceAmount2()).add(cbd.getBalanceAmount3());
    }
}

