/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.bp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.gov.adapters.CreditPanels;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.queries.TransactionQuery;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class CreditBP
implements Serializable {
    private static final long serialVersionUID = -4668343585395053967L;
    private CreditPanels creditPanels;
    private int numberOfPeriods;
    private Credit credit;

    public CreditBP(CreditPanels creditPanels) {
        this.creditPanels = creditPanels;
        this.numberOfPeriods = creditPanels.numberOfPeriods;
    }

    public Object[] create() throws Exception {
        Object[] result = new Object[2];
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message;
            result = CreditBO.create(this.creditPanels.company.getDBData(), this.creditPanels.company.getId(), this.creditPanels.id.getValue().trim(), this.creditPanels.description.getValue().trim(), 0, this.creditPanels.creditAmount.getBigDecimal(), this.creditPanels.startYear.getInteger(), this.creditPanels.endYear.getInteger(), this.creditPanels.financialDimension[0].getFormattedId(), this.creditPanels.financialDimension[1].getFormattedId(), this.creditPanels.financialDimension[2].getFormattedId(), this.creditPanels.financialDimension[3].getFormattedId(), Integer.parseInt(this.creditPanels.benefitType.getSelectedOptionValue()), Integer.parseInt(this.creditPanels.balanceType.getSelectedOptionValue()), this.creditPanels.resultAccountItem.isChecked(), this.creditPanels.type.getValue(), Integer.parseInt(this.creditPanels.interestCalculationMethod.getSelectedOptionValue()), this.creditPanels.interestTableId.getValue(), this.creditPanels.interestPercentage.getBigDecimal());
            if (result[1] != null) {
                BOAdapter.investigate(null, dbTransaction);
                return result;
            }
            this.credit = (Credit)result[0];
            this.saveDimensions();
            if (this.creditPanels.mainAccountIds != null && (message = this.saveValuationMainAccount()) != null) {
                BOAdapter.investigate(null, dbTransaction);
                result[1] = message;
                return result;
            }
            TotalEstimationTransactionBO.createTransaction(this.credit, 0, this.credit.getDescription(), this.credit.getOriginalInvestmentCreditAmount(), "");
            TotalEstimationTransactionBO.createEstimationTransactions(this.credit);
            TotalEstimationTransactionBO.createActivationSchemeTransactions(this.credit);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = BOAdapter.investigate(e, dbTransaction);
        }
        return result;
    }

    public String update(Credit credit) throws Exception {
        this.credit = credit;
        InterestTable interestTable = (InterestTable)InterestTableBO.get(this.creditPanels.company.getDBData(), this.creditPanels.interestTableId.getValue(), this.numberOfPeriods)[0];
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message = CreditBO.update(credit, this.creditPanels.description.getValue().trim(), this.creditPanels.startYear.getInteger(), this.creditPanels.endYear.getInteger(), this.creditPanels.financialDimension[0].getFormattedId(), this.creditPanels.financialDimension[1].getFormattedId(), this.creditPanels.financialDimension[2].getFormattedId(), this.creditPanels.financialDimension[3].getFormattedId(), Integer.parseInt(this.creditPanels.benefitType.getSelectedOptionValue()), Integer.parseInt(this.creditPanels.balanceType.getSelectedOptionValue()), this.creditPanels.resultAccountItem.isChecked(), this.creditPanels.type.getValue(), Integer.parseInt(this.creditPanels.interestCalculationMethod.getSelectedOptionValue()), interestTable, this.creditPanels.interestPercentage.getBigDecimal(), this.creditPanels.decisionId.getValue(), this.creditPanels.decisionDate.getValueAsDate(), Integer.parseInt(this.creditPanels.comboBoxState.getSelectedOptionValue()));
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            this.saveDimensions();
            TotalEstimationTransactionBO.createEstimationTransactions(credit);
            TotalEstimationTransactionBO.createActivationSchemeTransactions(credit);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    private void saveDimensions() throws Exception {
        String value;
        int i = 0;
        while (i < 6) {
            if (this.creditPanels.dimension[i] != null) {
                value = this.creditPanels.dimension[i].getValue();
                switch (i) {
                    case 0: {
                        this.credit.setDimValue1(value);
                        break;
                    }
                    case 1: {
                        this.credit.setDimValue2(value);
                        break;
                    }
                    case 2: {
                        this.credit.setDimValue3(value);
                        break;
                    }
                    case 3: {
                        this.credit.setDimValue4(value);
                        break;
                    }
                    case 4: {
                        this.credit.setDimValue5(value);
                        break;
                    }
                    case 5: {
                        this.credit.setDimValue6(value);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < 6) {
            if (this.creditPanels.freeDimension[i] != null) {
                value = this.creditPanels.freeDimension[i].getValue();
                switch (i) {
                    case 0: {
                        this.credit.setDimValue1(value);
                        break;
                    }
                    case 1: {
                        this.credit.setDimValue2(value);
                        break;
                    }
                    case 2: {
                        this.credit.setDimValue3(value);
                        break;
                    }
                    case 3: {
                        this.credit.setDimValue4(value);
                        break;
                    }
                    case 4: {
                        this.credit.setDimValue5(value);
                        break;
                    }
                    case 5: {
                        this.credit.setDimValue6(value);
                    }
                }
            }
            ++i;
        }
    }

    private String saveValuationMainAccount() throws Exception {
        Object[] result = ValuationMainAccountBO.create(this.credit.getDBData(), this.credit.getCompanyId(), "C", this.credit.getId(), 3, this.creditPanels.startYear.getIntValue(), 1, this.creditPanels.mainAccountIds[0], this.creditPanels.mainAccountIds[1], this.creditPanels.mainAccountIds[2], this.creditPanels.mainAccountIds[3], this.creditPanels.mainAccountIds[4], this.creditPanels.mainAccountIds[5], this.creditPanels.mainAccountIds[6], this.creditPanels.mainAccountIds[7], this.creditPanels.mainAccountIds[8]);
        return (String)result[1];
    }

    public static String delete(Credit credit) throws Exception {
        if (credit.getState() != 0) {
            return "invalid_state";
        }
        if (credit.getCreditBalanceReferenceCounter() > 0) {
            return "credit_has_balance(s)";
        }
        if (credit.getInitialProjectCostsReferenceCounter() != 0 && credit.getInitialProjectCostAmount().doubleValue() != 0.0) {
            return "credit_has_initial_project_costs";
        }
        if (credit.getTotalInterestAmount().doubleValue() != 0.0) {
            return "credit_has_periodical_interest_amount";
        }
        if (credit.getManualInterestAmount().doubleValue() != 0.0) {
            return "credit_has_manual_interest_amount";
        }
        if (credit.getManualDepreciationAmount().doubleValue() != 0.0) {
            return "credit_has_manual_depreciation_amount";
        }
        if (credit.getHasTransactions()) {
            return "credit_has_transactions";
        }
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message;
            for (TotalEstimationTransaction totalEstimationTransaction : TotalEstimationTransactionBO.getEstimationTransactions(credit, null)) {
                message = TotalEstimationTransactionBO.delete(totalEstimationTransaction);
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                totalEstimationTransaction.delete();
            }
            message = CreditBO.delete(credit);
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String closeZeroBalanceCredit(Credit credit, int closingYear, int closingPeriod) throws Exception {
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            credit.setClosingYear(closingYear);
            credit.setClosingPeriod(closingPeriod);
            credit.setState(4);
            Collection creditBalances = CreditBalanceBO.retrieveCreditBalances(credit);
            for (CreditBalance creditBalance : creditBalances) {
                creditBalance.setState(4);
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String confirm(Credit credit, int numberOfPeriods) throws Exception {
        Company company = (Company)CompanyBO.get(credit.getDBData(), credit.getCompanyId())[0];
        ProcessParameters processParameters = company.getProcessParameters();
        int batchId = company.getCurrentBatchId();
        String user = "";
        Iterator iterator = new TransactionQuery(credit.getDBData(), credit, true).fetchData(null, null, null, 0).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (iterator.hasNext()) {
                Transaction creditTransaction = (Transaction)iterator.next();
                user = creditTransaction.getCreatedByUser();
                Asset asset = creditTransaction.getAsset();
                if (asset == null) {
                    creditTransaction.setBatchId(batchId);
                    creditTransaction.setState(1);
                    continue;
                }
                if (creditTransaction.getAssetOriginatedByCredit()) {
                    String message = AssetBP.activate(asset);
                    if (message == null) continue;
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                Valuation valuation = (Valuation)ValuationBO.getValuation(asset.getDBData(), asset.getCompanyId(), asset.getCora(), asset.getId(), creditTransaction.getAccountingPrinciple())[0];
                for (Transaction transaction : TransactionBO.getTransactionsForDocument(creditTransaction)) {
                    if (transaction.getAccountingPrinciple() != valuation.getAccountingPrinciple() || transaction.getState() != 0) continue;
                    if (transaction.getMainTransactionType() == 1) {
                        GenericTransactionBP.updatePostedAcquisitionBalance(asset, valuation, transaction, true);
                        if (valuation.getInterestCalculationMethod() == 1) {
                            valuation.setPreviousBookvalueBalance(valuation.getPreviousBookvalueBalance().add(transaction.getAmount1()));
                        }
                    }
                    if (transaction.getMainTransactionType() == 3) {
                        GenericTransactionBP.updatePostedDepreciationBalance(asset, valuation, transaction, false);
                    }
                    if (transaction.getRevCode() == -1) {
                        transaction.setRevCode(1);
                        Transaction toBeReversedTransaction = (Transaction)TransactionBO.get(asset.getDBData(), asset.getCompanyId(), transaction.getRevDocumentNr(), transaction.getRevSeqNr())[0];
                        toBeReversedTransaction.setInfoLevel(1);
                        toBeReversedTransaction.setRevCode(2);
                        toBeReversedTransaction.setRevDocumentNr(transaction.getDocumentNr());
                        toBeReversedTransaction.setRevSeqNr(transaction.getSeqNr());
                    }
                    transaction.setBatchId(batchId);
                    transaction.setState(1);
                }
            }
            if (credit.getClosingYear() != 0) {
                int[] closingPeriod = PeriodHelper.getPreviousPeriod(numberOfPeriods, credit.getClosingYear(), credit.getClosingPeriod());
                credit.setClosingYear(closingPeriod[0]);
                credit.setClosingPeriod(closingPeriod[1]);
            }
            credit.setState(4);
            Collection creditBalances = CreditBalanceBO.retrieveCreditBalances(credit);
            Iterator cbi = creditBalances.iterator();
            int docnr = 0;
            int seqnr = 0;
            while (cbi.hasNext()) {
                CreditBalance creditBalance = (CreditBalance)cbi.next();
                Transaction closingTransaction = (Transaction)TransactionBO.create(credit.getDBData(), credit.getCompanyId(), docnr, ++seqnr, "Afsluiting " + credit.getClosingYear() + "-" + credit.getClosingPeriod(), "C", null, 3, 1, 120, credit.getClosingYear(), credit.getClosingPeriod(), credit.getClosingYear(), credit.getClosingPeriod(), creditBalance.getTotalBalanceAmount().negate(), new BigDecimal("0.00"), new BigDecimal("0.00"), null, credit.getFinDimId1(), credit.getFinDimId2(), credit.getFinDimId3(), credit.getFinDimId4(), "", 1, 0, batchId, user, credit.getProFormaTypeId())[0];
                closingTransaction.setMainAccount1(creditBalance.getGLAccountId());
                closingTransaction.setCreditId(credit.getId());
                closingTransaction.setBookingIndicator(1);
                closingTransaction.setState(1);
                if (docnr == 0) {
                    docnr = closingTransaction.getDocumentNr();
                    closingTransaction.setAmount2(credit.getManualDepreciationAmount().negate());
                }
                if (processParameters.getUseCorrectionCodeDC()) {
                    closingTransaction.setCorrectionCodeDC("J");
                }
                creditBalance.setState(4);
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }
}

