/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.bp;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.CreditBalanceDetail;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.CreditBalanceDetailBO;
import nl.ibs.fac.gov.queries.CreditBalanceQuery;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.util.NameValuePair;

public class CreditBalanceBP
implements Serializable {
    private static final long serialVersionUID = 6006641033445806833L;
    private Company company;

    public CreditBalanceBP(Company company) {
        this.company = company;
    }

    public String handleBalanceIsDirty(CreditBalance balance) throws Exception {
        if (!balance.getIsDirty()) {
            return null;
        }
        Iterator ifti = IncomingFinancialTransactionBO.retrieveNewInvestmentCreditTransactions(this.company, balance.getGLAccountId()).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (ifti.hasNext()) {
                IncomingFinancialTransaction ift = (IncomingFinancialTransaction)ifti.next();
                Object[] objects = CreditBalanceDetailBO.get(this.company, ift.getMainAccount(), ift.getBookYear(), 0);
                if (objects[0] == null) {
                    objects = CreditBalanceDetailBO.create(this.company, ift, balance.getCreditId());
                    if (objects[1] != null) {
                        BOAdapter.investigate(null, dbTransaction);
                        return (String)objects[1];
                    }
                } else {
                    String message = CreditBalanceDetailBO.update((CreditBalanceDetail)objects[0], ift);
                    if (message != null) {
                        BOAdapter.investigate(null, dbTransaction);
                        return (String)objects[1];
                    }
                }
                ift.setIsNew(false);
            }
            balance.setIsDirty(false);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    public static Collection<?> getCostAccounts(Company company, String bookYear, LoginHelper loginHelper) throws Exception {
        FMSHelper helper = new FMSHelper(loginHelper);
        Collection result = helper.getCostAccounts(company.getId(), bookYear);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            NameValuePair pair = (NameValuePair)iterator.next();
            CreditBalance creditBalance = (CreditBalance)CreditBalanceBO.get(company, pair.getName())[0];
            if (creditBalance == null || creditBalance.getCreditId() == null) continue;
            iterator.remove();
        }
        return result;
    }

    public void updateIsDeletable(Company company, LoginHelper loginHelper) throws Exception {
        Collection costAccounts = null;
        FMSHelper fmsHelper = new FMSHelper(loginHelper);
        Collection creditBalances = new CreditBalanceQuery(company.getDBData(), company.getId()).fetchData(null, null, null, 0);
        Iterator cbi = creditBalances.iterator();
        if (cbi.hasNext()) {
            CreditBalance creditBalance = (CreditBalance)cbi.next();
            this.handleBalanceIsDirty(creditBalance);
            Collection creditBalanceDetails = creditBalance.getCreditBalanceDetailsCollection(null);
            Iterator cbdi = creditBalanceDetails.iterator();
            if (cbdi.hasNext()) {
                CreditBalanceDetail creditBalanceDetail = (CreditBalanceDetail)cbdi.next();
                String year = "" + creditBalanceDetail.getYear();
                costAccounts = fmsHelper.getCostAccounts(company.getId(), year);
                this.updateIsDeletable(creditBalance, costAccounts);
            }
            while (cbi.hasNext()) {
                creditBalance = (CreditBalance)cbi.next();
                this.updateIsDeletable(creditBalance, costAccounts);
            }
        }
    }

    private void updateIsDeletable(CreditBalance creditBalance, Collection costAccounts) throws Exception {
        if (costAccounts == null) {
            return;
        }
        Iterator cai = costAccounts.iterator();
        boolean isDeletable = true;
        while (cai.hasNext()) {
            NameValuePair costAccount = (NameValuePair)cai.next();
            if (!costAccount.getName().trim().equals(creditBalance.getGLAccountId().trim())) continue;
            isDeletable = false;
            break;
        }
        creditBalance.setIsDeletable(isDeletable);
    }
}

