/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.bp;

import com.ibm.as400.access.AS400;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Vector;
import nl.ibs.fac.ComparisonValue;
import nl.ibs.fac.bp.BaseComparisonBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.queries.CreditBalanceQuery;
import nl.ibs.fac.gov.queries.CreditQuery;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.FreeQuery;
import nl.ibs.jsql.QueryFactory;

public class GOVComparisonBP
extends BaseComparisonBP
implements Serializable {
    private static final long serialVersionUID = 2794011880548357509L;
    private ProcessParameters processParms;

    public GOVComparisonBP(DBData dbData, AS400 as400, Environment env, Company company, int numberOfPeriods, ProcessParameters processParms) throws Exception {
        super(dbData, as400, company, numberOfPeriods);
        this.processParms = processParms;
    }

    public Vector retrieveGLComparisonValues(int accountingPrinciple, int year) throws Exception {
        this.types = null;
        this.allSchemes = null;
        this.glComparisonValues = null;
        this.year = year;
        this.accountingPrinciple = accountingPrinciple;
        if (accountingPrinciple == 3) {
            this.retrieveGLComparisonValuesForCreditBalances();
            if (this.glComparisonValues != null) {
                this.initializeFMSAdapters();
                this.retrieveFMSTotals();
                DBData defaultDBData = DBData.getDefaultDBData("fac");
                DBPersistenceManager.setDefaultDataBase(this.dbData);
                this.retrieveFACTotalsForCredits();
                DBPersistenceManager.setDefaultDataBase(defaultDBData);
                this.handleTotalDifferences();
            }
            return this.glComparisonValues;
        }
        this.retrieveSchemes();
        if (this.allSchemes == null || this.allSchemes.isEmpty()) {
            return null;
        }
        this.createGLComparisonValues();
        this.initializeFMSAdapters();
        this.retrieveFMSTotals();
        DBData defaultDBData = DBData.getDefaultDBData("fac");
        DBPersistenceManager.setDefaultDataBase(this.dbData);
        this.retrieveFACTotals();
        DBPersistenceManager.setDefaultDataBase(defaultDBData);
        if (this.processParms.getGLBookValueRegistration()) {
            this.handleTotalGLBookValueRegistration();
        } else {
            this.handleTotalDifferences();
        }
        return this.glComparisonValues;
    }

    private void retrieveGLComparisonValuesForCreditBalances() throws Exception {
        Collection creditBalances;
        CreditQuery creditQuery = new CreditQuery(this.dbData, this.company.getId(), false, false);
        Collection credits = creditQuery.fetchData(null, null, null, 0);
        for (Credit credit : credits) {
            if (credit.getStartYear() > this.year || credit.getCreditBalanceReferenceCounter() <= 0) continue;
            creditBalances = CreditBalanceBO.retrieveCreditBalances(credit);
            for (CreditBalance creditBalance : creditBalances) {
                this.addGLComparisionValueForCreditBalance(credit, creditBalance);
            }
        }
        CreditBalanceQuery creditBalanceQuery = new CreditBalanceQuery(this.dbData, this.company.getId());
        creditBalances = creditBalanceQuery.fetchData(null, null, null, 0);
        for (CreditBalance creditBalance : creditBalances) {
            this.addGLComparisionValueForCreditBalance(null, creditBalance);
        }
    }

    private void addGLComparisionValueForCreditBalance(Credit credit, CreditBalance creditBalance) throws Exception {
        if (this.glComparisonValues == null) {
            this.glComparisonValues = new Vector();
        }
        String typeId = "";
        if (credit != null) {
            typeId = credit.getProFormaTypeId();
        }
        ComparisonValue glComparisonValue = new ComparisonValue(this.accountingPrinciple, 0, typeId, creditBalance.getGLAccountId(), "", "", this.numberOfPeriods, this.numberOfCorrectionPeriods);
        if (credit != null) {
            glComparisonValue.setCreditId(credit.getId());
        }
        this.glComparisonValues.add(glComparisonValue);
    }

    private void retrieveFACTotalsForCredits() throws Exception {
        FreeQuery freeQuery = QueryFactory.createFreeQuery(IncomingFinancialTransaction.class);
        freeQuery.setQuery("SELECT SUM(transactionValue) FROM IncomingFinancialTransaction WHERE companyId = ?_companyId  AND bookYear <= ?_year AND mainAccount = ?_mainAccount");
        freeQuery.setParameter("_companyId", this.company.getId());
        freeQuery.setParameter("_year", this.year);
        freeQuery.setCacheable(true);
        for (ComparisonValue glComparisonValue : this.glComparisonValues) {
            BigDecimal amount;
            freeQuery.setParameter("_mainAccount", glComparisonValue.getAcquisitionAccount());
            Object[][] data = freeQuery.getResultArray();
            if (data[0][0] == null || (amount = (BigDecimal)data[0][0]).doubleValue() == 0.0) continue;
            glComparisonValue.setFACAcquisitionTotal(amount);
        }
    }

    public ComparisonValue retrieveGLComparisonValueDetailsForCreditBalance(ComparisonValue glComparisonValue) throws Exception {
        if (glComparisonValue.getDetailsAlreadyAvailable()) {
            return glComparisonValue;
        }
        this.retrieveFMSDetails(glComparisonValue);
        DBData defaultDBData = DBData.getDefaultDBData("fac");
        DBPersistenceManager.setDefaultDataBase(this.dbData);
        this.retrieveOBFiguresForCreditBalance(glComparisonValue);
        this.retrievePeriodFiguresForCreditBalance(glComparisonValue);
        DBPersistenceManager.setDefaultDataBase(defaultDBData);
        glComparisonValue.handleDetailDifferences();
        glComparisonValue.setDetailsAlreadyAvailable(true);
        return glComparisonValue;
    }

    private void retrieveOBFiguresForCreditBalance(ComparisonValue glComparisonValue) throws Exception {
        BigDecimal value;
        FreeQuery freeQuery = QueryFactory.createFreeQuery(IncomingFinancialTransaction.class);
        freeQuery.setQuery("SELECT SUM(transactionValue) FROM IncomingFinancialTransaction WHERE companyId = ?_companyId  AND bookYear < ?_year AND mainAccount = ?_mainAccount");
        freeQuery.setParameter("_companyId", this.company.getId());
        freeQuery.setParameter("_year", this.year);
        freeQuery.setParameter("_mainAccount", glComparisonValue.getAcquisitionAccount());
        freeQuery.setCacheable(true);
        Object[][] obData = freeQuery.getResultArray();
        if (obData != null && obData[0][0] != null && (value = (BigDecimal)obData[0][0]).doubleValue() != 0.0) {
            glComparisonValue.addFigure(value, 1, 0);
        }
    }

    private void retrievePeriodFiguresForCreditBalance(ComparisonValue glComparisonValue) throws Exception {
        FreeQuery freeQuery = QueryFactory.createFreeQuery(IncomingFinancialTransaction.class);
        freeQuery.setQuery("SELECT SUM(transactionValue) FROM IncomingFinancialTransaction WHERE companyId = ?_companyId  AND bookYear = ?_year AND period = ?_period AND mainAccount = ?_mainAccount");
        freeQuery.setParameter("_companyId", this.company.getId());
        freeQuery.setParameter("_year", this.year);
        freeQuery.setParameter("_mainAccount", glComparisonValue.getAcquisitionAccount());
        freeQuery.setCacheable(true);
        int period = 1;
        while (period <= this.numberOfPeriods) {
            BigDecimal value;
            freeQuery.setParameter("_period", period);
            this.perData = freeQuery.getResultArray();
            if (this.perData != null && this.perData[0][0] != null && (value = (BigDecimal)this.perData[0][0]).doubleValue() != 0.0) {
                glComparisonValue.addFigure(value, 1, period);
            }
            ++period;
        }
        if (this.numberOfCorrectionPeriods > 0) {
            this.executeExtendedPeriodFiguresForCreditBalanceQuery(glComparisonValue);
        }
    }

    private void executeExtendedPeriodFiguresForCreditBalanceQuery(ComparisonValue glComparisonValue) throws Exception {
        BigDecimal value;
        FreeQuery freeQuery = QueryFactory.createFreeQuery(IncomingFinancialTransaction.class);
        freeQuery.setQuery("SELECT SUM(transactionValue) FROM IncomingFinancialTransaction WHERE companyId = ?_companyId  AND bookYear = ?_year AND period > ?_period AND mainAccount = ?_mainAccount");
        freeQuery.setParameter("_companyId", this.company.getId());
        freeQuery.setParameter("_year", this.year);
        freeQuery.setParameter("_mainAccount", glComparisonValue.getAcquisitionAccount());
        freeQuery.setParameter("_period", this.numberOfPeriods);
        this.perData = freeQuery.getResultArray();
        if (this.perData != null && this.perData[0][0] != null && (value = (BigDecimal)this.perData[0][0]).doubleValue() != 0.0) {
            glComparisonValue.addFigure(value, 1, this.numberOfPeriods + 1);
        }
    }

    public ComparisonValue retrieveGLComparisonValueDetails(ComparisonValue glComparisonValue) throws Exception {
        if (glComparisonValue.getDetailsAlreadyAvailable()) {
            return glComparisonValue;
        }
        this.retrieveFMSDetails(glComparisonValue);
        DBData defaultDBData = DBData.getDefaultDBData("fac");
        DBPersistenceManager.setDefaultDataBase(this.dbData);
        this.retrieveFACDetails(glComparisonValue);
        DBPersistenceManager.setDefaultDataBase(defaultDBData);
        glComparisonValue.handleDetailDifferences();
        glComparisonValue.setDetailsAlreadyAvailable(true);
        return glComparisonValue;
    }

    private void handleTotalGLBookValueRegistration() throws Exception {
        for (ComparisonValue glComparisonValue : this.glComparisonValues) {
            if (glComparisonValue.getBeanType() != 0) continue;
            glComparisonValue.calculateFACBookValue();
            glComparisonValue.setAcquisitionTotalDifference();
        }
    }
}

