/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.bp;

import java.io.Serializable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.util.NameValuePair;

public class GenericGovernmentBP
implements Serializable {
    private static final long serialVersionUID = -6121701904151010164L;
    private Company company;
    private Object[] journalingTerms = null;
    private FinancialReferenceField[] mainAccounts = null;
    private FieldGroup maFieldGroup;
    private FMSReferenceField mainAccount;
    private NameValuePair pair;

    public GenericGovernmentBP(Company company) {
        this.company = company;
    }

    public FieldGroup getInitialMainAccountFieldGroup(LoginHelper loginHelper, AssetType assetType, int accountingPrinciple, int year, int period) throws Exception {
        if (this.journalingTerms == null) {
            this.journalingTerms = JournalingsTermEnum.getCollection().toArray();
        }
        this.maFieldGroup = new FieldGroup("Label.MainAccounts");
        this.mainAccounts = new FinancialReferenceField[this.journalingTerms.length];
        if (assetType != null) {
            return this.getInitialMainAccountFieldGroupFromAssetType(loginHelper, assetType, accountingPrinciple, year, period);
        }
        return this.getInitialMainAccountFieldGroupFromCompany(loginHelper, accountingPrinciple);
    }

    private FieldGroup getInitialMainAccountFieldGroupFromAssetType(LoginHelper loginHelper, AssetType assetType, int accountingPrinciple, int year, int period) throws Exception {
        MainAccountScheme masToUse = MainAccountSchemeBO.getMainAccountSchemeToUse(assetType, accountingPrinciple, year, period);
        int index = 0;
        while (index < this.journalingTerms.length) {
            if (index != 9 && index != 10) {
                this.pair = (NameValuePair)this.journalingTerms[index];
                this.mainAccount = new FMSReferenceField(loginHelper, this.pair.getValue(), 0, true);
                if (masToUse != null) {
                    switch (Integer.parseInt(this.pair.getName())) {
                        case 10: {
                            this.mainAccount.setValue(masToUse.getMainAccountId1());
                            break;
                        }
                        case 20: {
                            this.mainAccount.setValue(masToUse.getMainAccountId2());
                            break;
                        }
                        case 30: {
                            this.mainAccount.setValue(masToUse.getMainAccountId3());
                            break;
                        }
                        case 40: {
                            this.mainAccount.setValue(masToUse.getMainAccountId4());
                            break;
                        }
                        case 50: {
                            this.mainAccount.setValue(masToUse.getMainAccountId5());
                            break;
                        }
                        case 60: {
                            this.mainAccount.setValue(masToUse.getMainAccountId6());
                            break;
                        }
                        case 70: {
                            this.mainAccount.setValue(masToUse.getMainAccountId7());
                            break;
                        }
                        case 80: {
                            this.mainAccount.setValue(masToUse.getMainAccountId8());
                            break;
                        }
                        case 90: {
                            this.mainAccount.setValue(masToUse.getMainAccountId9());
                        }
                    }
                }
                this.maFieldGroup.add((Field)this.mainAccount);
                this.mainAccounts[index] = this.mainAccount;
            }
            ++index;
        }
        this.mainAccounts[8].setHidden(true);
        if (assetType.getIs3rdPartyLoan()) {
            this.mainAccounts[0].setLabel("Label.LoanAmount");
            this.mainAccounts[1].setLabel("Label.PayOffs");
            this.mainAccounts[2].setHidden(true);
        }
        return this.maFieldGroup;
    }

    private FieldGroup getInitialMainAccountFieldGroupFromCompany(LoginHelper loginHelper, int accountingPrinciple) throws Exception {
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.company.getDBData(), this.company.getId(), accountingPrinciple)[0];
        int index = 0;
        while (index < this.journalingTerms.length) {
            if (index != 9 && index != 10) {
                this.pair = (NameValuePair)this.journalingTerms[index];
                this.mainAccount = new FMSReferenceField(loginHelper, this.pair.getValue(), 0, true);
                if (capd != null) {
                    switch (Integer.parseInt(this.pair.getName())) {
                        case 10: {
                            this.mainAccount.setHidden(true);
                            break;
                        }
                        case 20: {
                            this.mainAccount.setValue(capd.getMainAccountId2());
                            break;
                        }
                        case 30: {
                            this.mainAccount.setValue(capd.getMainAccountId3());
                            break;
                        }
                        case 40: {
                            this.mainAccount.setValue(capd.getMainAccountId4());
                            break;
                        }
                        case 50: {
                            this.mainAccount.setHidden(true);
                            break;
                        }
                        case 60: {
                            this.mainAccount.setHidden(true);
                            break;
                        }
                        case 70: {
                            this.mainAccount.setValue(capd.getMainAccountId7());
                            break;
                        }
                        case 80: {
                            this.mainAccount.setValue(capd.getMainAccountId8());
                            break;
                        }
                        case 90: {
                            this.mainAccount.setHidden(true);
                        }
                    }
                }
                this.maFieldGroup.add((Field)this.mainAccount);
                this.mainAccounts[index] = this.mainAccount;
            }
            ++index;
        }
        return this.maFieldGroup;
    }

    public FieldGroup getMainAccountFieldGroupForCreditClosing(LoginHelper loginHelper, AssetType assetType, int year, int period, Credit credit) throws Exception {
        if (this.journalingTerms == null) {
            this.journalingTerms = JournalingsTermEnum.getCollection().toArray();
        }
        this.maFieldGroup = new FieldGroup("Label.MainAccounts");
        this.mainAccounts = new FinancialReferenceField[this.journalingTerms.length];
        MainAccountScheme mas = MainAccountSchemeBO.getMainAccountSchemeToUse(assetType, 1, year, period);
        ValuationMainAccount vma = ValuationMainAccountBO.getValuationMainAccountToUse(credit.getDBData(), credit.getCompanyId(), "C", credit.getId(), 3, year, period);
        int index = 0;
        while (index < this.journalingTerms.length) {
            if (index != 9 && index != 10) {
                this.pair = (NameValuePair)this.journalingTerms[index];
                this.mainAccount = new FMSReferenceField(loginHelper, this.pair.getValue(), 0, true);
                if (mas != null && vma != null) {
                    switch (Integer.parseInt(this.pair.getName())) {
                        case 10: {
                            this.mainAccount.setValue(mas.getMainAccountId1());
                            break;
                        }
                        case 20: {
                            this.mainAccount.setValue(mas.getMainAccountId2());
                            this.updateMainAccountRF(this.mainAccount, vma.getMainAccountId2());
                            break;
                        }
                        case 30: {
                            this.mainAccount.setValue(mas.getMainAccountId3());
                            this.updateMainAccountRF(this.mainAccount, vma.getMainAccountId3());
                            break;
                        }
                        case 40: {
                            this.mainAccount.setValue(mas.getMainAccountId4());
                            this.updateMainAccountRF(this.mainAccount, vma.getMainAccountId4());
                            break;
                        }
                        case 50: {
                            this.mainAccount.setValue(mas.getMainAccountId5());
                            break;
                        }
                        case 60: {
                            this.mainAccount.setValue(mas.getMainAccountId6());
                            break;
                        }
                        case 70: {
                            this.mainAccount.setValue(mas.getMainAccountId7());
                            this.updateMainAccountRF(this.mainAccount, vma.getMainAccountId7());
                            break;
                        }
                        case 80: {
                            this.mainAccount.setValue(mas.getMainAccountId8());
                            this.updateMainAccountRF(this.mainAccount, vma.getMainAccountId8());
                            break;
                        }
                        case 90: {
                            this.mainAccount.setValue(mas.getMainAccountId9());
                        }
                    }
                }
                this.maFieldGroup.add((Field)this.mainAccount);
                this.mainAccounts[index] = this.mainAccount;
            }
            ++index;
        }
        return this.maFieldGroup;
    }

    private void updateMainAccountRF(FMSReferenceField mainAccountRF, String mainAccount) throws Exception {
        if (mainAccountRF.getValue().trim().length() > 0) {
            return;
        }
        if (mainAccount.trim().length() <= 0) {
            return;
        }
        mainAccountRF.setValue(mainAccount);
    }

    public String[] getFormattedMainAccountIds() throws Exception {
        if (this.journalingTerms == null) {
            return null;
        }
        String[] mainAccountIds = new String[this.journalingTerms.length];
        int index = 0;
        while (index < this.journalingTerms.length) {
            if (index != 9 && index != 10) {
                mainAccountIds[index] = this.mainAccounts[index].getFormattedId();
            }
            ++index;
        }
        return mainAccountIds;
    }
}

