/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.bp;

import java.math.BigDecimal;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class LoanAndPayOffBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 7281748008410032666L;

    public LoanAndPayOffBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public String[] validateFACYearAndPeriod(Asset asset, int facYear, int facPeriod, boolean isPayOff) throws Exception {
        int status;
        int thePeriod;
        int theYear;
        String[] messages = new String[2];
        int index = 0;
        if (asset != null && PeriodHelper.isBefore(facYear, facPeriod, theYear = asset.getStartUseYear(), thePeriod = asset.getStartUsePeriod())) {
            messages[index] = "FACPeriodBeforeStartUsePeriod";
            ++index;
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateTransactionValue(BigDecimal transactionValue, boolean isPayOff) throws Exception {
        String[] messages = new String[1];
        int index = 0;
        if (transactionValue.doubleValue() == 0.0) {
            messages[index] = "TransactionValueCannotBeZero";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String createLoan(Asset asset, boolean initialInvestment, int facYear, int facPeriod, int finYear, int finPeriod, String description, BigDecimal transactionValue, IncomingFinancialTransaction incomingFinancialTransaction, boolean post, String user) throws Exception {
        this.asset = asset;
        String message = null;
        String iftId = null;
        if (incomingFinancialTransaction != null) {
            iftId = incomingFinancialTransaction.getId();
        }
        if (description.trim().length() == 0) {
            description = "Aanv. lening " + facYear + "-" + facPeriod;
        }
        this.documentNr = 0;
        this.seqNr = 0;
        Iterator vi = asset.getValuationsCollection(null).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (vi.hasNext()) {
                Valuation valuation = (Valuation)vi.next();
                if (finYear == 0) {
                    this.finBookYear = facYear;
                    this.finBookPeriod = facPeriod;
                } else {
                    this.finBookYear = finYear;
                    this.finBookPeriod = finPeriod;
                }
                this.retrieveFinancialDimensions(facYear, facPeriod);
                Object[] result = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, description, asset.getCora(), asset.getId(), valuation.getAccountingPrinciple(), 1, 110, facYear, facPeriod, this.finBookYear, this.finBookPeriod, transactionValue, new BigDecimal(0), new BigDecimal(0), iftId, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, 1, 0, -1, user, asset.getTypeId());
                message = (String)result[1];
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                Transaction transaction = (Transaction)result[0];
                this.documentNr = transaction.getDocumentNr();
                if (post) {
                    LoanAndPayOffBP.updatePostedAcquisitionBalance(asset, valuation, transaction, true);
                    transaction.setState(1);
                }
                if (this.processParameters.getUseCorrectionCodeDC() && (!asset.getNegativeInvestment() && transactionValue.doubleValue() < 0.0 || asset.getNegativeInvestment() && transactionValue.doubleValue() > 0.0)) {
                    transaction.setCorrectionCodeDC("J");
                }
                if (!initialInvestment) continue;
                valuation.setDocumentNr1stTransaction(this.documentNr);
                valuation.setSeqNr1stTransaction(this.seqNr);
            }
            if (incomingFinancialTransaction != null && (message = IncomingFinancialTransactionBO.update(incomingFinancialTransaction, incomingFinancialTransaction.getUnAllocatedValue().subtract(transactionValue))) != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    public String createPayOff(Asset asset, int facYear, int facPeriod, int finYear, int finPeriod, String description, BigDecimal transactionValue, IncomingFinancialTransaction incomingFinancialTransaction, boolean post, String user) throws Exception {
        this.asset = asset;
        String message = null;
        String iftId = null;
        if (incomingFinancialTransaction != null) {
            iftId = incomingFinancialTransaction.getId();
        }
        if (description.trim().length() == 0) {
            description = "Aflossing " + facYear + "-" + facPeriod;
        }
        this.documentNr = 0;
        this.seqNr = 0;
        Iterator vi = asset.getValuationsCollection(null).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (vi.hasNext()) {
                Valuation valuation = (Valuation)vi.next();
                if (finYear == 0) {
                    this.finBookYear = facYear;
                    this.finBookPeriod = facPeriod;
                } else {
                    this.finBookYear = finYear;
                    this.finBookPeriod = finPeriod;
                }
                this.retrieveFinancialDimensions(facYear, facPeriod);
                Object[] result = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, description, asset.getCora(), asset.getId(), valuation.getAccountingPrinciple(), 3, 190, facYear, facPeriod, this.finBookYear, this.finBookPeriod, new BigDecimal(0), transactionValue, new BigDecimal(0), iftId, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, 1, 0, -1, user, asset.getTypeId());
                message = (String)result[1];
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                Transaction transaction = (Transaction)result[0];
                this.documentNr = transaction.getDocumentNr();
                if (post) {
                    LoanAndPayOffBP.updatePostedDepreciationBalance(asset, valuation, transaction, false);
                    transaction.setState(1);
                }
                if (!this.processParameters.getUseCorrectionCodeDC() || !(!asset.getNegativeInvestment() && transactionValue.doubleValue() < 0.0) && (!asset.getNegativeInvestment() || !(transactionValue.doubleValue() > 0.0))) continue;
                transaction.setCorrectionCodeDC("J");
            }
            if (incomingFinancialTransaction != null && (message = IncomingFinancialTransactionBO.update(incomingFinancialTransaction, incomingFinancialTransaction.getUnAllocatedValue().subtract(transactionValue.negate()))) != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }
}

