/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.reports;

import java.math.BigDecimal;
import java.util.Collection;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.DetailEstimationTransaction;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.CreditDepreciationBP;

public abstract class CreditProofDepreciationReportHelper {
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public static BigDecimal[] retrieveAmounts(CreditDepreciationBP businessProcess, Credit credit, int bookYearFrom, int numberOfYears) throws Exception {
        BigDecimal[] amounts = new BigDecimal[2 + numberOfYears * 2 + 2];
        int index = 0;
        while (index < amounts.length) {
            amounts[index] = ZERO;
            ++index;
        }
        int bookYearTo = credit.getState() == 4 ? credit.getClosingYear() : bookYearFrom - 1 + numberOfYears;
        BigDecimal[] investmentAmounts = CreditProofDepreciationReportHelper.retrieveInvestmentBalanceAmounts(credit, bookYearFrom, bookYearTo);
        amounts[0] = investmentAmounts[0];
        amounts[numberOfYears * 2 + 2] = investmentAmounts[1];
        String message = businessProcess.proofDepreciate(credit, bookYearTo, true);
        if (message != null) {
            return amounts;
        }
        Collection values = businessProcess.getAllCalculationValues();
        for (CalculationValue value : values) {
            if (value.getYear() < bookYearFrom || value.getYear() > bookYearTo) continue;
            int mainIndex = value.getYear() - bookYearFrom;
            if (value.getDepreciationAmount().doubleValue() != 0.0) {
                amounts[mainIndex * 2 + 2] = amounts[mainIndex * 2 + 2].add(value.getDepreciationAmount());
                amounts[numberOfYears * 2 + 3] = amounts[numberOfYears * 2 + 3].add(value.getDepreciationAmount());
            }
            if (value.getInterestAmount().doubleValue() == 0.0) continue;
            amounts[mainIndex * 2 + 3] = amounts[mainIndex * 2 + 3].add(value.getInterestAmount());
        }
        return amounts;
    }

    public static BigDecimal[] retrieveInvestmentBalanceAmounts(Credit credit, int bookYearFrom, int bookYearTo) throws Exception {
        BigDecimal[] investmentAmounts = new BigDecimal[]{ZERO, ZERO};
        Collection<TotalEstimationTransaction> tets = TotalEstimationTransactionBO.getEstimationTransactions(credit, new Boolean(true));
        for (TotalEstimationTransaction tet : tets) {
            Collection dets = tet.getDetailEstimationTransactionsCollection(null);
            for (DetailEstimationTransaction det : dets) {
                if (det.getYear() < bookYearFrom) {
                    investmentAmounts[0] = investmentAmounts[0].add(det.getDetailTransactionAmount());
                }
                if (det.getYear() > bookYearTo) continue;
                investmentAmounts[1] = investmentAmounts[1].add(det.getDetailTransactionAmount());
            }
        }
        if (credit.getState() == 4) {
            investmentAmounts[1] = ZERO;
        } else if (credit.getEndYear() < bookYearTo) {
            investmentAmounts[1] = ZERO;
            tets = TotalEstimationTransactionBO.getEstimationTransactions(credit, new Boolean(false));
            for (TotalEstimationTransaction tet : tets) {
                if (tet.getEstimationTransactionType() == 104) continue;
                investmentAmounts[1] = investmentAmounts[1].add(tet.getTotalTransactionAmount());
            }
        }
        return investmentAmounts;
    }
}

