/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class GOVAssetSheetToPDF
extends PdfHelper {
    public static final String CLASSNAME = GOVAssetSheetToPDF.class.getName();
    private static final String FILENAME = "AssetSheetReport";
    private static final String REPORTTITLE = "AssetSheetReport";
    private static final String[][] LABELS = new String[][]{{"Id", "Description", "StartPeriod", "DepreciationTime", "Depreciated", "Rest", "Investment", "Afschr/Afl.", "BookValue", "Vermeerdering", "Vermindering", "Bijdr. 3den", "Afschrijving", "Aflossing", "Interest", "Kap. lasten", "Investment", "Afschr/Afl.", "BookValue"}};
    private static final int[] SIZES = new int[]{400, 1200, 250, 160, 160, 160, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500};
    private static final boolean[] RIGHTALIGN;
    private int theAccountingPrinciple = 0;
    private int accountingPrinciple = 0;
    private int bookYearForReport = 0;
    private int fromPeriodForReport = 0;
    private int toPeriodForReport = 0;
    private int numberOfColumns = 0;
    private int printedLines = 0;
    private int[] orderByField = null;
    private boolean numericId;
    private boolean credit = false;
    private static final BigDecimal ZERO;
    private BigDecimal OB_A = ZERO;
    private BigDecimal OB_B = ZERO;
    private BigDecimal CY_A = ZERO;
    private BigDecimal CY_B = ZERO;
    private BigDecimal CY_C = ZERO;
    private BigDecimal CY_D = ZERO;
    private BigDecimal CY_E = ZERO;
    private BigDecimal CY_F = ZERO;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private Environment env = null;
    private Credit theCredit = null;
    private Asset asset = null;
    private Valuation valuation = null;
    private AssetSelection selection;

    static {
        boolean[] blArray = new boolean[19];
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        blArray[18] = true;
        RIGHTALIGN = blArray;
        ZERO = new BigDecimal(0.0);
    }

    public GOVAssetSheetToPDF(String reportTitle, String[][] selections, AssetSelection assetSelection, boolean governmentActivated, Environment environment, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear, boolean numericId) throws Exception {
        super(reportTitle, selections, assetSelection.getCollection(), fmsHelper, fisHelper, companyId, bookYear);
        this.env = environment;
        this.numberOfColumns = LABELS[0].length;
        this.numericId = numericId;
        this.selection = assetSelection;
        this.orderByField = assetSelection.getOrderBy();
        this.value = new String[this.numberOfColumns];
        this.bold = new boolean[this.numberOfColumns];
        this.translate = new boolean[this.numberOfColumns];
        this.theAccountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple"));
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple"));
        this.bookYearForReport = Integer.parseInt(this.extractFromSelections("BookYearForReport"));
        this.fromPeriodForReport = Integer.parseInt(this.extractFromSelections("PeriodFrom"));
        this.toPeriodForReport = Integer.parseInt(this.extractFromSelections("PeriodTo"));
        this.init();
    }

    private void init() throws Exception {
        this.document.setPageSize(new Rectangle(2000.0f, 1200.0f));
        this.createTable(true, LABELS, SIZES, RIGHTALIGN, null);
        this.addTableHeaderFirstLine();
        this.addTableHeader(1);
    }

    private void addTableHeaderFirstLine() throws Exception {
        this.resetCellBorders();
        this.setCellBorder(6, 5);
        this.setCellBorder(7, 1);
        this.setCellBorder(8, 1);
        this.setCellBorder(9, 5);
        this.setCellBorder(10, 1);
        this.setCellBorder(11, 1);
        this.setCellBorder(12, 1);
        this.setCellBorder(13, 1);
        this.setCellBorder(14, 1);
        this.setCellBorder(15, 1);
        this.setCellBorder(16, 5);
        this.setCellBorder(17, 1);
        this.setCellBorder(18, 1);
        this.clearCells();
        this.setCell(7, LanguageHelper.getString("nl.ibs.fac.language", "BalanceBegin"), false, false);
        this.setCell(12, LanguageHelper.getString("nl.ibs.fac.language", "CumMutations"), false, false);
        this.setCell(17, LanguageHelper.getString("nl.ibs.fac.language", "BalanceEnd"), false, false);
        this.addTableRow();
        this.resetCellBorders();
        this.setCellBorder(6, 4);
        this.setCellBorder(9, 4);
        this.setCellBorder(16, 4);
    }

    @Override
    protected void processObject(Object object) throws Exception {
        if (object instanceof Credit) {
            this.theCredit = (Credit)object;
            if (this.theAccountingPrinciple == 9) {
                this.accountingPrinciple = 3;
            }
            this.printCredit();
            return;
        }
        this.asset = (Asset)object;
        if (this.theAccountingPrinciple == 9) {
            this.accountingPrinciple = 1;
        }
        Log.debug((String)this.asset.getId());
        this.printSubTotals();
        this.printedLines = 0;
        this.valuation = (Valuation)ValuationBO.getValuation(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), this.accountingPrinciple)[0];
        this.printAsset();
    }

    private void printCredit() throws Exception {
        if (!this.selection.getIncludeDisinvested() && this.theCredit.getClosingYear() > 0 && PeriodHelper.isBefore(this.theCredit.getClosingYear(), this.theCredit.getClosingPeriod(), this.bookYearForReport, this.fromPeriodForReport)) {
            return;
        }
        this.processCreditTransactions();
        if (this.selection.getExcludeBookValueZero() && this.OB_A.subtract(this.OB_B).doubleValue() == 0.0 && this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C).subtract(this.OB_B).subtract(this.CY_D).subtract(this.CY_E).doubleValue() == 0.0) {
            return;
        }
        String[] attr = this.getCreditPrintAttributes();
        int i = 0;
        while (i < attr.length) {
            this.setCell(i, attr[i], false, false);
            ++i;
        }
        if (!this.selection.getJustTotals()) {
            this.addTableRow();
        }
    }

    private String[] getCreditPrintAttributes() throws Exception {
        String[] attr = new String[this.numberOfColumns];
        attr[0] = this.theCredit.getId();
        attr[1] = this.theCredit.getDescription();
        attr[2] = this.theCredit.getStartYear() + "-1";
        attr[3] = "";
        attr[4] = "";
        attr[5] = "";
        attr[6] = IBSDecimal.format(this.OB_A, true);
        attr[7] = IBSDecimal.format(this.OB_B, true);
        attr[8] = IBSDecimal.format(this.OB_A.subtract(this.OB_B), true);
        attr[9] = IBSDecimal.format(this.CY_A, true);
        attr[10] = IBSDecimal.format(this.CY_B, true);
        attr[11] = IBSDecimal.format(this.CY_C, true);
        attr[12] = IBSDecimal.format(this.CY_D, true);
        attr[13] = IBSDecimal.format(this.CY_E, true);
        attr[14] = IBSDecimal.format(this.CY_F, true);
        attr[15] = IBSDecimal.format(this.CY_D.add(this.CY_F), true);
        attr[16] = IBSDecimal.format(this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C), true);
        attr[17] = IBSDecimal.format(this.OB_B.add(this.CY_D).add(this.CY_E), true);
        attr[18] = IBSDecimal.format(this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C).subtract(this.OB_B).subtract(this.CY_D).subtract(this.CY_E), true);
        return attr;
    }

    private void printAsset() throws Exception {
        if (!this.selection.getIncludeDisinvested() && this.asset.getDisinvestmentYear() > 0 && PeriodHelper.isBefore(this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), this.bookYearForReport, this.fromPeriodForReport)) {
            return;
        }
        if (this.valuation == null) {
            return;
        }
        this.processTransactions();
        if (this.selection.getExcludeBookValueZero() && this.OB_A.subtract(this.OB_B).doubleValue() == 0.0 && this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C).subtract(this.OB_B).subtract(this.CY_D).subtract(this.CY_E).doubleValue() == 0.0) {
            return;
        }
        String[] attr = this.getPrintAttributes();
        int i = 0;
        while (i < attr.length) {
            this.setCell(i, attr[i], false, false);
            ++i;
        }
        if (!this.selection.getJustTotals()) {
            this.addTableRow();
        }
        this.cumulate(this.asset);
        ++this.printedLines;
    }

    private String[] getPrintAttributes() throws Exception {
        String[] attr = new String[this.numberOfColumns];
        attr[0] = GOVAssetSheetToPDF.formatAssetId(this.asset, this.numericId);
        attr[1] = this.asset.getDescription();
        attr[2] = this.valuation.getStartDepreciationBookYear() + "-" + this.valuation.getStartDepreciationPeriod();
        attr[3] = "" + this.valuation.getDepreciatableLife();
        attr[4] = "" + this.valuation.getNumberOfDepreciatedPeriods();
        attr[5] = "" + (this.valuation.getDepreciatableLife() - this.valuation.getNumberOfDepreciatedPeriods());
        attr[6] = IBSDecimal.format(this.OB_A, true);
        attr[7] = IBSDecimal.format(this.OB_B, true);
        attr[8] = IBSDecimal.format(this.OB_A.subtract(this.OB_B), true);
        attr[9] = IBSDecimal.format(this.CY_A, true);
        attr[10] = IBSDecimal.format(this.CY_B, true);
        attr[11] = IBSDecimal.format(this.CY_C, true);
        attr[12] = IBSDecimal.format(this.CY_D, true);
        attr[13] = IBSDecimal.format(this.CY_E, true);
        attr[14] = IBSDecimal.format(this.CY_F, true);
        attr[15] = IBSDecimal.format(this.CY_D.add(this.CY_F), true);
        attr[16] = IBSDecimal.format(this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C), true);
        attr[17] = IBSDecimal.format(this.OB_B.add(this.CY_D).add(this.CY_E), true);
        attr[18] = IBSDecimal.format(this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C).subtract(this.OB_B).subtract(this.CY_D).subtract(this.CY_E), true);
        return attr;
    }

    protected void printSubTotals() throws Exception {
        int o = this.orderByField.length;
        int[] orderBy = new int[o];
        int i = 0;
        while (i < this.orderByField.length) {
            orderBy[i] = this.orderByField[--o];
            ++i;
        }
        o = 0;
        while (o < orderBy.length) {
            int lvl = orderBy[o];
            if (lvl > 0 && this.cumulator.getSwitchCumulationLevel(lvl) && (this.cumulator.levelBreak(this.asset, lvl) || this.endOfFile) && (lvl != 8 || this.printedLines > 1)) {
                this.addSubTotalRow(lvl);
            }
            ++o;
        }
        if (this.endOfFile && this.selection.getGrandTotal()) {
            this.addSubTotalRow(0);
        }
    }

    protected void addSubTotalRow(int level) throws Exception {
        String id = (String)this.numericIdTransformer.transform(this.cumulator.getLevelValue(level)[0]);
        String descr = this.cumulator.getLevelValue(level)[1];
        if (level >= 1 && level <= 6) {
            descr = this.getFinDimDescription(id, level - 1);
        }
        BigDecimal[] total = this.getTotalsForLevel(level);
        if (level == 0) {
            this.setCell(0, this.totalGenText, false, true);
            this.setCell(1, "", false, true);
        } else {
            this.setCell(0, this.totalText, false, true);
            this.setCell(1, String.valueOf(this.cumulator.getLevelName(level, this.env)) + " " + id + " (" + descr + ")", false, true);
        }
        this.setCell(2, "", false, true);
        this.setCell(3, "", false, true);
        this.setCell(4, "", false, true);
        this.setCell(5, "", false, true);
        this.setCell(6, IBSDecimal.format(total[6], true), false, true);
        this.setCell(7, IBSDecimal.format(total[7], true), false, true);
        this.setCell(8, IBSDecimal.format(total[8], true), false, true);
        this.setCell(9, IBSDecimal.format(total[9], true), false, true);
        this.setCell(10, IBSDecimal.format(total[10], true), false, true);
        this.setCell(11, IBSDecimal.format(total[11], true), false, true);
        this.setCell(12, IBSDecimal.format(total[12], true), false, true);
        this.setCell(13, IBSDecimal.format(total[13], true), false, true);
        this.setCell(14, IBSDecimal.format(total[14], true), false, true);
        this.setCell(15, IBSDecimal.format(total[15], true), false, true);
        this.setCell(16, IBSDecimal.format(total[16], true), false, true);
        this.setCell(17, IBSDecimal.format(total[17], true), false, true);
        this.setCell(18, IBSDecimal.format(total[18], true), false, true);
        this.addTableRow();
        this.addEmptyTableRow();
    }

    @Override
    protected void addTotalGenRow() throws Exception {
        this.printSubTotals();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            GOVAssetSheetToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(String.valueOf(AssetSelection.ASSETSELECTION) + "2");
        AssetSelection assetSelection = new AssetSelection(String.valueOf(assetSelectionAsString) + assetSelectionAsString2);
        assetSelection.governmentActivated = governmentActivated;
        assetSelection.ap = Integer.parseInt((String)map.get("AccountingPrinciple"));
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        GOVAssetSheetToPDF assetSheetToPDF = new GOVAssetSheetToPDF("AssetSheetReport", selections, assetSelection, governmentActivated, environment, fmsHelper, fisHelper, companyId, bookYear, AssetBO.isIdNumeric(company, false));
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, "AssetSheetReport", "pdf"));
        fos.write(assetSheetToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }

    private void processCreditTransactions() throws Exception {
        this.OB_A = ZERO;
        this.OB_B = ZERO;
        this.CY_A = ZERO;
        this.CY_B = ZERO;
        this.CY_C = ZERO;
        this.CY_D = ZERO;
        this.CY_E = ZERO;
        this.CY_F = ZERO;
        Iterator transactions = TransactionBO.getBeforeOrEquals(this.theCredit, this.bookYearForReport, this.toPeriodForReport, this.accountingPrinciple, true, true).iterator();
        Transaction transaction = null;
        int bookYearTransaction = 0;
        int bookPeriodTransaction = 0;
        while (transactions.hasNext()) {
            transaction = (Transaction)transactions.next();
            bookYearTransaction = transaction.getBookYearForJournalization();
            bookPeriodTransaction = transaction.getPeriodForJournalization();
            switch (transaction.getMainTransactionType()) {
                case 1: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_A = this.OB_A.add(transaction.getAmount1());
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    switch (transaction.getBookingIndicator()) {
                        case 1: {
                            this.CY_B = this.CY_B.add(transaction.getAmount1());
                            break;
                        }
                        case 2: {
                            this.CY_C = this.CY_C.add(transaction.getAmount1());
                            break;
                        }
                        default: {
                            this.CY_A = this.CY_A.add(transaction.getAmount1());
                        }
                    }
                    this.CY_D = this.CY_D.add(transaction.getAmount2());
                    break;
                }
                case 3: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    this.CY_D = this.CY_D.add(transaction.getAmount2());
                    this.CY_F = this.CY_F.add(transaction.getAmount3());
                }
            }
        }
        int bookYearIFT = 0;
        int bookPeriodIFT = 0;
        Collection cbs = CreditBalanceBO.retrieveCreditBalances(this.theCredit);
        for (CreditBalance cb : cbs) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("facLib", this.env.getFacLib());
            map.put("Company", this.companyId);
            map.put("MainAccountFrom", cb.getGLAccountId());
            map.put("MainAccountTo", cb.getGLAccountId());
            Collection ifts = IncomingFinancialTransactionBO.getIncomingFinancialTransactions(map);
            for (IncomingFinancialTransaction ift : ifts) {
                bookYearIFT = ift.getBookYear();
                bookPeriodIFT = ift.getPeriod();
                if (bookYearIFT > this.bookYearForReport || bookYearIFT == this.bookYearForReport && bookPeriodIFT > this.toPeriodForReport) continue;
                if (bookYearIFT < this.bookYearForReport || bookYearIFT == this.bookYearForReport && bookPeriodIFT < this.fromPeriodForReport) {
                    this.OB_A = this.OB_A.add(ift.getUnAllocatedValue());
                    continue;
                }
                switch (ift.getBBVCategory()) {
                    case 1: {
                        this.CY_B = this.CY_B.add(ift.getUnAllocatedValue());
                        break;
                    }
                    case 2: {
                        this.CY_C = this.CY_C.add(ift.getUnAllocatedValue());
                        break;
                    }
                    default: {
                        this.CY_A = this.CY_A.add(ift.getUnAllocatedValue());
                    }
                }
            }
        }
    }

    private void processTransactions() throws Exception {
        this.OB_A = ZERO;
        this.OB_B = ZERO;
        this.CY_A = ZERO;
        this.CY_B = ZERO;
        this.CY_C = ZERO;
        this.CY_D = ZERO;
        this.CY_E = ZERO;
        this.CY_F = ZERO;
        Iterator transactions = TransactionBO.getBeforeOrEquals(this.asset, this.bookYearForReport, this.toPeriodForReport, this.accountingPrinciple, true, true).iterator();
        Transaction transaction = null;
        int bookYearTransaction = 0;
        int bookPeriodTransaction = 0;
        while (transactions.hasNext()) {
            transaction = (Transaction)transactions.next();
            bookYearTransaction = transaction.getBookYearForJournalization();
            bookPeriodTransaction = transaction.getPeriodForJournalization();
            switch (transaction.getMainTransactionType()) {
                case 1: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_A = this.OB_A.add(transaction.getAmount1());
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    if (transaction.getTransactionType() == 20) {
                        if (transaction.getPeriodForJournalization() == 1) {
                            this.OB_A = this.OB_A.add(transaction.getAmount1());
                            this.OB_B = this.OB_B.add(transaction.getAmount2());
                            break;
                        }
                        switch (transaction.getBookingIndicator()) {
                            case 1: {
                                this.CY_B = this.CY_B.add(transaction.getAmount1());
                                break;
                            }
                            case 2: {
                                this.CY_C = this.CY_C.add(transaction.getAmount1());
                                break;
                            }
                            default: {
                                this.CY_A = this.CY_A.add(transaction.getAmount1());
                            }
                        }
                        if (this.asset.getLoan()) {
                            this.CY_E = this.CY_E.add(transaction.getAmount2());
                            break;
                        }
                        this.CY_D = this.CY_D.add(transaction.getAmount2());
                        break;
                    }
                    switch (transaction.getBookingIndicator()) {
                        case 1: {
                            this.CY_B = this.CY_B.add(transaction.getAmount1());
                            break;
                        }
                        case 2: {
                            this.CY_C = this.CY_C.add(transaction.getAmount1());
                            break;
                        }
                        default: {
                            this.CY_A = this.CY_A.add(transaction.getAmount1());
                        }
                    }
                    if (this.asset.getLoan()) {
                        this.CY_E = this.CY_E.add(transaction.getAmount2());
                        break;
                    }
                    this.CY_D = this.CY_D.add(transaction.getAmount2());
                    break;
                }
                case 2: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_A = this.OB_A.add(transaction.getAmount1());
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    this.CY_B = this.CY_B.add(transaction.getAmount1());
                    if (this.asset.getLoan()) {
                        this.CY_E = this.CY_E.add(transaction.getAmount2());
                        break;
                    }
                    this.CY_D = this.CY_D.add(transaction.getAmount2());
                    break;
                }
                case 3: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    if (this.asset.getLoan()) {
                        this.CY_E = this.CY_E.add(transaction.getAmount2());
                    } else {
                        this.CY_D = this.CY_D.add(transaction.getAmount2());
                    }
                    this.CY_F = this.CY_F.add(transaction.getAmount3());
                }
            }
        }
    }
}

