/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public class AnalysisGroupCSV
extends ImportCSVHelper {
    public static final String FILENAME = "AnalysisGroup.csv";
    public static final String CLASSNAME = AnalysisGroupCSV.class.getName();

    public static void main(String[] args) {
        try {
            AnalysisGroupCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = AnalysisGroupCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = AnalysisGroupCSV.getColumnNames(line);
        int size = names.size();
        int[] index = new int[size];
        index[0] = names.indexOf("operationArea");
        index[1] = names.indexOf("dataLib");
        index[2] = names.indexOf("adminId");
        index[3] = names.indexOf("companyId");
        index[4] = names.indexOf("branchId");
        index[5] = names.indexOf("seqNr");
        index[6] = names.indexOf("usage");
        index[7] = names.indexOf("name");
        index[8] = names.indexOf("shortName");
        index[9] = names.indexOf("type");
        index[10] = names.indexOf("length");
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[size];
        String[] saved = new String[size];
        Environment env = null;
        DBData dbData = null;
        line = bufferedReader.readLine();
        while (line != null) {
            ++lineCount;
            if (!(values = AnalysisGroupCSV.getColumnValues(line, values))[index[0]].equals(saved[index[0]]) || !values[index[1]].equals(saved[index[1]])) {
                env = AnalysisGroupCSV.getEnvironment(values[index[0]], values[index[1]]);
                if (env == null) {
                    Log.info((String)("environment not found for: " + values[index[0]] + " " + values[index[1]]));
                    line = bufferedReader.readLine();
                    continue;
                }
                dbData = AnalysisGroupCSV.getDBData(env);
                saved[index[0]] = values[index[0]];
                saved[index[1]] = values[index[1]];
            }
            if (AnalysisGroupCSV.createAnalysisGroup(values, index, dbData)) {
                ++okCount;
            }
            line = bufferedReader.readLine();
        }
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        String message = LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl);
        Log.info((String)message);
    }

    private static boolean createAnalysisGroup(String[] values, int[] index, DBData dbData) throws Exception {
        Object[] result;
        String shortName;
        String name;
        String companyId = values[index[2]];
        if (companyId.length() == 0) {
            companyId = values[index[4]].equals("0") ? values[index[3]] : String.valueOf(values[index[3]]) + '/' + values[index[4]];
        }
        if ((name = values[index[7]]).length() > 50) {
            name = name.substring(0, 49);
        }
        if ((shortName = values[index[8]]).length() > 15) {
            shortName = shortName.substring(0, 14);
        }
        if ((result = AnalysisGroupBO.create(dbData, companyId, Integer.parseInt(values[index[5]]), Integer.parseInt(values[index[6]]), name, shortName, values[index[9]], Integer.parseInt(values[index[10]]), 0, false, 0))[0] != null) {
            Log.info((String)("" + ((AnalysisGroup)result[0]).getSeqNr()));
        }
        if (result[1] != null) {
            Log.info((String)((String)result[1]));
        }
        return result[1] == null;
    }
}

