/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.DateHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.AssetAnalysisCodeBO;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetValueBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.MemoBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public class AssetCSV
extends ImportCSVHelper {
    public static final String FILENAME = "Asset.csv";
    public static final String CLASSNAME = AssetCSV.class.getName();

    public static void main(String[] args) {
        try {
            AssetCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = AssetCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = AssetCSV.getColumnNames(line);
        int size = names.size();
        int[] index = new int[size];
        index[0] = names.indexOf("operationArea");
        index[1] = names.indexOf("dataLib");
        index[2] = names.indexOf("adminId");
        index[3] = names.indexOf("companyId");
        index[4] = names.indexOf("branchId");
        index[5] = names.indexOf("typeCompanyId");
        index[6] = names.indexOf("id");
        index[7] = names.indexOf("description");
        index[8] = names.indexOf("state");
        index[9] = names.indexOf("typeId");
        index[10] = names.indexOf("parentId");
        index[11] = names.indexOf("parentAsset");
        index[12] = names.indexOf("subAsset");
        index[13] = names.indexOf("credit");
        index[14] = names.indexOf("loan");
        index[15] = names.indexOf("currentCapitalization");
        index[16] = names.indexOf("negativeInvestment");
        index[17] = names.indexOf("hasMemo");
        index[18] = names.indexOf("acquisitionDate");
        index[19] = names.indexOf("startUsePeriod");
        index[20] = names.indexOf("startUseYear");
        index[21] = names.indexOf("incomingFinancialTransactionId");
        index[22] = names.indexOf("finDimId1");
        index[23] = names.indexOf("finDimId2");
        index[24] = names.indexOf("finDimId3");
        index[25] = names.indexOf("finDimId4");
        index[26] = names.indexOf("finDimId5");
        index[27] = names.indexOf("facSeqnr1");
        index[28] = names.indexOf("facDimId1");
        index[29] = names.indexOf("facSeqnr2");
        index[30] = names.indexOf("facDimId2");
        index[31] = names.indexOf("facSeqnr3");
        index[32] = names.indexOf("facDimId3");
        index[33] = names.indexOf("facSeqnr4");
        index[34] = names.indexOf("facDimId4");
        index[35] = names.indexOf("facSeqnr5");
        index[36] = names.indexOf("facDimId5");
        index[37] = names.indexOf("facSeqnr6");
        index[38] = names.indexOf("facDimId6");
        index[39] = names.indexOf("facSeqnr7");
        index[40] = names.indexOf("facDimId7");
        index[41] = names.indexOf("facSeqnr8");
        index[42] = names.indexOf("facDimId8");
        index[43] = names.indexOf("facSeqnr9");
        index[44] = names.indexOf("facDimId9");
        index[45] = names.indexOf("facSeqnr10");
        index[46] = names.indexOf("facDimId10");
        index[47] = names.indexOf("creditState");
        index[48] = names.indexOf("councilDecision");
        index[49] = names.indexOf("councilDecisionDate");
        index[50] = names.indexOf("originId");
        index[51] = names.indexOf("creditAccount");
        index[52] = names.indexOf("costAccount");
        index[53] = names.indexOf("memo");
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[size];
        String[] saved = new String[size];
        Environment env = null;
        DBData dbData = null;
        String companyId = null;
        String savedCompanyId = null;
        String[] iftValues = new String[2];
        HashMap<String, String> iftIds = new HashMap<String, String>();
        FMSHelper fmsHelper = null;
        Company company = null;
        line = bufferedReader.readLine();
        while (line != null) {
            ++lineCount;
            if (!(values = AssetCSV.getColumnValues(line, values))[index[0]].equals(saved[index[0]]) || !values[index[1]].equals(saved[index[1]])) {
                env = AssetCSV.getEnvironment(values[index[0]], values[index[1]]);
                if (env == null) {
                    Log.info((String)("environment not found for: " + values[index[0]] + " " + values[index[1]]));
                    line = bufferedReader.readLine();
                    continue;
                }
                dbData = AssetCSV.getDBData(env);
                saved[index[0]] = values[index[0]];
                saved[index[1]] = values[index[1]];
            }
            if ((companyId = values[index[2]]).length() == 0) {
                companyId = values[index[4]].equals("0") ? values[index[3]] : String.valueOf(values[index[3]]) + '/' + values[index[4]];
            } else {
                fmsHelper = new FMSHelper(loginHelper);
            }
            if (!companyId.equals(savedCompanyId)) {
                BufferedReader iftIdReader;
                if (fmsHelper != null && company != null) {
                    loginHelper.logout(env, savedCompanyId, "" + company.getCurrentBookYear());
                }
                if (fmsHelper != null && (message = loginHelper.login(env, companyId, "" + (company = (Company)CompanyBO.get(dbData, companyId)[0]).getCurrentBookYear())) != null && message.trim().length() > 0) {
                    Log.error((String)message);
                    loginHelper.logout();
                    return;
                }
                try {
                    iftIdReader = AssetCSV.getReader(String.valueOf(AssetCSV.getFolderName(map, contextName)) + '/' + "IFT" + companyId.replace('/', '_') + ".csv");
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                    iftIdReader = null;
                }
                if (iftIdReader != null) {
                    String iftLine = iftIdReader.readLine();
                    while (iftLine != null) {
                        iftValues = AssetCSV.getColumnValues(iftLine, iftValues);
                        iftIds.put(iftValues[0], iftValues[1]);
                        iftLine = iftIdReader.readLine();
                    }
                }
                savedCompanyId = companyId;
            }
            if (AssetCSV.createAsset(values, index, dbData, fmsHelper, iftIds)) {
                ++okCount;
            }
            line = bufferedReader.readLine();
        }
        if (fmsHelper != null && company != null) {
            loginHelper.logout(env, companyId, "" + company.getCurrentBookYear());
        }
        loginHelper.logout();
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        message = LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl);
        Log.info((String)message);
    }

    private static boolean createAsset(String[] values, int[] index, DBData dbData, FMSHelper fmsHelper, HashMap iftIds) throws Exception {
        String incomingFinancialTransactionId;
        Date acquisitionDate;
        String description;
        String finDimId5;
        String finDimId4;
        String finDimId3;
        String finDimId2;
        String finDimId1 = values[index[22]];
        if (finDimId1.startsWith("'")) {
            finDimId1 = finDimId1.substring(1);
        }
        if ((finDimId2 = values[index[23]]).startsWith("'")) {
            finDimId2 = finDimId2.substring(1);
        }
        if ((finDimId3 = values[index[24]]).startsWith("'")) {
            finDimId3 = finDimId3.substring(1);
        }
        if ((finDimId4 = values[index[25]]).startsWith("'")) {
            finDimId4 = finDimId4.substring(1);
        }
        if ((finDimId5 = values[index[26]]).startsWith("'")) {
            finDimId5 = finDimId5.substring(1);
        }
        String companyId = values[index[2]];
        String dataSetId = values[index[5]];
        if (companyId.length() == 0) {
            companyId = values[index[4]].equals("0") ? values[index[3]] : String.valueOf(values[index[3]]) + '/' + values[index[4]];
            int i = dataSetId.indexOf(47);
            if (i > 0 && dataSetId.substring(i + 1).equals("0")) {
                dataSetId = dataSetId.substring(0, i);
            }
            finDimId1 = FISHelper.formatId(finDimId1, 1);
            finDimId2 = FISHelper.formatId(finDimId2, 2);
            finDimId3 = FISHelper.formatId(finDimId3, 3);
            finDimId4 = FISHelper.formatId(finDimId4, 4);
            finDimId5 = FISHelper.formatId(finDimId5, 5);
        } else {
            finDimId1 = AssetCSV.formatFMSId(finDimId1, 1, fmsHelper);
            finDimId2 = AssetCSV.formatFMSId(finDimId2, 2, fmsHelper);
            finDimId3 = AssetCSV.formatFMSId(finDimId3, 3, fmsHelper);
            finDimId4 = AssetCSV.formatFMSId(finDimId4, 4, fmsHelper);
            finDimId5 = "";
        }
        if (dataSetId.length() == 0) {
            dataSetId = companyId;
        }
        if ((description = values[index[7]]).length() > 50) {
            description = description.substring(0, 49);
        }
        boolean parentAsset = false;
        if ("true".equals(values[index[11]].toLowerCase())) {
            parentAsset = true;
        }
        boolean subAsset = false;
        if ("true".equals(values[index[12]].toLowerCase())) {
            subAsset = true;
        }
        boolean credit = false;
        if ("true".equals(values[index[13]].toLowerCase())) {
            credit = true;
        }
        boolean loan = false;
        if ("true".equals(values[index[14]].toLowerCase())) {
            loan = true;
        }
        boolean currentCapitalization = false;
        if ("true".equals(values[index[15]].toLowerCase())) {
            currentCapitalization = true;
        }
        boolean negativeInvestment = false;
        if ("true".equals(values[index[16]].toLowerCase())) {
            negativeInvestment = true;
        }
        boolean hasMemo = false;
        if ("true".equals(values[index[17]].toLowerCase())) {
            hasMemo = true;
        }
        if ((acquisitionDate = DateHelper.getDate(values[index[18]])) == null) {
            Log.info((String)"acquisitionDate==null");
            acquisitionDate = new Date();
        }
        if ((incomingFinancialTransactionId = values[index[21]]).startsWith("'")) {
            incomingFinancialTransactionId = incomingFinancialTransactionId.substring(1);
        }
        incomingFinancialTransactionId = (String)iftIds.get(incomingFinancialTransactionId);
        Object[] result = AssetBO.create(dbData, companyId, values[index[6]], description, Integer.parseInt(values[index[8]]), dataSetId, values[index[9]], values[index[10]], parentAsset, subAsset, credit, loan, currentCapitalization, negativeInvestment, hasMemo, acquisitionDate, Integer.parseInt(values[index[19]]), Integer.parseInt(values[index[20]]), 0, 0, incomingFinancialTransactionId, finDimId1, finDimId2, finDimId3, finDimId4, finDimId5, Integer.parseInt(values[index[47]]), values[index[48]], DateHelper.getDate(values[index[49]]), values[index[50]]);
        if (result[1] == null) {
            String text;
            Asset asset = (Asset)result[0];
            Log.info((String)asset.getId());
            if (index[51] > -1) {
                text = values[index[51]];
                if (text.startsWith("'")) {
                    text = text.substring(1);
                }
                if (text.length() > 0) {
                    asset.setCreditId(AssetCSV.formatFMSId(text, 1, fmsHelper));
                }
            }
            if (index[52] > -1) {
                text = values[index[52]];
                if (text.startsWith("'")) {
                    text = text.substring(1);
                }
                if (text.length() > 0) {
                    asset.setFinDimId5(AssetCSV.formatFMSId(text, 1, fmsHelper));
                }
            }
            if ((text = values[index[53]]).length() > 0) {
                MemoBO.create(asset, text);
            }
            int x = 27;
            int i = 0;
            while (i < 10) {
                if (values[index[x]].length() > 0 && values[index[x + 1]].length() > 0) {
                    int seqNr;
                    String value = values[index[x + 1]];
                    if (value.startsWith("'")) {
                        value = value.substring(1);
                    }
                    if ((result = AnalysisGroupBO.get(dbData, companyId, seqNr = Integer.parseInt(values[index[x]])))[1] != null) {
                        Log.info((String)((String)result[1]));
                    } else {
                        AnalysisGroup analysisGroup = (AnalysisGroup)result[0];
                        if (analysisGroup.getUsage() == 2) {
                            result = AssetValueBO.create(dbData, companyId, asset.getCora(), asset.getId(), analysisGroup, value);
                        }
                        if (analysisGroup.getUsage() == 1) {
                            value = value.toUpperCase();
                            result = AssetAnalysisCodeBO.create(dbData, companyId, asset.getCora(), asset.getId(), dataSetId, seqNr, value);
                            if (result[1] != null) {
                                Log.info((String)((String)result[1]));
                            }
                        }
                        analysisGroup.getUsage();
                    }
                }
                x += 2;
                ++i;
            }
        }
        if (result[1] != null) {
            Log.info((String)((String)result[1]));
        }
        return result[1] == null;
    }

    private static String formatFMSId(String finDimId, int index, FMSHelper fmsHelper) throws Exception {
        if (finDimId == null || finDimId.trim().length() == 0) {
            return finDimId;
        }
        String[] dimensionAttributes = fmsHelper.getDimensionAttributes(index);
        if (dimensionAttributes[0].equals("N")) {
            try {
                finDimId = "" + Integer.parseInt(finDimId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fmsHelper.formatId(finDimId, index);
    }
}

