/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.AnalysisCodeBO;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.AssetAnalysisCodeBO;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetValueBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class AssetCodeAndValueCSV
extends ImportCSVHelper {
    public static final String FILENAME = "AssetCodeAndValue.csv";
    public static final String CLASSNAME = AssetCodeAndValueCSV.class.getName();
    private static final int NUMBEROFCOLUMNS = 13;

    public static void main(String[] args) {
        try {
            AssetCodeAndValueCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    protected static void printColumnNames(List names, int[] index, FileOutputStream fos) throws Exception {
        fos.write("error;".getBytes());
        Iterator iterator = names.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (index[i] != -1) {
                fos.write((String.valueOf(value) + ';').getBytes());
            }
            ++i;
        }
        fos.write(FacConstants.EOL.getBytes());
    }

    protected static void printError(String[] values, int[] index, String message, FileOutputStream fos) throws Exception {
        fos.write((String.valueOf(message) + ';').getBytes());
        int i = 0;
        while (i < values.length) {
            if (index[i] != -1) {
                if (values[i] != null) {
                    fos.write((String.valueOf(values[i]) + ';').getBytes());
                } else {
                    fos.write(";".getBytes());
                }
            }
            ++i;
        }
        fos.write(FacConstants.EOL.getBytes());
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = AssetCodeAndValueCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = AssetCodeAndValueCSV.getColumnNames(line);
        int[] index = new int[]{names.indexOf("id"), names.indexOf("seqNr1"), names.indexOf("value1"), names.indexOf("seqNr2"), names.indexOf("value2"), names.indexOf("seqNr3"), names.indexOf("value3"), names.indexOf("seqNr4"), names.indexOf("value4"), names.indexOf("seqNr5"), names.indexOf("value5"), names.indexOf("seqNr6"), names.indexOf("value6")};
        FileOutputStream fos = AssetCodeAndValueCSV.createErrorOutputStream(args, "AssetCodeAndValueErrors", "csv");
        AssetCodeAndValueCSV.printColumnNames(names, index, fos);
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        String dataSetId = companyId;
        if (company.getDataSetId() != null) {
            dataSetId = company.getDataSetId();
        }
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[13];
        line = bufferedReader.readLine();
        while (line != null) {
            ++lineCount;
            values = AssetCodeAndValueCSV.getColumnValues(line, values);
            try {
                if (AssetCodeAndValueCSV.addCodesAndValues(values, index, dbData, company, dataSetId, loginHelper.getUser(), fos)) {
                    ++okCount;
                }
            }
            catch (Exception e) {
                if (Log.debug()) {
                    e.printStackTrace();
                }
                AssetCodeAndValueCSV.printError(values, index, e.getMessage(), fos);
            }
            line = bufferedReader.readLine();
        }
        loginHelper.logout();
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        message = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl)) + FacConstants.EOL;
        fos.write(message.getBytes());
        fos.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addCodesAndValues(String[] values, int[] index, DBData dbData, Company company, String dataSetId, String user, FileOutputStream fos) throws Exception {
        int x = 1;
        Object[] result = AssetBO.get(company, values[index[0]], false);
        if (result[1] != null) {
            AssetCodeAndValueCSV.printError(values, index, String.valueOf((String)result[1]) + " - asset", fos);
            return false;
        }
        Asset asset = (Asset)result[0];
        if (index[0] == -1 || index[1] == -1 || index[2] == -1) {
            AssetCodeAndValueCSV.printError(values, index, "Invalid layout", fos);
            return false;
        }
        if (values[index[0]] == null || values[index[1]] == null || values[index[2]] == null) {
            AssetCodeAndValueCSV.printError(values, index, "Mandatory content missing", fos);
            return false;
        }
        if (values[index[0]].length() == 0 || values[index[1]].length() == 0 || values[index[2]].length() == 0) {
            AssetCodeAndValueCSV.printError(values, index, "Mandatory content missing", fos);
            return false;
        }
        BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            int i = 0;
            while (true) {
                if (i >= 6) {
                    BOAdapter.commitTransaction();
                    return true;
                }
                if (index[x] != -1 && index[x + 1] != -1 && values[index[x]] != null && values[index[x + 1]] != null) {
                    if (values[index[x]].length() > 0 && values[index[x + 1]].length() > 0) {
                        String value = values[index[x + 1]];
                        int seqNr = Integer.parseInt(values[index[x]]);
                        result = AnalysisGroupBO.get(dbData, dataSetId, seqNr);
                        if (result[1] != null) {
                            AssetCodeAndValueCSV.printError(values, index, String.valueOf((String)result[1]) + " - anal. group", fos);
                            BOAdapter.investigate(null, dbTransaction);
                            return false;
                        }
                        AnalysisGroup analysisGroup = (AnalysisGroup)result[0];
                        if (analysisGroup.getUsage() != 2 && analysisGroup.getUsage() != 1) {
                            AssetCodeAndValueCSV.printError(values, index, "Anal. group type not supported", fos);
                            BOAdapter.investigate(null, dbTransaction);
                            return false;
                        }
                        if (value.length() > analysisGroup.getLength()) {
                            AssetCodeAndValueCSV.printError(values, index, "Max. length exceeded", fos);
                            BOAdapter.investigate(null, dbTransaction);
                            return false;
                        }
                        if ("N".equals(analysisGroup.getType())) {
                            try {
                                Integer.parseInt(value);
                            }
                            catch (NumberFormatException nfe) {
                                AssetCodeAndValueCSV.printError(values, index, nfe.getMessage(), fos);
                                BOAdapter.investigate(null, dbTransaction);
                                return false;
                            }
                        }
                        if (analysisGroup.getUsage() == 2 && (result = AssetValueBO.create(dbData, company.getId(), "A", asset.getId(), analysisGroup, value))[1] != null) {
                            AssetCodeAndValueCSV.printError(values, index, (String)result[1], fos);
                            BOAdapter.investigate(null, dbTransaction);
                            return false;
                        }
                        if (analysisGroup.getUsage() == 1) {
                            result = AnalysisCodeBO.get(dbData, analysisGroup, value = value.toUpperCase());
                            if (result[1] != null) {
                                AssetCodeAndValueCSV.printError(values, index, String.valueOf((String)result[1]) + " - anal. code", fos);
                                BOAdapter.investigate(null, dbTransaction);
                                return false;
                            }
                            result = AssetAnalysisCodeBO.create(dbData, company.getId(), asset.getCora(), asset.getId(), dataSetId, seqNr, value);
                            if (result[1] != null) {
                                AssetCodeAndValueCSV.printError(values, index, (String)result[1], fos);
                                BOAdapter.investigate(null, dbTransaction);
                                return false;
                            }
                        }
                    }
                    x += 2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            String message = BOAdapter.investigate(e, dbTransaction);
            AssetCodeAndValueCSV.printError(values, index, message, fos);
            return false;
        }
    }
}

