/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.DateHelper;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.GenericUsageEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.CurrentCapitalizationBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class CurrentCapitalizationCSV
extends ImportCSVHelper {
    public static final String FILENAME = "CurrentCapitalization.csv";
    public static final String CLASSNAME = CurrentCapitalizationCSV.class.getName();
    private static final String IS_PARENT = "isParent";
    private static final String IS_AP2_PRESENT = "isAP2Present";
    private static final int numberOfColumns = 58;

    public static void main(String[] args) {
        try {
            CurrentCapitalizationCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    protected static void printColumnNames(List names, int[] index, FileOutputStream fos) throws Exception {
        fos.write("error;".getBytes());
        Iterator iterator = names.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (index[i] != -1) {
                fos.write((String.valueOf(value) + ';').getBytes());
            }
            ++i;
        }
        fos.write(FacConstants.EOL.getBytes());
    }

    protected static void printError(String[] values, int[] index, String message, FileOutputStream fos) throws Exception {
        fos.write((String.valueOf(message) + ';').getBytes());
        int i = 0;
        while (i < values.length) {
            if (index[i] != -1) {
                if (values[i] != null) {
                    fos.write((String.valueOf(values[i]) + ';').getBytes());
                } else {
                    fos.write(";".getBytes());
                }
            }
            ++i;
        }
        fos.write(FacConstants.EOL.getBytes());
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = CurrentCapitalizationCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = CurrentCapitalizationCSV.getColumnNames(line);
        int[] index = new int[58];
        index[0] = names.indexOf("id");
        index[1] = names.indexOf("description");
        index[2] = names.indexOf("typeId");
        index[3] = names.indexOf("finDimId1");
        index[4] = names.indexOf("finDimId2");
        index[5] = names.indexOf("finDimId3");
        index[6] = names.indexOf("finDimId4");
        index[7] = names.indexOf("finDimId5");
        index[8] = names.indexOf(IS_PARENT);
        index[9] = names.indexOf(IS_AP2_PRESENT);
        index[10] = names.indexOf("parentId");
        index[11] = names.indexOf("postedAcquisitionBalance");
        index[12] = names.indexOf("negativeInvestment");
        index[50] = names.indexOf("loan");
        index[51] = names.indexOf("payOffYearAmount");
        index[13] = names.indexOf("acquisitionDate");
        index[14] = names.indexOf("startUsePeriod");
        index[15] = names.indexOf("startUseYear");
        index[16] = names.indexOf("periodForJournalization");
        index[17] = names.indexOf("bookYearForJournalization");
        index[18] = names.indexOf("historicalPeriod");
        index[19] = names.indexOf("historicalYear");
        index[20] = names.indexOf("depreciationMethod");
        index[21] = names.indexOf("degressivePercentage");
        index[22] = names.indexOf("yearPercentageTableId");
        index[23] = names.indexOf("startDepreciationBookYear");
        index[24] = names.indexOf("startDepreciationPeriod");
        index[25] = names.indexOf("depreciatableLife");
        index[26] = names.indexOf("residualValue");
        index[27] = names.indexOf("depreciationPaused");
        index[28] = names.indexOf("interestCalculationMethod");
        index[29] = names.indexOf("interestTableId");
        index[30] = names.indexOf("interestPercentage");
        index[31] = names.indexOf("numberOfDepreciatedPeriods");
        index[32] = names.indexOf("postedDepreciationBalance");
        index[33] = names.indexOf("residualPercentage");
        index[34] = names.indexOf("annuityPercentage");
        index[56] = names.indexOf("annuityInterestTableId");
        index[52] = names.indexOf("beyondEconomicLifePercentage");
        index[53] = names.indexOf("postedDepreciationBalanceBeyondEconomicLife");
        index[35] = names.indexOf("depreciationMethod2");
        index[36] = names.indexOf("degressivePercentage2");
        index[37] = names.indexOf("yearPercentageTableId2");
        index[38] = names.indexOf("startDepreciationBookYear2");
        index[39] = names.indexOf("startDepreciationPeriod2");
        index[40] = names.indexOf("depreciatableLife2");
        index[41] = names.indexOf("residualValue2");
        index[42] = names.indexOf("depreciationPaused2");
        index[43] = names.indexOf("interestCalculationMethod2");
        index[44] = names.indexOf("interestTableId2");
        index[45] = names.indexOf("interestPercentage2");
        index[46] = names.indexOf("numberOfDepreciatedPeriods2");
        index[47] = names.indexOf("postedDepreciationBalance2");
        index[48] = names.indexOf("residualPercentage2");
        index[49] = names.indexOf("annuityPercentage2");
        index[57] = names.indexOf("annuityInterestTableId2");
        index[54] = names.indexOf("beyondEconomicLifePercentage2");
        index[55] = names.indexOf("postedDepreciationBalanceBeyondEconomicLife2");
        FileOutputStream fos = CurrentCapitalizationCSV.createErrorOutputStream(args, "CurrentCapitalizationErrors", "csv");
        CurrentCapitalizationCSV.printColumnNames(names, index, fos);
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        String dataSetId = companyId;
        if (company.getDataSetId() != null) {
            dataSetId = company.getDataSetId();
        }
        FMSHelper fmsHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
            message = loginHelper.login(environment, companyId, "" + company.getCurrentBookYear());
            if (message != null && message.trim().length() > 0) {
                Log.error((String)message);
                loginHelper.logout();
                return;
            }
        }
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[58];
        line = bufferedReader.readLine();
        while (line != null) {
            ++lineCount;
            values = CurrentCapitalizationCSV.getColumnValues(line, values);
            try {
                if (CurrentCapitalizationCSV.createAsset(values, index, dbData, company, dataSetId, fmsHelper, loginHelper.getUser(), fos)) {
                    ++okCount;
                }
            }
            catch (Exception e) {
                if (Log.debug()) {
                    e.printStackTrace();
                }
                CurrentCapitalizationCSV.printError(values, index, e.getMessage(), fos);
            }
            line = bufferedReader.readLine();
        }
        if (fmsHelper != null) {
            loginHelper.logout(environment, companyId, "" + company.getCurrentBookYear());
        }
        loginHelper.logout();
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        message = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl)) + FacConstants.EOL;
        fos.write(message.getBytes());
        fos.close();
    }

    private static boolean createAsset(String[] values, int[] index, DBData dbData, Company company, String dataSetId, FMSHelper fmsHelper, String user, FileOutputStream fos) throws Exception {
        block81: {
            int seqNr;
            int documentNr;
            Valuation valuation;
            BigDecimal postedDepreciationBalanceBeyondEconomicLife;
            BigDecimal acquisitionValue;
            int bookYear;
            int bookPeriod;
            Asset asset;
            DBTransaction dbTransaction;
            Object[] result;
            block80: {
                BigDecimal beyondEconomicLifePercentage;
                BigDecimal postedDepreciationBalance;
                int numberOfDepreciatedPeriods;
                int depreciatableLife;
                String interestTable;
                BigDecimal interestPercentage;
                int interestMethod;
                BigDecimal residualPercentage;
                BigDecimal residualValue;
                int startDepreciationPeriod;
                int startDepreciationBookYear;
                String annuityInterestTable;
                String yearPercentageTable;
                BigDecimal annuityPercentage;
                BigDecimal degressivePercentage;
                boolean depreciationPaused;
                int depreciationMethod;
                block79: {
                    block78: {
                        block77: {
                            BigDecimal payOffYearAmount;
                            block76: {
                                String description;
                                int depreciatableLife2;
                                String finDimId5;
                                String finDimId4;
                                String finDimId3;
                                String finDimId2;
                                String finDimId1 = values[index[3]];
                                if (finDimId1.startsWith("'")) {
                                    finDimId1 = finDimId1.substring(1);
                                }
                                if ((finDimId2 = values[index[4]]).startsWith("'")) {
                                    finDimId2 = finDimId2.substring(1);
                                }
                                if ((finDimId3 = values[index[5]]).startsWith("'")) {
                                    finDimId3 = finDimId3.substring(1);
                                }
                                if ((finDimId4 = values[index[6]]).startsWith("'")) {
                                    finDimId4 = finDimId4.substring(1);
                                }
                                if ((finDimId5 = values[index[7]]).startsWith("'")) {
                                    finDimId5 = finDimId5.substring(1);
                                }
                                String typeId = values[index[2]];
                                result = AssetTypeBO.get(dbData, dataSetId, typeId);
                                AssetType assetType = (AssetType)AssetTypeBO.get(dbData, dataSetId, typeId)[0];
                                if (assetType == null) {
                                    CurrentCapitalizationCSV.printError(values, index, "Type: " + (String)result[1], fos);
                                    return false;
                                }
                                if (assetType.getAccountingPrinciple2IsUsed() && !"true".equals(values[index[9]].toLowerCase())) {
                                    String message = "AccountingPrinciple2: " + GenericUsageEnum.getValue(2);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (!assetType.getAccountingPrinciple2IsUsed() && "true".equals(values[index[9]].toLowerCase())) {
                                    String message = "AccountingPrinciple2: " + GenericUsageEnum.getValue(0);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension1Usage() == 2 && finDimId1.trim().length() == 0) {
                                    String message = "finDimId1: " + GenericUsageEnum.getValue(2);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension1Usage() == 0 && finDimId1.trim().length() > 0) {
                                    String message = "finDimId1: " + GenericUsageEnum.getValue(0);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension2Usage() == 2 && finDimId2.trim().length() == 0) {
                                    String message = "finDimId2: " + GenericUsageEnum.getValue(2);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension2Usage() == 0 && finDimId2.trim().length() > 0) {
                                    String message = "finDimId2: " + GenericUsageEnum.getValue(0);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension3Usage() == 2 && finDimId3.trim().length() == 0) {
                                    String message = "finDimId3: " + GenericUsageEnum.getValue(2);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension3Usage() == 0 && finDimId3.trim().length() > 0) {
                                    String message = "finDimId3: " + GenericUsageEnum.getValue(0);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension4Usage() == 2 && finDimId4.trim().length() == 0) {
                                    String message = "finDimId4: " + GenericUsageEnum.getValue(2);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension4Usage() == 0 && finDimId4.trim().length() > 0) {
                                    String message = "finDimId4: " + GenericUsageEnum.getValue(0);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension5Usage() == 2 && finDimId5.trim().length() == 0) {
                                    String message = "finDimId5: " + GenericUsageEnum.getValue(2);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (assetType.getFinancialDimension5Usage() == 0 && finDimId5.trim().length() > 0) {
                                    String message = "finDimId5: " + GenericUsageEnum.getValue(0);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                if (fmsHelper == null) {
                                    finDimId1 = FISHelper.formatId(finDimId1, 1);
                                    finDimId2 = FISHelper.formatId(finDimId2, 2);
                                    finDimId3 = FISHelper.formatId(finDimId3, 3);
                                    finDimId4 = FISHelper.formatId(finDimId4, 4);
                                    finDimId5 = FISHelper.formatId(finDimId5, 5);
                                } else {
                                    finDimId1 = fmsHelper.formatId(finDimId1, 1);
                                    finDimId2 = fmsHelper.formatId(finDimId2, 2);
                                    finDimId3 = fmsHelper.formatId(finDimId3, 3);
                                    finDimId4 = fmsHelper.formatId(finDimId4, 4);
                                    finDimId5 = "";
                                }
                                depreciationMethod = 99;
                                if (index[20] != -1 && values[index[20]] != null && values[index[20]].trim().length() > 0) {
                                    depreciationMethod = Integer.parseInt(values[index[20]]);
                                }
                                if (depreciationMethod == 11) {
                                    depreciatableLife2 = 0;
                                    if (index[25] != -1 && values[index[25]] != null && values[index[25]].trim().length() > 0) {
                                        depreciatableLife2 = Integer.parseInt(values[index[25]].trim());
                                    }
                                    if (depreciatableLife2 % company.getNumberOfPeriods() != 0) {
                                        String message = "depreciatableLife_in_complete_years";
                                        CurrentCapitalizationCSV.printError(values, index, message, fos);
                                        return false;
                                    }
                                }
                                depreciationMethod = 99;
                                if (index[35] != -1 && values[index[35]] != null && values[index[35]].trim().length() > 0 && (depreciationMethod = Integer.parseInt(values[index[35]])) == 11) {
                                    depreciatableLife2 = 0;
                                    if (index[40] != -1 && values[index[40]] != null && values[index[40]].trim().length() > 0) {
                                        depreciatableLife2 = Integer.parseInt(values[index[40]].trim());
                                    }
                                    if (depreciatableLife2 % company.getNumberOfPeriods() != 0) {
                                        String message = "depreciatableLife_in_complete_years";
                                        CurrentCapitalizationCSV.printError(values, index, message, fos);
                                        return false;
                                    }
                                }
                                if ((description = values[index[1]]).length() > 50) {
                                    description = description.substring(0, 49);
                                }
                                String parentId = "";
                                boolean subAsset = true;
                                boolean parentAsset = true;
                                boolean currentCapitalization = true;
                                boolean negativeInvestment = false;
                                boolean loan = false;
                                Date acquisitionDate = null;
                                int historicalYear = 0;
                                int historicalPeriod = 0;
                                if ("true".equals(values[index[8]].toLowerCase())) {
                                    block75: {
                                        subAsset = false;
                                        currentCapitalization = false;
                                        BOAdapter.beginTransaction();
                                        DBTransaction dbTransaction2 = DBPersistenceManager.getCurrentTransaction();
                                        try {
                                            result = AssetBO.create(dbData, company.getId(), values[index[0]], description, 0, dataSetId, typeId, "", parentAsset, subAsset, false, loan, currentCapitalization, negativeInvestment, false, new Date(), 0, 0, 0, 0, null, finDimId1, finDimId2, finDimId3, finDimId4, finDimId5, 0, "", null, "");
                                            if (result[1] == null) break block75;
                                            CurrentCapitalizationCSV.printError(values, index, (String)result[1], fos);
                                            BOAdapter.investigate(null, dbTransaction2);
                                            return false;
                                        }
                                        catch (Exception e) {
                                            String message = BOAdapter.investigate(e, dbTransaction2);
                                            CurrentCapitalizationCSV.printError(values, index, message, fos);
                                            return false;
                                        }
                                    }
                                    Asset asset2 = (Asset)result[0];
                                    Log.info((String)asset2.getId());
                                    BOAdapter.commitTransaction();
                                    return true;
                                }
                                if (index[10] != -1 && values[index[10]] != null && values[index[10]].trim().length() > 0) {
                                    parentId = values[index[10]].trim();
                                    parentAsset = false;
                                }
                                if (index[12] != -1 && values[index[12]] != null && "true".equals(values[index[12]].toLowerCase())) {
                                    negativeInvestment = true;
                                }
                                if (index[50] != -1 && values[index[50]] != null && "true".equals(values[index[50]].toLowerCase())) {
                                    loan = true;
                                }
                                boolean typeIs3rdPartyLoan = assetType.getIs3rdPartyLoan();
                                if (loan && !typeIs3rdPartyLoan || !loan && typeIs3rdPartyLoan) {
                                    String message = "wrong_asset_type_combination_for_loan";
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                                payOffYearAmount = index[51] != -1 && values[index[51]] != null && values[index[51]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[51]].trim()) : new BigDecimal("0");
                                if (index[13] != -1 && values[index[13]] != null && values[index[13]].trim().length() > 0) {
                                    acquisitionDate = DateHelper.getDate(values[index[13]]);
                                }
                                if (acquisitionDate == null) {
                                    acquisitionDate = new Date();
                                }
                                if (index[18] != -1 && values[index[18]] != null && values[index[18]].trim().length() > 0) {
                                    historicalPeriod = Integer.parseInt(values[index[18]].trim());
                                }
                                if (index[19] != -1 && values[index[19]] != null && values[index[19]].trim().length() > 0) {
                                    historicalYear = Integer.parseInt(values[index[19]].trim());
                                }
                                BOAdapter.beginTransaction();
                                dbTransaction = DBPersistenceManager.getCurrentTransaction();
                                try {
                                    result = AssetBO.create(dbData, company.getId(), values[index[0]], description, 0, dataSetId, typeId, parentId, parentAsset, subAsset, false, loan, currentCapitalization, negativeInvestment, false, acquisitionDate, Integer.parseInt(values[index[14]]), Integer.parseInt(values[index[15]]), historicalPeriod, historicalYear, null, finDimId1, finDimId2, finDimId3, finDimId4, finDimId5, 0, "", null, "");
                                    if (result[1] == null) break block76;
                                    CurrentCapitalizationCSV.printError(values, index, (String)result[1], fos);
                                    BOAdapter.investigate(null, dbTransaction);
                                    return false;
                                }
                                catch (Exception e) {
                                    String message = BOAdapter.investigate(e, dbTransaction);
                                    CurrentCapitalizationCSV.printError(values, index, message, fos);
                                    return false;
                                }
                            }
                            asset = (Asset)result[0];
                            Log.info((String)asset.getId());
                            if (asset.getLoan() && payOffYearAmount.doubleValue() != 0.0) {
                                asset.setPayOffYearAmount(payOffYearAmount);
                            }
                            bookPeriod = Integer.parseInt(values[index[14]]);
                            bookYear = Integer.parseInt(values[index[15]]);
                            if (index[16] != -1 && values[index[16]] != null && values[index[16]].trim().length() > 0) {
                                bookPeriod = Integer.parseInt(values[index[16]]);
                            }
                            if (index[17] != -1 && values[index[17]] != null && values[index[17]].trim().length() > 0) {
                                bookYear = Integer.parseInt(values[index[17]]);
                            }
                            acquisitionValue = index[11] != -1 && values[index[11]] != null && values[index[11]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[11]]) : new BigDecimal("0");
                            depreciationPaused = false;
                            depreciationPaused = false;
                            if (index[27] != -1 && values[index[27]] != null && "true".equals(values[index[27]].toLowerCase())) {
                                depreciationPaused = true;
                            }
                            degressivePercentage = new BigDecimal("0");
                            annuityPercentage = new BigDecimal("0");
                            yearPercentageTable = "";
                            annuityInterestTable = "";
                            depreciationMethod = 99;
                            if (index[20] != -1 && values[index[20]] != null && values[index[20]].trim().length() > 0) {
                                depreciationMethod = Integer.parseInt(values[index[20]]);
                            }
                            if (depreciationMethod == 2 && index[21] != -1 && values[index[21]] != null && values[index[21]].trim().length() > 0) {
                                degressivePercentage = CurrentCapitalizationCSV.createBigDecimal(values[index[21]].trim());
                            }
                            if (depreciationMethod == 3 && index[22] != -1 && values[index[22]] != null && values[index[22]].trim().length() > 0) {
                                yearPercentageTable = values[index[22]].trim();
                            }
                            if (depreciationMethod == 11) {
                                if (index[34] != -1 && values[index[34]] != null && values[index[34]].trim().length() > 0) {
                                    annuityPercentage = CurrentCapitalizationCSV.createBigDecimal(values[index[34]].trim());
                                }
                                if (index[56] != -1 && values[index[56]] != null && values[index[56]].trim().length() > 0) {
                                    String string = values[index[56]].trim();
                                }
                            }
                            startDepreciationBookYear = index[23] != -1 && values[index[23]] != null && values[index[23]].trim().length() > 0 ? Integer.parseInt(values[index[23]]) : Integer.parseInt(values[index[15]]);
                            startDepreciationPeriod = index[24] != -1 && values[index[24]] != null && values[index[24]].trim().length() > 0 ? Integer.parseInt(values[index[24]]) : Integer.parseInt(values[index[14]]);
                            residualValue = index[26] != -1 && values[index[26]] != null && values[index[26]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[26]].trim()) : new BigDecimal("0");
                            residualPercentage = index[33] != -1 && values[index[33]] != null && values[index[33]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[33]].trim()) : new BigDecimal("0");
                            interestMethod = 0;
                            interestPercentage = new BigDecimal("0");
                            interestTable = "";
                            if (index[28] != -1 && values[index[28]] != null && values[index[28]].trim().length() > 0) {
                                interestMethod = Integer.parseInt(values[index[28]].trim());
                            }
                            if (index[30] != -1 && values[index[30]] != null && values[index[30]].trim().length() > 0) {
                                interestPercentage = CurrentCapitalizationCSV.createBigDecimal(values[index[30]].trim());
                            }
                            if (index[29] != -1 && values[index[29]] != null && values[index[29]].trim().length() > 0) {
                                interestTable = values[index[29]].trim();
                            }
                            depreciatableLife = 0;
                            if (index[25] != -1 && values[index[25]] != null && values[index[25]].trim().length() > 0) {
                                depreciatableLife = Integer.parseInt(values[index[25]].trim());
                            }
                            numberOfDepreciatedPeriods = 0;
                            if (index[31] != -1 && values[index[31]] != null && values[index[31]].trim().length() > 0) {
                                numberOfDepreciatedPeriods = Integer.parseInt(values[index[31]].trim());
                            }
                            postedDepreciationBalance = index[32] != -1 && values[index[32]] != null && values[index[32]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[32]].trim()) : new BigDecimal("0");
                            beyondEconomicLifePercentage = index[52] != -1 && values[index[52]] != null && values[index[52]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[52]].trim()) : new BigDecimal("0");
                            postedDepreciationBalanceBeyondEconomicLife = index[53] != -1 && values[index[53]] != null && values[index[53]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[53]].trim()) : new BigDecimal("0");
                            result = ValuationBO.create(dbData, company.getId(), asset.getCora(), asset.getId(), 1, depreciationMethod, degressivePercentage, annuityInterestTable, annuityPercentage, yearPercentageTable, 1, startDepreciationBookYear, startDepreciationPeriod, depreciatableLife, residualValue, residualPercentage, depreciationPaused, interestMethod, interestTable, interestPercentage, numberOfDepreciatedPeriods, 0, 0, postedDepreciationBalance, new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), 0, 0, beyondEconomicLifePercentage);
                            if (result[1] == null) break block77;
                            CurrentCapitalizationCSV.printError(values, index, (String)result[1], fos);
                            BOAdapter.investigate(null, dbTransaction);
                            return false;
                        }
                        valuation = (Valuation)result[0];
                        Log.info((String)(String.valueOf(valuation.getAssetId()) + ' ' + valuation.getAccountingPrinciple()));
                        valuation.setPostedDepreciationBalanceBeyondEconomicLife(postedDepreciationBalanceBeyondEconomicLife);
                        documentNr = 0;
                        seqNr = 0;
                        result = new CurrentCapitalizationBP(company).createCurrentCapitalizationInvestment(documentNr, ++seqNr, "", asset, asset.getStartUseYear(), asset.getStartUsePeriod(), bookYear, bookPeriod, acquisitionValue, valuation, user);
                        if (result[1] == null) break block78;
                        CurrentCapitalizationCSV.printError(values, index, (String)result[1], fos);
                        BOAdapter.investigate(null, dbTransaction);
                        return false;
                    }
                    if ("true".equals(values[index[9]].toLowerCase())) break block79;
                    BOAdapter.commitTransaction();
                    return true;
                }
                Transaction transaction = (Transaction)result[0];
                documentNr = transaction.getDocumentNr();
                depreciationPaused = false;
                if (index[42] != -1 && values[index[42]] != null && "true".equals(values[index[42]].toLowerCase())) {
                    depreciationPaused = true;
                }
                degressivePercentage = new BigDecimal("0");
                annuityPercentage = new BigDecimal("0");
                annuityInterestTable = "";
                yearPercentageTable = "";
                depreciationMethod = 99;
                if (index[35] != -1 && values[index[35]] != null && values[index[35]].trim().length() > 0) {
                    depreciationMethod = Integer.parseInt(values[index[35]]);
                }
                if (depreciationMethod == 2 && index[36] != -1 && values[index[36]] != null && values[index[36]].trim().length() > 0) {
                    degressivePercentage = CurrentCapitalizationCSV.createBigDecimal(values[index[36]].trim());
                }
                if (depreciationMethod == 3 && index[37] != -1 && values[index[37]] != null && values[index[37]].trim().length() > 0) {
                    yearPercentageTable = values[index[37]].trim();
                }
                if (depreciationMethod == 11) {
                    if (index[49] != -1 && values[index[49]] != null && values[index[49]].trim().length() > 0) {
                        annuityPercentage = CurrentCapitalizationCSV.createBigDecimal(values[index[49]].trim());
                    }
                    if (index[55] != -1 && values[index[57]] != null && values[index[57]].trim().length() > 0) {
                        interestTable = values[index[57]].trim();
                    }
                }
                startDepreciationBookYear = index[38] != -1 && values[index[38]] != null && values[index[38]].trim().length() > 0 ? Integer.parseInt(values[index[38]]) : Integer.parseInt(values[index[15]]);
                startDepreciationPeriod = index[39] != -1 && values[index[39]] != null && values[index[39]].trim().length() > 0 ? Integer.parseInt(values[index[39]]) : Integer.parseInt(values[index[14]]);
                residualValue = index[41] != -1 && values[index[41]] != null && values[index[41]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[41]].trim()) : new BigDecimal("0");
                residualPercentage = index[48] != -1 && values[index[48]] != null && values[index[48]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[48]].trim()) : new BigDecimal("0");
                interestMethod = 0;
                interestPercentage = new BigDecimal("0");
                interestTable = "";
                if (index[43] != -1 && values[index[43]] != null && values[index[43]].trim().length() > 0) {
                    interestMethod = Integer.parseInt(values[index[43]].trim());
                }
                if (index[45] != -1 && values[index[45]] != null && values[index[45]].trim().length() > 0) {
                    interestPercentage = CurrentCapitalizationCSV.createBigDecimal(values[index[45]].trim());
                }
                if (index[44] != -1 && values[index[44]] != null && values[index[44]].trim().length() > 0) {
                    interestTable = values[index[44]].trim();
                }
                depreciatableLife = 0;
                if (index[40] != -1 && values[index[40]] != null && values[index[40]].trim().length() > 0) {
                    depreciatableLife = Integer.parseInt(values[index[40]].trim());
                }
                numberOfDepreciatedPeriods = 0;
                if (index[46] != -1 && values[index[46]] != null && values[index[46]].trim().length() > 0) {
                    numberOfDepreciatedPeriods = Integer.parseInt(values[index[46]].trim());
                }
                postedDepreciationBalance = index[47] != -1 && values[index[47]] != null && values[index[47]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[47]].trim()) : new BigDecimal("0");
                beyondEconomicLifePercentage = index[54] != -1 && values[index[54]] != null && values[index[54]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[54]].trim()) : new BigDecimal("0");
                postedDepreciationBalanceBeyondEconomicLife = index[55] != -1 && values[index[55]] != null && values[index[55]].trim().length() > 0 ? CurrentCapitalizationCSV.createBigDecimal(values[index[55]].trim()) : new BigDecimal("0");
                result = ValuationBO.create(dbData, company.getId(), asset.getCora(), asset.getId(), 2, depreciationMethod, degressivePercentage, annuityInterestTable, annuityPercentage, yearPercentageTable, 1, startDepreciationBookYear, startDepreciationPeriod, depreciatableLife, residualValue, residualPercentage, depreciationPaused, interestMethod, interestTable, interestPercentage, numberOfDepreciatedPeriods, 0, 0, postedDepreciationBalance, new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), 0, 0, beyondEconomicLifePercentage);
                if (result[1] == null) break block80;
                CurrentCapitalizationCSV.printError(values, index, (String)result[1], fos);
                BOAdapter.investigate(null, dbTransaction);
                return false;
            }
            valuation = (Valuation)result[0];
            Log.info((String)(String.valueOf(valuation.getAssetId()) + ' ' + valuation.getAccountingPrinciple()));
            valuation.setPostedDepreciationBalanceBeyondEconomicLife(postedDepreciationBalanceBeyondEconomicLife);
            result = new CurrentCapitalizationBP(company).createCurrentCapitalizationInvestment(documentNr, ++seqNr, "", asset, asset.getStartUseYear(), asset.getStartUsePeriod(), bookYear, bookPeriod, acquisitionValue, valuation, user);
            if (result[1] == null) break block81;
            CurrentCapitalizationCSV.printError(values, index, (String)result[1], fos);
            BOAdapter.investigate(null, dbTransaction);
            return false;
        }
        BOAdapter.commitTransaction();
        return true;
    }
}

