/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public abstract class ImportCSVHelper {
    public static final String PATHTOFILE = "pathToFile";

    public static String getDefaultPath() {
        return "/home" + FacConstants.getContextName();
    }

    public static boolean fileExists(LoginHelper loginHelper, String fileName) throws Exception {
        return new IFSFile((AS400)loginHelper.getAs400(), fileName).exists();
    }

    protected static BufferedReader getReader(Map map, String fileName, String contextName) throws Exception {
        String pathToFile = (String)map.get(PATHTOFILE);
        if (pathToFile != null) {
            return ImportCSVHelper.getReader(pathToFile);
        }
        return ImportCSVHelper.getReader("/home" + contextName + '/' + fileName);
    }

    protected static BufferedReader getReader(String path) throws Exception {
        URL url = new URL("file://" + path);
        FileReader fileReader = new FileReader(url.getFile());
        return new BufferedReader(fileReader);
    }

    protected static FileOutputStream getFileOutputStream(Map map, String fileName, String contextName) throws Exception {
        return new FileOutputStream(new File(String.valueOf(ImportCSVHelper.getFolderName(map, contextName)) + '/' + fileName));
    }

    protected static String getFolderName(Map map, String contextName) throws Exception {
        String pathToFile = (String)map.get(PATHTOFILE);
        if (pathToFile != null) {
            return pathToFile.substring(0, pathToFile.lastIndexOf(47));
        }
        return "/home" + contextName;
    }

    protected static List getColumnNames(String line) {
        ArrayList<String> names = new ArrayList<String>();
        int i = -1;
        int j = 0;
        while ((j = line.indexOf(59, i + 1)) != -1) {
            names.add(line.substring(i + 1, j).trim());
            i = j;
        }
        if (i > -1 && i < line.length() - 1) {
            names.add(line.substring(i + 1).trim());
        }
        ImportCSVHelper.printColumnNames(names);
        return names;
    }

    private static void printColumnNames(List names) {
        Log.info((String)("#columns: " + names.size()));
        Log.info((String)"columnNames:");
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            Log.info((String)(String.valueOf((String)iterator.next()) + ';'));
        }
    }

    protected static String[] getColumnValues(String line, String[] values) {
        int column = -1;
        int i = -1;
        int j = 0;
        while ((j = line.indexOf(59, i + 1)) != -1) {
            values[++column] = line.substring(i + 1, j).trim();
            i = j;
        }
        if (i > -1 && column < values.length - 1) {
            values[++column] = line.substring(i + 1).trim();
        }
        ImportCSVHelper.printColumnValues(values);
        return values;
    }

    private static void printColumnValues(String[] values) {
        Log.info((String)"columnValues:");
        int i = 0;
        while (i < values.length) {
            Log.info((String)(String.valueOf(values[i]) + ';'));
            ++i;
        }
    }

    protected static Environment getEnvironment(String operationArea, String datalib) throws Exception {
        Environment env = EnvironmentBO.getEnvironment(operationArea, datalib);
        if (env == null) {
            Log.warn((String)("no environment for: " + operationArea + datalib));
            return null;
        }
        return env;
    }

    protected static DBData getDBData(Environment env) throws Exception {
        return EnvironmentBO.getDBData(env.getFacLib());
    }

    protected static FileOutputStream createErrorOutputStream(String[] args, String fileName, String fileType) throws Exception {
        return new FileOutputStream(ReportFileHelper.getFileName(args, fileName, fileType));
    }

    protected static BigDecimal createBigDecimal(String value) throws Exception {
        return new BigDecimal(value.replace(',', '.'));
    }
}

