/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.bp.MassImportBP;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public class MassTransactionCSV
extends ImportCSVHelper {
    public static final String FILENAME = "MassTransaction.csv";
    public static final String CLASSNAME = MassTransactionCSV.class.getName();
    private static int lineCount = 0;
    private static int okCount = 0;
    private static int procType;
    private static int transType;
    private static String journalize;
    private static String cora;
    private static String id;
    private static int facYear;
    private static int facPeriod;
    private static int finYear;
    private static int finPeriod;
    private static BigDecimal amountA;
    private static String description;
    private static BigDecimal amountB;
    private static int accPrin;
    private static int bbvCat;

    static {
        transType = 0;
        journalize = "";
        cora = "A";
        id = "";
        facYear = 0;
        facPeriod = 0;
        finYear = 0;
        finPeriod = 0;
        description = "";
        accPrin = 0;
        bbvCat = 0;
    }

    public static void main(String[] args) {
        try {
            MassTransactionCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        lineCount = 0;
        okCount = 0;
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        procType = Integer.parseInt((String)map.get("PROCTYPE"));
        String user = (String)map.get("User");
        DBData dbData = BOAdapter.getDBData(map);
        String companyId = (String)map.get("Company");
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        MassImportBP bp = new MassImportBP(company, company.getNumberOfPeriods());
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = MassTransactionCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = MassTransactionCSV.getColumnNames(line);
        int size = names.size();
        int[] index = new int[size];
        index[0] = names.indexOf("transType");
        index[1] = names.indexOf("journalize");
        index[2] = names.indexOf("cora");
        index[3] = names.indexOf("id");
        index[4] = names.indexOf("facYear");
        index[5] = names.indexOf("facPeriod");
        index[6] = names.indexOf("finYear");
        index[7] = names.indexOf("finPeriod");
        index[8] = names.indexOf("amountA");
        index[9] = names.indexOf("description");
        index[10] = names.indexOf("amountB");
        index[11] = names.indexOf("accPrin");
        index[12] = names.indexOf("bbvCat");
        FileOutputStream fos = MassTransactionCSV.createErrorOutputStream(args, "MassTransactionErrors", "csv");
        MassTransactionCSV.printColumnNames(names, index, fos);
        String message = null;
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(dbData, companyId);
        if (transactionBatch != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "batch_already_exists");
            Log.error((String)message);
            MassTransactionCSV.printError(new String[0], index, message, fos);
            MassTransactionCSV.writeOutputStream(fos, lineCount, okCount);
            return;
        }
        Object[] result = TransactionBatchBO.create(dbData, companyId, user, 3);
        if (result[1] != null) {
            message = (String)result[1];
            Log.error((String)message);
            MassTransactionCSV.printError(new String[0], index, message, fos);
            MassTransactionCSV.writeOutputStream(fos, lineCount, okCount);
            return;
        }
        transactionBatch = (TransactionBatch)result[0];
        transactionBatch.setMassTransactionProcessType(procType);
        String[] args2 = new String[args.length + 2];
        System.arraycopy(args, 0, args2, 0, args.length);
        args2[args.length] = "batchId";
        args2[args.length + 1] = "" + transactionBatch.getBatchId();
        args = args2;
        selections = BatchJobHelper.getSelections(args);
        String[] values = new String[size];
        line = bufferedReader.readLine();
        while (line != null) {
            ++lineCount;
            values = MassTransactionCSV.getColumnValues(line, values);
            try {
                message = MassTransactionCSV.validateLineValues(values, index);
                if (message != null) {
                    MassTransactionCSV.printError(values, index, message, fos);
                } else {
                    message = bp.addToProposal(transactionBatch, transType, journalize, cora, id, facYear, facPeriod, finYear, finPeriod, amountA, description, amountB, accPrin, bbvCat);
                    if (message != null) {
                        MassTransactionCSV.printError(values, index, message, fos);
                    } else {
                        ++okCount;
                    }
                }
            }
            catch (Exception e) {
                if (Log.debug()) {
                    e.printStackTrace();
                }
                MassTransactionCSV.printError(values, index, e.getMessage(), fos);
            }
            line = bufferedReader.readLine();
        }
        MassTransactionCSV.writeOutputStream(fos, lineCount, okCount);
    }

    private static void writeOutputStream(FileOutputStream fos, int lineCount, int okCount) {
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        String message = LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl);
        Log.info((String)message);
        try {
            fos.write(message.getBytes());
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String validateLineValues(String[] values, int[] index) throws Exception {
        if (index[0] == -1 || index[3] == -1 || index[4] == -1 || index[5] == -1 || index[8] == -1) {
            return LanguageHelper.getString("nl.ibs.fac.language", "at_least_one_mandatory_column_missing");
        }
        try {
            transType = Integer.parseInt(values[index[0]]);
        }
        catch (Exception e) {
            return "transType " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
        }
        if (!(values[index[0]].equals("10") || values[index[0]].equals("15") || values[index[0]].equals("90"))) {
            return "transType " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
        }
        if (values[index[3]] == null || values[index[3]].trim().length() <= 0) {
            return "id " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
        }
        id = values[index[3]].trim();
        try {
            facYear = Integer.parseInt(values[index[4]]);
            facPeriod = Integer.parseInt(values[index[5]]);
        }
        catch (Exception e) {
            return "facYear / Period " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
        }
        amountA = BigDecimal.ZERO;
        if (values[index[8]] != null && values[index[8]].trim().length() > 0) {
            amountA = MassTransactionCSV.createBigDecimal(values[index[8]]);
        }
        journalize = "";
        if (index[1] != -1 && values[index[1]].trim().equals("true")) {
            journalize = "true";
        }
        if (index[1] != -1 && values[index[1]].trim().equals("false")) {
            journalize = "false";
        }
        cora = "A";
        if (index[6] != -1 && index[7] != -1 && values[index[6]] != null && values[index[6]].trim().length() > 0 && values[index[7]] != null && values[index[7]].trim().length() > 0) {
            try {
                finYear = Integer.parseInt(values[index[6]]);
                finPeriod = Integer.parseInt(values[index[7]]);
            }
            catch (Exception e) {
                return "finYear / Period " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
            }
        }
        description = "";
        if (index[9] != -1 && values[index[9]].trim().length() > 0) {
            description = values[index[9]].trim();
        }
        amountB = BigDecimal.ZERO;
        if (index[10] != -1 && values[index[10]] != null && values[index[10]].trim().length() > 0) {
            amountB = MassTransactionCSV.createBigDecimal(values[index[10]]);
        }
        if (transType == 10) {
            accPrin = 1;
        } else if (transType == 15) {
            accPrin = 2;
        }
        if (transType == 90) {
            accPrin = 1;
            if (index[11] != -1 && values[index[11]] != null && values[index[11]].trim().length() > 0) {
                try {
                    accPrin = Integer.parseInt(values[index[11]]);
                }
                catch (Exception e) {
                    return "accPrin " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
                }
            }
            if (accPrin != 1 && accPrin != 2) {
                return "accPrin " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
            }
        }
        bbvCat = 0;
        if (index[12] != -1 && values[index[12]] != null && values[index[12]].trim().length() > 0) {
            try {
                bbvCat = Integer.parseInt(values[index[12]]);
            }
            catch (Exception e) {
                return "bbvCat " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
            }
        }
        if (transType == 10 && procType != 4) {
            return "transType " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value") + "( process type)";
        }
        if (transType == 15 && procType != 5) {
            return "transType " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value") + "( process type)";
        }
        if (transType == 90 && procType != 6) {
            return "transType " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value") + "( process type)";
        }
        return null;
    }

    protected static void printColumnNames(List<?> names, int[] index, FileOutputStream fos) throws Exception {
        fos.write("error;".getBytes());
        Iterator<?> iterator = names.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (index[i] != -1) {
                fos.write((String.valueOf(value) + ';').getBytes());
            }
            ++i;
        }
        fos.write(FacConstants.EOL.getBytes());
    }

    protected static void printError(String[] values, int[] index, String message, FileOutputStream fos) throws Exception {
        fos.write((String.valueOf(message) + ';').getBytes());
        int i = 0;
        while (i < values.length) {
            if (index[i] != -1) {
                if (values[i] != null) {
                    fos.write((String.valueOf(values[i]) + ';').getBytes());
                } else {
                    fos.write(";".getBytes());
                }
            }
            ++i;
        }
        fos.write(FacConstants.EOL.getBytes());
    }
}

