/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.commands.PreviousBookValueBalanceUpdateCommand;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public class TransactionCSV
extends ImportCSVHelper {
    public static final String FILENAME = "Transaction.csv";
    public static final String CLASSNAME = TransactionCSV.class.getName();

    public static void main(String[] args) {
        try {
            TransactionCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String user = (String)map.get("User");
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = TransactionCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = TransactionCSV.getColumnNames(line);
        int size = names.size();
        int[] index = new int[size];
        index[0] = names.indexOf("operationArea");
        index[1] = names.indexOf("dataLib");
        index[2] = names.indexOf("adminId");
        index[3] = names.indexOf("companyId");
        index[4] = names.indexOf("branchId");
        index[5] = names.indexOf("description");
        index[6] = names.indexOf("assetId");
        index[7] = names.indexOf("accountingPrinciple");
        index[8] = names.indexOf("mainTransactionType");
        index[9] = names.indexOf("transactionType");
        index[10] = names.indexOf("bookYear");
        index[11] = names.indexOf("period");
        index[12] = names.indexOf("amount1");
        index[13] = names.indexOf("amount2");
        index[14] = names.indexOf("amount3");
        index[15] = names.indexOf("finDimId1");
        index[16] = names.indexOf("finDimId2");
        index[17] = names.indexOf("finDimId3");
        index[18] = names.indexOf("finDimId4");
        index[19] = names.indexOf("finDimId5");
        index[20] = names.indexOf("incomingFinancialTransactionId");
        int documentNr = 0;
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[size];
        String[] saved = new String[size];
        Environment env = null;
        DBData dbData = null;
        String companyId = null;
        String savedCompanyId = null;
        String[] iftValues = new String[2];
        HashMap<String, String> iftIds = new HashMap<String, String>();
        FMSHelper fmsHelper = null;
        Company company = null;
        line = bufferedReader.readLine();
        while (line != null) {
            Transaction transaction;
            ++lineCount;
            if (!(values = TransactionCSV.getColumnValues(line, values))[index[0]].equals(saved[index[0]]) || !values[index[1]].equals(saved[index[1]])) {
                env = TransactionCSV.getEnvironment(values[index[0]], values[index[1]]);
                if (env == null) {
                    Log.info((String)("environment not found for: " + values[index[0]] + " " + values[index[1]]));
                    line = bufferedReader.readLine();
                    continue;
                }
                dbData = TransactionCSV.getDBData(env);
                saved[index[0]] = values[index[0]];
                saved[index[1]] = values[index[1]];
            }
            if ((companyId = values[index[2]]).length() == 0) {
                companyId = values[index[4]].equals("0") ? values[index[3]] : String.valueOf(values[index[3]]) + '/' + values[index[4]];
            } else {
                fmsHelper = new FMSHelper(loginHelper);
            }
            if (!companyId.equals(savedCompanyId)) {
                BufferedReader iftIdReader;
                if (fmsHelper != null && company != null) {
                    loginHelper.logout(env, savedCompanyId, "" + company.getCurrentBookYear());
                }
                company = (Company)CompanyBO.get(dbData, companyId)[0];
                if (fmsHelper != null && (message = loginHelper.login(env, companyId, "" + company.getCurrentBookYear())) != null && message.trim().length() > 0) {
                    Log.error((String)message);
                    loginHelper.logout();
                    return;
                }
                try {
                    iftIdReader = TransactionCSV.getReader(String.valueOf(TransactionCSV.getFolderName(map, contextName)) + '/' + "IFT" + companyId.replace('/', '_') + ".csv");
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                    iftIdReader = null;
                }
                if (iftIdReader != null) {
                    String iftLine = iftIdReader.readLine();
                    while (iftLine != null) {
                        iftValues = TransactionCSV.getColumnValues(iftLine, iftValues);
                        iftIds.put(iftValues[0], iftValues[1]);
                        iftLine = iftIdReader.readLine();
                    }
                }
            }
            if (savedCompanyId == null) {
                savedCompanyId = companyId;
            }
            if (!companyId.equals(savedCompanyId)) {
                PreviousBookValueBalanceUpdateCommand.execute(new String[]{"facLib", dbData.getSchema(), "Company", savedCompanyId});
                savedCompanyId = companyId;
                documentNr = 0;
            }
            if ((transaction = TransactionCSV.createTransaction(values, index, dbData, documentNr, user, iftIds, fmsHelper, company)) != null) {
                documentNr = transaction.getDocumentNr();
                ++okCount;
            }
            line = bufferedReader.readLine();
        }
        if (savedCompanyId != null) {
            PreviousBookValueBalanceUpdateCommand.execute(new String[]{"facLib", dbData.getSchema(), "Company", savedCompanyId});
        }
        if (fmsHelper != null && company != null) {
            loginHelper.logout(env, companyId, "" + company.getCurrentBookYear());
        }
        loginHelper.logout();
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        message = LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl);
        Log.info((String)message);
    }

    private static Transaction createTransaction(String[] values, int[] index, DBData dbData, int documentNr, String user, HashMap iftIds, FMSHelper fmsHelper, Company company) throws Exception {
        Object[] result;
        Transaction transaction;
        String description;
        String incomingFinancialTransactionId;
        String companyId;
        String finDimId5;
        String finDimId4;
        String finDimId3;
        String finDimId2;
        String finDimId1 = values[index[15]];
        if (finDimId1.startsWith("'")) {
            finDimId1 = finDimId1.substring(1);
        }
        if ((finDimId2 = values[index[16]]).startsWith("'")) {
            finDimId2 = finDimId2.substring(1);
        }
        if ((finDimId3 = values[index[17]]).startsWith("'")) {
            finDimId3 = finDimId3.substring(1);
        }
        if ((finDimId4 = values[index[18]]).startsWith("'")) {
            finDimId4 = finDimId4.substring(1);
        }
        if ((finDimId5 = values[index[19]]).startsWith("'")) {
            finDimId5 = finDimId5.substring(1);
        }
        if ((companyId = values[index[2]]).length() == 0) {
            companyId = values[index[4]].equals("0") ? values[index[3]] : String.valueOf(values[index[3]]) + '/' + values[index[4]];
            finDimId1 = FISHelper.formatId(finDimId1, 1);
            finDimId2 = FISHelper.formatId(finDimId2, 2);
            finDimId3 = FISHelper.formatId(finDimId3, 3);
            finDimId4 = FISHelper.formatId(finDimId4, 4);
            finDimId5 = FISHelper.formatId(finDimId5, 5);
        } else {
            finDimId1 = TransactionCSV.formatFMSId(finDimId1, 1, fmsHelper);
            finDimId2 = TransactionCSV.formatFMSId(finDimId2, 2, fmsHelper);
            finDimId3 = TransactionCSV.formatFMSId(finDimId3, 3, fmsHelper);
            finDimId4 = TransactionCSV.formatFMSId(finDimId4, 4, fmsHelper);
            finDimId5 = "";
        }
        int accountingPrinciple = 0;
        if (values[index[7]].length() > 0) {
            accountingPrinciple = values[index[7]].equals("cal") ? 2 : (values[index[7]].equals("fis") ? 1 : Integer.parseInt(values[index[7]]));
        }
        String assetId = values[index[6]].trim();
        String cora = "A";
        if (assetId.length() == 0) {
            assetId = null;
            cora = "";
        }
        if ((incomingFinancialTransactionId = values[index[20]]).startsWith("'")) {
            incomingFinancialTransactionId = incomingFinancialTransactionId.substring(1);
        }
        incomingFinancialTransactionId = (String)iftIds.get(incomingFinancialTransactionId);
        if (documentNr != 0) {
            ++documentNr;
        }
        if ((description = values[index[5]]).length() > 30) {
            description = description.substring(0, 30);
        }
        if ((transaction = (Transaction)(result = TransactionBO.create(dbData, companyId, documentNr, 1, description, cora, assetId, accountingPrinciple, Integer.parseInt(values[index[8]]), Integer.parseInt(values[index[9]]), Integer.parseInt(values[index[10]]), Integer.parseInt(values[index[11]]), Integer.parseInt(values[index[10]]), Integer.parseInt(values[index[11]]), new BigDecimal(values[index[12]]), new BigDecimal(values[index[13]]), new BigDecimal(values[index[14]]), incomingFinancialTransactionId, finDimId1, finDimId2, finDimId3, finDimId4, finDimId5, 0, 0, 0, user, ""))[0]) != null) {
            Log.info((String)(String.valueOf(transaction.getAssetId()) + ' ' + transaction.getAccountingPrinciple()));
            transaction.setState(1);
            if (transaction.getAssetId() != null) {
                Valuation valuation;
                Asset asset = (Asset)AssetBO.get(company, transaction.getAssetId(), false)[0];
                if (asset != null) {
                    transaction.setProFormaTypeId(asset.getTypeId());
                }
                if ((valuation = (Valuation)ValuationBO.get(transaction.getDBData(), transaction.getCompanyId(), transaction.getCora(), transaction.getAssetId(), transaction.getAccountingPrinciple())[0]) != null) {
                    int period;
                    int bookYear;
                    if (valuation.getDocumentNr1stTransaction() == 0) {
                        valuation.setDocumentNr1stTransaction(transaction.getDocumentNr());
                        valuation.setSeqNr1stTransaction(transaction.getSeqNr());
                    }
                    if ((transaction.getMainTransactionType() == 1 || transaction.getMainTransactionType() == 2) && PeriodHelper.isAfter(bookYear = transaction.getBookYear(), period = transaction.getPeriod(), valuation.getLastAcquisitionBookYear(), valuation.getLastAcquisitionPeriod())) {
                        valuation.setLastAcquisitionBookYear(bookYear);
                        valuation.setLastAcquisitionPeriod(period);
                    }
                }
            }
        }
        if (result[1] != null) {
            Log.info((String)((String)result[1]));
        }
        return transaction;
    }

    private static String formatFMSId(String finDimId, int index, FMSHelper fmsHelper) throws Exception {
        if (finDimId == null || finDimId.trim().length() == 0) {
            return finDimId;
        }
        String[] dimensionAttributes = fmsHelper.getDimensionAttributes(index);
        if (dimensionAttributes[0].equals("N")) {
            try {
                finDimId = "" + Integer.parseInt(finDimId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fmsHelper.formatId(finDimId, index);
    }
}

