/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public class ValuationCSV
extends ImportCSVHelper {
    public static final String FILENAME = "Valuation.csv";
    public static final String CLASSNAME = ValuationCSV.class.getName();

    public static void main(String[] args) {
        try {
            ValuationCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = ValuationCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = ValuationCSV.getColumnNames(line);
        int size = names.size();
        int[] index = new int[size];
        index[0] = names.indexOf("operationArea");
        index[1] = names.indexOf("dataLib");
        index[2] = names.indexOf("adminId");
        index[3] = names.indexOf("companyId");
        index[4] = names.indexOf("branchId");
        index[5] = names.indexOf("assetId");
        index[6] = names.indexOf("accountingPrinciple");
        index[7] = names.indexOf("depreciationMethod");
        index[8] = names.indexOf("degressivePercentage");
        index[9] = names.indexOf("yearPercentageTableId");
        index[10] = names.indexOf("startDepreciationBookYear");
        index[11] = names.indexOf("startDepreciationPeriod");
        index[12] = names.indexOf("depreciatableLife");
        index[13] = names.indexOf("residualValue");
        index[14] = names.indexOf("depreciationPaused");
        index[15] = names.indexOf("interestCalculationMethod");
        index[16] = names.indexOf("interestTableId");
        index[17] = names.indexOf("interestPercentage");
        index[18] = names.indexOf("numberOfDepreciatedPeriods");
        index[19] = names.indexOf("lastDepreciationBookYear");
        index[20] = names.indexOf("lastDepreciationPeriod");
        index[21] = names.indexOf("postedDepreciationBalance");
        index[22] = names.indexOf("postedAcquisitionBalance");
        index[23] = names.indexOf("10");
        index[24] = names.indexOf("20");
        index[25] = names.indexOf("30");
        index[26] = names.indexOf("40");
        index[27] = names.indexOf("50");
        index[28] = names.indexOf("60");
        index[29] = names.indexOf("70");
        index[30] = names.indexOf("80");
        index[31] = names.indexOf("90");
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[size];
        String[] saved = new String[size];
        Environment env = null;
        DBData dbData = null;
        line = bufferedReader.readLine();
        while (line != null) {
            ++lineCount;
            if (!(values = ValuationCSV.getColumnValues(line, values))[index[0]].equals(saved[index[0]]) || !values[index[1]].equals(saved[index[1]])) {
                env = ValuationCSV.getEnvironment(values[index[0]], values[index[1]]);
                if (env == null) {
                    Log.info((String)("environment not found for: " + values[index[0]] + " " + values[index[1]]));
                    line = bufferedReader.readLine();
                    continue;
                }
                dbData = ValuationCSV.getDBData(env);
                saved[index[0]] = values[index[0]];
                saved[index[1]] = values[index[1]];
            }
            if (ValuationCSV.createValuation(values, index, dbData)) {
                ++okCount;
            }
            line = bufferedReader.readLine();
        }
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        String message = LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl);
        Log.info((String)message);
    }

    private static boolean createValuation(String[] values, int[] index, DBData dbData) throws Exception {
        String companyId = values[index[2]];
        if (companyId.length() == 0) {
            companyId = values[index[4]].equals("0") ? values[index[3]] : String.valueOf(values[index[3]]) + '/' + values[index[4]];
        }
        int accountingPrinciple = 0;
        accountingPrinciple = values[index[6]].equals("cal") ? 2 : (values[index[6]].equals("fis") ? 1 : Integer.parseInt(values[index[6]]));
        boolean depreciationPaused = false;
        if ("true".equals(values[index[14]].toLowerCase())) {
            depreciationPaused = true;
        }
        BigDecimal d_percentage = new BigDecimal(0.0);
        BigDecimal a_percentage = new BigDecimal(0.0);
        if (Integer.parseInt(values[index[7]]) == 2) {
            d_percentage = new BigDecimal(values[index[8]]);
        } else if (Integer.parseInt(values[index[7]]) == 11) {
            a_percentage = new BigDecimal(values[index[8]]);
        }
        Object[] result = ValuationBO.create(dbData, companyId, "A", values[index[5]], accountingPrinciple, Integer.parseInt(values[index[7]]), d_percentage, "", a_percentage, values[index[9]], 1, Integer.parseInt(values[index[10]]), Integer.parseInt(values[index[11]]), Integer.parseInt(values[index[12]]), new BigDecimal(values[index[13]]), new BigDecimal(0), depreciationPaused, Integer.parseInt(values[index[15]]), values[index[16]], new BigDecimal(values[index[17]]), Integer.parseInt(values[index[18]]), Integer.parseInt(values[index[19]]), Integer.parseInt(values[index[20]]), new BigDecimal(values[index[21]]), new BigDecimal(values[index[22]]), new BigDecimal(0), new BigDecimal(0), 0, 0, new BigDecimal(0));
        if (result[0] != null) {
            Valuation valuation = (Valuation)result[0];
            Log.info((String)(String.valueOf(valuation.getAssetId()) + ' ' + valuation.getAccountingPrinciple()));
        }
        if (result[1] != null) {
            Log.info((String)((String)result[1]));
        }
        return result[1] == null;
    }
}

