/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.language;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import nl.ibs.fac.language.TokenList;
import nl.ibs.fac.language.UserContext;

public abstract class LanguageHelper {
    private static final String DEFAULT_RESOURCE_BUNDLE = "Texts";

    private static String getBundleName(String packageName) {
        String result = null;
        result = packageName == null || packageName.trim().length() == 0 ? DEFAULT_RESOURCE_BUNDLE : String.valueOf(packageName) + "." + DEFAULT_RESOURCE_BUNDLE;
        return result;
    }

    public static String getString(boolean b) {
        return LanguageHelper.getString("nl.ibs.fac.language", b ? "Yes" : "No", null);
    }

    public static String getString(String packagePrefix, String msgKey) {
        return LanguageHelper.getString(packagePrefix, msgKey, null);
    }

    public static String getString(String prefix, String msgKey, TokenList list) {
        Locale locale = UserContext.getLocale();
        String bundleName = LanguageHelper.getBundleName(prefix);
        return LanguageHelper.getString(bundleName, msgKey, list, locale);
    }

    public static String getString(String bundleName, String msgKey, TokenList list, Locale locale) {
        if (msgKey == null || msgKey.equals("")) {
            return msgKey;
        }
        ResourceBundle resource = ResourceBundle.getBundle(bundleName, locale);
        String result = "";
        try {
            result = resource.getString(msgKey);
            if (list != null && !list.isEmpty()) {
                result = MessageFormat.format(result, list.getValues());
            }
        }
        catch (MissingResourceException mre) {
            try {
                result = resource.getString(String.valueOf(Character.toUpperCase(msgKey.charAt(0))) + msgKey.substring(1));
                if (list != null && !list.isEmpty()) {
                    result = MessageFormat.format(result, list.getValues());
                }
            }
            catch (MissingResourceException mre2) {
                result = msgKey;
            }
        }
        return result;
    }
}

