/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.mc;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.mc.MC_IncomingFinancialTransactionQuery;
import nl.ibs.fac.mc.MC_IncomingFinancialTransactionToCSV;
import nl.ibs.util.Scrambler;

public class MC_IncomingFinancialTransactionInfoAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -4577360479978865994L;
    public static final String PAGE = MC_IncomingFinancialTransactionInfoAdapter.class.getName();
    public String tableName1 = "IFTAdapter1MC";
    public String tableName2 = "IFTAdapter2MC";
    private static final String REFRESH = "refresh";
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
    private static final NumericIdTransformer NUMERICIDTRANSFORMER = new NumericIdTransformer();
    private static final String[] NAMES1 = new String[]{"companyId", "bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] SHORTLABELS1 = new String[]{"Label.Company", "Label.Year", "Label.Period.short", "Label.Amount", "Label.Description", "Label.SystemItemNbr.Xshort", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
    private static final short[] SIZES1 = new short[]{80, 50, 30, 125, 250, 100, 80, 120};
    private Transformer[] transformers1;
    private static final String[] SEARCHNAMES1 = new String[]{"companyId", "bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] SEARCHLABELS1 = new String[]{"Label.Company", "Label.Year", "Label.Period", "Label.Amount", "Label.Description", "Label.SystemItemNbr.short", "Label.VoucherId", "Label.InvoiceNbr.short"};
    private static final String[] NAMES2 = new String[]{"companyId", "bookYear", "period", "transactionValue", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
    private String[] shortLabels2;
    private static final String[] SEARCHNAMES2 = new String[]{"companyId", "bookYear", "period", "transactionValue", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
    private String[] searchLabels2;
    private static final short[] SIZES2 = new short[]{80, 50, 30, 125, 91, 91, 91, 91, 91, 91};
    private Transformer[] transformers2;
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbShow = new FloatBar();
    private boolean table2Active = false;
    private Action changeView;

    public MC_IncomingFinancialTransactionInfoAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.shortLabels2 = new String[]{"Label.Company", "Label.Year", "Label.Period.short", "Label.Amount", "Label.MainAccount", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), this.env.getShortName5()};
        this.searchLabels2 = new String[]{"Label.Company", "Label.Year", "Label.Period", "Label.Amount", "Label.MainAccount", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5()};
        Transformer[] transformerArray = new Transformer[8];
        transformerArray[3] = DECIMALTRANSFORMER;
        transformerArray[7] = ZLTBTRANSFORMER;
        this.transformers1 = transformerArray;
        Transformer[] transformerArray2 = new Transformer[10];
        transformerArray2[3] = DECIMALTRANSFORMER;
        this.transformers2 = transformerArray2;
        if (this.env.getOperationArea().trim().length() == 0) {
            this.transformers1[6] = NUMERICIDTRANSFORMER;
            this.transformers2[4] = NUMERICIDTRANSFORMER;
            this.transformers2[5] = NUMERICIDTRANSFORMER;
            this.transformers2[6] = NUMERICIDTRANSFORMER;
            this.transformers2[7] = NUMERICIDTRANSFORMER;
            this.transformers2[8] = NUMERICIDTRANSFORMER;
            this.transformers2[9] = NUMERICIDTRANSFORMER;
        }
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow.addAction(refresh);
        this.changeView = new Action("Button.ToView_2").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("changeView");
        this.fbShow.addAction(this.changeView);
        Action exportToCSV = new Action("Button.ExportToCSVFile").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("exportAsCSVFile");
        this.fbShow.addAction(exportToCSV);
        this.fbShow.addAction(this.finish);
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        this.headerActions = new Action[]{refresh, this.changeView};
        this.rowActions = new Action[]{details};
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AllocatableIFTs", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.AllCompanies", "sub_screen_name"));
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject changeView(DataObject object) throws Exception {
        if (this.table2Active) {
            this.table2Active = false;
            this.changeView.setLabel("Button.ToView_2");
        } else {
            this.table2Active = true;
            this.changeView.setLabel("Button.ToView_1");
        }
        this.table = null;
        return this.show(object);
    }

    private void createTable() throws Exception {
        if (this.table2Active) {
            this.createTable2();
        } else {
            this.createTable1();
        }
    }

    private void createTable1() throws Exception {
        this.table = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)new MC_IncomingFinancialTransactionQuery(this.dbData, false), new String[]{"companyId", "id"}, 12);
        this.table.setName(this.tableName1);
        this.table.setColumnNames(NAMES1);
        this.table.setColumnLabels(SHORTLABELS1);
        this.table.setColumnSizes(SIZES1);
        this.table.setDisplayTransformers(this.transformers1);
        this.table.setSortable(true);
        this.table.setSelectable(false);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(SEARCHNAMES1, SEARCHLABELS1);
        this.searchPanel.setCSSClass("headerPanel");
        this.searchPanel.setWidth(849);
        Action filterAction = this.table.createFilterAction(SEARCHNAMES1, SEARCHLABELS1, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    private void createTable2() throws Exception {
        this.table = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)new MC_IncomingFinancialTransactionQuery(this.dbData, false), new String[]{"companyId", "id"}, 12);
        this.table.setName(this.tableName2);
        this.table.setColumnNames(NAMES2);
        this.table.setColumnLabels(this.shortLabels2);
        this.table.setColumnSizes(SIZES2);
        this.table.setDisplayTransformers(this.transformers2);
        this.table.setSortable(true);
        this.table.setSelectable(false);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(SEARCHNAMES2, this.searchLabels2);
        this.searchPanel.setCSSClass("headerPanel");
        this.searchPanel.setWidth(849);
        Action filterAction = this.table.createFilterAction(SEARCHNAMES2, this.searchLabels2, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject exportAsCSVFile(DataObject object) throws Exception {
        String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"System", this.loginHelper.getSystem()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"Company", "ALL"}};
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("classNameCSV", (Object)MC_IncomingFinancialTransactionToCSV.CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)"Job.MC_IncomingFinancialTransactionReport");
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
        return object;
    }
}

