/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.mc;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class MC_IncomingFinancialTransactionToCSV
extends CSVHelper {
    public static final String CLASSNAME = MC_IncomingFinancialTransactionToCSV.class.getName();
    private static final String FILENAME = "MC_IncomingFinancialTransactionReport";
    public static final String JOBNAME = "Job.MC_IncomingFinancialTransactionReport";
    private static int numberOfColumns = 14;
    private int fms = 0;
    private String[] attr;
    private IncomingFinancialTransaction ift = null;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();

    public MC_IncomingFinancialTransactionToCSV(String[][] selections, Collection collection, String[][] labels, FMSHelper fmsHelper, FISHelper fisHelper) throws Exception {
        super(selections, collection, labels, fmsHelper, fisHelper);
        if (fisHelper == null) {
            this.fms = 1;
        }
        this.attr = new String[numberOfColumns - this.fms];
        int index = 0;
        while (index < numberOfColumns) {
            this.attr[index] = "";
            ++index;
        }
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        this.ift = (IncomingFinancialTransaction)object;
        return this.getAttributes();
    }

    private String[] getAttributes() throws Exception {
        this.attr[0] = this.ift.getCompanyId();
        this.attr[1] = PeriodHelper.toString(this.ift.getBookYear(), this.ift.getPeriod());
        this.attr[2] = IBSDecimal.format(this.ift.getTransactionValue(), true);
        this.attr[3] = IBSDecimal.format(this.ift.getTransactionValue().subtract(this.ift.getUnAllocatedValue()), true);
        this.attr[4] = this.ift.getDescription();
        this.attr[5] = (String)this.numericIdTransformer.transform(this.ift.getMainAccount());
        if (this.ift.getFinDimId1().trim().length() > 0) {
            this.attr[6] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId1());
        }
        if (this.ift.getFinDimId2().trim().length() > 0) {
            this.attr[7] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId2());
        }
        if (this.ift.getFinDimId3().trim().length() > 0) {
            this.attr[8] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId3());
        }
        if (this.ift.getFinDimId4().trim().length() > 0) {
            this.attr[9] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId4());
        }
        if (this.fms == 0 && this.ift.getFinDimId5().trim().length() > 0) {
            this.attr[10] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId5());
        }
        this.attr[11 - this.fms] = "" + this.ift.getSystemItemNumber();
        this.attr[12 - this.fms] = this.ift.getVoucherId();
        this.attr[13 - this.fms] = "" + this.ift.getInternalInvoiceId();
        return this.attr;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            MC_IncomingFinancialTransactionToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        DBData dbData = BOAdapter.getDBData(map);
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        int fms = 0;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
            fms = 1;
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        String[][] labels = new String[1][numberOfColumns - fms];
        labels[0][0] = LanguageHelper.getString("nl.ibs.fac.language", "Company");
        labels[0][1] = LanguageHelper.getString("nl.ibs.fac.language", "Period");
        labels[0][2] = LanguageHelper.getString("nl.ibs.fac.language", "Amount");
        labels[0][3] = "Reeds verantw.";
        labels[0][4] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
        labels[0][5] = LanguageHelper.getString("nl.ibs.fac.language", "MainAccount");
        labels[0][6] = environment.getShortName1();
        labels[0][7] = environment.getShortName2();
        labels[0][8] = environment.getShortName3();
        labels[0][9] = environment.getShortName4();
        if (fms == 0) {
            labels[0][10] = environment.getShortName5();
        }
        labels[0][11 - fms] = LanguageHelper.getString("nl.ibs.fac.language", "SystemItemNumber");
        labels[0][12 - fms] = LanguageHelper.getString("nl.ibs.fac.language", "VoucherId");
        labels[0][13 - fms] = LanguageHelper.getString("nl.ibs.fac.language", "InternalInvoiceId");
        ArrayList allifts = new ArrayList();
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("facLib", dbData.getSchema());
        Collection companies = CompanyBO.getCompanies(myMap);
        for (Company company : companies) {
            myMap = new HashMap();
            myMap.put("facLib", dbData.getSchema());
            myMap.put("Company", company.getId());
            myMap.put("Confirmed", Boolean.FALSE);
            Collection ifts = IncomingFinancialTransactionBO.getIncomingFinancialTransactions(myMap);
            if (ifts.isEmpty()) continue;
            allifts.addAll(ifts);
        }
        MC_IncomingFinancialTransactionToCSV mc_iftToCSV = new MC_IncomingFinancialTransactionToCSV(selections, allifts, labels, fmsHelper, fisHelper);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "csv"));
        fos.write(mc_iftToCSV.createCsv());
        fos.close();
        loginHelper.logout();
    }
}

