/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.queries;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.ODBCounterImpl;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionManager;
import nl.ibs.fac.db.TransactionManagerFactory;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.vegas.persistence.Manager;

public class TransactionQuery
implements ODBQuery,
ODBCounter {
    private static final long serialVersionUID = -6292865358515727643L;
    private TransactionManager manager;
    private ODBCounter counter;
    private ExecutableQuery qry;
    private String sql = "companyId = ?_companyId";
    private Asset asset = null;
    private Credit credit = null;
    private IncomingFinancialTransaction incomingFinancialTransaction = null;
    private TransactionBatch transactionBatch = null;
    private Transaction transaction = null;
    private static final String ORDERING = "documentNr,seqNr";

    public TransactionQuery(DBData dbData, Company company, int accountingPrinciple, String cora, int mainTransactionType, int year, int period, String[] typeIds, int greaterThanPeriod) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.sql = "companyId = '" + company.getId() + "' AND " + "cora" + " = '" + cora + "' AND " + "accountingPrinciple" + " = " + accountingPrinciple + " AND " + "bookYearForJournalization" + " = " + year;
        if (period != 99 && greaterThanPeriod == 0) {
            this.sql = String.valueOf(this.sql) + " AND " + "periodForJournalization" + " = " + period;
        }
        if (greaterThanPeriod > 0) {
            this.sql = String.valueOf(this.sql) + " AND " + "periodForJournalization" + " > " + greaterThanPeriod;
        }
        if (mainTransactionType != 99) {
            this.sql = String.valueOf(this.sql) + " AND " + "mainTransactionType" + " = " + mainTransactionType;
        } else {
            this.sql = String.valueOf(this.sql) + " AND (" + "mainTransactionType" + " = 1" + " OR " + "mainTransactionType" + " = 2" + " OR " + "mainTransactionType" + " = 3" + ")";
            this.sql = String.valueOf(this.sql) + " AND " + "amount2" + " <> 0";
        }
        if (typeIds != null && typeIds.length > 0) {
            if (typeIds.length == 1) {
                this.sql = String.valueOf(this.sql) + " AND " + "proFormaTypeId" + " = '" + typeIds[0] + "'";
            } else {
                this.sql = String.valueOf(this.sql) + " AND (";
                int i = 0;
                while (i < typeIds.length) {
                    if (i > 0) {
                        this.sql = String.valueOf(this.sql) + " OR ";
                    }
                    this.sql = String.valueOf(this.sql) + "proFormaTypeId" + " = '" + typeIds[i] + "'";
                    ++i;
                }
                this.sql = String.valueOf(this.sql) + ")";
            }
        }
    }

    public TransactionQuery(DBData dbData, Asset asset, int accountingPrinciple, boolean allTransactions) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.asset = asset;
        this.sql = String.valueOf(this.sql) + " AND " + "assetId" + " = ?_assetId" + " AND " + "cora" + " = ?_cora" + " AND " + "accountingPrinciple" + " = " + accountingPrinciple + " AND " + "aggregationDocumentNr" + " = 0";
        if (!allTransactions) {
            this.sql = String.valueOf(this.sql) + " AND " + "infoLevel" + " <> 1";
        }
    }

    public TransactionQuery(DBData dbData, Asset asset, int accountingPrinciple, int aggregatedDocumentNr) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.asset = asset;
        this.sql = String.valueOf(this.sql) + " AND " + "assetId" + " = ?_assetId" + " AND " + "cora" + " = ?_cora" + " AND " + "accountingPrinciple" + " = " + accountingPrinciple + " AND " + "aggregationDocumentNr" + " = " + aggregatedDocumentNr;
        this.sql = String.valueOf(this.sql) + " AND " + "infoLevel" + " = 2";
    }

    public TransactionQuery(DBData dbData, Asset asset) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.asset = asset;
        this.sql = String.valueOf(this.sql) + " AND " + "assetId" + " = ?_assetId" + " AND " + "cora" + " = ?_cora" + " AND " + "accountingPrinciple" + " = 1" + " AND " + "state" + " = " + 1 + " AND " + "infoLevel" + " <>  1" + " AND " + "transactionType" + " <> " + 40 + " AND (" + "mainTransactionType" + " = " + 1 + " OR " + "mainTransactionType" + " = " + 2 + ")";
    }

    public TransactionQuery(DBData dbData, Credit credit, boolean isCreditClosing) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.credit = credit;
        this.sql = String.valueOf(this.sql) + " AND " + "creditId" + " = ?_creditId";
        this.sql = isCreditClosing ? String.valueOf(this.sql) + " AND " + "seqNr" + " = 1" + " AND " + "state" + " = 0" : String.valueOf(this.sql) + " AND " + "cora" + " = 'C'";
    }

    public TransactionQuery(DBData dbData, Credit credit) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.credit = credit;
        this.sql = String.valueOf(this.sql) + " AND " + "creditId" + " = ?_creditId";
        this.sql = String.valueOf(this.sql) + " AND " + "seqNr" + " = 1";
        this.sql = String.valueOf(this.sql) + " AND " + "cora" + " <> 'C'";
    }

    public TransactionQuery(DBData dbData, IncomingFinancialTransaction incomingFinancialTransaction) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.incomingFinancialTransaction = incomingFinancialTransaction;
        this.sql = String.valueOf(this.sql) + " AND " + "incomingFinancialTransactionId" + " = ?_incomingFinancialTransactionId" + " AND " + "seqNr" + " = 1";
    }

    public TransactionQuery(DBData dbData, TransactionBatch transactionBatch, int accountingPrinciple) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.transactionBatch = transactionBatch;
        this.sql = String.valueOf(this.sql) + " AND " + "batchId" + " = ?_batchId";
        this.sql = accountingPrinciple == 1 ? String.valueOf(this.sql) + " AND " + "accountingPrinciple" + " <= " + accountingPrinciple : String.valueOf(this.sql) + " AND " + "accountingPrinciple" + " = " + accountingPrinciple;
    }

    public TransactionQuery(DBData dbData, Transaction transaction) throws Exception {
        this.manager = TransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Transaction.class, null, ORDERING);
        this.qry.setCacheable(true);
        this.transaction = transaction;
        this.sql = String.valueOf(this.sql) + " AND " + "documentNr" + " = ?_documentNr";
    }

    public Collection fetchData(String filter, String order, Map parameters, int maxObjects) throws Exception {
        if (filter != null) {
            this.qry.setFilter(String.valueOf(this.sql) + " AND " + filter);
        } else {
            this.qry.setFilter(this.sql);
        }
        Map map = parameters = parameters == null ? new HashMap() : parameters;
        if (this.asset != null) {
            parameters.put("_companyId", this.asset.getCompanyId());
            parameters.put("_cora", this.asset.getCora());
            parameters.put("_assetId", this.asset.getId());
        }
        if (this.credit != null) {
            parameters.put("_companyId", this.credit.getCompanyId());
            parameters.put("_creditId", this.credit.getId());
        }
        if (this.incomingFinancialTransaction != null) {
            parameters.put("_companyId", this.incomingFinancialTransaction.getCompanyId());
            parameters.put("_incomingFinancialTransactionId", this.incomingFinancialTransaction.getId());
        }
        if (this.transactionBatch != null) {
            parameters.put("_companyId", this.transactionBatch.getCompanyId());
            parameters.put("_batchId", new Integer(this.transactionBatch.getBatchId()));
        }
        if (this.transaction != null) {
            parameters.put("_companyId", this.transaction.getCompanyId());
            parameters.put("_documentNr", new Integer(this.transaction.getDocumentNr()));
        }
        this.qry.setParameters(parameters);
        this.qry.setMaxObjects(maxObjects);
        this.qry.setOrdering(order);
        return this.manager.getCollection(this.qry);
    }

    public long count(String filter, Map parameters) throws Exception {
        Map map = parameters = parameters == null ? new HashMap() : parameters;
        if (this.asset != null) {
            parameters.put("_companyId", this.asset.getCompanyId());
            parameters.put("_cora", this.asset.getCora());
            parameters.put("_assetId", this.asset.getId());
        }
        if (this.credit != null) {
            parameters.put("_companyId", this.credit.getCompanyId());
            parameters.put("_creditId", this.credit.getId());
        }
        if (this.incomingFinancialTransaction != null) {
            parameters.put("_companyId", this.incomingFinancialTransaction.getCompanyId());
            parameters.put("_incomingFinancialTransactionId", this.incomingFinancialTransaction.getId());
        }
        if (this.transactionBatch != null) {
            parameters.put("_companyId", this.transactionBatch.getCompanyId());
            parameters.put("_batchId", new Integer(this.transactionBatch.getBatchId()));
        }
        if (this.transaction != null) {
            parameters.put("_companyId", this.transaction.getCompanyId());
            parameters.put("_documentNr", new Integer(this.transaction.getDocumentNr()));
        }
        if (filter != null && filter.trim().length() > 0) {
            return this.counter.count(String.valueOf(this.sql) + " AND " + filter, parameters);
        }
        return this.counter.count(this.sql, parameters);
    }
}

