/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReasonCodeEnum;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.jsql.DBData;

public class DepreciationProposalErrorsToPDF
extends PdfHelper {
    public static final String CLASSNAME = DepreciationProposalErrorsToPDF.class.getName();
    private static final String FILENAME = "DepreciationProposalErrors";
    private static final String[][] LABELS = new String[][]{{"AssetId", "Description", "Type", "Period", "Depreciation", "Interest", "", "Remark"}};
    private static final int[] SIZES = new int[]{50, 150, 50, 40, 70, 70, 15, 150};
    private static final boolean[] RIGHTALIGN;
    private static final String SEVERE_ERROR = "**";
    private boolean hasSevereErrors = false;
    private Asset asset = null;
    private Transaction transaction = null;
    private int reasonCode = 0;
    private int numberOfColumns = LABELS[0].length;
    private int detailRows = 0;
    private boolean post;

    static {
        boolean[] blArray = new boolean[8];
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        RIGHTALIGN = blArray;
    }

    public DepreciationProposalErrorsToPDF(String reportTitle, String[][] selections, Collection collection) throws Exception {
        super(reportTitle, selections, collection, LABELS, SIZES, RIGHTALIGN, null, null, "", "");
        this.value = new String[this.numberOfColumns];
        this.bold = new boolean[this.numberOfColumns];
        this.translate = new boolean[this.numberOfColumns];
        this.post = Boolean.valueOf(this.extractFromSelections("Post"));
        this.document.setPageSize(new Rectangle(1500.0f, 900.0f));
    }

    @Override
    protected void processObject(Object object) throws Exception {
        this.transaction = (Transaction)object;
        this.reasonCode = this.transaction.getReasonCode();
        if (!this.hasSevereErrors && this.reasonCode == 50) {
            this.hasSevereErrors = true;
        }
        this.asset = this.transaction.getAsset();
        if (this.asset == null) {
            return;
        }
        this.value[0] = this.asset.getId();
        this.value[1] = this.asset.getDescription();
        this.value[2] = this.asset.getTypeId();
        this.value[3] = PeriodHelper.toString(this.transaction.getBookYear(), this.transaction.getPeriod());
        this.value[4] = IBSDecimal.format(this.transaction.getAmount2());
        this.value[5] = IBSDecimal.format(this.transaction.getAmount3());
        this.value[6] = this.reasonCode < 50 ? "" : SEVERE_ERROR;
        this.value[7] = ReasonCodeEnum.getValue(this.reasonCode);
        int i = 0;
        while (i < this.value.length) {
            this.setCell(i, this.value[i], false, false);
            ++i;
        }
        this.addTableRow();
        ++this.detailRows;
    }

    @Override
    protected void addTotalGenRow() throws Exception {
        String msg = null;
        if (this.detailRows == 0) {
            msg = LanguageHelper.getString("nl.ibs.fac.language", "NoRecordsToPrint");
        } else if (this.hasSevereErrors) {
            msg = "** " + LanguageHelper.getString("nl.ibs.fac.language", "batch_has_severe_errors");
            if (this.post) {
                msg = String.valueOf(msg) + "\n" + LanguageHelper.getString("nl.ibs.fac.language", "batch_has_severe_errors_part2");
            }
        }
        if (msg != null) {
            this.addEmptyTableRow();
            this.value = new String[this.numberOfColumns];
            this.value[1] = msg;
            int i = 0;
            while (i < this.value.length) {
                this.setCell(i, this.value[i], false, false);
                ++i;
            }
            this.addTableRow();
        }
    }

    private boolean hasSevereErrors() {
        return this.hasSevereErrors;
    }

    public static boolean execute(String[] args, boolean ap1, boolean ap2) throws Exception {
        FileOutputStream fos;
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        map.put("SKIP_FRONTPAGE", Boolean.TRUE);
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        Environment env = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        TransactionBatch transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(dbData, companyId);
        DepreciationProposalErrorsToPDF depreciationProposalErrorsToPDF = null;
        Collection collection = null;
        String reportTitle = "";
        boolean hasSevereErrors1 = false;
        boolean hasSevereErrors2 = false;
        String[][] modifiedSelections = DepreciationProposalErrorsToPDF.modifySelections(selections, env);
        map.put("ReasonCodeFrom", "1");
        map.put("governmentActivated", new Boolean(env.getGovernmentActivated()));
        if (ap1) {
            map.put("AccountingPrinciple2", Boolean.FALSE);
            collection = TransactionBO.getTransactions(map, transactionBatch);
            reportTitle = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", FILENAME)) + " - " + env.getAPName1();
            modifiedSelections[5][1] = ": " + env.getAPName1();
            depreciationProposalErrorsToPDF = new DepreciationProposalErrorsToPDF(reportTitle, modifiedSelections, collection);
            fos = new FileOutputStream(ReportFileHelper.getFileName(args, reportTitle, "pdf"));
            fos.write(depreciationProposalErrorsToPDF.createPdf().toByteArray());
            fos.close();
            hasSevereErrors1 = depreciationProposalErrorsToPDF.hasSevereErrors();
        }
        if (ap2) {
            map.put("AccountingPrinciple2", Boolean.TRUE);
            collection = TransactionBO.getTransactions(map, transactionBatch);
            reportTitle = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", FILENAME)) + " - " + env.getAPName2();
            modifiedSelections[5][1] = ": " + env.getAPName2();
            depreciationProposalErrorsToPDF = new DepreciationProposalErrorsToPDF(reportTitle, modifiedSelections, collection);
            fos = new FileOutputStream(ReportFileHelper.getFileName(args, reportTitle, "pdf"));
            fos.write(depreciationProposalErrorsToPDF.createPdf().toByteArray());
            fos.close();
            hasSevereErrors2 = depreciationProposalErrorsToPDF.hasSevereErrors();
        }
        return hasSevereErrors1 || hasSevereErrors2;
    }

    private static String[][] modifySelections(String[][] selections, Environment env) throws Exception {
        String[][] modifiedSelections = new String[6][2];
        int index = 0;
        String selectionValue = DepreciationProposalErrorsToPDF.retrieveSelection("User", selections);
        modifiedSelections[index][0] = "Gebruiker";
        modifiedSelections[index][1] = ": " + selectionValue;
        selectionValue = DepreciationProposalErrorsToPDF.retrieveSelection("facLib", selections);
        modifiedSelections[++index][0] = "FAC - omgeving";
        modifiedSelections[index][1] = ": " + selectionValue;
        selectionValue = DepreciationProposalErrorsToPDF.retrieveSelection("batchId", selections);
        modifiedSelections[++index][0] = "Afschrijvingsvoorstel";
        modifiedSelections[index][1] = ": " + selectionValue;
        selectionValue = DepreciationProposalErrorsToPDF.retrieveSelection("Company", selections);
        modifiedSelections[++index][0] = "Bedrijf";
        modifiedSelections[index][1] = ": " + selectionValue;
        String bookYear = DepreciationProposalErrorsToPDF.retrieveSelection("BookYearTo", selections);
        String bookPeriod = DepreciationProposalErrorsToPDF.retrieveSelection("PeriodTo", selections);
        modifiedSelections[++index][0] = "Periode";
        modifiedSelections[index][1] = ": " + bookYear + "-" + bookPeriod;
        modifiedSelections[++index][0] = "Verslaggevingssoort";
        modifiedSelections[index][1] = ": ";
        return modifiedSelections;
    }

    private static String retrieveSelection(String key, String[][] selections) throws Exception {
        int i = 0;
        while (i < selections.length) {
            if (key.equals(selections[i][0])) {
                return selections[i][1];
            }
            ++i;
        }
        return null;
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return null;
    }
}

